<?php

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~ E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'post_comment');
define('CSRF_PROTECTION', true);
define('LOCATION_BYPASS', 1);
define('NOPMPOPUP', 1);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array(
	'changuondyu_comment',		
	'changuondyu_comment_bit',
	'changuondyu_comment_form',
	'changuondyu_comment_script',
	'changuondyu_comment_page'
);

// ######################### REQUIRE BACK-END ############################
require_once ('./global.php');
require_once ('./includes/functions_post_comments.php');

if ($vbulletin->options['changcomment_turn'])
{
	require_once (DIR . '/includes/class_xml.php');

	if ($_POST['do'] == 'post_comment' AND $vbulletin->userinfo['userid'])
	{
		$vbulletin->input->clean_array_gpc('p', array(
			'postid' => TYPE_UINT, 
			'threadid' => TYPE_UINT, 
			'message' => TYPE_STR
		));

		$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
		$xml->add_group('changpc');

		$postcomm = $vbulletin->GPC;

		require_once ('./includes/functions_user.php');
		$postcomm['avatarurl'] = fetch_avatar_url($vbulletin->userinfo['userid']);
		$postcomm['avatarurl'] = $postcomm['avatarurl'][0];

		post_comment($postcomm);

		$out = fetch_comments($postcomm, 1);

		$xml->add_tag('setcomm', process_replacement_vars($out));
		$xml->close_group();
		$xml->print_xml();
		exit;
	}

	if ($_POST['do'] == 'get_comment')
	{
		$vbulletin->input->clean_array_gpc('p', array(
			'postid' => TYPE_UINT, 
			'page' => TYPE_UINT
		));

		$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
		$xml->add_group('changpc');

		$getcomm = $vbulletin->GPC;
		$getcomm['can_manage'] = can_moderate($threadinfo['forumid'], '', $vbulletin->userinfo['userid']);

		$out = fetch_comments($getcomm);

		$xml->add_tag('getcomm', process_replacement_vars($out));
		$xml->close_group();
		$xml->print_xml();
		exit;
	}

	if ($_POST['do'] == 'del_comment' AND $vbulletin->userinfo['userid'])
	{
		$vbulletin->input->clean_array_gpc('p', array(
			'commentid' => TYPE_UINT, 
			'postid' =>	TYPE_UINT
		));

		del_comment($vbulletin->GPC);
		exit;
	}
}
?>