<?php
date_default_timezone_set('Asia/Riyadh');
class prayer_time {
    function julian_day($y, $m, $d) {
        $day =((367*$y)-((INT)((7/4)*($y+(INT)(($m+9)/12))))+(INT)(275*($m/9))+$d-730531.5);
        return $day;
    }
    
    
function sun_long($julian_day) {
        $l=  (280.461+0.9856474*$julian_day);
        if($l>360) {
            $l= (($l/360)-(INT)($l/360))*360;
        }

        return $l;
    }

    function sun_period($julian_day)
    {
        $m = (357.528+0.9856003*$julian_day);
        if($m>360)
        {
            $m= (($m/360)-(INT)($m/360))*360;
        }

        return $m;
    }
    
    function sun_wave_long($sun_long, $sun_period, $pi)
    {
        $Lambda = $sun_long +1.915*SIN($sun_period*$pi/180)+0.02*SIN(2* $sun_period*$pi/180);
        return $Lambda;
    }
    
    // obliquity
    
function obliquity($julian_day)
    {
        $Obliquity = (23.439-0.0000004*$julian_day);
        return $Obliquity;
    }
    
    // alpha
    
    function alpha($Obliquity, $Lambda, $pi)
    {

        $Alpha =ATAN (COS($Obliquity*$pi/180)*TAN($Lambda*$pi/180))*180/$pi;
        if($Alpha>90 AND $Alpha<180)
        {
            $Alpha= $Alpha + 180;
        }
        else
        {
            $Alpha= $Alpha + 360;
        }

        $Alpha=  $Alpha + 90 * (((INT)($Lambda/90))-((INT)($Alpha/90)));



        return $Alpha;
    }
    
    //  ST
    
    function starry_time($julian_day)
    {
        $ST = (100.46+0.985647352*$julian_day);
        if ($ST>360)
        {
            $ST=  (($ST/360)-((INT)($ST/360)))*360;
        }
        return $ST;
    }
    

    // Dec
    
    function sun_obliquity($Obliquity, $Lambda, $pi) {
        $Dec = ASIN(SIN($Obliquity*$pi/180)*SIN($Lambda*$pi/180))*180/$pi;
        return $Dec;
    }
    
    // noon
    
    function sun_miday($Alpha, $ST) {
        $noon = ($Alpha - $ST);
        if($noon<0)
        {
            $noon = $noon+360;
        }
        return $noon;
    }
    
    // UT NOON
    
    function international_midday($noon, $long) {
        $UT_noon = $noon - $long;
        return $UT_noon;
    }
    
    // local_noon
    
    function local_noon($UT_noon, $zone) {
        $local_noon = $UT_noon/15+$zone;
        return $local_noon;
    }

    //   
     
    function zuhr_time($local_noon) {
        $timeh = floor ($local_noon);
		$timeh2 = ($timeh < 10) ? '0'.$timeh : $timeh ;
        $timem = floor (($local_noon - (INT)($local_noon))*60);
		$timem2 = ($timem < 10) ? '0'.$timem : $timem ;
        $zuhr_prayer = "$timeh2:$timem2";
        
        return $zuhr_prayer;

    }
    
    // Asr_Alt

    function asr_alt($lat, $Dec, $pi) {
		$Asr_Alt= ATAN(1+TAN(($lat-$Dec)*$pi/180))*180/$pi;
        return $Asr_Alt;
    }
	
	//     -  
	
	  function asr_alt2($lat, $Dec, $pi) {
		$Asr_Alt2= ATAN(2+TAN(($lat-$Dec)*$pi/180))*180/$pi;
		return $Asr_Alt2;
    }
	
    // AsrArc
	function asr_arc($AsrAlt, $lat, $Dec, $pi) {
		$AsrArc= ACOS((SIN((90-$AsrAlt)*$pi/180)-SIN($Dec*$pi/180)*SIN($lat*$pi/180))/(COS($Dec*$pi/180)*COS($lat*$pi/180)))*180/$pi/15; 
		return $AsrArc;
    }
	
	function asr_time($local_noon, $AsrArc) {
        $AsrTime = $local_noon + $AsrArc; 
        return $AsrTime;
    }
	
	//     -  
	function asr_arc2($AsrAlt2, $lat, $Dec, $pi) {
		$AsrArc2= ACOS((SIN((90-$AsrAlt2)*$pi/180)-SIN($Dec*$pi/180)*SIN($lat*$pi/180))/(COS($Dec*$pi/180)*COS($lat*$pi/180)))*180/$pi/15; 
		return $AsrArc2;
    }
    
    function asr_time2($local_noon, $AsrArc2) {
        $AsrTime2 = $local_noon + $AsrArc2; 
        return $AsrTime2;
    }   
    
	//   

    function asr_prayer_time($AsrTime) {
        $timeh = floor ($AsrTime);
        $timeh= $timeh-12;
		$timeh2 = ($timeh < 10) ? '0'.$timeh : $timeh ;
        $timem = floor (($AsrTime - (INT)($AsrTime))*60);
		$timem2 = ($timem < 10) ? '0'.$timem : $timem ;
        $asr_prayer = "$timeh2:$timem2";

        return $asr_prayer;

    } 
	
	//    -  

    function asr_prayer_time2($AsrTime2) {
        $timeh = floor ($AsrTime2);
        $timeh= $timeh-12;
		$timeh2 = ($timeh < 10) ? '0'.$timeh : $timeh ;
        $timem = floor (($AsrTime2 - (INT)($AsrTime2))*60);
		$timem2 = ($timem < 10) ? '0'.$timem : $timem ;
        $asr_prayer2 = "$timeh2:$timem2";

        return $asr_prayer2;

    }  

    // Durinal_Arc
    
    function Durinal_Arc ($lat, $Dec, $pi) {
        $Durinal_Arc= Acos((SIN(-0.8333*$pi/180)-SIN($Dec*$pi/180)*SIN($lat*$pi/180))/(COS($Dec*$pi/180)*COS($lat*$pi/180)))*180/$pi;
        return $Durinal_Arc;
    }
    

    // sun_rise
    
    function sun_rise($local_noon, $Durinal_Arc) {
        $sun_rise= $local_noon - ($Durinal_Arc/15);
        
        return $sun_rise;
    }
    
    //   
	
    function shrouk_prayer($sun_rise) {
        $timeh= floor($sun_rise);
		$timeh2 = ($timeh < 10) ? '0'.$timeh : $timeh ;
        $timem = floor (($sun_rise - (INT)($sun_rise))*60);
		$timem2 = ($timem < 10) ? '0'.$timem : $timem ;
        $sun_rise_prayer = "$timeh2:$timem2";
        
        return $sun_rise_prayer;
    }
    
    // sun_set
    
    function sun_set($local_noon, $Durinal_Arc) {
        $sun_set= $local_noon + ($Durinal_Arc/15);

        return $sun_set;
    }
    
     //   

function goroub_prayer($sun_set) {
        $timeh= floor($sun_set);
        $timeh= $timeh-12;
		$timeh2 = ($timeh < 10) ? '0'.$timeh : $timeh ;
        $timem = floor (($sun_set - (INT)($sun_set))*60);
		$timem2 = ($timem < 10) ? '0'.$timem : $timem ;
        $goroub_prayer = "$timeh2:$timem2";

        return $goroub_prayer;
    }

	//   
	
    function maghrib_prayer($sun_set) {
        $timeh= floor($sun_set);
        $timeh= $timeh-12;
        $timeh2 = ($timeh < 10) ? '0'.$timeh : $timeh;
        $timem = floor (($sun_set - (INT)($sun_set))*60);
		$timem2 = ($timem < 10) ? '0'.$timem : $timem;
        $maghrib_prayer = "$timeh2:$timem2";
		
        return $maghrib_prayer;
    }
	
	//     -  
	
    function eshaain_prayer($sun_set) {
        $timeh= floor($sun_set);
        $timeh= $timeh-12;
		$timeh2 = ($timeh < 10) ? '0'.$timeh : $timeh ;
        $timem = floor (($sun_set - (INT)($sun_set))*60 +15);
		$timem2 = ($timem < 10) ? '0'.$timem : $timem ;
        $eshaain_prayer = "$timeh2:$timem2";

        return $eshaain_prayer;
    }
	
	
    
    // Esha_Arc

    function esha_arc($lat, $Dec, $pi)
    {
        $Esha_Arc= Acos((SIN(-18*$pi/180)-SIN($Dec*$pi/180)*SIN($lat*$pi/180))/(COS($Dec*$pi/180)*COS($lat*$pi/180)))*180/$pi;
        return $Esha_Arc;
    }
    
    // esha_time
 
    function esha_time($local_noon, $Esha_Arc)
    {
        $esha_time= $local_noon + ($Esha_Arc/15);
        return $esha_time;
    }
    
    //   
    
    function esha_prayer($esha_time){
        $timeh= floor($esha_time);
        $timeh= $timeh-12;
		$timeh2 = ($timeh < 10) ? '0'.$timeh : $timeh ;
        $timem = floor (($esha_time - (INT)($esha_time))*60);
		$timem2 = ($timem < 10) ? '0'.$timem : $timem ;
        $esha_prayer = "$timeh2:$timem2";

        return $esha_prayer;
    }
    
	
    // Fajr_Arc
    
    function fajr_arc($lat, $Dec, $pi)
    {
        $Fajr_Arc= Acos((SIN(-18*$pi/180)-SIN($Dec*$pi/180)*SIN($lat*$pi/180))/(COS($Dec*$pi/180)*COS($lat*$pi/180)))*180/$pi;
        return $Fajr_Arc;
    }
    
    // fajr_time
    function fajr_time($local_noon, $Fajr_Arc)
    {
        $fajr_time= $local_noon - ($Fajr_Arc/15);
        return $fajr_time;
    }
    
    //   
    function fajr_prayer($fajr_time)
    {
        $timeh= floor($fajr_time);
		$timeh2 = ($timeh < 10) ? '0'.$timeh : $timeh ;
        $timem = floor (($fajr_time - (INT)($fajr_time))*60);
		$timem2 = ($timem < 10) ? '0'.$timem : $timem ;
        $fajr_time = "$timeh2:$timem2";

        return $fajr_time;
    }

}

$algdeerclass = new prayer_time;

$y= date("Y");
$m= date("n");
$d= date("j");
//$d=stripslashes($vbulletin->options['ain_prayer_offset3']);
//$m=stripslashes($vbulletin->options['ain_prayer_offset2']);
//$y=stripslashes($vbulletin->options['ain_prayer_offset1']);
	// pi 
$pi = 3.14159265358979323846;

	//   
$long = 46.716667;

	//  
$lat = 24.633333;

	//  
$zone =3;

        //  
$zone_desc = $vbulletin->options['ain_prayer_description'];  

$julian_day = $algdeerclass->julian_day($y, $m, $d);
$sun_long = $algdeerclass->sun_long($julian_day);
$sun_period = $algdeerclass->sun_period($julian_day);
$Lambda = $algdeerclass->sun_wave_long($sun_long, $sun_period, $pi);
$Obliquity = $algdeerclass->obliquity($julian_day);
$Alpha = $algdeerclass->alpha($Obliquity, $Lambda, $pi);
$ST = $algdeerclass->starry_time($julian_day);
$Dec = $algdeerclass->sun_obliquity($Obliquity, $Lambda, $pi);

$noon = $algdeerclass->sun_miday($Alpha, $ST);
$UT_noon = $algdeerclass->international_midday($noon, $long);
$local_noon = $algdeerclass->local_noon($UT_noon, $zone);
$zuhr_prayer = $algdeerclass->zuhr_time($local_noon);

$AsrAlt = $algdeerclass->asr_alt($lat, $Dec, $pi);
$AsrAlt2 = $algdeerclass->asr_alt2($lat, $Dec, $pi);		
$AsrArc = $algdeerclass->asr_arc($AsrAlt, $lat, $Dec, $pi);
$AsrArc2 = $algdeerclass->asr_arc2($AsrAlt2, $lat, $Dec, $pi);
$AsrTime = $algdeerclass->asr_time($local_noon, $AsrArc);
$AsrTime2 = $algdeerclass->asr_time2($local_noon, $AsrArc2);
$asr_prayer = $algdeerclass->asr_prayer_time($AsrTime);
$asr_prayer2 = $algdeerclass->asr_prayer_time2($AsrTime2);

$Durinal_Arc = $algdeerclass->Durinal_Arc ($lat, $Dec, $pi);
$sun_rise =  $algdeerclass->sun_rise($local_noon, $Durinal_Arc);
$Shrouk_prayer = $algdeerclass->shrouk_prayer($sun_rise);
$sun_set = $algdeerclass->sun_set($local_noon, $Durinal_Arc);

$goroub_prayer = $algdeerclass->goroub_prayer($sun_set);
$maghrib_prayer = $algdeerclass->maghrib_prayer($sun_set);
$eshaain = $algdeerclass->eshaain_prayer($sun_set);

$Esha_Arc = $algdeerclass->esha_arc($lat, $Dec, $pi);
$esha_time= $algdeerclass->esha_time($local_noon, $Esha_Arc);
$esha_prayer= $algdeerclass->esha_prayer($esha_time);

$Fajr_Arc= $algdeerclass->fajr_arc($lat, $Dec, $pi);
$fajr_time= $algdeerclass->fajr_time($local_noon, $Fajr_Arc);
$fajr_prayer= $algdeerclass->fajr_prayer($fajr_time);
######
$sanexday = new prayer_time;

$y= date("Y");
$m= date("n");
$d= date("j")+1;
$dd= date("j");
//$d=stripslashes($vbulletin->options['ain_prayer_offset3']);
//$m=stripslashes($vbulletin->options['ain_prayer_offset2']);
//$y=stripslashes($vbulletin->options['ain_prayer_offset1']);
	// pi 
$pi = 3.14159265358979323846;

	//   
$long = 46.716667;

	//  
$lat = 24.633333;

	//  
$zone =3;

        //  
$zone_desc = $vbulletin->options['ain_prayer_description'];  

$julian_day = $sanexday->julian_day($y, $m, $d);
$sun_long = $sanexday->sun_long($julian_day);
$sun_period = $sanexday->sun_period($julian_day);
$Lambda = $sanexday->sun_wave_long($sun_long, $sun_period, $pi);
$Obliquity = $sanexday->obliquity($julian_day);
$Alpha = $sanexday->alpha($Obliquity, $Lambda, $pi);
$ST = $sanexday->starry_time($julian_day);
$Dec = $sanexday->sun_obliquity($Obliquity, $Lambda, $pi);

$noon = $sanexday->sun_miday($Alpha, $ST);
$UT_noon = $sanexday->international_midday($noon, $long);
$local_noon = $sanexday->local_noon($UT_noon, $zone);
$zuhr_prayer2 = $sanexday->zuhr_time($local_noon);

$AsrAlt = $sanexday->asr_alt($lat, $Dec, $pi);
$AsrAlt2 = $sanexday->asr_alt2($lat, $Dec, $pi);		
$AsrArc = $sanexday->asr_arc($AsrAlt, $lat, $Dec, $pi);
$AsrArc2 = $sanexday->asr_arc2($AsrAlt2, $lat, $Dec, $pi);
$AsrTime = $sanexday->asr_time($local_noon, $AsrArc);
$AsrTime2 = $sanexday->asr_time2($local_noon, $AsrArc2);
$asr_prayer3 = $sanexday->asr_prayer_time($AsrTime);
$asr_prayer2 = $sanexday->asr_prayer_time2($AsrTime2);

$Durinal_Arc = $sanexday->Durinal_Arc ($lat, $Dec, $pi);
$sun_rise =  $sanexday->sun_rise($local_noon, $Durinal_Arc);
$Shrouk_prayer2 = $sanexday->shrouk_prayer($sun_rise);
$sun_set = $sanexday->sun_set($local_noon, $Durinal_Arc);

$goroub_prayer = $sanexday->goroub_prayer($sun_set);
$maghrib_prayer2 = $sanexday->maghrib_prayer($sun_set);
$eshaain = $sanexday->eshaain_prayer($sun_set);

$Esha_Arc = $sanexday->esha_arc($lat, $Dec, $pi);
$esha_time= $sanexday->esha_time($local_noon, $Esha_Arc);
$esha_prayer2= $sanexday->esha_prayer($esha_time);

$Fajr_Arc= $sanexday->fajr_arc($lat, $Dec, $pi);
$fajr_time= $sanexday->fajr_time($local_noon, $Fajr_Arc);
$fajr_prayer2= $sanexday->fajr_prayer($fajr_time);

/**
* @version 3.1.0 Hijriah Date Module
* @package Mohd Farhan Rahmat based on Zumaidi Zainuddin
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
*/

/**
* @version 3.1.0 Hijriah Date Module
* @package Mohd Farhan Rahmat based on Zumaidi Zainuddin
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
*/

//       
$modification = 0;

$b_01 = "";
$b_02 = "";
$b_03 = " ";
$b_04 = " ";
$b_05 = " ";
$b_06 = " ";
$b_07 = "";
$b_08 = "";
$b_09 = "";
$b_10 = "";
$b_11 = " ";
$b_12 = " ";

///////// Days //////////
$h_01 = "b_t_2";  // Sunday
$h_02 = "b_t_3"; // Monday
$h_03 = "b_t_4"; // Tuesday
$h_04 = "b_t_5"; // Wednesday
$h_05 = "b_t_6";	// Thursday
$h_06 = "b_t_7";	// Friday
$h_07 = "b_t_1";	// Saturday

?>



<div align="center" id="hijriah">

<style type="text/css">
<!--
.bulan {
	color:#ffffff;
	font-family:  Arial, Helvetica, sans-serif;
	font-size: 16px;
	font-weight:bold;
	text-transform: uppercase;
	padding-left:3px;
}

.hari {
	color:#000000;
	font-family: Times New Roman, Arial, Helvetica, sans-serif;
	font-size: 45px;
	font-weight: bold;
	text-transform: uppercase;
	line-height: 0.7em;
}

.namahari {
	color:#000000;
	font-family: Tahoma, Helvetica, sans-serif;
	font-size: 11px;
	text-transform: uppercase;
}

.tahun {
	color:#000000;
	font-family: Tahoma, Helvetica, sans-serif;
	font-size: 12px;
}

-->

</style>

<?php

$ztoday = getdate(time() + (3600));
$zyr = $ztoday[year];
$zd=$ztoday[mday]+ $modification;
$zm=$ztoday[mon];
$zy=$zyr;



if (($zy>1582)||(($zy==1582)&&($zm>10))||(($zy==1582)&&($zm==10)&&($zd>14)))
	{


        $zjd=(int)((1461*($zy + 4800 + (int)( ($zm-14) /12) ))/4) + (int)((367*($zm-2-12*((int)(($zm-14)/12))))/12)-(int)((3*(int)(( ($zy+4900+(int)(($zm-14)/12))/100)))/4)+$zd-32075;
        }
 else
	{
        $zjd = 367*$zy-(int)((7*($zy+5001+(int)(($zm-9)/7)))/4)+(int)((275*$zm)/9)+$zd+1729777;
	}

$zl=$zjd-1948440+10632;
$zn=(int)(($zl-1)/10631);
$zl=$zl-10631*$zn+354;
$zj=((int)((10985-$zl)/5316))*((int)((50*$zl)/17719))+((int)($zl/5670))*((int)((43*$zl)/15238));
$zl=$zl-((int)((30-$zj)/15))*((int)((17719*$zj)/50))-((int)($zj/16))*((int)((15238*$zj)/43))+29;
$zm=(int)((24*$zl)/709);
$zd=$zl-(int)((709*$zm)/24);
$zy=30*$zn+$zj-30;

if($zm==1){ $bulan = $b_01;}
if($zm==2){ $bulan = $b_02;}
if($zm==3){ $bulan = $b_03;}
if($zm==4){ $bulan = $b_04;}
if($zm==5){ $bulan = $b_05;}
if($zm==6){ $bulan = $b_06;}
if($zm==7){ $bulan = $b_07;}
if($zm==8){ $bulan = $b_08;}
if($zm==9){ $bulan = $b_09;}
if($zm==10){ $bulan = $b_10;}
if($zm==11){ $bulan = $b_11;}
if($zm==12){ $bulan = $b_12;}

if($ztoday[wday]==0){ $hari = $h_01;}
if($ztoday[wday]==1){ $hari = $h_02;}
if($ztoday[wday]==2){ $hari = $h_03;}
if($ztoday[wday]==3){ $hari = $h_04;}
if($ztoday[wday]==4){ $hari = $h_05;}
if($ztoday[wday]==5){ $hari = $h_06;}
if($ztoday[wday]==6){ $hari = $h_07;}

?>
<TABLE WIDTH=162 height="210" BORDER=0 align="center" CELLPADDING=0 CELLSPACING=0 background="images/<? echo "$hari"; ?>.gif" style="background-repeat:no-repeat; background-position:center;" ?>
	<TR>
		<TD height="40" align="center" valign="bottom"><span class="bulan"></span></TD>
	</TR><br>
	<TR>
		<TD height="40" align="center" valign="bottom"><span class="hari" lang="ar"><? echo "$zd"; ?></span>
	 </TD>
	</TR>
	<TR>
	<TD height="30" align="center" valign="top">
		  <span class="namahari" lang="ar"><? echo "$zy"; ?> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <? echo "$bulan"; ?><br>[]</span>
</TD>
	</TR></TABLE>  
<TABLE WIDTH= "230"
<TR><TD height="10" align="center" valign="top"><span class="tahun"><? echo ""; ?>
</span></TD>
<TD height="10" align="center" valign="top"><span class="tahun"><? echo ""; ?>
 </span></TD>
</TR>
<TR><TD height="10" align="center" valign="top"><span class="tahun"><? echo "$zuhr_prayer"; ?>
 $zuhr_prayer </span></TD>
<TD height="10" align="center" valign="top"><span class="tahun"><? echo "$zuhr_prayer2"; ?>
 $zuhr_prayer2 </span></TD>
</TR>
<TR>
<TD height="10" align="center" valign="top"><span class="tahun"><? echo "$fajr_prayer"; ?>$fajr_prayer </span></TD>
<TD height="10" align="center" valign="top"><span class="tahun"><? echo "$fajr_prayer2"; ?>$fajr_prayer2 </span></TD>
</TR>
<TR>
<TD height="10" align="center" valign="top"><span class="tahun"><? echo "$asr_prayer"; ?>$asr_prayer </span></TD>
<TD height="10" align="center" valign="top"><span class="tahun"><? echo "$asr_prayer3"; ?>$asr_prayer3 </span></TD>
</TR>
<TR>
<TD height="10" align="center" valign="top"><span class="tahun"><? echo "$maghrib_prayer"; ?> $maghrib_prayer &nbsp</span></TD>
<TD height="10" align="center" valign="top"><span class="tahun"><? echo "$maghrib_prayer2"; ?> $maghrib_prayer2 &nbsp</span></TD>
</TR>
<TR>
<TD height="10" align="center" valign="top"><span class="tahun"><? echo "$esha_prayer"; ?> $esha_prayer &nbsp</span></TD>
<TD height="10" align="center" valign="top"><span class="tahun"><? echo "$esha_prayer2"; ?> $esha_prayer2 &nbsp</span></TD>
</TR>
<TR>
<TD height="5" align="center" valign="top"><span class="tahun"><? echo "$Shrouk_prayer"; ?>$Shrouk_prayer </span></TD>
<TD height="5" align="center" valign="top"><span class="tahun"><? echo "$Shrouk_prayer2"; ?>$Shrouk_prayer2 <img src="http://alshafen.atwebpages.com/vb/uploaded/1_01613135632.png" width="15" highet="16"/> </span></TD>
</TR>
<TR>
<TD height="14" align="left" valign="top"><span class="tahun"><? echo "$y"; ?>$y -</span></TD>
<TD height="10" align="center" valign="top"><span class="tahun"><? echo "$m"; ?>$m -</span></TD>
<TD height="10" align="righet" valign="top"><span class="tahun"><? echo "$dd"; ?>$dd</span></TD></TR><br>
<TR><TD height="29" align="center" valign="top"><span class="tahun"><div align="center" dir="rtl"><span id="digitalclock" class="styling"></span>
<script>
<!--
var alternate=0
var standardbrowser=!document.all&&!document.getElementById
if (standardbrowser)
document.write('<form name="tick"><input type="text" name="tock" size="6"></form>')
function show(){
if (!standardbrowser)
var clockobj=document.getElementById? document.getElementById("digitalclock") : document.all.digitalclock
var Digital=new Date()
var hours=Digital.getHours()
var minutes=Digital.getMinutes()
var dn=""
if (hours==12) dn=""
if (hours>12){
dn=""
hours=hours-12
}
if (hours==0) hours=12
if (hours.toString().length==1)
hours="0"+hours
if (minutes<=9)
minutes="0"+minutes
if (standardbrowser){
if (alternate==0)
document.tick.tock.value=minutes+" : "+hours+" "+dn
else
document.tick.tock.value=minutes+"   "+hours+" "+dn
}
else{
if (alternate==0)
clockobj.innerHTML=minutes+"<font color='##BBBBBB'>&nbsp;:&nbsp;</font>"+hours+" "+dn+"<sup style='font-size:1px'>"+"</sup>"
else
clockobj.innerHTML=minutes+"<font color='#245DD7'>&nbsp;:&nbsp;</font>"+hours+" "+dn+"<sup style='font-size:1px'>"+"</sup>"
}
alternate=(alternate==0)? 1 : 0
setTimeout("show()",1000)
}
window.onload=show
//-->
</script></div></span></TD>
	</TR>
</TABLE>
</div>