<?php
// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('plugins');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
// don't allow demo version or admin with no permission to administer plugins
if (is_demo_mode() OR !can_administer('canadminplugins'))
{
	print_cp_no_permission();
}

$vbulletin->input->clean_array_gpc('r', array('pluginid' => TYPE_UINT));

// ############################# LOG ACTION ###############################
log_admin_action(iif($vbulletin->GPC['pluginid'] != 0, 'plugin id = ' . $vbulletin->GPC['pluginid']));

// #############################################################################
// ########################### START MAIN SCRIPT ###############################
// #############################################################################

print_cp_header($vbphrase['plugin_system']);


if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'modify';
}


$vbulletin->input->clean_gpc('r', 'vbulletin_collapse', TYPE_NOCLEAN);
$vbcollapse = array();
if (!empty($vbulletin->GPC['vbulletin_collapse']))
{
	$val = preg_split('#\n#', $vbulletin->GPC['vbulletin_collapse'], -1, PREG_SPLIT_NO_EMPTY);
	foreach ($val AS $key)
	{
		$vbcollapse["collapseobj_$key"] = 'display:none;';
		$vbcollapse["collapseimg_$key"] = '_collapsed';
		$vbcollapse["collapsecel_$key"] = '_collapsed';
	}
	unset($val);
}


// #############################################################################

if ($_REQUEST['do'] == 'modify')
{
	?>
	<script type="text/javascript">
	function js_page_jump(sid)
	{
		var action = eval("document.cpform.s" + sid + ".options[document.cpform.s" + sid + ".selectedIndex].value");
		if (action != '')
		{
			switch (action)
			{
				case 'productdisable': page = "plugin.php?do=productdisable&productid="; break;
				case 'productenable': page = "plugin.php?do=productenable&productid="; break;
				case 'productedit': page = "plugin.php?do=productedit&productid="; break;
				case 'productexport': page = "plugin.php?do=productexport&productid="; break;
				case 'productdelete': page = "plugin.php?do=productdelete&productid="; break;
				default: return;
			}
			document.cpform.reset();
			jumptopage = page + sid + "&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";
			window.location = jumptopage;
		}
		else
		{
			alert("<?php echo $vbphrase['invalid_action_specified']; ?>");
		}
	}
	</script>
	<?php
	if (!$vbulletin->options['enablehooks'] OR defined('DISABLE_HOOKS'))
	{
		print_form_header('', '');
		if (!$vbulletin->options['enablehooks'])
		{
			print_description_row($vbphrase['plugins_disabled_options']);
		}
		else
		{
			print_description_row($vbphrase['plugins_disable_config']);
		}
		print_table_footer();
	}

	$products = fetch_product_list();

	print_form_header('plugin', 'updateactive');
	print_table_header($vbphrase['plugin_system'], 4);
	print_cells_row(array("$vbphrase[product] / $vbphrase[title]", 'Hookname', $vbphrase['active'], $vbphrase['controls']), 1);

	$plugins = $db->query_read("SELECT plugin.*,product.active AS productactive, product.productid FROM " . TABLE_PREFIX . "plugin AS plugin
	LEFT JOIN " . TABLE_PREFIX . "product AS product ON (product.productid=plugin.product)
	ORDER BY product, title, hookname");
	$prevproduct = '';
	
 	while ($plugin = $db->fetch_array($plugins))
	{

		$title = htmlspecialchars_uni($plugin['title']);
		$title = $plugin['active'] ? $title : "<strike>$title</strike>";

		$product = $products[($plugin['product'] ? $plugin['product'] : 'vbulletin')];
		$product = ($plugin['productactive'] OR $plugin['product'] == 'vbulletin') ? "<b>$product</b>" : "<strike>$product</strike>";

		if (!$product)
		{
			$product = "<em>$plugin[product]</em>";
		}

		if ($plugin['product'] != $prevproduct)
		{
		   	if ($prevproduct != '')
			{
			echo('</tbody>');
			}
		$options= array('productedit' => $vbphrase['edit']);
		if ($plugin['productactive'])
		{
			$options['productdisable'] = $vbphrase['disable'];
		}
		else
		{
			$options['productenable'] = $vbphrase['enable'];
		}
		$options['productexport'] = $vbphrase['export'];
		$options['productdelete'] = $vbphrase['uninstall'];
			print_description_row("<span style=\"float: right\"><select name=\"s$plugin[productid]\" onchange=\"js_page_jump('$plugin[productid]');\" class=\"bginput\">\n" . construct_select_options($options) . "\t</select>&nbsp;<input type=\"button\" class=\"button\" value=\"" . $vbphrase['go'] . "\" onclick=\"js_page_jump('$plugin[productid]');\" /></span><a href=\"#\" onclick=\"return toggle_collapse('$plugin[product]')\"><img style=\"vertical-align: middle\" id=\"collapseimg_$plugin[product]\" src=\"../images/buttons/collapse_alt{$vbcollapse["collapseimg_$plugin[product]"]}.gif\" /></a> $product", 0, 4, 'tfoot');
			echo("<tbody id=\"collapseobj_$plugin[product]\" style=\"" . $vbcollapse["collapseobj_$plugin[product]"] . "\">");
			$prevproduct = $plugin['product'];
		}

		print_cells_row(array(
			"<a href=\"plugin.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&amp;pluginid=$plugin[pluginid]\">$title</a>",
			$plugin['hookname'],
			"<input type=\"checkbox\" name=\"active[$plugin[pluginid]]\" value=\"1\"" . ($plugin['active'] ? ' checked="checked"' : '') . " />",
			construct_link_code($vbphrase['edit'], "plugin.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&amp;pluginid=$plugin[pluginid]") .
			construct_link_code($vbphrase['delete'], "plugin.php?" . $vbulletin->session->vars['sessionurl'] . "do=delete&amp;pluginid=$plugin[pluginid]")
		));
	}
	echo('</tbody>');

	print_submit_row($vbphrase['save_active_status'], false, 4);

	echo '<p align="center">' . construct_link_code($vbphrase['add_new_plugin'], "plugin.php?" . $vbulletin->session->vars['sessionurl'] . "do=add") . ' ' . construct_link_code($vbphrase['add_import_product'], "plugin.php?" . $vbulletin->session->vars['sessionurl'] . "do=productadd") . '</p>';
}

print_cp_footer();
?>