<?php
date_default_timezone_set('Asia/Riyadh');
class prayer_time {
    function julian_day($y, $m, $d) {
        $day =((367*$y)-((INT)((7/4)*($y+(INT)(($m+9)/12))))+(INT)(275*($m/9))+$d-730531.5);
        return $day;
    }
    
    
function sun_long($julian_day) {
        $l=  (280.461+0.9856474*$julian_day);
        if($l>360) {
            $l= (($l/360)-(INT)($l/360))*360;
        }

        return $l;
    }
    function sun_period($julian_day)
    {
        $m = (357.528+0.9856003*$julian_day);
        if($m>360)
        {
            $m= (($m/360)-(INT)($m/360))*360;
        }

        return $m;
    }
    
    function sun_wave_long($sun_long, $sun_period, $pi)
    {
        $Lambda = $sun_long +1.915*SIN($sun_period*$pi/180)+0.02*SIN(2* $sun_period*$pi/180);
        return $Lambda;
    }
    
    // obliquity
    
function obliquity($julian_day)
    {
        $Obliquity = (23.439-0.0000004*$julian_day);
        return $Obliquity;
    }
    
    // alpha
    
    function alpha($Obliquity, $Lambda, $pi)
    {

        $Alpha =ATAN (COS($Obliquity*$pi/180)*TAN($Lambda*$pi/180))*180/$pi;
        if($Alpha>90 AND $Alpha<180)
        {
            $Alpha= $Alpha + 180;
        }
        else
        {
            $Alpha= $Alpha + 360;
        }

        $Alpha=  $Alpha + 90 * (((INT)($Lambda/90))-((INT)($Alpha/90)));



        return $Alpha;
    }
    
    //  ST
    
    function starry_time($julian_day)
    {
        $ST = (100.46+0.985647352*$julian_day);
        if ($ST>360)
        {
            $ST=  (($ST/360)-((INT)($ST/360)))*360;
        }
        return $ST;
    }
    

    // Dec
    
    function sun_obliquity($Obliquity, $Lambda, $pi) {
        $Dec = ASIN(SIN($Obliquity*$pi/180)*SIN($Lambda*$pi/180))*180/$pi;
        return $Dec;
    }
    
    // noon
    
    function sun_miday($Alpha, $ST) {
        $noon = ($Alpha - $ST);
        if($noon<0)
        {
            $noon = $noon+360;
        }
        return $noon;
    }
    
    // UT NOON
    
    function international_midday($noon, $long) {
        $UT_noon = $noon - $long;
        return $UT_noon;
    }
    
    // local_noon
    
    function local_noon($UT_noon, $zone) {
        $local_noon = $UT_noon/15+$zone;
        return $local_noon;
    }

    // وقت صلاة الظهر
     
    function zuhr_time($local_noon) {
        $timeh = floor ($local_noon);
		$timeh2 = ($timeh < 10) ? '0'.$timeh : $timeh ;
        $timem = floor (($local_noon - (INT)($local_noon))*60);
		$timem2 = ($timem < 10) ? '0'.$timem : $timem ;
        $zuhr_prayer = "$timeh2:$timem2";
        
        return $zuhr_prayer;

    }
    
    // Asr_Alt

    function asr_alt($lat, $Dec, $pi) {
		$Asr_Alt= ATAN(1+TAN(($lat-$Dec)*$pi/180))*180/$pi;
        return $Asr_Alt;
    }
	
	// حساب وقت صلاة العصر - المذهب الحنفي
	
	  function asr_alt2($lat, $Dec, $pi) {
		$Asr_Alt2= ATAN(2+TAN(($lat-$Dec)*$pi/180))*180/$pi;
		return $Asr_Alt2;
    }
	
    // AsrArc
	function asr_arc($AsrAlt, $lat, $Dec, $pi) {
		$AsrArc= ACOS((SIN((90-$AsrAlt)*$pi/180)-SIN($Dec*$pi/180)*SIN($lat*$pi/180))/(COS($Dec*$pi/180)*COS($lat*$pi/180)))*180/$pi/15; 
		return $AsrArc;
    }
	
	function asr_time($local_noon, $AsrArc) {
        $AsrTime = $local_noon + $AsrArc; 
        return $AsrTime;
    }
	
	// حساب وقت صلاة العصر - المذهب الحنفي
	function asr_arc2($AsrAlt2, $lat, $Dec, $pi) {
		$AsrArc2= ACOS((SIN((90-$AsrAlt2)*$pi/180)-SIN($Dec*$pi/180)*SIN($lat*$pi/180))/(COS($Dec*$pi/180)*COS($lat*$pi/180)))*180/$pi/15; 
		return $AsrArc2;
    }
    
    function asr_time2($local_noon, $AsrArc2) {
        $AsrTime2 = $local_noon + $AsrArc2; 
        return $AsrTime2;
    }   
    
	// وقت صلاة العصر

    function asr_prayer_time($AsrTime) {
        $timeh = floor ($AsrTime);
        $timeh= $timeh-12;
		$timeh2 = ($timeh < 10) ? '0'.$timeh : $timeh ;
        $timem = floor (($AsrTime - (INT)($AsrTime))*60);
		$timem2 = ($timem < 10) ? '0'.$timem : $timem ;
        $asr_prayer = "$timeh2:$timem2";

        return $asr_prayer;

    } 
	
	// وقت صلاة العصر - المذهب الحنفي

    function asr_prayer_time2($AsrTime2) {
        $timeh = floor ($AsrTime2);
        $timeh= $timeh-12;
		$timeh2 = ($timeh < 10) ? '0'.$timeh : $timeh ;
        $timem = floor (($AsrTime2 - (INT)($AsrTime2))*60);
		$timem2 = ($timem < 10) ? '0'.$timem : $timem ;
        $asr_prayer2 = "$timeh2:$timem2";

        return $asr_prayer2;

    }  

    // Durinal_Arc
    
    function Durinal_Arc ($lat, $Dec, $pi) {
        $Durinal_Arc= Acos((SIN(-0.8333*$pi/180)-SIN($Dec*$pi/180)*SIN($lat*$pi/180))/(COS($Dec*$pi/180)*COS($lat*$pi/180)))*180/$pi;
        return $Durinal_Arc;
    }
    

    // sun_rise
    
    function sun_rise($local_noon, $Durinal_Arc) {
        $sun_rise= $local_noon - ($Durinal_Arc/15);
        
        return $sun_rise;
    }
    
    // وقت شروق الشمس
	
    function shrouk_prayer($sun_rise) {
        $timeh= floor($sun_rise);
		$timeh2 = ($timeh < 10) ? '0'.$timeh : $timeh ;
        $timem = floor (($sun_rise - (INT)($sun_rise))*60);
		$timem2 = ($timem < 10) ? '0'.$timem : $timem ;
        $sun_rise_prayer = "$timeh2:$timem2";
        
        return $sun_rise_prayer;
    }
    
    // sun_set
    
    function sun_set($local_noon, $Durinal_Arc) {
        $sun_set= $local_noon + ($Durinal_Arc/15);

        return $sun_set;
    }
    
     // وقت غروب الشمس

function goroub_prayer($sun_set) {
        $timeh= floor($sun_set);
        $timeh= $timeh-12;
		$timeh2 = ($timeh < 10) ? '0'.$timeh : $timeh ;
        $timem = floor (($sun_set - (INT)($sun_set))*60);
		$timem2 = ($timem < 10) ? '0'.$timem : $timem ;
        $goroub_prayer = "$timeh2:$timem2";

        return $goroub_prayer;
    }

	// وقت صلاة المغرب
	
    function maghrib_prayer($sun_set) {
        $timeh= floor($sun_set);
        $timeh= $timeh-12;
        $timeh2 = ($timeh < 10) ? '0'.$timeh : $timeh;
        $timem = floor (($sun_set - (INT)($sun_set))*60);
		$timem2 = ($timem < 10) ? '0'.$timem : $timem;
        $maghrib_prayer = "$timeh2:$timem2";
		
        return $maghrib_prayer;
    }
	
	// حساب وقت صلاة المغرب - المذهب الجعفري
	
    function eshaain_prayer($sun_set) {
        $timeh= floor($sun_set);
        $timeh= $timeh-12;
		$timeh2 = ($timeh < 10) ? '0'.$timeh : $timeh ;
        $timem = floor (($sun_set - (INT)($sun_set))*60 +15);
		$timem2 = ($timem < 10) ? '0'.$timem : $timem ;
        $eshaain_prayer = "$timeh2:$timem2";

        return $eshaain_prayer;
    }
	
	
    
    // Esha_Arc

    function esha_arc($lat, $Dec, $pi)
    {
        $Esha_Arc= Acos((SIN(-18*$pi/180)-SIN($Dec*$pi/180)*SIN($lat*$pi/180))/(COS($Dec*$pi/180)*COS($lat*$pi/180)))*180/$pi;
        return $Esha_Arc;
    }
    
    // esha_time
 
    function esha_time($local_noon, $Esha_Arc)
    {
        $esha_time= $local_noon + ($Esha_Arc/15);
        return $esha_time;
    }
    
    // وقت صلاة العشاء
    
    function esha_prayer($esha_time){
        $timeh= floor($esha_time);
        $timeh= $timeh-12;
		$timeh2 = ($timeh < 10) ? '0'.$timeh : $timeh ;
        $timem = floor (($esha_time - (INT)($esha_time))*60);
		$timem2 = ($timem < 10) ? '0'.$timem : $timem ;
        $esha_prayer = "$timeh2:$timem2";

        return $esha_prayer;
    }
    
	
    // Fajr_Arc
    
    function fajr_arc($lat, $Dec, $pi)
    {
        $Fajr_Arc= Acos((SIN(-18*$pi/180)-SIN($Dec*$pi/180)*SIN($lat*$pi/180))/(COS($Dec*$pi/180)*COS($lat*$pi/180)))*180/$pi;
        return $Fajr_Arc;
    }
    
    // fajr_time
    function fajr_time($local_noon, $Fajr_Arc)
    {
        $fajr_time= $local_noon - ($Fajr_Arc/15);
        return $fajr_time;
    }
    
    // وقت صلاة الفجر
    function fajr_prayer($fajr_time)
    {
        $timeh= floor($fajr_time);
		$timeh2 = ($timeh < 10) ? '0'.$timeh : $timeh ;
        $timem = floor (($fajr_time - (INT)($fajr_time))*60);
		$timem2 = ($timem < 10) ? '0'.$timem : $timem ;
        $fajr_time = "$timeh2:$timem2";

        return $fajr_time;
    }

}


######


/**
* @version 3.1.0 Hijriah Date Module
* @package Mohd Farhan Rahmat based on Zumaidi Zainuddin
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
*/

/**
* @version 3.1.0 Hijriah Date Module
* @package Mohd Farhan Rahmat based on Zumaidi Zainuddin
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
*/

// تعديل التاريخ بإضافة يوم او انقاص يوم
$modification = 0;

$b_01 = "محرم";
$b_02 = "صفر";
$b_03 = "ربيع الاول";
$b_04 = "ربيع الثاني";
$b_05 = "جمادى الاول";
$b_06 = "جمادى الثاني";
$b_07 = "رجب";
$b_08 = "شعبان";
$b_09 = "رمضان";
$b_10 = "شوال";
$b_11 = "ذو القعدة";
$b_12 = "ذو الحجة";

///////// Days //////////
$h_01 = "b_t_2";  // Sunday
$h_02 = "b_t_3"; // Monday
$h_03 = "b_t_4"; // Tuesday
$h_04 = "b_t_5"; // Wednesday
$h_05 = "b_t_6";	// Thursday
$h_06 = "b_t_7";	// Friday
$h_07 = "b_t_1";	// Saturday

?>



<div align="center" id="hijriah">

<style type="text/css">
<!--
.bulan {
	color:#ffffff;
	font-family:  Arial, Helvetica, sans-serif;
	font-size: 16px;
	font-weight:bold;
	text-transform: uppercase;
	padding-left:3px;
}

.hari {
	color:#000000;
	font-family: Times New Roman, Arial, Helvetica, sans-serif;
	font-size: 45px;
	font-weight: bold;
	text-transform: uppercase;
	line-height: 0.7em;
}

.namahari {
	color:#000000;
	font-family: Tahoma, Helvetica, sans-serif;
	font-size: 11px;
	text-transform: uppercase;
}

.tahun {
	color:#000000;
	font-family: Tahoma, Helvetica, sans-serif;
	font-size: 12px;
}

-->

</style>

<?php

$ztoday = getdate(time() + (3600));
$zyr = $ztoday[year];
$zd=$ztoday[mday]+ $modification;
$zm=$ztoday[mon];
$zy=$zyr;



if (($zy>1582)||(($zy==1582)&&($zm>10))||(($zy==1582)&&($zm==10)&&($zd>14)))
	{


        $zjd=(int)((1461*($zy + 4800 + (int)( ($zm-14) /12) ))/4) + (int)((367*($zm-2-12*((int)(($zm-14)/12))))/12)-(int)((3*(int)(( ($zy+4900+(int)(($zm-14)/12))/100)))/4)+$zd-32075;
        }
 else
	{
        $zjd = 367*$zy-(int)((7*($zy+5001+(int)(($zm-9)/7)))/4)+(int)((275*$zm)/9)+$zd+1729777;
	}

$zl=$zjd-1948440+10632;
$zn=(int)(($zl-1)/10631);
$zl=$zl-10631*$zn+354;
$zj=((int)((10985-$zl)/5316))*((int)((50*$zl)/17719))+((int)($zl/5670))*((int)((43*$zl)/15238));
$zl=$zl-((int)((30-$zj)/15))*((int)((17719*$zj)/50))-((int)($zj/16))*((int)((15238*$zj)/43))+29;
$zm=(int)((24*$zl)/709);
$zd=$zl-(int)((709*$zm)/24);
$zy=30*$zn+$zj-30;

if($zm==1){ $bulan = $b_01;}
if($zm==2){ $bulan = $b_02;}
if($zm==3){ $bulan = $b_03;}
if($zm==4){ $bulan = $b_04;}
if($zm==5){ $bulan = $b_05;}
if($zm==6){ $bulan = $b_06;}
if($zm==7){ $bulan = $b_07;}
if($zm==8){ $bulan = $b_08;}
if($zm==9){ $bulan = $b_09;}
if($zm==10){ $bulan = $b_10;}
if($zm==11){ $bulan = $b_11;}
if($zm==12){ $bulan = $b_12;}

if($ztoday[wday]==0){ $hari = $h_01;}
if($ztoday[wday]==1){ $hari = $h_02;}
if($ztoday[wday]==2){ $hari = $h_03;}
if($ztoday[wday]==3){ $hari = $h_04;}
if($ztoday[wday]==4){ $hari = $h_05;}
if($ztoday[wday]==5){ $hari = $h_06;}
if($ztoday[wday]==6){ $hari = $h_07;}

?>
