<?PHP

include("./class/DC-Template-200.class.php");
include("./class/DC-MySQL-102.class.php");
include("./config.inc.php");

/*******************************************************/

$cTML = new DCTemplate("./template/");
$cTML->TEMPLATE("MainDesign:mainDesign.tml");
$cTML->REPLACE_BLOCK("SiteTitle",$config["sitetitle"],'MainDesign');

/*******************************************************/

function f_con2db() {
	global $cDB,$config;

	if ( ! is_object($cDB) ) {
	     $cDB = new DCMySQL;
	     $cDB->dbhost = $config["dbhost"];
	     $cDB->dbname = $config["dbname"];
	     $cDB->dbusername = $config["dbusername"];
	     $cDB->dbpassword = $config["dbpassword"];
	     $cDB->connect();
	} // end if

} // end f_con2db function

/*******************************************************/

function f_print_msg($msg, $backto ="") {
	
	global $cTML;

	$cTML->TEMPLATE("MSG:MSG.tml");
	$cTML->REPLACE_BLOCK("MSG", $msg, "MSG");

	if ( $backto == "" ) {
		$cTML->REPLACE_BLOCK("URL", "javascript:history.back(1)" , "MSG");
	} else {
		$cTML->REPLACE_BLOCK("URL", $backto , "MSG");	
	}// end if

	$cTML->PRINT_TEMPLATE("MSG");

} // end f_print_msg function

/*******************************************************/

function f_main_design($block_body)
{
	global $cTML;

	$cTML->REPLACE_BLOCK("BODY", $block_body, "MainDesign");
	$cTML->PRINT_TEMPLATE("MainDesign");

} // end f_main_design function

/*******************************************************/

function f_print_template($template_name,$replace = "")
{
	global $cTML;

	$cTML->TEMPLATE("$template_name:$template_name.tml");

	if ( ! empty($replace) ) {
		while ( list($block_name, $replaceby) = each($replace) ) {
			$cTML->REPLACE_BLOCK($block_name, $replaceby, $template_name);
		} // end while loop
	}// end if

	f_main_design($cTML->GET_TEMPLATE("$template_name"));	
} // end PRINT_TEMPLATE function

/*******************************************************/

function f_get_subject() {

	global $tbl,$cDB;
	$subjects = array();
	$result = $cDB->query("SELECT * FROM " . $tbl["subject"]);
	while( $row = $cDB->result2array($result) ) {
		$subjects[$row[0]] = $row[1];
	}
	return($subjects);
}
?>