<?php



function HttpRequest($url, $header_only = false, $callback_function = '', $callback_param = '', $timeout = 10, $maxredirs = 2) {

	$urlinfo = parse_url($url);

	if (empty($urlinfo['scheme'])) {$urlinfo = parse_url('http://'.$url);}                                                                 

	if (empty($urlinfo["path"])) {$urlinfo["path"]="/";}

	if (empty($urlinfo['port'])) {

		switch($urlinfo['scheme']) {

			case "http":

					$urlinfo['port'] = 80;

					break; 

			case "https":

					$urlinfo['port'] = 443;

					break;               

		}

	}

	$cmd = ($header_only) ? 'HEAD' : 'GET';

	if (isset($urlinfo["query"])) {

		$request = "$cmd ".$urlinfo["path"]."?".$urlinfo["query"]." ";

	} 

	else {   

		$request = "$cmd ".$urlinfo["path"]." ";

	}

	$request .= "HTTP/1.0\r\n";

	$request .= "Host: ".$urlinfo['host']."\r\n";

	$request .= "User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\r\n";

	$request .= "Connection: close\r\n\r\n";

	$fp = @fsockopen($urlinfo['host'], $urlinfo['port'], $errno, $errstr, $timeout);

	if (!$fp) {

    $urlinfo['status'] = 'err';

		if ($callback_function) {

			$params[url] = $url;

			$params[status] = $urlinfo['status'];

			$params[urlinfo] = $urlinfo;

			$params[moreparam] = $callback_param;

			call_user_func($callback_function, $params);

		}

	}

	else {   

    $urlinfo['status'] = 'ok';

		socket_set_blocking($fp, 1);

		if(strcmp(phpversion(),'4.1.2') > 0) {

			@socket_set_timeout($fp, 0, 5000);

		}

		fwrite($fp, $request);

    $data = '';

		while (!feof($fp)) {

			$data .= fgets($fp, 4096);                     

		}

		fclose($fp);

		$tmp = explode("\r\n\r\n", $data, 2);

		$urlinfo['header'] = $tmp[0];

		$urlinfo['html'] = $tmp[1];

		if ((strpos(strtolower($urlinfo['header']), "location:")) && ($maxredirs > 0)) {

			preg_match("/\r\nlocation:(.*)/i", $urlinfo['header'], $match);

			if ($match) {   

				$location = trim($match[1]);

				if (strpos($location, 'http://') === 0 || strpos($location, 'http://')) {

					$redirect_url = $location;

				}

				elseif (strpos($location, '/') === 0) {

					$redirect_url = $urlinfo['scheme']."://".$urlinfo['host'].$location;

				} 

        else {

					$redirect_url = $urlinfo['scheme']."://".$urlinfo['host'].$urlinfo['path'].$location;

				}

				$maxredirs--;

				return HttpRequest($redirect_url, $header_only, $callback_function, $callback_param, $timeout, $maxredirs);

			}

		}

    if ($callback_function) {

      $params[url] = $url;

      $params[status] = $urlinfo['status'];

      $params[urlinfo] = $urlinfo;

      $params[moreparam] = $callback_param;

      call_user_func($callback_function, $params);

    }

	}

  return $urlinfo;

}



function HttpMultiRequest($urls, $header_only = false, $callback_function = '', $callback_params = array(), $timeout = 10, $maxredirects = 2) {

	$num_urls = count($urls);

	$numdone = array();

  $data = array();

	$done = false;



	for ($i = 0; $i < $num_urls; $i++) {

		$urlinfo[$i] = parse_url($urls[$i]);

		$maxredirs[$i] = $maxredirects;

		if (empty($urlinfo[$i]['scheme'])) {$urlinfo[$i] = parse_url('http://'.$url);}                                                                 

		if (empty($urlinfo[$i]["path"])) {$urlinfo[$i]["path"]="/";}

		if (empty($urlinfo[$i]['port'])) {

			switch($urlinfo[$i]['scheme']) {

			case "http": 

					$urlinfo[$i]['port'] = 80;

					break; 

			case "https":  

					$urlinfo[$i]['port'] = 443;

					break;               

			}

		}

		$cmd = ($header_only) ? 'HEAD' : 'GET';

		if (isset($urlinfo[$i]["query"])) {

			$request[$i] = "$cmd ".$urlinfo[$i]["path"]."?".$urlinfo[$i]["query"]." ";

		} 

		else {   

			$request[$i] = "$cmd ".$urlinfo[$i]["path"]." ";

		}

		$request[$i] .= "HTTP/1.0\r\n";

		$request[$i] .= "Host: ".$urlinfo[$i]['host']."\r\n";

		$request[$i] .= "User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\r\n";

		$request[$i] .= "Connection: close\r\n\r\n";

		$fp[$i] = @fsockopen($urlinfo[$i]['host'], $urlinfo[$i]['port'], $urlinfo[$i]['errno'], $urlinfo[$i]['errstr'], $timeout);

		if (!$fp[$i]) {

      $urlinfo[$i]['status'] = 'err';

			$numdone[$i] = 1;

			if ($callback_function) {

				$params[url] = $urls[$i];

				$params[status] = $urlinfo[$i]['status'];

				$params[urlinfo] = $urlinfo[$i];

				$params[moreparam] = $callback_params[$i];

				call_user_func($callback_function, $params);

			}

		}

		else {   

      $urlinfo[$i]['status'] = 'ok';

			socket_set_blocking($fp[$i], 1);

			if(strcmp(phpversion(),'4.1.2') > 0) {

				@socket_set_timeout($fp[$i], 0, 5000);

			}

			fwrite($fp[$i], $request[$i]);

		}       

	}



	while (!$done) {       

		for ($i = 0; $i < $num_urls; $i++) {

			if ($fp[$i]) {

				if (!feof($fp[$i])) {

					$data[$i] .= fgets($fp[$i], 4096);                     

				}

				elseif (empty($numdone[$i])) {

					$numdone[$i] = 1;

					$tmp[$i] = explode("\r\n\r\n", $data[$i], 2);

					$urlinfo[$i]['header'] = $tmp[$i][0];

					$urlinfo[$i]['html'] = $tmp[$i][1];

					if ((strpos(strtolower($urlinfo[$i]['header']), "location:")) && ($maxredirs[$i] > 0)) {

						preg_match("/\r\nlocation:(.*)/i", $urlinfo[$i]['header'], $match[$i]);

						if ($match[$i]) {   

							$location[$i] = trim($match[$i][1]);

              if (strpos($location[$i], 'http://') === 0 || strpos($location[$i], 'http://')) {

                $redirect_url[$i] = $location[$i];

              }

              elseif (strpos($location[$i], '/') === 0) {

                $redirect_url[$i] = $urlinfo[$i]['scheme']."://".$urlinfo[$i]['host'].$location[$i];

              } 

              else {

                $redirect_url[$i] = $urlinfo[$i]['scheme']."://".$urlinfo[$i]['host'].$urlinfo[$i]['path'].$location[$i];

              }

							$maxredirs[$i]--;                         

							$urlinfo[$i] = HttpRequest($redirect_url[$i], $header_only, $callback_function, $callback_params[$i], $timeout, $maxredirs[$i]);

						}

					}

          if ($callback_function) {

            $params[url] = $urls[$i];

            $params[status] = $urlinfo[$i]['status'];

            $params[urlinfo] = $urlinfo[$i];

            $params[moreparam] = $callback_params[$i];

            call_user_func($callback_function, $params);

          }

				}

			}

		}

		$done = (array_sum($numdone) == $num_urls);

	}

	for ($i = 0; $i < $num_urls; $i++) {

		if ($fp[$i]) {

			fclose($fp[$i]);

		}

	}

	return $urlinfo;   

}



?>