<?php



/**

 *

 * INDEXU

 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.

 *

 * INDEXU(tm) is protected by Indonesia and International copyright laws.

 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,

 * violators will be prosecuted. To obtain a license for using INDEXU(tm),

 * please register at Nicecoder home page at http://www.nicecoder.com

 *

 * Author:

 *    Dody Rachmat Wicaksono (dody@nicecoder.com)

 *    M. Zuber (zubby@nicecoder.com)

 *

 */



  /*===================================================

    ViewPendingEditor()

  ===================================================*/



  function ViewPendingEditor() {



    // vars global configuration

    global $dbConn, $category_separator, $admin_template_path;



    // vars url & form

    global $pg_which;



    // vars messages

    global $msg;



    // vars template

    global $editor, $pagination, $chk_box, $num_rows, $param;





    $links_obj = new clsLink;



    $links_obj->table_name = "idx_link";

    $links_obj->category_table_name = "idx_category";

    $links_obj->editor_table_name = "idx_editor";

    $links_obj->user_table_name = "idx_users";



    $links_obj->date_format = $msg["20231"];



    $links_obj->paging = true;

    $links_obj->pg_size = 15;

    $links_obj->href = "editor_validate.php";

    $links_obj->more_param = "";

    $links_obj->category_file = "../browse.php";

    $links_obj->category_separator = $category_separator;

    $links_obj->template_file = $admin_template_path . "editor_validate_rows.html";



    $param = "pg_which=$pg_which";



    $editor = $links_obj->DisplayEditor();



    $pagination = $links_obj->pagination;

    $num_rows = $links_obj->num_rows;



    DisplayTemplate($admin_template_path . "editor_validate.html",

      "\$num_rows,\$pagination,\$editor,\$param");

  }





  /*===================================================

    ApproveEditor()

  ===================================================*/



  function ApproveEditor() {



    // vars global configuration

    global $dbConn, $admin_template_path, $email_address, $theme_path, $active_theme;



    // vars url & form

    global $num_rows;



    // vars messages

    global $msg;



    // vars template

    global $message, $title, $category, $name, $email, $username;



    $tpl = new Template();



    $theme_path = $theme_path . $active_theme;



    $links_obj = new clsLink;

    $links_obj->table_name = "idx_link";

    $links_obj->editor_table_name = "idx_editor";

    $links_obj->user_table_name = "idx_users";



    $i=1;

    while($i<=$num_rows){

      $var = "chkbox_$i";

      $id = $GLOBALS["$var"];



      $param = split("&",$id);

      $username = $param[0];

      $cat_id = $param[1];



      if(!empty($id)) {



        $links_obj->ApproveEditor($username,$cat_id);



        $message .= $msg["20221"];

        $tpl->assign('username', $username);

        $message = $tpl->fetch('var:' . $message);



        // send email submitter

        $body = EvalTemplate($theme_path . "/mail/become_editor_approved.mail", $links_obj->email_template_fields);

        $from = $email_address;

        mail($email, $msg["20242"], $body, "From: $from \nX-Mailer: INDEXU_X-Mailer/1.0");



      }

      $i++;

    }



    if(empty($message)) $message = $msg["20222"];



    DisplayTemplate($admin_template_path . "message.html", "\$message");

  }





  /*===================================================

    RejectEditor()

  ===================================================*/



  function RejectEditor() {



    // vars global configuration

    global $dbConn, $admin_template_path, $email_address, $theme_path, $active_theme;



    // vars url & form

    global $num_rows;



    // vars messages

    global $msg;



    // vars template

    global $message, $category, $name, $email, $username;



    $tpl = new Template();



    $theme_path = $theme_path . $active_theme;



    $links_obj = new clsLink;

    $links_obj->table_name = "idx_link";

    $links_obj->editor_table_name = "idx_editor";

    $links_obj->user_table_name = "idx_users";



    $i=1;

    while($i<=$num_rows){

      $var = "chkbox_$i";

      $id = $GLOBALS["$var"];



      $param = split("&",$id);

      $username = $param[0];

      $cat_id = $param[1];



      if(!empty($id)) {

        $links_obj->RejectEditor($username,$cat_id);



        $message .= $msg["20223"];

        $tpl->assign('username', $username);

        $message = $tpl->fetch('var:' . $message);



        // send email submitter

        $body = EvalTemplate($theme_path . "/mail/become_editor_rejected.mail", $links_obj->email_template_fields);

        $from = $email_address;

        mail($email, $msg["20244"], $body, "From: $from \nX-Mailer: INDEXU_X-Mailer/1.0");



      }

      $i++;

    }



    if(empty($message)) $message = $msg["20222"];



    DisplayTemplate($admin_template_path . "message.html", "\$message");

  }





  /*===================================================

    main

  ===================================================*/



  include "../application.php";



  RunPreFilter(__FILE__);



  DisplayTemplate($admin_template_path . "header.html");

  if (empty($pflag)) {

    ViewPendingEditor();

  }

  elseif ($pflag == 'approve') {

    ApproveEditor();

  }

  elseif ($pflag == 'reject') {

    RejectEditor();

  }

  DisplayTemplate($admin_template_path . "footer.html");



  RunPostFilter(__FILE__);



?>