<?php



/**

 *

 * INDEXU

 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.

 *

 * INDEXU(tm) is protected by Indonesia and International copyright laws.

 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,

 * violators will be prosecuted. To obtain a license for using INDEXU(tm),

 * please register at Nicecoder home page at http://www.nicecoder.com

 *

 * Author:

 *    Dody Rachmat Wicaksono (dody@nicecoder.com)

 *    M. Zuber (zubby@nicecoder.com)

 *

 */



  class navigator {

    var $pg_size    = 10;

    var $pg_which   = 1;

    var $cp_size    = 10;

    var $rec_count  = 0;

    var $rec_start  = 0;

    var $more_param = "";

    var $href       = "";

    var $page_file  = "";

    var $page_title = "";



    var $page_text  = "Pages";

    var $first_text = "[First]";

    var $last_text  = "[Last]";

    var $prev_text  = "[Prev]";

    var $next_text  = "[Next]";



    var $active_link_color  = "";

    var $disable_link_color = "gray";



    function init() {

      global $lang;

      $this->rec_start = ($this->pg_which - 1) * $this->pg_size;

      if ($lang['nav_page']) {

        $this->page_text = $lang['nav_page'];

      }

      if ($lang['nav_first']) {

        $this->first_text = $lang['nav_first'];

      }

      if ($lang['nav_last']) {

        $this->last_text = $lang['nav_last'];

      }

      if ($lang['nav_prev']) {

        $this->prev_text = $lang['nav_prev'];

      }

      if ($lang['nav_next']) {

        $this->next_text = $lang['nav_next'];

      }

    }



    function print_all() {

      $length = $this->rec_count;

      if ($length <= $this->pg_size) {

        return;

      }



      if (!is_numeric($this->pg_which)) {

        $this->pg_which = 1;

      }



      $pref = (strpos($this->href, "?") === FALSE) ? "?" : "&";

      $radius = floor($this->cp_size / 2 * $this->pg_size);

      $offset = ($this->pg_which - 1) * $this->pg_size;

      if ($offset < $radius) {

        $start = 0;

      }

      elseif ($offset <= $length - $radius) {

        $start = $offset - $radius;

      }

      else {

        $start = (floor($length / $this->pg_size) - $this->cp_size) * $this->pg_size + $this->pg_size;

        if ($start < 0) {

          $start = $this->pg_size;

        }

      }



      $out = "";

      if ($offset > 0) {

        if ($start > 1) {

          $out .= "<a href=\"" . $this->href . $pref . "pg_which=1$this->more_param\" style=\"color: $this->active_link_color\">". $this->first_text ."</a>\n";

        }

        $out .= "<a href=\"" . $this->href . $pref . "pg_which=" . ($this->pg_which - 1) . $this->more_param . "\" style=\"color: $this->active_link_color\">". $this->prev_text ."</a>\n";

      }



      for ($i = $start; (($i < $length) && ($i < $start + $this->cp_size * $this->pg_size)); $i += $this->pg_size) {

        if ($i == $offset) {

          $out .= "<font color=\"$this->disable_link_color\"><b>" . ($i / $this->pg_size + 1) . "</b></font>\n";

        }

        else {

          $out .= "<a href=\"" . $this->href . $pref . "pg_which=" . ($i / $this->pg_size + 1) . $this->more_param . "\" style=\"color: $this->active_link_color\">" . ($i / $this->pg_size + 1) . "</a>\n";

        }

      }



      if ($offset < $length - $this->pg_size) {

        $out .= "<a href=\"" . $this->href . $pref . "pg_which=" . ($this->pg_which + 1) . $this->more_param . "\" style=\"color: $this->active_link_color\">". $this->next_text ."</a>\n";

        if ((ceil($length/$this->pg_size) - 1) * $this->pg_size >= $i) {

          $out .= "<a href=\"" . $this->href . $pref . "pg_which=" . ceil($length/$this->pg_size) . $this->more_param . "\" style=\"color: $this->active_link_color\">". $this->last_text ."</a>\n";

        }

      }



      if (GetModRewriteStatus() == '1') {

        $this->apply_seo($out);

      }



      $out = $this->page_text . ": " . $out;



      return $out;



    }



    function apply_seo(&$out) {

      if ($this->page_file == "browse") {

        $src[] = "|\"browse.php\?pg_which=(\w*?)&cat=(\w*?)\"|mse";

        $replacement[] = "\$this->apply_browse_seo('\\1', '\\2')";

      }

      

      if (is_array($src)) {

        $out = preg_replace($src, $replacement, $out);

      }

    }



    function apply_browse_seo($page, $cat) {

      $page_title            = SEOReplace($this->page_title);

      $mod_rewrite_pattern   = GetModRewritePatternCategory();

      if (strpos($mod_rewrite_pattern, '{$cat_path}') === FALSE) {

        $mod_rewrite_pattern = str_replace('{$cat_name}', $page_title, $mod_rewrite_pattern);

        $mod_rewrite_pattern = str_replace('{$cat_id}', $cat, $mod_rewrite_pattern);

        $mod_rewrite_pattern = str_replace('{$page}', $page, $mod_rewrite_pattern);

        $out                 = strtolower($mod_rewrite_pattern);

      }

      else {

        $page_text = substr(strrchr($mod_rewrite_pattern, '/'), 1);

        $out = $_SERVER['REQUEST_URI'];

        if (strpos($out, '.html') !== FALSE) {

          $outs = explode('/', $out);

          unset($outs[@count($outs) - 1]);

          $out = implode('/', $outs) . '/';

        }

        if ($page > 1) {

          if (substr($out, -1) != '/') {

            $out .= '/';

          }

          $out .=  str_replace('{$page}', $page, $page_text);

        }

        $out = "\"$out\"";

      }

      return $out;

    }



  }



?>