<?php



/**

 *

 * INDEXU

 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.

 *

 * INDEXU(tm) is protected by Indonesia and International copyright laws.

 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,

 * violators will be prosecuted. To obtain a license for using INDEXU(tm),

 * please register at Nicecoder home page at http://www.nicecoder.com

 *

 * Author:

 *    Dody Rachmat Wicaksono (dody@nicecoder.com)

 *    M. Zuber (zubby@nicecoder.com)

 *

 */



  /*===================================================

    ViewCategory()

  ===================================================*/



  function ViewCategory() {



    // vars global configuration

    global $dbConn, $category_separator, $admin_template_path;



    // vars url & form

    global $cat;



    // vars messages

    global $msg;



    // vars template

    global $children,$chk_box, $name, $cat_id, $dark_light, $category, $cat_path, $num_rows, $param, $editor;

    

    global $links_obj, $category_obj;

    

    global $counter;



    global $total;



    global $html_row, $back;



    global $expand_all;

    global $opened_cats;



    $links_obj = new clsLink;

    $links_obj->table_name = "idx_link";

    $links_obj->category_table_name = "idx_category";

    $links_obj->editor_table_name = "idx_editor";

    $links_obj->user_table_name = "idx_users";



    if(empty($cat)) $cat = 0;

    

    $category_obj = new clsCategory;

    $category_obj->table_name = "idx_category";

    $category_obj->separator = $category_separator;

    

    $counter = 0;



    PrepareArray();

    

    $num_rows = $total;

    

    $category = $html_row;

    $back     = "cat_view.php";

    

    DisplayTemplate($admin_template_path . "cat_view.html",

      "\$category,\$cat_path,\$num_rows,\$param,\$back,\$expand_all");

  }





  /*===================================================

    PrepareArray()

  ===================================================*/



  function PrepareArray() {

    global $dbConn, $total, $cats;

    global $expand_all;

    global $opened_cats;



    $query = "select category_id, parent_id, name, order_num, basic_price, premium_price, sponsored_price 

              from idx_category order by order_num, name asc";

    $result = $dbConn->Execute($query);

    $total = $result->RecordCount();

    while($row = $result->FetchRow()) {

      $cats[$row['parent_id']][$row['category_id']] = $row;

    }



    if(sizeof($cats)!=0) {

      BuildTree();

    }

  }





  /*===================================================

    BuildTree() build tree using depth first algorithm

  ===================================================*/



  function BuildTree($cat_id = 0, $lv = 0) {

    global $admin_template_path;

    global $cats;    // get array contain node data

    global $spacer, $name, $category_id, $html_row, $dark_light, $chk_box, $editor, $set_order;

    global $links_obj, $category_obj;

    global $counter, $set_price_basic, $set_price_premium, $set_price_sponsored;

    global $expand_all;

    global $opened_cats;

    

    // prepare to stop recursive, if has no value then go to next node

    if(!isset($cats[$cat_id]))  return false;

    

    // do recursive on each node

    foreach ($cats[$cat_id] as $key => $cat_node) {

    

      // assign var

      $name = $cat_node['name'];

      $category_id = $cat_node['category_id'];

      $order_num = $cat_node['order_num'];

      $basic_price = $cat_node['basic_price'];

      $premium_price = $cat_node['premium_price'];

      $sponsored_price = $cat_node['sponsored_price'];

      



      $counter++;



      // shift left for next level

      $j=0;

      $space = "";

      while($j<$lv) {

        if($j==0) $space .= "&nbsp;&nbsp;";

        else $space .= "<img src=../admin_tpl/images/transparent.gif border=0 align='middle' width='22'>";

        $j++;

      }

      

      $folder = "../admin_tpl/images/folder2.gif";

      $line   = "../admin_tpl/images/tree_line.gif";

      

      if($lv>0) $space.="<img src=$line border=0 align='middle'>";

      if (!$expand_all) {

        if (count($category_obj->GetChildren($cat_node[category_id])) > 1) {

          if (!eregi(":$cat_node[category_id]:", $opened_cats)) {

            $space = $space."[<a href='cat_view.php?opened_cats=$opened_cats:$cat_node[category_id]:' style='text-decoration: none'>+</a>] ";

          }

          else {

            $space = $space."[<a href='cat_view.php?opened_cats=$opened_cats' style='text-decoration: none'>-</a>] ";

            $space = str_replace(":$cat_node[category_id]:", '', $space);

          }

        }

        else {

            $space = $space."<img src=../admin_tpl/images/transparent.gif border=0 align='middle' width='22'>";

        }

      }

      $spacer = $space."<img src=$folder border=0 align='middle'> ";



      // get editor



      $editor = "(<b>Editor: </b>";

      $editor_list = $links_obj->GetEditor($category_id);

      $j = 0;

      $count_editor_list = @count($editor_list);

      while ($j < $count_editor_list) {

        $username = $editor_list[$j];

        $editor .= "<a href=editor_delete.php?username=$username&cat=$category_id>$username</a>";

        if($j!=$count_editor_list-1) $editor .= ", ";

        $j++;

      }

      if($count_editor_list==0) $editor = "";    

      if($editor!="") $editor .= ")";

      

      if($counter%2==0) $dark_light = "tbl_light";

      else $dark_light = "tbl_light2";

      

      $number = $counter;

    

      $chk_box = "<input type=checkbox name=chkbox_$number value=$category_id>";

      $set_order = "O: <input type=text name=order_$category_id value=$order_num size=6 class=textbg>";

      $set_price_basic = "B: <input type=text name=price_basic_$category_id value='$basic_price' size=6 class=textbg>";

      $set_price_premium = "P: <input type=text name=price_premium_$category_id value='$premium_price' size=6 class=textbg>";

      $set_price_sponsored = "S: <input type=text name=price_sponsored_$category_id value='$sponsored_price' size=6 class=textbg>";



      $html_row .= EvalTemplate($admin_template_path . "cat_view_rows.html",

        "\$spacer,\$name,\$category_id,\$dark_light,\$chk_box,\$editor,\$set_order,\$set_price_basic,\$set_price_premium,\$set_price_sponsored");

      

      // this will go to next first child node

      if ($expand_all || eregi(":$cat_node[category_id]:", $opened_cats)) {

        BuildTree($cat_node['category_id'], $lv+1);

      }

    }

    unset($cats[$cat_id]);

  } 





  /*===================================================

    main

  ===================================================*/



  include "../application.php";

  

  RunPreFilter(__FILE__);



  DisplayTemplate($admin_template_path . "header.html");

  ViewCategory();

  DisplayTemplate($admin_template_path . "footer.html");



  RunPostFilter(__FILE__);



?>