<?php



/**

 *

 * INDEXU

 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.

 *

 * INDEXU(tm) is protected by Indonesia and International copyright laws.

 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,

 * violators will be prosecuted. To obtain a license for using INDEXU(tm),

 * please register at Nicecoder home page at http://www.nicecoder.com

 *

 * Author:

 *    Dody Rachmat Wicaksono (dody@nicecoder.com)

 *    M. Zuber (zubby@nicecoder.com)

 *

 */



  /*===================================================

    RunningTime()

  ===================================================*/



  function RunningTime($start_time) {

    $running_time = time() - $start_time;

    $running_time =  gmdate("z\d G\h i\m s\s", $running_time);

    return $running_time;

  }





  /*===================================================

    ProcessResult()

  ===================================================*/



  function ProcessResult($params) {

    global $dbConn, $no, $site_url, $broken_only;

    $no++;

    $link_id = $params['moreparam'];

    $urlinfo = $params['urlinfo'];

    $parse_url = parse_url($params['url']);

    parse_str($parse_url['query'], $str);

    $params['url'] = urldecode($str['url']);

    $httpinfo = @explode("\n", $urlinfo['header']);

    $httpinfo[0] = strip_tags($httpinfo[0]);

    $font_start_red = "<b><font color='red'>";

    $font_start_blue = "<b><font color='blue'>";

    $font_end = "</font></b>";

    if ($broken_only) {

      if ($params['status'] == 'err' || substr($urlinfo['header'], 9, 3) != "200") {

          $query = "replace into idx_checkurl(link_id, live, reciprocal_found, date) values 

                    ($link_id, 'N', '', now())";

          $live = "{$font_start_red}Down{$font_end}";

          if (!trim($httpinfo[0])) {

            $httpinfo[0] = 'N/A';

          }

          $reciprocal_satus = "";

      }

      else {

          $query = "replace into idx_checkurl(link_id, live, reciprocal_found, date) values 

                    ($link_id, 'Y', '', now())";

          $live = "{$font_start_blue}Online{$font_end}";

          $reciprocal_satus = "";

      }

    }

    else {

      if ($params['status'] == 'err' || substr($urlinfo['header'], 9, 3) != "200") {

          $query = "replace into idx_checkurl(link_id, live, reciprocal_found, date) values 

                    ($link_id, 'N', 'N', now())";

          $live = "{$font_start_red}Down{$font_end}";

          if (!trim($httpinfo[0])) {

            $httpinfo[0] = 'N/A';

          }

          $reciprocal_satus = "";

      }

      elseif (strpos($urlinfo['html'], $site_url) !== FALSE) {

          $query = "replace into idx_checkurl(link_id, live, reciprocal_found, date) values 

                    ($link_id, 'Y', 'Y', now())";

          $live = "{$font_start_blue}Online";

          $reciprocal_satus = ", Reciprocal Found{$font_end}";

          $font_start = "";

          $font_end = "";

      }

      else {

          $query = "replace into idx_checkurl(link_id, live, reciprocal_found, date) values 

                    ($link_id, 'Y', 'N', now())";

          $live = "{$font_start_blue}Online{$font_end}";

          $reciprocal_satus = ", {$font_start_red}Reciprocal Not Found{$font_end}";

      }

    }

    echo "\n$no. [ID:$link_id] " . $params['url']." => $live{$reciprocal_satus} [".trim($httpinfo[0])."]";

    flush();

    $dbConn->Execute($query);

  }





  /*===================================================

    main

  ===================================================*/



  include "../application.php";

  include "../key.php";

  ini_set("max_execution_time", "0");

  

  RemoveFilter("gzip_compression");

  RemoveFilter("runtime");

  RemoveFilter("start_session");

  RemoveFilter("validate_admin");

  RunPreFilter(__FILE__);



  $broken_only = FALSE;

  if (strpos(@implode('', $_SERVER['argv']) . $_SERVER['QUERY_STRING'], 'broken_only=true') !== FALSE) {

    $broken_only = TRUE;

  }



  $no = 0;



  $query = "select count(*) c

            from idx_link a

                 left join idx_checkurl b on (a.link_id = b.link_id)

            where b.date is NULL or (to_days(now()) - to_days(b.date) > $urlcheck_limit)";

  $result = $dbConn->Execute($query);

  $num_rows = $result->Fields('c');



  echo "\n<pre>";

  echo "\nINDEXU - Spider Link & Reciprocal Checker";

  echo "\nThere are $num_rows url(s) to check. It may takes from seconds to";

  echo "\nseveral hours depend on how many urls and internet connection.\n\n";

  flush();



  $start_time = time();

  while ($num_rows) {

    $query = "select a.link_id, a.url, a.reciprocal_url

              from idx_link a

                   left join idx_checkurl b on (a.link_id = b.link_id)

              where b.date is NULL or (to_days(now()) - to_days(b.date) > $urlcheck_limit) 

              order by a.link_id asc

              limit 100";

    $result = $dbConn->Execute($query);

    $num_rows = $result->RecordCount();

    

    unset($link_id);

    unset($url);

    unset($reciprocal_url);

    while (!$result->EOF) {

      $link_id[] = $result->Fields("link_id");

      $url[] = $result->Fields("url");

      if ($result->Fields("reciprocal_url")) {

        $reciprocal_url[] = $result->Fields("reciprocal_url");

      }

      else {

        $reciprocal_url[] = $result->Fields("url");

      }

      $result->MoveNext();

    }

    $result->Close();



    while (true) {

      unset($link_id_to_process);

      unset($url_to_process);

      $i = 0;

      while (list($k, $v) = @each($link_id)) {

        $i++;

        $link_id_to_process[] = $link_id[$k];

        if ($broken_only) {

          $url_to_process[] = $site_url . '/admin/geturl.php?url=' . urlencode($url[$k]) . '&header_only=1';

        }

        else {

          $url_to_process[] = $site_url . '/admin/geturl.php?url=' . urlencode($reciprocal_url[$k]) . ';

        }

        if ($i >= 10) {

          break;

        }

      }

      if (@count($link_id_to_process)) {

        HttpMultiRequest($url_to_process, false, 'ProcessResult', $link_id_to_process);

      }

      else {

        break;

      }

    }

  }



  $running_time = RunningTime($start_time);

  echo "\n\nExecution time: $running_time";

  

  RunPostFilter(__FILE__);



?>