<?php



/**

 *

 * INDEXU

 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.

 *

 * INDEXU(tm) is protected by Indonesia and International copyright laws.

 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,

 * violators will be prosecuted. To obtain a license for using INDEXU(tm),

 * please register at Nicecoder home page at http://www.nicecoder.com

 *

 * Author:

 *    Dody Rachmat Wicaksono (dody@nicecoder.com)

 *    M. Zuber (zubby@nicecoder.com)

 *

 */



  /*===================================================

    ViewLink()

  ===================================================*/



  function ViewLink() {



    // vars global configuration

    global $dbConn, $category_separator, $theme_path;



    // vars url & form

    global $cat, $pg_which;



    // vars messages

    global $msg;



    // vars template

    global $link, $pagination, $chk_box, $num_rows, $param;



    $links_obj = new clsLink;

    $links_obj->table_name          = "idx_link_temp";

    $links_obj->category_table_name = "idx_category";

    $links_obj->editor_table_name   = "idx_editor";

    $links_obj->custom_field_offset++;



    // get editor category

    $categories                     = $links_obj->GetEditorCategory($_COOKIE['COOKIE_USERNAME']);



    // build query

    $query = "select * from idx_link_temp where 0!=0";



    while (list(, $v) = @each($categories)) {

      $query .= " or category_id = '$v'";

    }



    $query .= " order by date";



    $links_obj->template_file      = $theme_path . "cp/editor_link_validate_rows.html";

    $links_obj->date_format        = $msg["20111"];

    $links_obj->query              = $query;

    $links_obj->paging             = true;

    $links_obj->pg_size            = 15;

    $links_obj->href               = "editor_link_validate.php";

    $links_obj->more_param         = "";

    $links_obj->category_file      = "../browse.php";

    $links_obj->category_separator = $category_separator;

    $links_obj->new_link_number    = 1;

    $link                          = $links_obj->Display(true);

    $pagination                    = $links_obj->pagination;

    $num_rows                      = $links_obj->new_link_number - 1;

    $param                         = "pg_which=$pg_which";



    DisplayTemplate($theme_path . "cp/editor_link_validate.html", "\$num_rows,\$pagination,\$link,\$param");

  }





  /*===================================================

    ApproveLink()

  ===================================================*/



  function ApproveLink() {

    // vars global configuration

    global $dbConn, $theme_path, $message, $email_address;



    // vars url & form

    global $num_rows;



    // vars messages

    global $msg;



    // vars template

    global $link_id, $title, $url, $description, $contact_name, $email, $bid, $category, $category_id;



    $tpl = new Template();



    $links_obj = new clsLink;

    $links_obj->table_name          = "idx_link";

    $links_obj->category_table_name = "idx_category";

    $links_obj->editor_table_name   = "idx_editor";

    $links_obj->user_table_name     = "idx_users";



    $category_obj = new clsCategory;

    $category_obj->table_name = "idx_category";

    $category_obj->user_table_name = "idx_users";



    $users_obj = new clsUsers;

    $users_obj->table_name = "idx_users";



    $i = 1;



    while ($i <= $num_rows) {

      $var = "chkbox_$i";

      $id  = $GLOBALS["$var"];



      if (!empty($id)) {

        $query  = "select link_id, title from idx_link_temp where vid = '$id'";

        $result = $dbConn->Execute($query);

        $lid    = $result->Fields("link_id");

        $title  = $result->Fields("title");



        if (empty($lid))

          $flag = 0;

        else

          $flag = 1;



        $links_obj->ApproveLink($id, $flag);



        $message .= $msg["20121"];

        $tpl->assign('title', $title);

        $message = $tpl->fetch('var:' . $message);



        // update new flag

        if ($flag == 0)

          $links_obj->UpdateNewFlag();



        // update updated flag

        elseif ($flag == 1)

          $links_obj->UpdateUpdatedFlag();



        // send email submitter

        $body = EvalTemplate($theme_path . "mail/approved.mail", $links_obj->email_template_fields);

        $from = $email_address;

        mail($email, $msg["20131"], $body, "From: $from \nX-Mailer: INDEXU_X-Mailer/1.0");



        // send email to all editors and admin

        $emails   = $links_obj->GetEditorEmail($category_id);

        $emails[] = $email_address;

        $subscriber_emails =  $category_obj->GetSubscriberEmail($category_id);



        while (list(, $v) = @each($emails)) {

          $body = EvalTemplate($theme_path . "mail/approved_editor.mail", $links_obj->email_template_fields);

          $from = $email_address;

          mail($v, $msg["20133"], $body, "From: $from \nX-Mailer: INDEXU_X-Mailer/1.0");

        }



        while (list(, $v) = @each($subscriber_emails)) {

          $body = EvalTemplate($theme_path . "mail/approved_subscriber.mail", $links_obj->email_template_fields);

          $from = $email_address;

          mail($v, $msg["20133"], $body, "From: $from \nX-Mailer: INDEXU_X-Mailer/1.0");

        }



      }



      $i++;

    }



    if (empty($message))

      $message = $msg["20122"];



    DisplayTemplate($theme_path . "cp/editor_link_validate_result.html", "\$message");

  }





  /*===================================================

    RejectLink()

  ===================================================*/



  function RejectLink() {

    // vars global configuration

    global $dbConn, $theme_path, $email_address;



    // vars url & form

    global $num_rows;



    // vars messages

    global $msg;



    // vars template

    global $message, $link_id, $title, $url, $description, $contact_name, $email, $bid, $category, $category_id;



    $tpl = new Template();



    $links_obj = new clsLink;

    $links_obj->table_name          = "idx_link";

    $links_obj->category_table_name = "idx_category";

    $links_obj->editor_table_name   = "idx_editor";

    $links_obj->user_table_name     = "idx_users";



    $users_obj = new clsUsers;

    $users_obj->table_name = "idx_users";



    $i                     = 1;



    while ($i <= $num_rows) {

      $var = "chkbox_$i";

      $id  = $GLOBALS["$var"];



      if (!empty($id)) {

        $query  = "select title from idx_link_temp where vid = '$id'";

        $result = $dbConn->Execute($query);

        $title  = $result->Fields("title");



        $links_obj->RejectLink($id);



        $message .= $msg["20123"];

        $tpl->assign('title', $title);

        $message = $tpl->fetch('var:' . $message);



        // send email submitter

        $body    = EvalTemplate($theme_path . "mail/rejected.mail", $links_obj->email_template_fields);

        $from    = $email_address;

        mail($email, $msg["20135"], $body, "From: $from \nX-Mailer: INDEXU_X-Mailer/1.0");



        // send email to all editors and admin

        $emails   = $links_obj->GetEditorEmail($category_id);

        $emails[] = $email_address;



        while (list(, $v) = @each($emails)) {

          $body = EvalTemplate($theme_path . "mail/rejected_editor.mail", $links_obj->email_template_fields);

          $from = $email_address;

          mail($v, $msg["20137"], $body, "From: $from \nX-Mailer: INDEXU_X-Mailer/1.0");

        }

      }



      $i++;

    }



    if (empty($message))

      $message = $msg["20122"];



    DisplayTemplate($theme_path . "cp/editor_link_validate_result.html", "\$message");

  }





  /*===================================================

    main

  ===================================================*/



  include "../application.php";



  AddFilter('validate_editor');

  RunPreFilter(__FILE__);

  

  if (empty($pflag)) {

    ViewLink();

  }

  elseif ($pflag == 'validate') {

    if ($op == 'Approve') {

      ApproveLink();

    }

    elseif ($op == 'Reject') {

      RejectLink();

    }

  }



  RunPostFilter(__FILE__);



?>