<?php



/**

 *

 * INDEXU

 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.

 *

 * INDEXU(tm) is protected by Indonesia and International copyright laws.

 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,

 * violators will be prosecuted. To obtain a license for using INDEXU(tm),

 * please register at Nicecoder home page at http://www.nicecoder.com

 *

 * Author:

 *    Dody Rachmat Wicaksono (dody@nicecoder.com)

 *    M. Zuber (zubby@nicecoder.com)

 *

 */



  /*===================================================

    ViewPendingReview()

  ===================================================*/



  function ViewPendingReview() {



    // vars global configuration

    global $dbConn, $theme_name, $category_separator, $theme_path;



    // vars url & form

    global $pg_which;



    // vars messages

    global $msg;



    // vars template

    global $review, $pagination, $chk_box, $num_rows, $param;



    $links_obj = new clsLink;

    $links_obj->table_name            = "idx_link";

    $links_obj->category_table_name   = "idx_category";

    $links_obj->editor_table_name     = "idx_editor";

    $links_obj->date_format           = $msg["20164"];

    $links_obj->paging                = true;

    $links_obj->pg_size               = 15;

    $links_obj->href                  = "review_validate.php";

    $links_obj->more_param            = "";

    $links_obj->category_file         = "../browse.php";

    $links_obj->category_separator    = $category_separator;

    $links_obj->rating_image_path     = "../themes/" . $theme_name . "/images/rating/";

    $links_obj->rev_rating_image_path = "../themes/" . $theme_name . "/images/review/";

    $param                            = "pg_which=$pg_which";

    $links_obj->rating_image_path     = $theme_path . "images/";

    $links_obj->template_file         = $theme_path . "cp/editor_review_validate_rows.html";



    // get editor category

    $categories                       = $links_obj->GetEditorCategory($_COOKIE['COOKIE_USERNAME']);



    // build query

    $query = "select distinct idx_link.category_id, idx_review.*

	            from idx_link, idx_review

		          where idx_link.link_id = idx_review.link_id

		          and idx_review.status = 0 and (0 != 0";



    while (list(, $v) = @each($categories)) {

        $query .= " or category_id = '$v'";

    }



    $query .= ")";



    $review     = $links_obj->DisplayReview($id, $query, true);

    $pagination = $links_obj->pagination;

    $num_rows   = $links_obj->num_rows;



    DisplayTemplate($theme_path . "cp/editor_review_validate.html", "\$num_rows,\$pagination,\$review,\$param");

  }





  /*===================================================

    ApproveReview()

  ===================================================*/



  function ApproveReview() {

    // vars global configuration

    global $dbConn, $theme_path;



    // vars url & form

    global $num_rows;



    // vars messages

    global $msg;



    // vars template

    global $message, $title;



    $tpl = new Template();



    $links_obj = new clsLink;

    $links_obj->table_name        = "idx_link";

    $links_obj->review_table_name = "idx_review";



    $i = 1;



    while ($i <= $num_rows) {

      $var = "chkbox_$i";

      $id  = $GLOBALS["$var"];



      if (!empty($id)) {

        $query  = "select link_id from idx_review where review_id = '$id'";

        $result = $dbConn->Execute($query);

        $lid    = $result->Fields("link_id");



        $query  = "select title from idx_link where link_id = '$lid'";

        $result = $dbConn->Execute($query);

        $title  = $result->Fields("title");



        $links_obj->ApproveReview($id);



        $message .= $msg["20161"];

        $tpl->assign('title', $title);

        $message = $tpl->fetch('var:' . $message);



        // recalculate avg_review

        $links_obj->UpdateAvgReview($id);

      }



      $i++;

    }



    if (empty($message))

      $message = $msg["20162"];



    DisplayTemplate($theme_path . "cp/editor_review_validate_result.html", "\$message");

  }





  /*===================================================

    RejectReview()

  ===================================================*/



  function RejectReview() {

    // vars global configuration

    global $dbConn, $theme_path;



    // vars url & form

    global $num_rows;



    // vars messages

    global $msg;



    // vars template

    global $message, $link_id, $title, $url, $description, $contact_name, $email, $bid, $category, $category_id;



    $tpl = new Template();



    $links_obj = new clsLink;

    $links_obj->table_name        = "idx_link";

    $links_obj->review_table_name = "idx_review";



    $i = 1;



    while ($i <= $num_rows) {

      $var = "chkbox_$i";

      $id  = $GLOBALS["$var"];



      if (!empty($id)) {

        $query  = "select link_id from idx_review where review_id = '$id'";

        $result = $dbConn->Execute($query);

        $lid    = $result->Fields("link_id");



        $query  = "select title from idx_link where link_id = '$lid'";

        $result = $dbConn->Execute($query);

        $title  = $result->Fields("title");



        $links_obj->RejectReview($id);



        $message .= $msg["20163"];

        $tpl->assign('title', $title);

        $message = $tpl->fetch('var:' . $message);

      }



      $i++;

    }



    if (empty($message))

      $message = $msg["20162"];



    DisplayTemplate($theme_path . "cp/editor_review_validate_result.html", "\$message");

  }





  /*===================================================

    main

  ===================================================*/



  include "../application.php";



  AddFilter('validate_editor');

  RunPreFilter(__FILE__);



  if (empty($pflag)) {

    ViewPendingReview();

  }

  elseif ($pflag == 'validate') {

    if ($op == 'Approve') {

      ApproveReview();

    }

    elseif ($op == 'Reject') {

      RejectReview();

    }

  }



  RunPostFilter(__FILE__);



?>