<?php



/**

 *

 * INDEXU

 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.

 *

 * INDEXU(tm) is protected by Indonesia and International copyright laws.

 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,

 * violators will be prosecuted. To obtain a license for using INDEXU(tm),

 * please register at Nicecoder home page at http://www.nicecoder.com

 *

 * Author:

 *    Dody Rachmat Wicaksono (dody@nicecoder.com)

 *    M. Zuber (zubby@nicecoder.com)

 *

 */



  /*===================================================

    ShowFormSelectPayment()

  ===================================================*/



  function ShowFormSelectPayment() {



    // vars global configuration

    global $dbConn, $theme_path, $category_separator, $paid_link_day_period, $paid_link_price_factor;





    // vars messages

    global $msg;



    // vars template

    global $error_msg, $id, $type, $category, $listing_period,

             $available_payment_systems, $currency_symbol;





    $query  = "select category_id from idx_link where link_id = {$id}";

    $result = $dbConn->Execute($query);

    $cid = $result->Fields("category_id");



    // get price

    $query    = "select {$type}_price from idx_category where category_id = {$cid}";

    $result   = $dbConn->Execute($query);

    $price    = $result->Fields("{$type}_price");



    // period and price factor

    $period       = @explode(',', $paid_link_day_period);

    $price_factor = @explode(',', $paid_link_price_factor);

    $i = 0;

    $checked  = "checked";



    while (list($k, $v) = @each($period)) {

      if ($i>0) {

        $checked = '';

      }

      if ($k == 0) {

        $default_day = $v;

      }



      if ($price > 0) {

        $price_no_disc                  = ($v / $default_day) * $price;

        $listing_period[$k]['checked']  = $checked;

        $listing_period[$k]['period']   = $v;

        $listing_period[$k]['price']    = $price_factor[$k] * $price;

        $listing_period[$k]['disc']     = sprintf("%01.2f", ($price_no_disc - $listing_period[$k]['price']) / $price_no_disc * 100);

        $listing_period[$k]['save']     = $price_no_disc - $listing_period[$k]['price'];

      }



      $i++;

    }



    // get category path

    $category_obj = new clsCategory;

    $category_obj->table_name = "idx_category";

    $category_obj->separator  = $category_separator;

    $category                 = $category_obj->GetCategoryPath($cid);



    $currency_symbol = $dbConn->Lookup("currency_symbol", "idx_invoice_config", "0 = 0");

    $available_payment_systems = GetPaymentSystems();



    DisplayTemplate($theme_path . "cp/select_payment.html", "\$id,\$type,\$total,\$category,".

                    "\$listing_period,\$currency_symbol,\$available_payment_systems");

  }





  /*===================================================

    ProcessFormSelectPayment()

  ===================================================*/



  function ProcessFormSelectPayment() {



    // vars global configuration

    global $dbConn, $theme_path, $site_url;



    // vars url & form

    global $id, $type, $gateway, $price, $periodprice;



    // vars messages

    global $msg;



    list($period, $total) = @explode('|', $periodprice);



    // prepare var

    $currency_code = $dbConn->Lookup("currency_code", "idx_invoice_config", "0 = 0");

    $custom        = "{$_COOKIE[COOKIE_USERNAME]}&{$type}&{$id}&{$period}";

    $item_name     = "Upgrade {$type} LISTING (ID: {$id})";

    $notify_url    = $site_url . "/payment/{$gateway}.check-upgrade.php";

    $return_url    = $site_url . "/cp/mylisting.php";

    $cancel_url    = $site_url . "/cp/mylisting.php";



    // route to selected payment system



    include "../payment/" . $gateway . ".inc.php";

    include "../payment/" . $gateway . ".php";

  }





  /*===================================================

    main

  ===================================================*/



  include "../application.php";



  RunPreFilter(__FILE__);



  if (empty($pflag)) {

    ShowFormSelectPayment();

  }

  elseif ($pflag == 'select') {

    ProcessFormSelectPayment();

  }



  RunPostFilter(__FILE__);



?>