<?php



/**

 *

 * INDEXU

 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.

 *

 * INDEXU(tm) is protected by Indonesia and International copyright laws.

 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,

 * violators will be prosecuted. To obtain a license for using INDEXU(tm),

 * please register at Nicecoder home page at http://www.nicecoder.com

 *

 * Author:

 *    Dody Rachmat Wicaksono (dody@nicecoder.com)

 *    M. Zuber (zubby@nicecoder.com)

 *

 */



class rss {

  var $parser = null;

  var $rssurl = "";

  var $title = "";

  var $cache_file = "";

  var $rsscontent = "";

	var $items = array();

	var $tag = "";

  var $index = 0;



  var $cache_dir = "./cache";

  var $cache_time = 3600;



	function rss($rssurl, $title, $cache_time = 'default', $cache_dir = 'default') {

    $this->parser = xml_parser_create();

		xml_set_object($this->parser, &$this);

    xml_set_element_handler($this->parser, "startElement", "endElement");

    xml_set_character_data_handler($this->parser, "characterData");

    if ($cache_time != 'default') {

      $this->cache_time = $cache_time;

    }

    if ($cache_dir != 'default') {

      $this->cache_dir = $cache_dir;

    }

		$this->rssurl = $rssurl;

    $this->title = $title;

    $str_arr = array (

        ' ',

        '-',

        '/',

        '\\',

        ',',

        '#',

        ':',

        ';',

        '\'',

        '"',

        '[',

        ']',

        '{',

        '}',

        '|',

        '`',

        '~',

        '!',

        '@',

        '%',

        '$',

        '^',

        '&',

        '*',

        '=',

        '+'

      );

    $this->cache_file = $this->cache_dir.'/rss_'.md5($this->rssurl).'.cache';

    if (!$this->is_expired()){

      $this->rsscontent = file_get_contents($this->cache_file);

    }

    else {

      $content = HttpRequest($this->rssurl);

      $this->rsscontent = $content['html'];

      if ($cache_time) {

        $fp = fopen($this->cache_file, 'w+');

        fwrite($fp, $this->rsscontent);

        fclose($fp);

      }

    }

    $this->rsscontent = str_replace('&amp;', 'indexu-dan-amp;', $this->rsscontent);

    $this->rsscontent = str_replace('&', '&amp;', $this->rsscontent);

    $this->rsscontent = str_replace('indexu-dan-amp;', '&amp;', $this->rsscontent);

    $this->rsscontent = str_replace('<br clear=all>', '<br clear="all" />', $this->rsscontent);

    xml_parse($this->parser, $this->rsscontent);

    xml_parser_free($this->parser);

  }

	

	function startElement($parser, $tagName, $attrs) {

		if ($this->insideitem) {

			$this->tag = $tagName;

		} elseif ($tagName == "ITEM") {

			$this->insideitem = true;

		}

	}



  function endElement($parser, $tagName) {

		if ($tagName == "ITEM") {

			$this->insideitem = false;

      while (list($k, $v) = @each($this->items[$this->index])) {

        $content = trim($v);

        $content = str_replace('&amp;', '&', $content);

        $content = str_replace(array('&lt;', '&#60;'), '<', $content);

        $content = str_replace(array('&gt;', '&#62;'), '>', $content);

        $content = str_replace(array('&quot;', '&#34;'), '"', $content);

        $content = str_replace('& ', '&amp;', $content);

        // convert back & to &amp; for url and images

        $content = preg_replace("|<img src=[\"'](.*?)[\"']|mse", "'<img src=\"'.str_replace('&', '&amp;', '\\1').'\"'", $content);

        $content = preg_replace("|<a href=[\"'](.*?)[\"']|mse", "'<a href=\"'.str_replace('&', '&amp;', '\\1').'\"'", $content);

        if ($k == 'link') {

          $content = str_replace('&', '&amp;', $content);

        }

        $this->items[$this->index][$k] = $content;

      }

      $this->index++;

    }

	}	

	

  function characterData($parser, $data) {

    if ($this->insideitem) {

      $key = str_replace(':', '', strtolower($this->tag));

      $this->items[$this->index][$key] .= $data;

    }

	}



	function is_expired() {

		clearstatcache();

		if (!file_exists($this->cache_file)):

			 return TRUE;

		endif;

		if ((filemtime($this->cache_file) + $this->cache_time) > strtotime('now')):

			 return FALSE;

		endif;

		return TRUE;

	}

}	

?>