<?php



/**

 *

 * INDEXU

 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.

 *

 * INDEXU(tm) is protected by Indonesia and International copyright laws.

 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,

 * violators will be prosecuted. To obtain a license for using INDEXU(tm),

 * please register at Nicecoder home page at http://www.nicecoder.com

 *

 * Author:

 *    Dody Rachmat Wicaksono (dody@nicecoder.com)

 *    M. Zuber (zubby@nicecoder.com)

 *

 */



  include dirname(__FILE__) . "/smarty/Smarty.class.php";

  include dirname(__FILE__) . "/smarty/plugins/resource.var.php";



  class Template extends Smarty {



    function Template() {

      global $site_url, $base_path, $active_theme, $theme_path, $site_name, $email_address, $indexu_version;



      $this->Smarty();



      $this->template_dir    = $theme_path;

      $this->compile_dir     = $base_path . "templates_c";

      $this->config_dir      = $theme_path . "config";

      $this->cache_dir       = $base_path . "cache";

      $this->caching         = false;



      $this->left_delimiter  = '<%';

      $this->right_delimiter = '%>';



      $this->assign('tpl_base', $site_url . '/themes/' . $active_theme);

      $this->assign('site_url', $site_url);

      $this->assign('site_name', $site_name);

      $this->assign('email_address', $email_address);

      $this->assign('indexu_version', $indexu_version);



      $this->register_resource("var", array (

        "smarty_resource_var_resource",

        "smarty_resource_var_timestamp",

        "smarty_resource_var_secure",

        "smarty_resource_var_trusted"

      ));

    }





    function _load_block_function($file) {

      global $theme_path, $base_path;

      static $_tpl_contents = array();

      

      if (strpos($file, 'var:') !== FALSE) {

        $content = $file;

      }

      else {

        if (strpos($file, $base_path) === FALSE) {

          $tpl_file = $theme_path . $file;

        }

        else {

          $tpl_file = $file;

        }

        $tpl_hash = md5($tpl_file);

        if ($_tpl_contents[$tpl_hash]) {

          $content = $_tpl_contents[$tpl_hash];

        }

        else {

          $content = $this->_read_file($tpl_file);

          $_tpl_contents[$tpl_hash] = $content;

        }

      }

      preg_match_all("|<%include.*?file=['\"](.*?)['\"]|ms", $content, $match);

      if (@count($match[0])) {

        while (list($k, $v) = @each($match[1])) {

          $tpl_file = dirname($file) . "/$v";

          $tpl_hash = md5($tpl_file);

          $tpl_content = "";

          if ($_tpl_contents[$tpl_hash]) {

            $tpl_content = $_tpl_contents[$tpl_hash];

          }

          else {

            $tpl_content = $this->_read_file($tpl_file);

            $_tpl_contents[$tpl_hash] = $tpl_content;

          }

          $content .= $tpl_content;

        }

      }



      preg_match_all('|<%block_(.*?)%>|ms', $content, $match);

      while (list($key, $value) = @each($match[1])) {

        $arr   = explode(" ", $value);

        $value = $arr[0];



        if (!function_exists('block_' . $value)) {

          if (file_exists($base_path . "blocks/block." . $value . ".php")) {

            include_once $base_path . "blocks/block." . $value . ".php";

          }

        }

        $this->register_function("block_$value", "block_$value");

      }

    }





    function fetch($file, $cache_id = null, $compile_id = null, $display = false) {

      $this->_load_block_function($file);

      return parent::fetch($file, $cache_id, $compile_id, $display);

    }



  }





  function DisplayTemplate($templatefile, $vars = "") {

    $tpl = new Template;



    if ($vars) {

      eval ("global $vars;");



      // get vars

      $vars     = str_replace(",", "", $vars);

      $var_list = explode("\$", $vars);

      $i        = 0;



      while ($i <= sizeof($var_list)) {

        $var = $var_list[$i];

        $tpl->assign($var, $$var);

        $i++;

      }

    }



    global $cat;

    $tpl->assign($cat, $cat);



    $tpl->assign("page_name", basename($templatefile, ".html"));

    $tpl->display($templatefile);

  }





  function EvalTemplate($templatefile, $vars = "") {

    $tpl = new Template;



    if ($vars) {

      eval ("global $vars;");



      // get vars

      $vars     = str_replace(",", "", $vars);

      $var_list = explode("\$", $vars);

      $i        = 0;



      while ($i <= sizeof($var_list)) {

        $var = $var_list[$i];

        $tpl->assign($var, $$var);

        $i++;

      }

    }



    global $cat;

    $tpl->assign($cat, $cat);



    return $tpl->fetch($templatefile);

  }





  function revers_htmlspecialchars($msg) {

    $msg = str_replace("/&gt;/i", ">", $msg);

    $msg = str_replace("/&lt;/i", "<", $msg);

    $msg = str_replace("/&quot;/i", "\"", $msg);

    $msg = str_replace("/&amp;/i", "&", $msg);

    return $msg;

  }

?>

