<?php
/*======================================================================*\
|| #################################################################### ||
|| #				vB Pager for vBulletin 3.5.x					  # ||
|| #						Version 3.0.1							  # ||
|| #					by [WwW.UAEWEB.COM]							  # ||
|| # ---------------------------------------------------------------- # ||
|| # 	Copyright 20002006 WwW.UAEWEB.COM All Rights Reserved.      # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('CVS_REVISION', '$RCSfile: pageradmin.php,v $ - $Revision: 3.0.1 $');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('cpuser', 'forum', 'timezone', 'user');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_user.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminusers'))
{
	print_cp_no_permission();
}

$vbulletin->input->clean_array_gpc('r', array(
	'userid'   => TYPE_INT
));

if (is_browser('webkit') AND empty($_POST['do']))
{
	$_POST['do'] = $_REQUEST['do'] = 'pagerstats';
}

// ############################# LOG ACTION ###############################
log_admin_action(!empty($vbulletin->GPC['userid']) ? 'user id = ' . $vbulletin->GPC['userid'] : '');

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['pager_vbpager']);


// ###################### Start Remove User's Pagers #######################
if ($_REQUEST['do'] == 'removepagers')
{
	print_delete_confirmation('user', $vbulletin->GPC['userid'], 'pageradmin', 'killpagers', 'pager_messages_belonging_to_the_user');
}

// ###################### Start Remove User's Pagers #######################
if ($_POST['do'] == 'killpagers')
{
	$userid = $vbulletin->GPC['userid'];
	$pagers	= $db->query_first("SELECT count(*) AS totalout 
		FROM " . TABLE_PREFIX . "pagerreceipt 
		WHERE touserid = $userid AND markdeleted = 0");
	$totalout = $pagers['totalout'];

	$pagers	= $db->query_first("SELECT count(*) AS totalin 
		FROM " . TABLE_PREFIX . "pagerreceipt 
		WHERE userid = $userid AND active = 1");
	$totalin = $pagers['totalin'];
	$totalpager = $totalin + $totalout ;
	
	$sql = "UPDATE " . TABLE_PREFIX . "pagerreceipt 
			SET markdeleted = 1 WHERE touserid = $userid";
	$result = $db->query($sql);

	$sql = "UPDATE " . TABLE_PREFIX . "pagerreceipt 
			SET active = 0 WHERE userid = $userid";
	$result = $db->query($sql);

	$dbresult = vbpager_updatedb($userid);

	define('CP_REDIRECT', "pageradmin.php?do=pagerstats");
	print_stop_message('pager_x_deleted_pager_messages_successfully', $totalpager);	
}


// ############################# start user Pager stats #########################
if ($_REQUEST['do'] == 'pagerfolderstats')
{
	$userid = $vbulletin->GPC['userid'];
	$user	= fetch_userinfo($userid);

	$pagers	= $db->query_first("SELECT count(*) AS totalout, 
		sum(active = 0) AS deletedout 
		FROM " . TABLE_PREFIX . "pagerreceipt 
		WHERE userid = $userid ");
	$totalout		= $pagers['totalout'];
	$totaldeletedout= $pagers['deletedout'];
	
	$pagers	= $db->query_first("SELECT count(*) AS totalin, 
		sum(readtime = 0) AS totalunread, sum(markdeleted = 1) AS deletedin 
		FROM " . TABLE_PREFIX . "pagerreceipt 
		WHERE touserid = $userid ");
	$totalin		= $pagers['totalin'];
	$totalunread	= $pagers['totalunread'];
	$totaldeletein	= $pagers['deletedin'];
	$totaldeleted	= $totaldeletein + $totaldeletedout;

	$pagers	= $db->query_first("SELECT count(*) AS deletedunread 
		FROM " . TABLE_PREFIX . "pagerreceipt 
		WHERE touserid = $userid AND readtime = 0 AND markdeleted = 1");
	$deletedunread	= $pagers['deletedunread'];	

	if ($totalout == 0 AND $totalin == 0)
	{
		print_stop_message('no_matches_found');
	}
	$pagertotal = $totalout + $totalin;

	print_form_header('user', 'edit');
	construct_hidden_code('userid', $user['userid']);
	print_table_header(construct_phrase($vbphrase['pager_messages_for_x'], $user['username']) . "</b> (userid: $userid)<b>", "3");
	print_cells_row(array($vbphrase['folder'], $vbphrase['number_of_messages'], "Deleted Messages"), 1);

	if ($totalin > 0)
	 {
		print_cells_row(array($vbphrase['inbox'], $totalin, $totaldeletein));
	 }
	if ($totalout > 0)
	 {
		print_cells_row(array($vbphrase['sent_items'], $totalout, $totaldeletedout));
	 }
	if ($totalunread > 0)
	 {
		print_cells_row(array($vbphrase['unread_nav'], $totalunread, $deletedunread));	
	 }

	print_cells_row(array('<b>' . $vbphrase['total'] . '</b>', "<b>$pagertotal</b>", "<b>" . $totaldeleted . "</b>"));
	print_description_row('<div align="center">' . construct_link_code($vbphrase['pager_delete_pager_messages'], "pageradmin.php?" . $vbulletin->session->vars['sessionurl'] . "do=removepagers&amp;u=" . $vbulletin->GPC['userid']) . '</div>', 0, 3, 'thead');
	print_submit_row($vbphrase['edit_user'], 0,3);
}

// ############################# Confirming Delete Pager Message #########################
if ($_REQUEST['do'] == 'removepagermessages')
{
	$pagerall		= $_REQUEST['pagerall'];
	$pagerread		= $_REQUEST['pagerread'];
	$pagerunread	= $_REQUEST['pagerunread'];
	$pagerdeleted	= $_REQUEST['pagerdeleted'];

	if ($pagerall)
	 {
	 	$action = 'killpagerall';
	 }
	else
	 {
		 $action = ($pagerunread == 1 AND $pagerdeleted == 1) ? 'killpagerunreaddeleted' : $action ;
		 $action = ($pagerunread == 1 AND $pagerdeleted == 0) ? 'killpagerunread' : $action ;
		 $action = ($pagerunread == 0 AND $pagerdeleted == 1) ? 'killpagerdeleted' : $action ;
	 }

	print_form_header('pageradmin', '' . $action . '', 0, 1, '', '75%');
	print_table_header("<b>$vbphrase[confirm_deletion]: </b> $vbphrase[pager_vbpager]");
	print_description_row("
		<blockquote><br /> $vbphrase[pager_confirm_message_delete] 
		<br /></blockquote>\n\t");
	print_submit_row($vbphrase['yes'], 0, 2, $vbphrase['no']);
}

// ############################# Delete Pager Message #########################
if (($_REQUEST['do'] == 'killpagerall') OR ($_REQUEST['do'] == 'killpagerunreaddeleted') OR ($_REQUEST['do'] == 'killpagerunread') OR ($_REQUEST['do'] == 'killpagerdeleted'))
{
	$killoption = $_REQUEST['do'];

	$totalpager = 0;
	switch ($killoption)
	 {
	 	case 'killpagerall':
	 			$result = $db->query_first("SELECT count(*) AS total 
	 				FROM " . TABLE_PREFIX . "pagerreceipt");
	 			$totalpager = intval($result['total']);

		 		$sql	= "DELETE FROM " . TABLE_PREFIX . "pagerreceipt";
				$result	= $db->query($sql);
				$result = $db->query("DELETE FROM " . TABLE_PREFIX . "pagertext");
				$result = $db->query_write("UPDATE " . TABLE_PREFIX . "user SET pagertotal=0, pagerunread=0");
	 		break;
	 	case 'killpagerunread':
	 		// Delete all unread Pager messages...
	 			$result = $db->query_first("SELECT count(*) AS total 
	 				FROM " . TABLE_PREFIX . "pagerreceipt
	 				WHERE readtime = 0");
				$totalpager = intval($result['total']);
		 		$sql	= "DELETE FROM " . TABLE_PREFIX . "pagerreceipt
		 					WHERE readtime = 0";
				$result	= $db->query($sql);
				$result = $db->query_write("UPDATE " . TABLE_PREFIX . "user SET pagerunread=0");
	 		break;
	 	case 'killpagerdeleted':
			// Delete all Deleted PAGER messages....
	 			$result = $db->query_first("SELECT count(*) AS total 
	 				FROM " . TABLE_PREFIX . "pagerreceipt
	 				WHERE active = 0 AND markdeleted = 1");
	 			$totalpager = intval($result['total']);

		 		$sql	= "DELETE FROM " . TABLE_PREFIX . "pagerreceipt
		 					WHERE active = 0 AND markdeleted = 1";
				$result	= $db->query($sql);
	 		break;
	 	case 'killpagerunreaddeleted':
	 		// Delete all unread Pager messages...
	 			$result = $db->query_first("SELECT count(*) AS total 
	 				FROM " . TABLE_PREFIX . "pagerreceipt
	 				WHERE readtime = 0");
	 			$totalunread = intval($result['total']);

		 		$sql	= "DELETE FROM " . TABLE_PREFIX . "pagerreceipt
		 					WHERE readtime = 0";
				$result	= $db->query($sql);
				$result = $db->query_write("UPDATE " . TABLE_PREFIX . "user SET pagerunread=0");

			// Delete all Deleted PAGER messages....
	 			$result = $db->query_first("SELECT count(*) AS total 
	 				FROM " . TABLE_PREFIX . "pagerreceipt
	 				WHERE active = 0 AND markdeleted = 1");
	 			$totaldeleted = intval($result['total']);
				$totalpager	  = $totalunread + $totaldeleted;
		 		$sql	= "DELETE FROM " . TABLE_PREFIX . "pagerreceipt
		 					WHERE active = 0 AND markdeleted = 1";
				$result	= $db->query($sql);
	 		break; 
	 }
	$dbresult = vbpager_updatedb();
	 
	define('CP_REDIRECT', "pageradmin.php?do=pagerstats");
	print_stop_message('pager_x_deleted_pager_messages_successfully', $totalpager);	
}

// ############################# start Pager stats #########################
if ($_REQUEST['do'] == 'pagerstats')
{
	$sqlpager = $db->query_read("
		SELECT COUNT(*) AS total, userid  
		FROM " . TABLE_PREFIX . "pagerreceipt 
		WHERE (active = 1) 
		GROUP BY userid  
		ORDER BY total DESC
	");

// Custom Modification ....... Custom Modification
	$result = $db->query_first("SELECT count(*) AS total,
				sum(readtime>0) AS totalread, sum(active) AS totalactive 
				FROM " . TABLE_PREFIX . "pagerreceipt");
	$totalpager		= $result['total'];
	$totalread		= $result['totalread'];
	$totalunread	= ($totalpager - $totalread);

	$result = $db->query_first("SELECT count(*) AS totaldeleted 
				FROM " . TABLE_PREFIX . "pagerreceipt 
				WHERE active = 0 AND markdeleted = 1");
	$totaldeleted	= $result['totaldeleted'];

	print_form_header('pageradmin', 'removepagermessages');
	print_table_header($vbphrase['pager_prune_pager_messages'], 2, 0, 'style');
	print_yes_no_row($vbphrase['pager_total_number_stored_in_system'] . ' (' . $totalpager . ')', 'pagerall', 0);
	print_yes_no_row($vbphrase['pager_total_number_unread_in_system'] . ' (' . $totalunread . ')', 'pagerunread', 0);
	print_yes_no_row($vbphrase['pager_total_number_deleted_in_system'] . ' (' . $totaldeleted . ')', 'pagerdeleted', 0);
	print_submit_row($vbphrase['pager_prune_selected'], 0);
	
	print_form_header('pageradmin', 'viewpagerstats');
	print_table_header($vbphrase['pager_message_statistics'], 3);
	print_cells_row(array($vbphrase['number_of_messages'], $vbphrase['number_of_users'], $vbphrase['controls']), 1);

	$groups = array();
	while ($pm = $db->fetch_array($sqlpager))
	{
		$groups[$pm['total']]++;
	}
	foreach ($groups AS $key => $total)
	{
		$cell = array();
		$cell[] = $key . iif($vbulletin->options['pmquota'], '/' . $vbulletin->options['pmquota']);
		$cell[] = $total;
		$cell[] = construct_link_code(construct_phrase($vbphrase['list_users_with_x_messages'], $key), "pageradmin.php?" . $vbulletin->session->vars['sessionurl'] . "do=pageruserstats&total=$key");
		print_cells_row($cell);
	}
	print_table_footer();
}

// ############################# start Pager stats #########################
if ($_REQUEST['do'] == 'pageruserstats')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'total' => TYPE_UINT
	));

	$users = $db->query_read("
		SELECT COUNT( * ) AS total, pager.userid, user.username, 
		user.lastactivity FROM " . TABLE_PREFIX . "pagerreceipt AS pager
		INNER JOIN " . TABLE_PREFIX . "user AS user ON (pager.userid = user.userid) 
		WHERE (pager.active = 1) 
		GROUP BY pager.userid
		HAVING total = " . $vbulletin->GPC['total'] . "
		ORDER BY user.username DESC
		");

	if (!$db->num_rows($users))
	{
		print_stop_message('no_users_matched_your_query');
	}

	// a little javascript for the options menus
	?>
	<script type="text/javascript">
	function js_pm_jump(userid,username)
	{
		value = eval("document.cpform.u" + userid + ".options[document.cpform.u" + userid + ".selectedIndex].value");
		var page = '';
		switch (value)
		{
			case 'pagerstats': page = "pageradmin.php?do=pagerfolderstats&u=" + userid; break;
			case 'profile': page = "user.php?do=edit&u=" + userid; break;
			case 'pmuser': page = "../private.php?do=newpm&u=" + userid; break;
			case 'delete': page = "pageradmin.php?do=removepagers&u=" + userid; break;
		}
		if (page != '')
		{
			window.location = page + "&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";
		}
		else
		{
			window.location = "mailto:" + value;
		}
	}
	</script>
	<?php

	print_form_header('pageradmin', '');
	print_table_header(construct_phrase($vbphrase['pager_users_with_x_pager_messages_stored'], $vbulletin->GPC['pms']), 3);
	print_cells_row(array($vbphrase['username'], $vbphrase['last_activity'], $vbphrase['options']), 1);
	while($user = $db->fetch_array($users))
	{
		$cell = array();
		$cell[] = "<a href=\"../member.php?" . $vbulletin->session->vars['sessionurl'] . "do=getinfo&amp;u=$user[userid]\" target=\"_blank\">$user[username]</a>";
		$cell[] = vbdate($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $user['lastactivity']);
		$cell[] = "
		<select name=\"u$user[userid]\" onchange=\"js_pm_jump($user[userid], '$user[username]');\" tabindex=\"1\" class=\"bginput\">
			<option value=\"pagerstats\">" . $vbphrase['pager_view_pager_message_statistics'] . "</option>
			<option value=\"profile\">" . $vbphrase['edit_user'] . "</option>
			<option value=\"$user[email]\">" . $vbphrase['send_email_to_user'] . "</option>
			<option value=\"pmuser\">" . $vbphrase['send_private_message_to_user'] . "</option>
			<option value=\"delete\">" . construct_phrase($vbphrase['pager_delete_all_users_pager_messages']) . "</option>
		</select><input type=\"button\" class=\"button\" value=\"$vbphrase[go]\" onclick=\"js_pm_jump($user[userid], '$user[username]');\" tabindex=\"1\" />\n\t";
		print_cells_row($cell);
	}
	print_table_footer();

}

print_cp_footer();

// ********** Local Functions... *************
function vbpager_totalpager($userid = 0)
{
	global $vbulletin;

	if ($userid > 0)
	 {
		$result = $vbulletin->db->query_first("SELECT count(*) AS totalpager 
					FROM " . TABLE_PREFIX . "pagerreceipt 
					WHERE (userid = $userid AND active = 1 ) 
					OR (touserid = $userid AND markdeleted = 0)");
		$totalpager	= intval($result['totalpager']);
		return $totalpager;
	 }
	return 0;
}

function vbpager_totalunread($userid = 0)
{
	global $vbulletin;
	if ($userid > 0)
	 {
		$result = $vbulletin->db->query_first("SELECT count(*) AS totalpager 
					FROM " . TABLE_PREFIX . "pagerreceipt 
					WHERE (touserid = $userid AND markdeleted = 0) 
					AND readtime = 0");
		$totalpager	= intval($result['totalpager']);
	
		return $totalpager;
	 }
}

function vbpager_updatedb($uid = 0)
{
	global $vbulletin;
	$pagerusers = $vbulletin->db->query_read("SELECT userid 
						FROM " . TABLE_PREFIX . "user " .
						iif($uid > 0, " WHERE userid = '$uid' ", ' ') . " 
						ORDER BY userid");		
	$i	= 0;
	while ($pageruser = $vbulletin->db->fetch_array($pagerusers))
	 {		
	 	$userid		= $pageruser['userid'];
	 	$sumpager	= vbpager_totalpager($userid);
	 	$unreadsum	= vbpager_totalunread($userid);

		$i++;
	 	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET 
	 			pagertotal = '$sumpager', pagerunread = '$unreadsum' 
	 			WHERE userid = $userid ");
	 }	
	return $i;
}


/*======================================================================*\
|| ####################################################################
|| # Last Update: 03:42, Wed Jan 25th 2006
|| # CVS: $RCSfile: pageradmin.php,v $ - $Revision: 3.0.1 $
|| ####################################################################
\*======================================================================*/
?>