<?php

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);
$phrasegroups = array('cpuser');
$specialtemplates = array();
$globaltemplates = array();
$actiontemplates = array();

require_once('./global.php');
require_once('./includes/functions.php');
require_once('./includes/adminfunctions_user.php');

print_cp_header($vbphrase['postreports_postreports']);

$vbulletin->input->clean_array_gpc('r', array('do' => STR, 'page' => INT));
$do = $vbulletin->GPC['do'];
$page = $vbulletin->GPC['page'];

if ($_REQUEST['do'] == 'list' || $_REQUEST['do'] == 'closed')
{
    if ($_REQUEST['do'] == 'list')
    {
        $totalreports = $db->query_first("
            SELECT COUNT(p.reportid) AS reportcount
            FROM " . TABLE_PREFIX . "postreport p
            WHERE p.status < 2
        ");
    
        if ($totalreports['reportcount'] == 0)
        {
            print_stop_message('postreports_nooutstanding');
        }
        $dolist = true;
    }
    else if ($_REQUEST['do'] == 'closed')
    {
        $totalreports = $db->query_first("
            SELECT COUNT(p.reportid) AS reportcount
            FROM " . TABLE_PREFIX . "postreport p
            WHERE p.status = 2
        ");
        
        if ($totalreports['reportcount'] == 0)
        {
            print_stop_message('postreports_noclosed');
        }
        $dolist = false;
    }
    $reportcount = $totalreports['reportcount'];
    $reports_per_page = 5;
    if ($page < 1)
    {
        $page = 1;
    }
    sanitize_pageresults($reportcount, $page, $reports_per_page);
    $startat = ($page - 1) * $reports_per_page;
    $totalpages = ceil($reportcount / $reports_per_page);

    $searchquery = "
        SELECT
        postreport.*,
        user.username modname,
        user2.username reporter,
        post.username postername,
        post.userid posterid,
        thread.title,
        thread.threadid,
        forum.title forumtitle,
        forum.forumid
        FROM " . TABLE_PREFIX . "postreport AS postreport
        LEFT JOIN " . TABLE_PREFIX . "user AS user ON (postreport.modid = user.userid)
        LEFT JOIN " . TABLE_PREFIX . "user AS user2 ON (postreport.userid = user2.userid)
        LEFT JOIN " . TABLE_PREFIX . "post AS post ON (postreport.postid = post.postid)
        LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON (post.threadid = thread.threadid)
        LEFT JOIN " . TABLE_PREFIX . "forum AS forum ON (thread.forumid = forum.forumid)
        WHERE " . iif($dolist, "postreport.status < 2" , "postreport.status = 2") . "
        ORDER BY dateline DESC
        LIMIT $startat, $reports_per_page
    ";
    
    $postreports = $db->query($searchquery);

    if ($page != 1)
    {
        $prv = $page - 1;
        $firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['first_page'] . "\" tabindex=\"1\" onclick=\"window.location='postreports.php?$session[sessionurl]do=" . iif($dolist, "list", "closed") . "&page=1'\">";
        $prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['prev_page'] . "\" tabindex=\"1\" onclick=\"window.location='postreports.php?$session[sessionurl]do=" . iif($dolist, "list", "closed") . "&page=$prv'\">";
    }
    
    if ($page != $totalpages)
    {
        $nxt = $page + 1;
        $nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['next_page'] . " &gt;\" tabindex=\"1\" onclick=\"window.location='postreports.php?$session[sessionurl]do=" . iif($dolist, "list", "closed") . "&page=$nxt'\">";
        $lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['last_page'] . " &raquo;\" tabindex=\"1\" onclick=\"window.location='postreports.php?$session[sessionurl]do=" . iif($dolist, "list", "closed") . "&page=$totalpages'\">";
    }    
        
    print_form_header();
    print_table_header(
        construct_phrase($vbphrase['postreports_page_x_of_y'], $page, $totalpages) .
        " " . 
        $reportcount .
        " " .
        iif($dolist, $vbphrase['postreports_open'], $vbphrase['postreports_closed']) .
        "  " .
        $vbphrase['postreports_reports'] .
        ".", 4
    );
    print_table_footer(4, "$firstpage $prevpage &nbsp; $nextpage $lastpage");
    
    while ($postreport = $db->fetch_array($postreports))
    {
        print_form_header('postreports', 'update');
        
        $postreport['datelinetime'] =
            vbdate("h:i A", $postreport['dateline'], true);
        $postreport['datelinedate'] =
            vbdate("d-m-Y", $postreport['dateline'], true);
        $title = $vbphrase['postreport_reportfrom'] .
             " <a href=\"" .
             "../member.php?u=" .
             $postreport['userid'] .
             "\" target=\"new\">" .
             "<strong>" .
             $postreport['reporter'] .
             "</strong>" .
             "</a> " .
             $postreport['datelinedate'] . " " . $postreport['datelinetime'];
             
        print_table_header($title, 2);    
        
        
        $cell = array();
        
        $cell[] = "<input type=\"hidden\" name=\"reportid\" value=\"" .
                  $postreport['reportid'] .
                  "\">" .
                  "<input type=\"hidden\" name=\"page\" value=\"list\">" .
              "Post" .
              ": " .
              "<a href=\"" .
              "../showpost.php?postid=" .
              $postreport['postid'] .
              "\" target=\"new\">[" .
              $postreport['postid'] .
              "]</a>";
        $cell[] = $vbphrase['postreports_postedby'] .
              ": " .
              "<a href=\"" .
              "../member.php?u=" .
              $postreport[posterid] .
              "\" target=\"new\">" .
              $postreport[postername] .
              "</a>";        
        print_cells_row($cell);
        
        $cell = array();

        $cell[] = $vbphrase['postreports_onthread'] .
              ": " .
              "<a href=\"" . 
              "../showthread.php?p=" .
              $postreport[postid] .
              "\" target=\"new\">" .
              $postreport[title] .
              "</a>";
              
        $cell[] = $vbphrase['postreports_inforum'] .
              ": " .
              "<a href=\"" . 
              "../forumdisplay.php?f=" .
              $postreport[forumid] .
              "\" target=\"new\">" .
              $postreport[forumtitle] .
              "</a>";
        
        print_cells_row($cell);
        
        $cell = array();
        
        $cell[] = $vbphrase['postreports_usercomment'] . ":<br/><br/>" .
               "<textarea rows=\"6\" cols=\"40\">" .
               $postreport['reporttext'] .
               "</textarea>";

        $cell[] = $vbphrase['postreports_moderatorcomment'] . ":<br/><br/>" .
              "<textarea id=\"modtext\" name=\"modtext\" rows=\"6\" cols=\"40\">" .
              $postreport['modtext'] .
              "</textarea>";        
        
        print_cells_row($cell);
        
        $cell = array();
        
        $cell[] = $vbphrase['postreports_moderator'] . ": " .
              $postreport[modname];            
        
        if ($postreport['updatetime'] != null)
        {
            $postreport['updatetimetime'] =
            vbdate("h:i A", $postreport['updatetime'], true);
            $postreport['updatetimedate'] =
            vbdate("d-m-Y", $postreport['updatetime'], true);
            $cell[] = "" . "Updated" . ": " .
                $postreport['updatetimedate'] . " " . $postreport['updatetimetime'];        
        }
        else
        {
            $cell[] = "" . "Updated" . ": -";
        }        
        
        print_cells_row($cell);
        
        $cell = array();
            
        $cell[] = "";
        
        
        switch ($postreport['status'])
        {
        case 1:
            $cell[] =  "" . "Status" . ":<br/>" .
                     "<select id=\"status\" name=\"status\">" .
                     "<option value=\"0\">Open" .
                       "<option value=\"1\" selected>Pending" .
                       "<option value=\"2\">Closed" .
                       "</select>";                        
            break;
        case 2:
            $cell[] =  "" . "Updated" . ":<br/>" .
                     "<select id=\"status\" name=\"status\">" .
                     "<option value=\"0\">Open" .
                       "<option value=\"1\">Pending" .
                       "<option value=\"2\" selected>Closed" .
                       "</select>";                        
             break;
        case 0:
        default:
            $cell[] =  "" . "Updated" . ":<br/>" .
                     "<select id=\"status\" name=\"status\">" .
                     "<option value=\"0\" selected>Open" .
                       "<option value=\"1\">Pending" .
                       "<option value=\"2\">Closed" .
                       "</select>";                
            break;
             

        }
        print_cells_row($cell);
        print_submit_row("Save", "Reset", 4);
        print_table_footer();
    }
}

if ($_POST['do'] == 'update')
{
    $status = $_POST['status'];
    $modtext = addslashes(htmlspecialchars_uni($_POST['modtext']));
    $reportid = $_POST['reportid'];
    $page = $_POST['page'];
    
    $db->query("
        UPDATE " . TABLE_PREFIX . "postreport
        SET status = $status, modtext = '$modtext',
        updatetime = " . TIMENOW . ", modid = ". $vbulletin->userinfo['userid'] . "
        WHERE reportid = $reportid
    ");
    
    if ($page == "list")
    {
        $url = "postreports.php?do=list";
    }
    else
    {
        $url = "postreports.php?do=closed";
    }

    print_cp_message("Updated report", $url, 2);
}

print_cp_footer();

?> 