<?php

error_reporting(E_ALL & ~E_NOTICE);

define('THIS_SCRIPT', 'postreports');
define('NO_REGISTER_GLOBALS', 1);

$phrasegroups = array();
$specialtemplates = array();
$globaltemplates = array('postreports', 'postreportbits');
$actiontemplates = array();

require_once('./global.php');
require_once('./includes/functions.php');

if (!$vbulletin->userinfo['userid'])
{
	print_no_permission();
}

$userid = $vbulletin->userinfo['userid'];
$mod = 0;
$reports_per_page = 25;

$totalreports = $db->query_first("
	SELECT COUNT(p.reportid) AS reportcount
	FROM " . TABLE_PREFIX . "postreport p WHERE p.userid = $userid
");
$totalpages = ceil(($totalreports['reportcount']) / $reports_per_page);
$pagenumber = $_REQUEST['page'];

if ($pagenumber == "" || $pagenumber == "0" || $pagenumber < 0)
{
	$pagenumber = 1;
}
$page_start = ($pagenumber - 1) * $reports_per_page;

$pagenav = construct_page_nav($totalpages, $reports_per_page, $totalreports['reportcount'], "postreports.php?$session[sessionurl]");

$postreports = $db->query("
	SELECT
	postreport.*,
	user.username modname,
	post.username postername,
	post.userid posterid,
	thread.title, thread.threadid
	FROM " . TABLE_PREFIX . "postreport AS postreport
	LEFT JOIN " . TABLE_PREFIX . "user AS user ON (postreport.modid = user.userid)
	LEFT JOIN " . TABLE_PREFIX . "post AS post ON (postreport.postid = post.postid)
	LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON (post.threadid = thread.threadid)
	WHERE postreport.userid = $userid
	ORDER BY postreport.dateline DESC
	LIMIT $page_start, $reports_per_page
");

while ($postreport = $db->fetch_array($postreports))
{
	$postreport['timeline'] =
		vbdate($vbulletin->options['timeformat'], $postreport['dateline']);
	$postreport['dateline'] =
		vbdate($vbulletin->options['dateformat'], $postreport['dateline']);
	$postreport['reporttext'] =
		htmlspecialchars_uni($postreport['reporttext']);
	$postreport['modtext'] = 
		htmlspecialchars_uni($postreport['modtext']);
	
	if ($postreport['updatetime'] != NULL)
	{
		$postreport['updatetimetime'] = 
			vbdate($vbulletin->options['timeformat'], $postreport['updatetime']);
		$postreport['updatetimedate'] =
			vbdate($vbulletin->options['dateformat'], $postreport['updatetime']);
	}
	else
	{
		$postreport['updatetimetime'] = "";
		$posrreport['updatetimedate'] = "";
	}

	if ($postreport['modid'] == "")
	{
		$mod = 0;
	}
	else
	{
		$mod = 1;
	}

	if ($postreport['modtext'] == NULL)
	{
		$postreport['modtext'] = "";
	}

	switch ($postreport['status'])
	{
	case 0:
		$postreport['status'] = $vbphrase['postreports_status_open'];
		break;
	case 1:
		$postreport['status'] = $vbphrase['postreports_status_pending'];
		break;	
	case 2:
		$postreport['status'] = $vbphrase['postreports_status_closed'];
		break;	
	default:
		$postreport['status'] = "-";
		break;	
	}
    
    $postreport['reporttext'] = stripslashes(strtr($postreport['reporttext'], array_flip(get_html_translation_table(HTML_SPECIALCHARS, ENT_COMPAT))));
    $postreport['modtext'] = stripslashes(strtr($postreport['modtext'], array_flip(get_html_translation_table(HTML_SPECIALCHARS, ENT_COMPAT))));
    
	eval('$postreportbits .= "' . fetch_template('postreportbits') . '";');
}
	
$navbits = construct_navbits(array('' => $vbphrase['postreports']));
eval('$navbar = "' . fetch_template('navbar') . '";');
eval('print_output("' . fetch_template('postreports') . '");');

?>