<?php
/*======================================================================*\
|| ######################################################################## ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| ######################################################################## ||
\*======================================================================*/

if (function_exists('set_time_limit') AND get_cfg_var('safe_mode')==0)
{
	@set_time_limit(0);
}

ignore_user_abort(true);
error_reporting(E_ALL & ~E_NOTICE);

$nozip = 1;
define('VB_AREA', 'ImpEx');

// If there is no global file in the same dir, then we aren't in vB
// we are standalone, else assume we are.

if (file_exists('../includes/config.php'))
{
	if (file_exists('../admincp/language.php'))
	{
		// admin CP directory wasn't renamed
		// this bit allows people on 3.0.0 to do an import (if they haven't renamed their admin CP dir)
		chdir('../admincp/');
	}
	else
	{
		require('../includes/config.php');
		chdir("../$admincpdir/");
	}
	require_once('./global.php');

	$usewrapper = true;
}
else
{
	chdir('../'); // make sure our includes use the same paths
	$usewrapper = false;
}

$systempath = './';


// #############################################################################
// Requires
// #############################################################################

extract(parse_ini_file($systempath . 'impex/ImpExConfig.php'), EXTR_SKIP); // use skip to prevent existing variables being overwritten

require_once ($systempath . 'impex/ImpExController.php');
require_once ($systempath . 'impex/ImpExSession.php');
require_once ($systempath . 'impex/ImpExDisplay.php');
require_once ($systempath . 'impex/ImpExDisplayWrapper.php');
require_once ($systempath . 'impex/ImpExData.php');
require_once ($systempath . 'impex/ImpExModule.php');
require_once ($systempath . 'impex/ImpExFunction.php');

require_once ($systempath . 'impex/db_mysql.php');

##################

// #############################################################################
// Help page echo
// #############################################################################

$ImpEx = new ImpExController();

if($usewrapper)
{
	$ImpExDisplay = new ImpExDisplayWrapper();
}
else
{
	$ImpExDisplay = new ImpExDisplay();
}

$Db_source = new DB_Sql_vb_impex();

$Db_target = new DB_Sql_vb_impex();
$Db_target->appname = 'vBulletin:ImpEx Target';
$Db_target->appshortname = 'vBulletin:ImpEx Target';
$Db_target->database = $targetdatabase;
$Db_target->connect($targetserver, $targetuser, $targetpassword, 0);

// #############################################################################
// Session start
// #############################################################################

$session_state = $ImpEx->return_session($Db_target, $targettableprefix);

if ($session_state)
{
	$ImpExSession = $session_state;
}
else
{
	$ImpExSession = new ImpExSession();
}

// #############################################################################
// create vbfields
// #############################################################################

if($ImpExSession->get_session_var('vbfields') != 'done')
{
	require_once($systempath. 'impex/vbfields.php');
	$queries = &retrieve_vbfields_queries($targettableprefix);
	foreach ($queries AS $query)
	{
		$Db_target->query($query);
	}

	$ImpExSession->add_session_var('vbfields', 'done');
}

// #############################################################################
// Add vars to session
// #############################################################################

$ImpExSession->add_session_var('systempath', $systempath);
$ImpExSession->add_session_var('sourceexists', $sourceexists);

$ImpExSession->add_session_var('targettableprefix', $targettableprefix);
$ImpExSession->add_session_var('targetdatabasetype', strtolower($targetdatabasetype));

$ImpExSession->add_session_var('sourcetableprefix', $sourcetableprefix);
$ImpExSession->add_session_var('sourcedatabasetype', strtolower($sourcedatabasetype));


if($sourceexists)
{
	$Db_source->appname = 'vBulletin:ImpEx Source';
	$Db_source->appshortname = 'vBulletin:ImpEx Source';
	$Db_source->database = $sourcedatabase;

	$Db_source->reporterror = 0;
	$Db_source->connect($sourceserver, $sourceuser, $sourcepassword, 0);
	$Db_source->reporterror = 1;
	if ($Db_source->link_id)
	{ // got connected
		switch ($Db_source->geterrno())
		{
			case 1046:
				$ImpExDisplay->display_error('A source database was not entered in ImpExConfig.php');
				exit;
			break;
			case 1049:
				$ImpExDisplay->display_error('The source database entered in ImpExConfig.php does not exist.');
				exit;
			break;
		}
	}
	else
	{
		$ImpExDisplay->display_error('Connection to source server failed. Check username and password.');
		exit;
	}

	// php versions before 4.2.0 do nasty things with multiple connections to the same server
	// See http://uk.php.net/manual/en/function.mysql-connect.php
	if (($Db_target->link_id === $Db_source->link_id) AND phpversion() < '4.2.0')
	{
		$Db_target->require_db_reselect = true;
		$Db_source->require_db_reselect = true;
	}
}

$ImpEx->get_post_values($ImpExSession,$_POST);

// #############################################################################
// Autosubmit
// #############################################################################

$ImpExDisplay->update_basic('autosubmit',$ImpExSession->get_session_var('autosubmit'));

// #############################################################################
// Autosubmit & Home
// #############################################################################

if ($ImpExSession->get_session_var('module') == '000' OR $ImpExSession->get_session_var('module') == NULL)
{
	if ($ImpExSession->get_session_var('system') != '' AND $ImpExSession->get_session_var('system') != 'NONE')
	{
		require_once($systempath . 'impex/systems/' . $ImpExSession->get_session_var('system') . '/000.php');
		$ImpExSession->build_module_list();
	}
	else
	{
		if ($ImpExSession->get_session_var('system') == '')
		{
			$ImpExSession->set_session_var('system', 'NONE');
		}
		else
		{
			$ImpExSession->set_session_var('system', $ImpExSession->get_session_var('system'));
			$ImpExDisplay->update_basic('title', $ImpExSession->get_session_var('system'));
		}
	}
}

echo $ImpExDisplay->page_header();
echo '<br> <div align="center"><a href="help.php">Database cleanup &amp; restart</a> ||| <a href="http://www.vbulletin.com/docs/html/impex" target="blank_">Online manual</a></div><br>';
// #############################################################################
// Resume
// #############################################################################

$currentmoduleworking = $ImpExSession->any_working();

if ($currentmoduleworking != NULL)
{
	$name = $systempath . 'impex/systems/' . $ImpExSession->get_session_var('system') . '/' . $currentmoduleworking . '.php';
	require_once($systempath . 'impex/systems/' . $ImpExSession->get_session_var('system') . '/000.php');
	require_once($name);
	$classname = $ImpExSession->get_session_var('system') . '_' . $currentmoduleworking;
	$ModuleCall = new $classname($ImpExSession);
	$ModuleCall->resume($ImpExSession, $ImpExDisplay, $Db_target, $Db_source);
}

// #############################################################################
// Init
// #############################################################################

if ($ImpExSession->get_session_var('module') != '000' AND $ImpExSession->get_session_var('module') != NULL AND $currentmoduleworking == FALSE)
{
	$ImpExDisplay->update_basic('displaymodules', 'FALSE');
	$name = $systempath . 'impex/systems/' . $ImpExSession->get_session_var('system') . '/' . $ImpExSession->get_session_var('module') . '.php';
	require_once($systempath . 'impex/systems/' . $ImpExSession->get_session_var('system') . '/000.php');
	require_once($name);
	$classname = $ImpExSession->get_session_var('system') . '_' .  $ImpExSession->get_session_var('module');
	$ModuleCall = new $classname($ImpExSession);

	if ($ImpExSession->get_session_var($ImpExSession->get_session_var('module')) == 'FINISHED')
	{
		$ModuleCall->restarted();
	}

	$ModuleCall->using($ImpExSession);
	$ModuleCall->init($ImpExSession, $ImpExDisplay, $Db_target, $Db_source);
}

// #############################################################################
// Update & Display
// #############################################################################

$ImpEx->updateDisplay($ImpExSession, $ImpExDisplay);
echo $ImpExDisplay->display($ImpExSession);
if ($displayerrors)
{
	echo $ImpExSession->display_errors('all');
}

// #############################################################################
// Session End
// #############################################################################

$ImpEx->store_session($Db_target, $targettableprefix, $ImpExSession);

echo $ImpExDisplay->page_footer();

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 13:19, Thu Oct 21st 2004
|| # CVS: $RCSfile: index.php,v $ - $Revision: 1.25 $
|| ####################################################################
\*======================================================================*/
?>
