<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* phpBB2_000
*
* @package 		ImpEx.phpBB2
* @version		$Revision: 1.34 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/10/20 14:19:13 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class phpBB2_000 extends ImpExModule
{
	/**
	* Supported version
	*
	* @var    string
	*/
	var $_version = '2.0.6';

	/**
	* Module string
	*
	* Class string for phpUnit header
	*
	* @var    array
	*/
	var $_modulestring 	= 'phpBB2';
	var $_homepage 	= 'http://www.phpbb.com/';

	/**
	* Valid Database Tables
	*
	* @var    array
	*/
	var $_valid_tables = array (
					'auth_access','banlist','categories','config','confirm','disallow','forum_prune','forums','groups','posts','posts_text',
					'privmsgs','privmsgs_text','ranks','search_results','search_wordlist','search_wordmatch','sessions','smilies',
					'themes','themes_name','topics','topics_watch','user_group','users','vote_desc','vote_results','vote_voters','words'
					);


	function phpBB2_000()
	{
	}

	/**
	* HTML parser
	*
	* @param	string	mixed			The string to parse
	* @param	boolean					Truncate smilies
	*
	* @return	array
	*/
	function phpbb_html($text, $truncate_smilies = false)
	{
		// Quotes
		// With name

		for($i=0;$i<10;$i++)
		{
			$text = preg_replace('#\[quote:([a-z0-9]+)="(.*)"\](.*)\[/quote:\\1\]#siU', '[quote=$2]$3[/quote]', $text);
		}
			// Without
		for($i=0;$i<10;$i++)
		{
			$text = preg_replace('#\[quote:([a-z0-9]+)\](.*)\[/quote:\\1\]#siU', '[quote]$2[/quote]', $text);
		}

		$text = preg_replace('#\[code:([0-9]+):([a-z0-9]+)\](.*)\[/code:\\1:\\2\]#siU', '[code]$3[/code]', $text);

		// Bold , Underline, Italic
		$text = preg_replace('#\[b:([a-z0-9]+)\](.*)\[/b:\\1\]#siU', '[b]$2[/b]', $text);
		$text = preg_replace('#\[u:([a-z0-9]+)\](.*)\[/u:\\1\]#siU', '[u]$2[/u]', $text);
		$text = preg_replace('#\[i:([a-z0-9]+)\](.*)\[/i:\\1\]#siU', '[i]$2[/i]', $text);

		// Images
		$text = preg_replace('#\[img:([a-z0-9]+)\](.*)\[/img:\\1\]#siU', '[img]$2[/img]', $text);

		// Lists
		$text = preg_replace('#\[list(=1|=a)?:([a-z0-9]+)\](.*)\[/list:(u:|o:)?\\2\]#siU', '[list$1]$3[/list]', $text);

		// Lists items
		$text = preg_replace('#\[\*:([a-z0-9]+)\]#siU', '[*]', $text);

		// Color
		$text = preg_replace('#\[color=([^:]*):([a-z0-9]+)\](.*)\[/color:\\2\]#siU', '[color=$1]$3[/color]', $text);

		// Font
		$text = preg_replace('#\[font=([^:]*):([a-z0-9]+)\](.*)\[/font:\\2\]#siU', '[font=$1]$3[/font]', $text);

		// Text size
		$text = preg_replace('#\[size=([0-9]+):([a-z0-9]+)\](.*)\[/size:\\2\]#siUe', "\$this->pixel_size_mapping('\\1', '\\3')", $text);

		// Smiles
		// Get just truncated phpBB smilies for this one to do the replacments

		if($truncate_smilies)
		{
			$text = str_replace(array_keys($truncate_smilies), $truncate_smilies, $text);
		}

		return $text;
	}

	/**
	* Regex call back
	*
	* @param	string	mixed			The origional size
	* @param	string	mixed			The content text
	*
	* @return	array
	*/
	function pixel_size_mapping($size, $text)
	{
		$text = str_replace('\"', '"', $text);

		if ($size <= 8)
		{
		   $outsize = 1;
		}
		else if ($size <= 10)
		{
		   $outsize = 2;
		}
		else if ($size <= 12)
		{
		   $outsize = 3;
		}
		else if ($size <= 14)
		{
		   $outsize = 4;
		}
		else if ($size <= 16)
		{
		   $outsize = 5;
		}
		else if ($size <= 18)
		{
		   $outsize = 6;
		}
		else
		{
		   $outsize = 7;
		}

		return '[size=' . $outsize . ']' . $text .'[/size]';
	}


	/**
	* Returns the user_id => username array
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	int		mixed			Start point
	* @param	int		mixed			End point
	*
	* @return	array
	*/
	function get_phpbb_members_list(&$Db_object, &$databasetype, &$tableprefix, &$start, &$per_page)
	{
		$return_array = array();

		// Check that there isn't a empty value
		if(empty($per_page)) { return $return_array; }

		if ($databasetype == 'mysql')
		{
			$sql = "
			SELECT user_id,username
			FROM " . $tableprefix . "users
			ORDER BY user_id
			LIMIT " . $start . "," . $per_page;

			$user_list = $Db_object->query($sql);

			while ($user = $Db_object->fetch_array($user_list))
			{
					$tempArray = array($user['user_id'] => $user['username']);
					$return_array = $return_array + $tempArray;
			}
			return $return_array;
		}
		else
		{
			return false;
		}
	}


	/**
	* Returns the user details array
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	int		mixed			Start point
	* @param	int		mixed			End point
	*
	* @return	array
	*/
	function get_phpbb2_user_details(&$DB_object, &$database_type, &$table_prefix, &$start, &$per_page)
	{
		$return_array = array();

		// Check that there isn't a empty value
		if(empty($per_page)) { return $return_array; }

		if ($database_type == 'mysql')
		{
			$sql = "
			SELECT * FROM " .
			$table_prefix."users
			ORDER BY user_id
			LIMIT " .
			$start .
			"," .
			$per_page
			;

			$users = $DB_object->query($sql);

			while ($user = $DB_object->fetch_array($users))
			{
				switch ($user['user_level'])
				{
					case "0":
						$user['usergroupid'] = "2"; //Registered
						break;
					case "1":
						$user['usergroupid'] = "6"; //Administrator
						break;
					case "2":
						$user['usergroupid'] = "7"; //Moderator
						break;
				}

				if (!$user['usergroupid'])
				{
					$user['usergroupid'] = "1"; //Unregistered
				}

				$user['user_sig'] = $this->html_2_bb($user['user_sig'], $user['user_sig_bbcode_uid']);


				$return_array["$user[user_id]"] = $user;
				unset($user);
			}
		}
		else
		{
			return false;
		}

		return $return_array;
	}


	/**
	* Returns a type of ban list
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	object	displayobject	The display object
	* @param	object	sessionobject	The prefix to the table name i.e. 'vb3_'
	* @param	string	mixed			The type of list to be returned
	*
	* @return	array
	*/
	function get_list(&$Db_object, &$database_type, &$table_prefix, $type)
	{
		$return_array = array();

		if ($database_type == 'mysql')
		{
			$sql = "
			SELECT
			ban_id,
			ban_" . $type . "
			FROM
			" . $table_prefix . "banlist
			";

			$ban_list = $Db_object->query($sql);

			while ($ban = $Db_object->fetch_array($ban_list))
			{
				$return_array[$ban_list['ban_id']] = $ban_list[1];
			}
		}
		else
		{
			return false;
		}
		return $return_array;
	}

	/**
	* Imports a list with error handeling
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	object	displayobject	The display object
	* @param	object	sessionobject	The prefix to the table name i.e. 'vb3_'
	* @param	array	mixed			The list to be imported
	* @param	string	mixed			The type of list being imported
	*
	* @return	none
	*/
	function do_list(&$Db_target, &$displayobject, &$sessionobject, &$list, $type)
	{
		$result = $this->import_ban_list($Db_target,
										$sessionobject->get_session_var('targetdatabasetype'),
										$sessionobject->get_session_var('targettableprefix'),
										$list,
										$type);

		if (!$result)
		{
			$sessionobject->add_session_var($class_num . '_objects_faild',intval($sessionobject->get_session_var($class_num . '_objects_failed')) + 1 );
			$sessionobject->add_error('warning', $this->_modulestring,
						$class_num . "::import_ban_list failed on $type - $list",
						 "Check for format of the $type $list");
			$displayobject->update_html("<b>There was an error with the import of the $type ban list.</b>");
		}
		else
		{
			$sessionobject->add_session_var($class_num . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
			$displayobject->update_html("<br /><b>$type</b> Ban list <i>imported.</i>");
		}
	}


	/**
	* Returns the sytles array
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	*
	* @return	array
	*/
	function get_phpbb_styles(&$DB_object, &$database_type, &$table_prefix)
	{
		$return_array = array();
		if ($database_type == 'mysql')
		{
			$sql = "
			SELECT * FROM " .
			$table_prefix."themes"
			;

			$themes = $DB_object->query($sql);

			while ($theme = $DB_object->fetch_array($themes))
			{
				$return_array["$theme[themes_id]"] = $theme;
				unset($theme);
			}
		}
		else
		{
			return false;
		}

		return $return_array;
	}


	/**
	* Returns the categories details array
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	*
	* @return	array
	*/
	function get_phpbb2_categories_details(&$DB_object, &$database_type, &$table_prefix)
	{
		$return_array = array();
		if ($database_type == 'mysql')
		{
			$sql = "
			SELECT * FROM " .
			$table_prefix."categories"
			;

			$categories = $DB_object->query($sql);

			while ($categorie = $DB_object->fetch_array($categories))
			{
				$return_array["$categorie[cat_id]"] = $categorie;
			}
		}
		else
		{
			return false;
		}
		return $return_array;
	}


	/**
	* Returns the forum details array
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	int		mixed			Start point
	* @param	int		mixed			End point
	*
	* @return	array
	*/
	function get_phpbb2_forum_details(&$DB_object, &$database_type, &$table_prefix, &$start, &$per_page)
	{
		$return_array = array();

		// Check that there isn't a empty value
		if(empty($per_page)) { return $return_array; }

		if ($database_type == 'mysql')
		{
			if (!$forum_per_page)
			{
				$forum_per_page = 10;
			}
			$sql = "
			SELECT * FROM " .
			$table_prefix."forums
			ORDER BY forum_id
			LIMIT " .
			$start .",".
			$per_page
			;

			$forums = $DB_object->query($sql);

			while ($forum = $DB_object->fetch_array($forums))
			{
				$return_array["$forum[forum_id]"] = $forum;
				unset($forum);
			}
		}
		else
		{
			return false;
		}
		return $return_array;
	}


	/**
	* Returns the threads details array
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	int		mixed			Start point
	* @param	int		mixed			End point
	*
	* @return	array
	*/
	function get_phpbb2_threads_details(&$DB_object, &$database_type, &$table_prefix, &$start, &$per_page)
	{
		$return_array = array();

		// Check that there isn't a empty value
		if(empty($per_page)) { return $return_array; }

		if ($database_type == 'mysql')
		{
			$sql = "
			SELECT * FROM " .
			$table_prefix."topics
			ORDER BY topic_id
			LIMIT " .
			$start .",".
			$per_page
			;

			$threads = $DB_object->query($sql);

			while ($thread = $DB_object->fetch_array($threads))
			{
				$return_array[$thread['topic_id']] = $thread;
				unset($thread);
			}
		}
		else
		{
			return false;
		}
		return $return_array;
	}


	/**
	* Returns the smilie details array
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	int		mixed			Start point
	* @param	int		mixed			End point
	*
	* @return	array
	*/
	function get_phpbb2_smilie_details(&$DB_object, &$database_type, &$table_prefix)
	{
		$return_array = array();
		if ($database_type == 'mysql')
		{
			$sql = "
			SELECT * FROM " .
			$table_prefix."smilies"
			;

			$posts = $DB_object->query($sql);

			while ($post = $DB_object->fetch_array($posts))
			{
				$return_array["$post[smilies_id]"] = $post;
			}
		}
		else
		{
			return false;
		}
		return $return_array;
	}


	/**
	* Returns the post details array
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	int		mixed			Start point
	* @param	int		mixed			End point
	*
	* @return	array
	*/
	function get_phpbb2_posts_details(&$DB_object, &$database_type, &$table_prefix, &$start, &$per_page)
	{
		$return_array = array();

		// Check that there isn't a empty value
		if(empty($per_page)) { return $return_array; }

		if ($database_type == 'mysql')
		{
			$sql = "
			SELECT * FROM " .
			$table_prefix."posts
			ORDER BY post_id
			LIMIT " .
			$start .",".
			$per_page
			;

			$posts = $DB_object->query($sql);

			while ($post = $DB_object->fetch_array($posts))
			{
				$return_array["$post[post_id]"] = $post;
			}
		}
		else
		{
			return false;
		}

		return $return_array;
	}


	/**
	* Returns the post details
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	int		mixed			The phpBB post id
	*
	* @return	array
	*/
	function get_phpbb_post_text(&$DB_object, &$database_type, &$table_prefix, &$post_id)
	{
		$return_array = array();
		if ($database_type == 'mysql')
		{

			$sql = "
			SELECT post_text,post_subject FROM " .
			$table_prefix."posts_text
			WHERE
			post_id='$post_id'
			";

			$posts_text = $DB_object->query($sql);

			while ($text = $DB_object->fetch_array($posts_text))
			{

				$return_array = array(
					'post_text' => $text['post_text'],
					'post_subject' => $text['post_subject']
					);
				unset($text);
			}
		}
		else
		{
			return false;
		}

		return $return_array;
	}


	/**
	* Returns the truncated smilies
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	*
	* @return	array
	*/
	function get_phpbb_truncated_smilies(&$DB_object, &$database_type, &$table_prefix)
	{
		$return_array = array();
		if ($database_type == 'mysql')
		{
			$sql = "
			SELECT code FROM " .
			$table_prefix."smilies
			";

			$smilies = $DB_object->query($sql);

			while ($smilie = $DB_object->fetch_array($smilies))
			{
				if(strlen($smilie['code']) > 10)
				{
					 $return_array[$smilie['code']] =  substr($smilie['code'],0,9) . ':';
				}
			}
		}
		else
		{
			return false;
		}

		return $return_array;
	}


	/**
	* Returns the poll details as an array
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	int		mixed			Start point
	* @param	int		mixed			End point
	*
	* @return	array
	*/
	function get_phpbb2_polls_details(&$DB_object, &$database_type, &$table_prefix, &$start, &$per_page)
	{
		$return_array = array();

		// Check that there isn't a empty value
		if(empty($per_page)) { return $return_array; }

		if ($database_type == 'mysql')
		{
			$poll_start_at = $this->iif($poll_start_at == '','0',$poll_start_at);

			// TODO: Need an order by
			$sql = "
			SELECT * FROM " .
			$table_prefix."vote_desc
			ORDER BY vote_id
			LIMIT " .
			$start .",".
			$per_page
			;

			$polls = $DB_object->query($sql);

			while ($poll = $DB_object->fetch_array($polls))
			{
				$return_array["$poll[vote_id]"] = $poll;
			}
		}
		else
		{
			return false;
		}
		return $return_array;
	}


	/**
	* Returns the post result details
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	int		mixed			The phpBB post id
	*
	* @return	array
	*/
	function get_phpbb2_poll_results_details(&$DB_object, &$database_type, &$table_prefix, &$poll_id)
	{
		$return_array = array();
		if ($database_type == 'mysql')
		{
			$sql = "
			SELECT * FROM " .
			$table_prefix."vote_results
			WHERE vote_id ='" .	$poll_id ."'"

			;

			$polls = $DB_object->query($sql);

			while ($poll = $DB_object->fetch_array($polls))
			{
				$return_array["$poll[vote_option_id]"] = $poll;
			}
		}
		else
		{
			return false;
		}
		return $return_array;
	}


	/**
	* Returns the poll voter details
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	int		mixed			The phpBB post id
	*
	* @return	array
	*/
	function get_phpbb2_vote_voters(&$DB_object, &$database_type, &$table_prefix, &$poll_id)
	{
		$return_array = array();
		if ($database_type == 'mysql')
		{
			$sql = "
			SELECT * FROM " .
			$table_prefix."vote_voters
			WHERE vote_id ='" .	$poll_id ."'"

			;

			$polls = $DB_object->query($sql);

			while ($poll = $DB_object->fetch_array($polls))
			{
				$return_array["$poll[vote_user_id]"] = 0;
			}
		}
		else
		{
			return false;
		}
		return $return_array;
	}


	/**
	* Returns the pm details
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	int		mixed			Start point
	* @param	int		mixed			End point
	*
	* @return	array
	*/
	function get_phpbb2_pm_details(&$DB_object, &$database_type, &$table_prefix, &$start, &$per_page)
	{
		$return_array = array();

		// Check that there isn't a empty value
		if(empty($per_page)) { return $return_array; }

		if ($database_type == 'mysql')
		{
			$sql = "
			SELECT * FROM " .
			$table_prefix."privmsgs
			ORDER BY privmsgs_id
			LIMIT " .
			$start .",".
			$per_page
			;

			$pms = $DB_object->query($sql);

			while ($pm = $DB_object->fetch_array($pms))
			{
				$return_array["$pm[privmsgs_id]"] = $pm;
			}
		}
		else
		{
			return false;
		}
		return $return_array;
	}


	/**
	* Returns the pm text
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	int		mixed			pm id
	*
	* @return	array
	*/
	function get_phpbb2_pm_text(&$DB_object, &$database_type, &$table_prefix, &$pm_id)
	{
		if ($database_type == 'mysql')
		{
			$sql = "
			SELECT * FROM " .
			$table_prefix."privmsgs_text
			WHERE privmsgs_text_id ='" . $pm_id ."'"
			;

			$pms = $DB_object->query_first($sql);

			return $pms;
		}
		else
		{
			return false;
		}
		return $return_array;
	}


	/**
	* Returns the rank details
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	int		mixed			Start point
	* @param	int		mixed			End point
	*
	* @return	array
	*/
	function get_phpbb2_ranks_details(&$DB_object, &$database_type, &$table_prefix, &$start, &$per_page)
	{
		$return_array = array();

		// Check that there isn't a empty value
		if(empty($per_page)) { return $return_array; }

		if ($database_type == 'mysql')
		{
			$sql = "
			SELECT * FROM " .
			$table_prefix."ranks
			ORDER BY rank_id
			LIMIT " .
			$start .",".
			$per_page
			;

			$ranks = $DB_object->query($sql);

			while ($rank = $DB_object->fetch_array($ranks))
			{
				$return_array["$rank[rank_id]"] = $rank;
			}
		}
		else
		{
			return false;
		}
		return $return_array;
	}


	function reverse_ip($ip)
	{
		$hexy_thing = explode('.', chunk_split($ip, 2, '.'));
		return hexdec($hexy_thing[0]). '.' . hexdec($hexy_thing[1]) . '.' . hexdec($hexy_thing[2]) . '.' . hexdec($hexy_thing[3]);
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: 13:19, Thu Oct 21st 2004
|| # CVS: $RCSfile: 000.php,v $ - $Revision: 1.34 $
|| ####################################################################
\*======================================================================*/
?>
