<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* eve Import Ban List
*
*
* @package 		ImpEx.eve
* @version		$Revision: 1.15 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/04/15 00:29:34 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class eve_004 extends eve_000
{
	var $_version 		= '0.0.1';
	var $_dependent 	= '003';
	var $_modulestring 	= 'Import Ban List';

	function eve_004()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject, $this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source, 'clear_ban_list'))
				{
					$this->_restart = FALSE;
					$displayobject->display_now("<h4>Imported ban lists have been cleared</h4>");
				}
				else
				{
					$sessionobject->add_error(
						'fatal',
						$this->_modulestring,
						get_class($this) . "::restart failed , clear_ban_list",
						'Check database permissions and ban table'
					);
				}
			}

			$displayobject->update_basic('title', 'Import ban List');
			$displayobject->update_html($displayobject->do_form_header('index', "004"));
			$displayobject->update_html($displayobject->make_hidden_code('004', 'WORKING'));
			$displayobject->update_html($displayobject->make_table_header('Import Ban List(s)'));
			$displayobject->update_html($displayobject->make_yesno_code('Would you like to import the banlist?', 'importbanlist', 1));
			$displayobject->update_html($displayobject->do_form_footer('Continue', 'Reset'));
		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index', ''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue', ''));
			$sessionobject->set_session_var('004', 'FALSE');
			$sessionobject->set_session_var('module', '000');
			$sessionobject->add_session_var('enablebanning', '0');
		}
	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		if ($sessionobject->get_session_var('importbanlist'))
		{
			// Some working variables
			$displayobject->update_basic('displaymodules', 'FALSE');
			$sdt = $sessionobject->get_session_var('sourcedatabasetype');
			$stp = $sessionobject->get_session_var('sourcetableprefix');
			$tdt = $sessionobject->get_session_var('targetdatabasetype');
			$ttp = $sessionobject->get_session_var('targettableprefix');

			$class_num = substr(get_class($this) , -3);

			if(!$sessionobject->get_session_var($class_num . '_start'))
			{
				$sessionobject->timing($class_num, 'start', $sessionobject->get_session_var('autosubmit'));
			}



			// Get the lists
			$user_ids_array = $this->get_user_ids($Db_target, $tdt, $ttp);
			$userid = $this->get_list($Db_source, $sdt, $stp, 'userid',$user_ids_array);
			$iplist = $this->get_list($Db_source, $sdt, $stp, 'ip');
			$email = $this->get_list($Db_source, $sdt, $stp, 'email');


			$done = 0;
			// If there is any thing
			if(count($userid) > 0)
			{
				$this->do_list($Db_target, $displayobject, $sessionobject, $userid, 'userid');
				$displayobject->display_now("<br /><b>Importing</b> userid ban list ....");
				$done++;
			}
			else
			{
				$displayobject->display_now("<br /><b>NO</b> userid ban list ....");
			}

			if(count($iplist) > 0)
			{
				$this->do_list($Db_target, $displayobject, $sessionobject, $iplist, 'iplist');
				$displayobject->display_now("<br /><b>Importing</b> iplist ban list ....");
				$done++;
			}
			else
			{
				$displayobject->display_now("<br /><b>NO</b> iplist ban list ....");
			}

			if(count($email) > 0)
			{
				$this->do_list($Db_target, $displayobject, $sessionobject, $email, 'emaillist');
				$displayobject->display_now("<br /><b>Importing</b> email ban list ....");
				$done++;
			}
			else
			{
				$displayobject->display_now("<br /><b>NO</b> email ban list ....");
			}

			$sessionobject->add_session_var($class_num . '_objects_done', intval($sessionobject->get_session_var($class_num . '_objects_done')) + $done);

			$sessionobject->timing($class_num, 'stop', $sessionobject->get_session_var('autosubmit'));
			$sessionobject->remove_session_var($class_num . '_start');
			$displayobject->update_basic('displaymodules', 'FALSE');

			$displayobject->update_html($displayobject->module_finished(
				$this->_modulestring,
				$sessionobject->return_stats($class_num,'_time_taken'),
				$sessionobject->return_stats($class_num,'_objects_done'),
				$sessionobject->return_stats($class_num,'_objects_failed')
			));

			$displayobject->update_html($displayobject->make_hidden_code('importbanlist', 'done'));
			$sessionobject->set_session_var($class_num, 'FINISHED');
			$sessionobject->set_session_var('module', '000');
			$displayobject->update_html($displayobject->print_redirect('index.php', '2'));
		}
		else
		{
			$displayobject->update_basic('displaymodules', 'FALSE');
			$sessionobject->set_session_var($class_num, 'FINISHED');
			$sessionobject->set_session_var('importbanlist', 'done');
			$sessionobject->set_session_var('module', '000');

			$displayobject->display_now("You have skipped the Importing of the ban list");

			$displayobject->update_html($displayobject->print_redirect('index.php', '2'));
		}
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: [#]zeveuilddate[#]
|| # CVS: $RCSfile: 004.php,v $ - $Revision: 1.15 $
|| ####################################################################
\*======================================================================*/
?>
