<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* vb3 Import Polls
*
*
* @package 		ImpEx.vb3
* @version		$Revision: 1.1 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/05/20 22:09:41 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class vb3_010 extends vb3_000
{
	var $_version 		= '0.0.1';
	var $_dependent 	= '008';
	var $_modulestring 	= 'Import Polls';

	function vb3_010()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject,$this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source,'clear_imported_polls'))
				{
					$this->_restart = FALSE;
					$displayobject->display_now("<h4>Imported Polls have been cleared</h4>");
				}
				else
				{
						$displayobject->display_now("<h4>Borked</h4>");
					$sessionobject->add_error('fatal',
											 $this->_modulestring,
											 get_class($this) . "::restart failed , clear_imported_polls",
											 'Check database permissions and user table');
				}
			}
			$displayobject->update_basic('title','Import posts');
			$displayobject->update_html($displayobject->do_form_header('index',substr(get_class($this), -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this), -3),'WORKING'));
			$displayobject->update_html($displayobject->make_hidden_code('polls','working'));
			$displayobject->update_html($displayobject->make_table_header('Import Polls'));
			$displayobject->update_html($displayobject->make_description('<p>The importer will now start to import polls from your vb3 board. Depending on the size of your board, this may take some time.</p>'));
			$displayobject->update_html($displayobject->make_input_code('Number of polls to import per cycle','pollsperpage','10'));
			$displayobject->update_html($displayobject->do_form_footer('Import polls'));


			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_done', '0');
			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_failed', '0');


			$sessionobject->add_session_var('pollsstartat','0');
		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index',''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue',''));
			$sessionobject->set_session_var(substr(get_class($this), -3),'FALSE');
			$sessionobject->set_session_var('module','000');
		}
	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{

		// Set up working variables.
		$displayobject->update_basic('displaymodules','FALSE');
		$target_database_type 	= $sessionobject->get_session_var('targetdatabasetype');
		$target_table_prefix  	= $sessionobject->get_session_var('targettableprefix');

		$source_database_type 	= $sessionobject->get_session_var('sourcedatabasetype');
		$source_table_prefix  	= $sessionobject->get_session_var('sourcetableprefix');

		$polls_start_at 		= $sessionobject->get_session_var('pollsstartat');
		$polls_per_page 		= $sessionobject->get_session_var('pollsperpage');

		$class_num				= substr(get_class($this), -3);
		$displayobject->update_basic('displaymodules','FALSE');


		if(!$sessionobject->get_session_var($class_num . '_start'))
		{
			$sessionobject->timing($class_num,'start' ,$sessionobject->get_session_var('autosubmit'));
		}

		if(intval($polls_per_page) == 0)
		{
			$polls_per_page = 10;
		}

		$polls_array 		= $this->get_details($Db_source, $source_database_type, $source_table_prefix, $polls_start_at, $polls_per_page, 'poll', 'pollid');
		$thread_ids			= $this->get_threads_ids($Db_target, $target_database_type, $target_table_prefix);

		$to = $polls_start_at + $polls_per_page;
		$last_pass = $sessionobject->get_session_var('last_pass');
		$displayobject->display_now("<h4>Importing " . count($polls_array) . " polls</h4><p><b>From</b> : " . $polls_start_at . " ::  <b>To</b> : " . $to ."</p><p><b>Last pass took</b> : " . $last_pass . " seconds</p>");

		$poll_object = new ImpExData( $Db_target, $sessionobject,'poll');

		$start = time();
		foreach ($polls_array as $poll_id => $details)
		{
			$try = $poll_object;

			// Mandatory
			$try->set_value('mandatory', 'question',			$details['question']);
			$try->set_value('mandatory', 'dateline',			$details['dateline']);
			$try->set_value('mandatory', 'options',				$details['options']);
			$try->set_value('mandatory', 'votes',				$details['votes']);
			$try->set_value('mandatory', 'importpollid',		$poll_id);

			// Non Mandatory
			$try->set_value('nonmandatory', 'active',			$details['active']);
			$try->set_value('nonmandatory', 'numberoptions',	$details['numberoptions']);
			$try->set_value('nonmandatory', 'timeout',			$details['timeout']);
			$try->set_value('nonmandatory', 'multiple',			$details['multiple']);
			$try->set_value('nonmandatory', 'voters',			$details['voters']);
			$try->set_value('nonmandatory', 'public',			$details['public']);


			$result = $try->import_poll($Db_target,$target_database_type,$target_table_prefix);

			$vb_poll_id = $Db_target->insert_id();

			if($try->is_valid())
			{
				if($result)
				{
					if($try->import_poll_to_vb3_thread($Db_target, $target_database_type, $target_table_prefix, $vb_poll_id, $poll_id))
					{
						$displayobject->display_now("<br /><span class=\"isucc\"><b>" . $try->how_complete() . "%</b></span> :: Poll  -> '" . $try->get_value('mandatory','question') ."'");
						$sessionobject->add_session_var($class_num . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
					}
					else
					{
						$sessionobject->add_error('warning', $this->_modulestring,
												get_class($this) . "::import_poll_to_thread failed for " . $try->get_value('mandatory', 'question'),
												'Check database permissions');
												$displayobject->display_now("<br />Poll " . $try->get_value('mandatory','question') . " and <b>DID </b> imported to the " . $target_database_type . " database but isn't assigned to the thread");
					}
				}
				else
				{
					$sessionobject->add_error('warning', $this->_modulestring,
												get_class($this) . "::import_poll failed for " . $try->get_value('mandatory', 'question'),
												'Check database permissions');
					$displayobject->display_now("<br />Poll " . $try->get_value('mandatory','question') . " and <b>DID NOT</b> imported to the " . $target_database_type . " database");
				}
			}
			else
			{
				$displayobject->display_now("<br />Invalid object, skipping.");
			}
			unset($try);
		}

		$the_end = time() - $start;
		$sessionobject->add_session_var('last_pass', $the_end);


		if (count($polls_array) == 0 OR count($polls_array) < $polls_per_page)
		{
			$sessionobject->timing($class_num,'stop', $sessionobject->get_session_var('autosubmit'));
			$sessionobject->remove_session_var($class_num . '_start');

			$displayobject->update_html($displayobject->module_finished($this->_modulestring,
										$sessionobject->return_stats($class_num, '_time_taken'),
										$sessionobject->return_stats($class_num, '_objects_done'),
										$sessionobject->return_stats($class_num, '_objects_failed')
										));

			$sessionobject->set_session_var($class_num ,'FINISHED');
			$sessionobject->set_session_var('polls','done');
			$sessionobject->set_session_var('module','000');
			$sessionobject->set_session_var('autosubmit','0');
			$displayobject->update_html($displayobject->print_redirect('index.php','1'));
		}

		$sessionobject->set_session_var('pollsstartat',$polls_start_at+$polls_per_page);
		$displayobject->update_html($displayobject->print_redirect('index.php'));
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: [#]zeveuilddate[#]
|| # CVS: $RCSfile: 010.php,v $ - $Revision: 1.1 $
|| ####################################################################
\*======================================================================*/
?>
