<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* ipb Import Forums
*
* The ubb users are stored in files with each lines corresponding to a
* diffrent values.
*
* @package 		ImpEx.ipb
* @version		$Revision: 1.18 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/05/21 11:33:42 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class ipb_006 extends ipb_000
{
	var $_version 		= '0.0.1';
	var $_dependent 	= '004';
	var $_modulestring 	= 'Import Forums';

	function ipb_006()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject,$this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject,$displayobject,$Db_target,$Db_source,'clear_imported_forums'))
				{
					$this->_restart = FALSE;
					$displayobject->display_now("<h4>Imported Forums have been cleared</h4>");
				}
				else
				{
					$sessionobject->add_error('fatal',
											 $this->_modulestring,
											 substr(get_class($this) , -3) . "::restart failed , clear_imported_forums",
											 'Check database permissions and user table');
				}
			}

			$displayobject->update_basic('title','Import forums');
			$displayobject->update_html($displayobject->do_form_header('index',substr(get_class($this) , -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this) , -3) ,'WORKING'));
			$displayobject->update_html($displayobject->make_table_header('Import Forums'));
			$displayobject->update_html($displayobject->make_hidden_code('forums','working'));
			$displayobject->update_html($displayobject->make_input_code("Forums to import per cycle (must be greater than 1)","forumsperpage",10));

			$displayobject->update_html($displayobject->do_form_footer("Import Forums"));

			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_done', '0');
			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_failed', '0');

			$sessionobject->add_session_var('forumsstartat','0');
			$sessionobject->add_session_var('categoriesdone','0');

		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index',''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue',''));
			$sessionobject->set_session_var(substr(get_class($this) , -3) ,'FALSE');
			$sessionobject->set_session_var('module','000');
		}

	}

	function resume(&$sessionobject,&$displayobject,&$Db_target,&$Db_source)
	{
		// Set up working variables.
		$displayobject->update_basic('displaymodules','FALSE');
		$target_database_type = $sessionobject->get_session_var('targetdatabasetype');
		$target_table_prefix  = $sessionobject->get_session_var('targettableprefix');

		$source_database_type = $sessionobject->get_session_var('sourcedatabasetype');
		$source_table_prefix  = $sessionobject->get_session_var('sourcetableprefix');

		$forum_start_at = $sessionobject->get_session_var('forumsstartat');
		$forum_per_page = $sessionobject->get_session_var('forumsperpage');

		$class_num		= substr(get_class($this) , -3);

		$displayobject->update_basic('displaymodules','FALSE');

		if(!$sessionobject->get_session_var($class_num . '_start'))
		{
			$sessionobject->timing($class_num ,'start' ,$sessionobject->get_session_var('autosubmit'));
		}

		// TODO: Do we need this
		$styles_array  		=  $this->get_imported_ipb_style_ids($Db_target, $target_database_type, $target_table_prefix);

		// TODO: Wont 0 evaluate out anyway ?
		// Import the categories first
		if($sessionobject->get_session_var('categoriesdone') == '0')
		{
			// Get all the details
			$categories_array  	=  $this->get_ipb_category_details($Db_source, $source_database_type, $source_table_prefix);
			$category_object	= new ImpExData($Db_target, $sessionobject,'forum');

			if(is_array($categories_array[-1]))
			{
				$displayobject->display_now("<h4>Importing " . (count($categories_array) -1) . " categories</h4>");
			}
			else
			{
				$displayobject->display_now("<h4>Importing " . count($categories_array) . " categories</h4>");
			}

			foreach ($categories_array as $category_id => $category)
			{
				// If its not the first blank one
				if($category_id != '-1')
				{
					$try = $category_object;

					$try->set_value('mandatory', 'title', 				$category['name']);
					$try->set_value('mandatory', 'displayorder',		$category['position']);
					$try->set_value('mandatory', 'parentid',			'-1');
					$try->set_value('mandatory', 'importforumid',		'0');
					$try->set_value('mandatory', 'importcategoryid',	$category_id);

					if($category['description'] != '')
					{
						$try->set_value('nonmandatory', 'description',	$category['description']);
					}
					else
					{
						$try->set_value('nonmandatory', 'description',		"Please update the description for : " . $category['name']);
					}
					//$try->set_value('nonmandatory', 'options',	$category['']);
					//$try->set_value('nonmandatory', 'daysprune',	$category['']);

					/* TODO: from ipb
					state
					image
					url
					*/

					if($try->is_valid())
					{
						if($try->import_category($Db_target, $target_database_type, $target_table_prefix))
						{
							$displayobject->display_now("<br /><span class=\"isucc\"><b>" . $try->how_complete() . "%</b></span> :: Category - " . $try->get_value('mandatory','title'));
							$sessionobject->add_session_var($class_num  . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
						}
						else
						{
							$sessionobject->add_error('warning',
													 $this->_modulestring,
													 get_class($this) . "::import_category failed for " . $category['name'] . " get_phpbb2_categories_details was ok.",
													 'Check database permissions and user table');
							$sessionobject->set_session_var($class_num. '_objects_failed',$sessionobject->get_session_var($class_num . '_objects_failed') + 1 );
							$displayobject->display_now("<br />Got category " . $cat['cat_title'] . " and <b>DID NOT</b> imported to the " . $target_database_type . " database");
						}
					}
					else
					{
						$displayobject->display_now("<br />Invalid category object, skipping." . $try->_failedon);

					}
					unset($try);
				}
			}
			$sessionobject->set_session_var('categoriesdone','1');
		}
		else
		{
			// Weve done the categories have a go at the forums
			// Get all the details
			$forum_array  	= $this->get_ipb_forum_details($Db_source, $source_database_type, $source_table_prefix, $forum_start_at,$forum_per_page);

			$displayobject->display_now("<h4>Importing " . count($forum_array) . " forums</h4><p><b>From</b> : " . $forum_start_at . " ::  <b>To</b> : " . ($forum_start_at + count($forum_array)) ."</p>");

			$forum_object = new ImpExData($Db_target,$sessionobject,'forum');
			foreach ($forum_array as $forum_id => $forum)
			{
				$forum_ids 		= $this->get_forum_ids($Db_target, $target_database_type, $target_table_prefix);
				$cat_ids 		= $this->get_category_ids($Db_target, $target_database_type, $target_table_prefix);
				$try = $forum_object;

				$try->set_value('mandatory', 'title', 				$forum['name']);
				$try->set_value('mandatory', 'displayorder',		$forum['position']);
				$try->set_value('mandatory', 'importforumid',		$forum_id);
				$try->set_value('mandatory', 'importcategoryid',	'0');

				if(!$forum_ids["$forum[parent_id]"])
				{
					$try->set_value('mandatory', 'parentid',		'-1');
				}
				else
				{
					$try->set_value('mandatory', 'parentid',		$forum_ids["$forum[parent_id]"]);
				}

				if(!$try->get_value('mandatory', 'parentid'))
				{
					$try->set_value('mandatory', 'parentid',		$$cat_ids["$forum[parent_id]"]);
				}

				$try->set_value('nonmandatory', 'description', 		$forum['description']);

				$try->set_value('nonmandatory', 'replycount',		$forum['psots']);
				$try->set_value('nonmandatory', 'lastpost',			$forum['last_post']);
				$try->set_value('nonmandatory', 'lastposter',		$forum['last_poster_name']);
				$try->set_value('nonmandatory', 'threadcount',		$forum['topics']);


				$try->set_value('nonmandatory', 'daysprune',		$forum['prune']);

				/*
				$try->set_value('nonmandatory', 'newpostemail','');
				$try->set_value('nonmandatory', 'newthreademail','');
				$try->set_value('nonmandatory', 'parentlist','');
				$try->set_value('nonmandatory', 'password','');
				$try->set_value('nonmandatory', 'link','');
				$try->set_value('nonmandatory', 'childlist','');

				/*

				Permissions :

				   use_ibc  tinyint(1)   Yes  NULL
				   use_html  tinyint(1)   Yes  NULL
				   status  varchar(10)   Yes  NULL




				IPB

				   start_perms  varchar(255)   Yes  NULL
				   reply_perms  varchar(255)   Yes  NULL
				   read_perms  varchar(255)   Yes  NULL
				   password  varchar(32)   Yes  NULL
				   category  smallint(5)   No  0
				   last_title  varchar(128)   Yes  NULL
				   last_id  int(10)   Yes  NULL
				   sort_key  varchar(32)   Yes  NULL
				   sort_order  varchar(32)   Yes  NULL
				   prune  tinyint(3)   Yes  NULL
				   show_rules  tinyint(1)   Yes  NULL
				   upload_perms  varchar(255)   Yes  NULL
				   preview_posts  tinyint(1)   Yes  NULL
				   allow_poll  tinyint(1)   No  1
				   allow_pollbump  tinyint(1)   No  0
				   inc_postcount  tinyint(1)   No  1
				   skin_id  int(10)   Yes  NULL
				   parent_id  mediumint(5)   Yes  -1
				   subwrap  tinyint(1)   Yes  0
				   sub_can_post  tinyint(1)   Yes  1
				   quick_reply  tinyint(1)   Yes  0
				   redirect_url  varchar(250)   Yes
				   redirect_on  tinyint(1)   No  0
				   redirect_hits  int(10)   No  0
				   redirect_loc  varchar(250)   Yes
				   rules_title  varchar(255)   No
				   rules_text  text   No
				   has_mod_posts  tinyint(1)   No  0
				   topic_mm_id  varchar(250)   No
				   notify_modq_emails  text
				*/


				//$try->set_value('nonmandatory', 'lasticonid','');
				//$try->set_value('nonmandatory', 'lastthread','');
				//$try->set_value('nonmandatory', 'styleid',			$forum['']);

				if($try->is_valid())
				{
					if($try->import_forum($Db_target,$target_database_type,$target_table_prefix))
					{
						$displayobject->display_now("<br /><span class=\"isucc\"><b>" . $try->how_complete() . "%</b></span> :: FORUM - " . $try->get_value('mandatory','title'));
						$sessionobject->add_session_var($class_num  . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
					}
					else
					{
						$sessionobject->add_error('warning',
												 $this->_modulestring,
												 get_class($this) . "::import_category failed for " . $cat['cat_title'] . " get_phpbb2_categories_details was ok.",
												 'Check database permissions and user table');
						$sessionobject->set_session_var($class_num. '_objects_failed',$sessionobject->get_session_var($class_num . '_objects_failed') + 1 );
						$displayobject->display_now("<br />Got category " . $cat['cat_title'] . " and <b>DID NOT</b> imported to the " . $target_database_type . " database");
					}
				}
				else
				{
					$displayobject->display_now("<br />Invalid object, skipping.");
				}

				unset($try);
			}

			// If we are all finished
			if (count($forum_array) == 0 OR count($forum_array) < $forum_per_page)
			{
				$this->build_forum_child_lists($Db_target, $target_database_type, $target_table_prefix);

				$sessionobject->timing($class_num,'stop', $sessionobject->get_session_var('autosubmit'));
				$sessionobject->remove_session_var($class_num . '_start');

				$displayobject->update_html($displayobject->module_finished($this->_modulestring,
																			$sessionobject->return_stats($class_num ,'_time_taken'),
																			$sessionobject->return_stats($class_num ,'_objects_done'),
																			$sessionobject->return_stats($class_num ,'_objects_failed')
																			));

				$sessionobject->set_session_var($class_num, 'FINISHED');
				$sessionobject->set_session_var('forums','done');
				$sessionobject->set_session_var('module','000');
				$sessionobject->set_session_var('autosubmit','0');
			}
			// Only update this when in the forums loop
			$sessionobject->set_session_var('forumsstartat',$forum_start_at+$forum_per_page);
		}
		$displayobject->update_html($displayobject->print_redirect('index.php','1'));
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: [#]zeveuilddate[#]
|| # CVS: $RCSfile: 006.php,v $ - $Revision: 1.18 $
|| ####################################################################
\*======================================================================*/
?>
