<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* eve_002 Import Users module
*
*
* @package 		ImpEx.eve
* @version		$Revision: 1.25 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/04/22 16:10:04 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/

class eve_003 extends eve_000
{
	var $_version 		= '0.0.1';
	var $_dependent 	= '001';
	var $_modulestring 	= 'Import Users';

	function eve_003()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject, $this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source, 'clear_imported_users'))
				{
					$this->_restart = true;
					$displayobject->display_now("<h4>Imported users have been cleared</h4>");
				}
				else
				{
					$sessionobject->add_error(
						'fatal',
						$this->_modulestring,
						get_class($this) . "::restart failed , clear_non_admin_users",
						'Check database permissions and user table'
					);
				}
			}

			$displayobject->update_basic('title', 'Import users');
			$displayobject->update_html($displayobject->do_form_header('index', substr(get_class($this) , -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this) , -3), 'WORKING'));
			$displayobject->update_html($displayobject->make_hidden_code('import_users', 'working'));
			$displayobject->update_html($displayobject->make_table_header('Import Users'));
			$displayobject->update_html($displayobject->make_input_code('Users to import per cycle (must be greater than 1)', 'usersperpage', 500));
			$displayobject->update_html($displayobject->make_yesno_code('Would you like to empty your existing vBulletin members database?', 'clear_non_admin_users', 0));

			$displayobject->update_html($displayobject->do_form_footer('Continue', 'Reset'));

			// Add all the custom fields we want to import
			$tdt = $sessionobject->get_session_var('targetdatabasetype');
			$ttp = $sessionobject->get_session_var('targettableprefix');

			$this->add_custom_field($Db_target, $tdt, $ttp, 'display_name', 'the eve displayname');
			$this->add_custom_field($Db_target, $tdt, $ttp, 'first_name', 'the eve first name');
			$this->add_custom_field($Db_target, $tdt, $ttp, 'last_name', 'the eve last name');
			$this->add_custom_field($Db_target, $tdt, $ttp, 'gender', 'the eve user gender');
			$this->add_custom_field($Db_target, $tdt, $ttp, 'custom_1', 'the eve user custom field 1');
			$this->add_custom_field($Db_target, $tdt, $ttp, 'custom_2', 'the eve user custom field 2');
			$this->add_custom_field($Db_target, $tdt, $ttp, 'custom_3', 'the eve user custom field 3');
			$this->add_custom_field($Db_target, $tdt, $ttp, 'custom_4', 'the eve user custom field 4');
			$this->add_custom_field($Db_target, $tdt, $ttp, 'custom_5', 'the eve user custom field 5');


			$sessionobject->add_session_var('usersstartat', '0');
			$sessionobject->add_session_var('totalusersdone', '0');
		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index', ''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue', ''));
			$sessionobject->set_session_var(substr(get_class($this) , -3), 'FALSE');
			$sessionobject->set_session_var('module', '000');
		}
	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		// Set up working variables.
		$displayobject->update_basic('displaymodules','FALSE');
		$target_database_type 	= $sessionobject->get_session_var('targetdatabasetype');
		$target_table_prefix  	= $sessionobject->get_session_var('targettableprefix');

		$source_database_type 	= $sessionobject->get_session_var('sourcedatabasetype');
		$source_table_prefix  	= $sessionobject->get_session_var('sourcetableprefix');

		$user_start_at 			= $sessionobject->get_session_var('usersstartat');
		$user_per_page 			= $sessionobject->get_session_var('usersperpage');
		$class_num				= substr(get_class($this) , -3);

		// Start the timing
		if(!$sessionobject->get_session_var($class_num . '_start'))
		{
			$sessionobject->timing($class_num, 'start', $sessionobject->get_session_var('autosubmit'));
		}

		// Check and clear the NON admin users
		if ($sessionobject->get_session_var('clear_non_admin_users') == 1)
		{
			if ($this->clear_non_admin_users($Db_target, $target_database_type,$target_table_prefix))
			{
				$displayobject->display_now("<b>All users deleted</b>");
				$sessionobject->set_session_var('clear_non_admin_users', '0');
			}
			else
			{
				$sessionobject->add_error(
					'fatal',
					$this->_modulestring,
					get_class($this) . "::resume failed , clear_non_admin_users",
					'Check database permissions and user table'
				);
			}
		}

		// Get the banned and done (associated users)
		$bannedgroup =  $this->get_banned_group($Db_target, $target_database_type, $target_table_prefix);
		$doneusers	 =  $this->get_done_user_ids($Db_target, $target_database_type, $target_table_prefix);

		// Get a page worths of users
		$user_array  =  $this->get_eve_user_details($Db_source, $source_database_type, $source_table_prefix, $user_start_at, $user_per_page);

		$to = $user_start_at + count($user_array);
		$displayobject->display_now("<h4>Importing " . count($user_array) . " users</h4><p><b>From</b> : " . $user_start_at . " ::  <b>To</b> : " . $to ."</p>");


		$user_object = new ImpExData($Db_target,$sessionobject, 'user');
		foreach ($user_array as $user_id => $user)
		{
			// Have we already associated them, or imported them by mistake etc.
			if (!array_key_exists($user_id, $doneusers))
			{
				$try = $user_object;

				// Mandatory
				$try->set_value('mandatory', 'username',			addslashes($user['USERNAME']));
				$try->set_value('mandatory', 'email',				$user['EMAIL']);
				$try->set_value('mandatory', 'usergroupid',			$user['USERGROUPID']);
				$try->set_value('mandatory', 'importuserid',		$user['USER_OID']);

				// Non mandatory
				$try->set_value('nonmandatory', 'password',			trim($user['PASSWORD']));
				$try->set_value('nonmandatory', 'joindate',			strtotime($user['REGISTRATION_DATE']));
				//$try->set_value('nonmandatory', 'avatar',			$user['PICTURE_URL']);
				$try->set_value('nonmandatory', 'homepage',			addslashes($user['HOME_PAGE_URL']));
				$try->set_value('nonmandatory', 'icq',				addslashes($user['ICQ_NUMBER']));

				$date_bits = explode('-',$user['DOB']);
				$try->set_value('nonmandatory', 'birthday',			$date_bits[2] . "-" . $date_bits[1] . "-" . $date_bits[0]);

				$try->set_value('nonmandatory', 'birthday_search',	$user['DOB']);

				$try->set_value('nonmandatory', 'ipaddress',		$user['IP_AT_REGISTRATION']);
				$try->set_value('nonmandatory', 'lastvisit',		strtotime($user['LAST_LOGIN_DATETIME']));
				$try->set_value('nonmandatory', 'usertitle',		$user['USER_TITLE']);
				$try->set_value('nonmandatory', 'posts',			$user['CUMULATIVE_USER_POST_COUNT']);

				// TODO: What is the mapping here
				//$try->set_value('nonmandatory', 'autosubscribe',	$user['SUSPEND_SUBSCRIPTIONS']);

				$try->set_value('nonmandatory', 'passworddate',		'');
				$try->set_value('nonmandatory', 'membergroupids',	'');
				$try->set_value('nonmandatory', 'displaygroupid',	'');

				// Custom values
				$try->add_custom_value('display_name', 				addslashes($user['DISPLAY_NAME']));
				$try->add_custom_value('first_name', 				addslashes($user['FIRST_NAME']));
				$try->add_custom_value('last_name',		 			addslashes($user['LAST_NAME']));
				$try->add_custom_value('gender',		 			$user['GENDER']);
				$try->add_custom_value('custom_1', 					addslashes($user['CUSTOM_FIELD_1']));
				$try->add_custom_value('custom_2', 					addslashes($user['CUSTOM_FIELD_2']));
				$try->add_custom_value('custom_3', 					addslashes($user['CUSTOM_FIELD_3']));
				$try->add_custom_value('custom_4', 					addslashes($user['CUSTOM_FIELD_4']));
				$try->add_custom_value('custom_5', 					addslashes($user['CUSTOM_FIELD_5']));

				$try->set_value('nonmandatory', 'parentemail',		$user['PARENT_EMAIL']);

				// Default values
				$try->add_default_value('signature', 				addslashes($this->html_2_bb($user['SIGNATURE'])));

				$try->add_default_value('Location',		 			addslashes($user['LOCATION']));
				$try->add_default_value('Occupation',	 			addslashes($user['OCCUPATION']));
				$try->add_default_value('Interests', 				addslashes($user['INTERESTS']));
				if(strlen($user['BIO']) > 99)
				{
					$user['BIO'] = substr($user['BIO'], 0, 99);
				}
				$try->add_default_value('Biography', 				addslashes($user['BIO']));


				/*	Eve data

				SITE_OID	The site id that the board came from.
				IS_BANNED	Is the user banned [Y/N]
				BANNER_OID	The user that banned this user
				BAN_REASON	The reason for banning this user

				// TODO:

				COPPA
				$user['IS_AGE_RESTRICTED_USER']


				$user['IS_REGISTRATION_VALIDATED']
				$user['IS_EMAIL_VERIFIED']
				$user['IS_ADMINISTRATOR']
				$user['IS_PRIMARY_ADMIN']
				$user['HAS_OPTED_OUT_OF_EMAIL']
				$user['DISPLAY_EMAIL']
				$user['SMS_NUMBER']
				$user['VISIT_COUNT']
				$user['PAGE_VIEW_COUNT']
				$user['PRIVATE_CUSTOM_FIELD_1']
				$user['PRIVATE_CUSTOM_FIELD_2']
				$user['PRIVATE_CUSTOM_FIELD_3']
				$user['PRIVATE_CUSTOM_FIELD_4']
				$user['PRIVATE_CUSTOM_FIELD_5']
				$user['PARENT_USERNAME_LOWERCASE']
				$user['PARENT_PASSWORD']
				$user['IS_SUBSCRIPTIONS_PUBLIC']
				$user['CUMULATIVE_EMAILS_GENERATED']
				$user['NON_OT_USER_ID']
				$user['IS_AUTO_CREATE_GT_SUB']

				// Don't know

				RANDOM_CONFIRMATION_ID
				*/

				if($try->is_valid())
				{
					if($try->import_user($Db_target, $target_database_type, $target_table_prefix))
					{
						$displayobject->display_now("<br /><span class=\"isucc\"><b>" . $try->how_complete() . "%</b></span> :: " . $try->get_value('mandatory','username'));
						$sessionobject->add_session_var($class_num . '_objects_done', intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1);
					}
					else
					{
						$sessionobject->set_session_var($class_num . '_objects_failed',$sessionobject->get_session_var($class_num . '_objects_failed') + 1 );
						$sessionobject->add_error(
							'warning',
							$this->_modulestring,
							get_class($this) . "::import_user failed for " . $user['USERNAME'],
							'Check database permissions and user table'
						);
						$displayobject->display_now("<br />Got user " . $try->get_value('mandatory', 'username') . " and <b>DID NOT</b> imported to the " . $target_database_type . " database failed on : " . $this->_failedon);
					}
				}
				else
				{
					$displayobject->display_now("<br />Invalid object, skipping.");
				}
			}
			else
			{
				// User already been imported or assosaited
				// Mark it as failed, though really its already been done, though we have to show that is wasn't a sucssfull
				// import in this sense of the word.
				$sessionobject->set_session_var($class_num . '_objects_failed',$sessionobject->get_session_var($class_num. '_objects_failed') + 1 );
				$displayobject->display_now("<br />Already imported or associated -> <span class=\"isucc\">" . $user['name'] . "</span> ");
			}

		}

		if (count($user_array) == 0 OR count($user_array) < $user_per_page)
		{
			// build_user_statistics();
			$this->build_user_statistics($Db_target, $target_database_type, $target_table_prefix);

			$sessionobject->timing($class_num ,'stop', $sessionobject->get_session_var('autosubmit'));
			$sessionobject->remove_session_var($class_num . '_start');

			$displayobject->update_html($displayobject->module_finished(
				$this->_modulestring,
				$sessionobject->return_stats($class_num, '_time_taken'),
				$sessionobject->return_stats($class_num, '_objects_done'),
				$sessionobject->return_stats($class_num, '_objects_failed')
			));

			$sessionobject->set_session_var($class_num ,'FINISHED');
			$sessionobject->set_session_var('import_users', 'done');
			$sessionobject->set_session_var('module', '000');
			$sessionobject->set_session_var('autosubmit', '0');
			$displayobject->update_html($displayobject->print_redirect('index.php', '1'));
		}
		else
		{
			$sessionobject->add_session_var('totalusersdone', ($sessionobject->get_session_var('totalusersdone') + $doneperpass));
			$displayobject->update_html($displayobject->print_redirect('index.php'));
			$sessionobject->set_session_var('usersstartat', (intval($user_start_at) + intval($sessionobject->get_session_var('usersperpage'))));
		}
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: [#]zeveuilddate[#]
|| # CVS: $RCSfile: 003.php,v $ - $Revision: 1.25 $
|| ####################################################################
\*======================================================================*/
?>
