<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* vb3_003 Import Users groups and ranks
*
*
* @package 		ImpEx.vb3
* @version		$Revision: 1.1 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/05/20 22:09:41 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class vb3_003 extends vb3_000
{
	var $_version 		= '0.0.1';
	var $_dependent 	= '001';
	var $_modulestring 	= 'Import User Groups and Ranks';

	function vb3_003()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject,$this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source,'clear_imported_user_groups'))
				{
					$this->clear_imported_ranks($Db_target, $sessionobject->get_session_var('targetdatabasetype'), $sessionobject->get_session_var('targettableprefix'));
					$this->_restart = true;
					$displayobject->display_now("<h4>Imported user groups and ranks have been cleared</h4>");
				}
				else
				{
					$sessionobject->add_error('fatal',
											 $this->_modulestring,
											 get_class($this) . "::restart failed , clear_non_admin_users",
											 'Check database permissions and user table');
				}
			}

			$displayobject->update_basic('title','Import user groups');
			$displayobject->update_html($displayobject->do_form_header('index',substr(get_class($this) , -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this) , -3),'WORKING'));
			$displayobject->update_html($displayobject->make_hidden_code('import_user_groups','working'));
			$displayobject->update_html($displayobject->make_table_header('Import Users Groups'));
			$displayobject->update_html($displayobject->make_description('The importer will now import all the user groups and ranks'));


			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_done', '0');
			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_failed', '0');


			$displayobject->update_html($displayobject->do_form_footer('Continue',''));

		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index',''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue',''));
			$sessionobject->set_session_var(substr(get_class($this) , -3),'FALSE');
			$sessionobject->set_session_var('module','000');
		}
	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		// Set up working variables.
		$displayobject->update_basic('displaymodules','FALSE');
		$target_database_type 	= $sessionobject->get_session_var('targetdatabasetype');
		$target_table_prefix  	= $sessionobject->get_session_var('targettableprefix');

		$source_database_type 	= $sessionobject->get_session_var('sourcedatabasetype');
		$source_table_prefix  	= $sessionobject->get_session_var('sourcetableprefix');

		$class_num		= substr(get_class($this) , -3);

		// Start the timing
		if(!$sessionobject->get_session_var($class_num . '_start'))
		{
			$sessionobject->timing($class_num ,'start' ,$sessionobject->get_session_var('autosubmit'));
		}

		// *************
		// Usergroups
		// *************

		// Get all the user groups
		$user_groups_array = $this->get_details($Db_source, $source_database_type, $source_table_prefix, 0, -1, 'usergroup', 'usergroupid');


		$user_group_object = new ImpExData($Db_target, $sessionobject,'usergroup');

		$displayobject->display_now("<h4>Importing " . count($user_groups_array) . " users groups</h4>");

		// Do the user group array
		foreach ($user_groups_array as $user_group_id => $user_group)
		{
			$try = $user_group_object;

			// Mandatory
			$try->set_value('mandatory', 'importusergroupid',		$user_group_id);

			// Non mandatory
			$try->set_value('nonmandatory', 'title',				$user_group['title']);
			$try->set_value('nonmandatory', 'description',			$user_group['description']);
			$try->set_value('nonmandatory', 'usertitle',			$user_group['usertitle']);
			$try->set_value('nonmandatory', 'passwordexpires',		$user_group['passwordexpires']);
			$try->set_value('nonmandatory', 'passwordhistory',		$user_group['passwordhistory']);
			$try->set_value('nonmandatory', 'pmquota',				$user_group['pmquota']);
			$try->set_value('nonmandatory', 'pmsendmax',			$user_group['pmsendmax']);
			$try->set_value('nonmandatory', 'pmforwardmax',			$user_group['pmforwardmax']);
			$try->set_value('nonmandatory', 'opentag',				$user_group['opentag']);
			$try->set_value('nonmandatory', 'closetag',				$user_group['closetag']);
			$try->set_value('nonmandatory', 'canoverride',			$user_group['canoverride']);
			$try->set_value('nonmandatory', 'ispublicgroup',		$user_group['ispublicgroup']);
			$try->set_value('nonmandatory', 'forumpermissions',		$user_group['forumpermissions']);
			$try->set_value('nonmandatory', 'pmpermissions',		$user_group['pmpermissions']);
			$try->set_value('nonmandatory', 'calendarpermissions',	$user_group['calendarpermissions']);
			$try->set_value('nonmandatory', 'wolpermissions',		$user_group['wolpermissions']);
			$try->set_value('nonmandatory', 'adminpermissions',		$user_group['adminpermissions']);
			$try->set_value('nonmandatory', 'genericpermissions',	$user_group['genericpermissions']);
			$try->set_value('nonmandatory', 'genericoptions',		$user_group['genericoptions']);
			$try->set_value('nonmandatory', 'pmpermissions_bak',	$user_group['pmpermissions_bak']);
			$try->set_value('nonmandatory', 'attachlimit',			$user_group['attachlimit']);
			$try->set_value('nonmandatory', 'avatarmaxwidth',		$user_group['avatarmaxwidth']);
			$try->set_value('nonmandatory', 'avatarmaxheight',		$user_group['avatarmaxheight']);
			$try->set_value('nonmandatory', 'avatarmaxsize',		$user_group['avatarmaxsize']);
			$try->set_value('nonmandatory', 'profilepicmaxwidth',	$user_group['profilepicmaxwidth']);
			$try->set_value('nonmandatory', 'profilepicmaxheight',	$user_group['profilepicmaxheight']);
			$try->set_value('nonmandatory', 'profilepicmaxsize',	$user_group['profilepicmaxsize']);


			if($try->is_valid())
			{
				if($try->import_user_group($Db_target,$target_database_type,$target_table_prefix))
				{
					$displayobject->display_now("<br /><span class=\"isucc\"><b>" . $try->how_complete() . "%</b></span> :: Usergroup ->" . $try->get_value('nonmandatory','title'));
					$sessionobject->add_session_var($class_num . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
				}
				else
				{
					$sessionobject->add_error('warning', $this->_modulestring,
								 get_class($this) . "::import_user_group failed for " . $user_group['g_title'],
								 'Check database permissions and user table');
					$displayobject->display_now("<br />Got user " . $try->get_value('mandatory','username') . " and <b>DID NOT</b> imported to the " . $target_database_type . " database");
				}
			}
			else
			{
				$displayobject->display_now("<br />Invalid object, skipping.");
			}
		}// foreach

		// *************
		// Ranks
		// *************

		$rank_object = new ImpExData($Db_target, $sessionobject,'ranks');


		// Get all the user group details from the target dB so we can match them to the
		$user_groups_array = $this->get_details($Db_target, $targete_database_type, $target_table_prefix, 0, -1, 'usergroup', 'importusergroupid');

		// Get the ranks from the source database to import
		$ranks_array = $this->get_details($Db_source, $source_database_type, $source_table_prefix, 0, -1, 'ranks', 'rankid');

		$displayobject->display_now("<h4>Importing " . count($ranks_array) . " ranks </h4>");

		// Do the ranks array
		foreach ($ranks_array as $rank_id => $rank)
		{
			$try = $rank_object;


			// Mandatory
			$try->set_value('mandatory', 'importrankid',	$rank_id);

			// Non mandatory
			$try->set_value('nonmandatory', 'minposts',		$rank['minposts']);
			$try->set_value('nonmandatory', 'ranklevel',	$rank['ranklevel']);
			$try->set_value('nonmandatory', 'rankimg',		$rank['rankimg']);
			$try->set_value('nonmandatory', 'usergroupid',	$user_groups_array["$rank[usergroupid]"]);
			$try->set_value('nonmandatory', 'type',			$rank['type']);


			if($try->is_valid())
			{
				if($try->import_rank($Db_target,$target_database_type,$target_table_prefix))
				{
					$displayobject->display_now("<br /><span class=\"isucc\"><b>" . $try->how_complete() . "%</b></span> :: Rank ->" . $rank['rankimg']);
					$sessionobject->add_session_var($class_num . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
				}
				else
				{
					$sessionobject->add_error('warning', $this->_modulestring,
								 get_class($this) . "::import_user_group failed for " . $user_group['g_title'],
								 'Check database permissions and user table');
					$displayobject->display_now("<br />Got user " . $try->get_value('mandatory','username') . " and <b>DID NOT</b> imported to the " . $target_database_type . " database");
				}
			}
			else
			{
				$displayobject->display_now("<br />Invalid object, skipping.");
			}
		}// foreach


		// All on one page, no page count
		$sessionobject->timing($class_num ,'stop', $sessionobject->get_session_var('autosubmit'));
		$sessionobject->remove_session_var($class_num . '_start');

		$displayobject->update_html($displayobject->module_finished($this->_modulestring,
																	$sessionobject->return_stats($class_num ,'_time_taken'),
																	$sessionobject->return_stats($class_num ,'_objects_done'),
																	$sessionobject->return_stats($class_num ,'_objects_failed')
																	));

		$sessionobject->set_session_var($class_num ,'FINISHED');
		$sessionobject->set_session_var('import_users','done');
		$sessionobject->set_session_var('module','000');
		$sessionobject->set_session_var('autosubmit','0');
		$displayobject->update_html($displayobject->print_redirect('index.php','3'));
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: [#]zeveuilddate[#]
|| # CVS: $RCSfile: 003.php,v $ - $Revision: 1.1 $
|| ####################################################################
\*======================================================================*/
?>
