<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* vb3_007 Import Avatars
*
* @package 		ImpEx.vb3
* @version		$Revision: 1.2 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/07/05 16:16:54 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/

class vb3_007 extends vb3_000
{
	var $_version 		= '0.0.1';
	var $_dependent 	= '004';
	var $_modulestring 	= 'Import Forums';

	function vb3_007()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject,$this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source,'clear_imported_forums'))
				{
					$displayobject->display_now("<h4>Imported forums have been cleared</h4>");
					$this->_restart = true;
				}
				else
				{
					$sessionobject->add_error('fatal',
											 $this->_modulestring,
											 get_class($this) . "::restart failed , clear_imported_forums",
											 'Check database permissions also the forum table');
				}
			}

			$displayobject->update_basic('title','Import avatars');
			$displayobject->update_html($displayobject->do_form_header('index',substr(get_class($this) , -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this) , -3),'WORKING'));
			$displayobject->update_html($displayobject->make_hidden_code('import_forums','working'));
			$displayobject->update_html($displayobject->make_table_header('Import Forums'));
			$displayobject->update_html($displayobject->make_input_code("Forums to import per cycle (must be greater than 1)","forumsperpage",50));

			$displayobject->update_html($displayobject->do_form_footer('Continue','Reset'));


			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_done', '0');
			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_failed', '0');


			$sessionobject->add_session_var('forumsstartat','0');
		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index',''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue',''));
			$sessionobject->set_session_var(substr(get_class($this) , -3),'FALSE');
			$sessionobject->set_session_var('module','000');
		}
	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		// Set up working variables.
		$displayobject->update_basic('displaymodules','FALSE');
		$target_database_type	= $sessionobject->get_session_var('targetdatabasetype');
		$target_table_prefix	= $sessionobject->get_session_var('targettableprefix');

		$source_database_type	= $sessionobject->get_session_var('sourcedatabasetype');
		$source_table_prefix	= $sessionobject->get_session_var('sourcetableprefix');

		$forums_start_at	= $sessionobject->get_session_var('forumsstartat');
		$forums_per_page	= $sessionobject->get_session_var('forumsperpage');

		$class_num				= substr(get_class($this) , -3);

		// Start the timing
		if(!$sessionobject->get_session_var($class_num . '_start'))
		{
			$sessionobject->timing($class_num ,'start' ,$sessionobject->get_session_var('autosubmit'));
		}


		$forums_array = $this->get_details($Db_source, $source_database_type, $source_table_prefix, $forums_start_at, $forums_per_page, 'forum', 'forumid');
		$users_ids = $this->get_user_ids($Db_target, $target_database_type, $target_table_prefix);

		$forum_object = new ImpExData($Db_target, $sessionobject, 'forum');

		$displayobject->display_now("<h4>Importing " . count($forums_array) . " forums</h4><p><b>From</b> : " . $forums_start_at . " ::  <b>To</b> : " . ($forums_start_at + count($forums_array)) . "</p>");

		foreach ($forums_array as $forum_id => $details)
		{
			$try = $forum_object;
			// Nasty, but we need the parent ids
			$forum_ids = $this->get_forum_ids($Db_target, $target_database_type, $target_table_prefix);

			// Mandatory
			$try->set_value('mandatory', 'title',				$details['title']);
			$try->set_value('mandatory', 'displayorder',		$details['displayorder']);

			if(!$forum_ids["$details[parentid]"])
			{
				$try->set_value('mandatory', 'parentid',		'-1');
			}
			else
			{
				$try->set_value('mandatory', 'parentid',			$forum_ids["$details[parentid]"]);
			}

			$try->set_value('mandatory', 'importforumid',		$forum_id);
			$try->set_value('mandatory', 'importcategoryid',	'0');

			// Non Mandatory
			$try->set_value('nonmandatory', 'styleid',			$details['styleid']);
			$try->set_value('nonmandatory', 'description',		addslashes($details['description']));
			$try->set_value('nonmandatory', 'options',			$details['options']);
			$try->set_value('nonmandatory', 'replycount',		$details['replycount']);
			$try->set_value('nonmandatory', 'lastpost',			$details['lastpost']);
			$try->set_value('nonmandatory', 'lastposter',		addslashes($details['lastposter']));
			$try->set_value('nonmandatory', 'lastthread',		addslashes($details['lastthread']));
			$try->set_value('nonmandatory', 'lasticonid',		$details['lasticonid']);
			$try->set_value('nonmandatory', 'threadcount',		$details['threadcount']);
			$try->set_value('nonmandatory', 'daysprune',		$details['daysprune']);
			$try->set_value('nonmandatory', 'newpostemail',		$details['newpostemail']);
			$try->set_value('nonmandatory', 'newthreademail',	$details['newthreademail']);

			$old_list = explode(",",$details['parentlist']);
			foreach ($old_list as $key => $value)
			{
				$old_list[$key] = $forum_ids["$old_list[$key]"];
			}
			$new_list = implode(",",$old_list);

			$try->set_value('nonmandatory', 'parentlist',		$new_list);
			$try->set_value('nonmandatory', 'password',			$details['password']);
			$try->set_value('nonmandatory', 'link',				$details['link']);

			// Can't get the id's for things that haven't been imported yet, will need to clean up afterwards
			#$try->set_value('nonmandatory', 'childlist',		$details['childlist']);
			#$try->set_value('nonmandatory', 'lastthreadid',		$details['lastthreadid']);


			if($try->is_valid())
			{
				if($try->import_forum($Db_target, $target_database_type, $target_table_prefix))
				{
					$displayobject->display_now("<br /><span class=\"isucc\"><b>" . $try->how_complete() . "%</b></span> :: " . $try->get_value('mandatory','title'));
					$sessionobject->add_session_var($class_num . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
					$imported = true;
				}
				else
				{
					$sessionobject->set_session_var($class_num . '_objects_failed',$sessionobject->get_session_var($class_num. '_objects_failed') + 1 );
					$sessionobject->add_error('warning', $this->_modulestring, get_class($this) . "::import_custom_profile_pic failed.", 'Check database permissions and user table');
					$displayobject->display_now("<br />Found avatar " . $try->get_value('nonmandatory','title') . " and <b>DID NOT</b> imported to the " . $target_database_type . " database");
				}
			}
			else
			{
				$displayobject->display_now("<br />Invalid forum object, skipping." . $try->_failedon);
			}
			unset($try);
		}


		if (count($forums_array) == 0 OR count($forums_array) < $forums_per_page)
		{
			$sessionobject->timing($class_num ,'stop', $sessionobject->get_session_var('autosubmit'));
			$sessionobject->remove_session_var($class_num . '_start');

			$displayobject->update_html($displayobject->module_finished($this->_modulestring,
																		$sessionobject->return_stats($class_num ,'_time_taken'),
																		$sessionobject->return_stats($class_num ,'_objects_done'),
																		$sessionobject->return_stats($class_num ,'_objects_failed')
																		));
			$sessionobject->set_session_var($class_num ,'FINISHED');
			$sessionobject->set_session_var('import_forums','done');
			$sessionobject->set_session_var('module','000');
			$sessionobject->set_session_var('autosubmit','0');
			$displayobject->update_html($displayobject->print_redirect('index.php','1'));
		}
		else
		{
			$displayobject->update_html($displayobject->print_redirect('index.php'));
			$sessionobject->set_session_var('forumsstartat',(intval($forums_start_at)+intval($sessionobject->get_session_var('forumsperpage'))));
		}
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: 13:19, Thu Oct 21st 2004
|| # CVS: $RCSfile: 007.php,v $ - $Revision: 1.2 $
|| ####################################################################
\*======================================================================*/
?>
