<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* eve Import Polls
*
*
* @package 		ImpEx.eve
* @version		$Revision: 1.16 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/06/15 15:57:00 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class eve_009 extends eve_000
{
	var $_version 		= '0.0.1';
	var $_dependent 	= '007';
	var $_modulestring 	= 'Import Polls';

	function eve_009()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject, $this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source, 'clear_imported_polls'))
				{
					$this->_restart = FALSE;
					$displayobject->display_now("<h4>Imported Polls have been cleared</h4>");
				}
				else
				{
					$displayobject->display_now("<h4>Borked</h4>");
					$sessionobject->add_error(
						'fatal',
						$this->_modulestring,
						get_class($this) . "::restart failed , clear_imported_polls",
						'Check database permissions and user table'
					);
				}
			}
			$displayobject->update_basic('title', 'Import posts');
			$displayobject->update_html($displayobject->do_form_header('index', substr(get_class($this), -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this), -3), 'WORKING'));
			$displayobject->update_html($displayobject->make_hidden_code('polls', 'working'));
			$displayobject->update_html($displayobject->make_table_header('Import Polls'));
			$displayobject->update_html($displayobject->make_description('<p>The importer will now start to import polls from your EVE board. Depending on the size of your board, this may take some time.</p>'));
			$displayobject->update_html($displayobject->make_input_code('Number of posts to import per cycle', 'pollsperpage', '10'));
			$displayobject->update_html($displayobject->do_form_footer('Import polls'));

			$sessionobject->add_session_var('pollsstartat', '0');
		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index', ''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue', ''));
			$sessionobject->set_session_var(substr(get_class($this), -3), 'FALSE');
			$sessionobject->set_session_var('module', '000');
		}
	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		if ($sessionobject->get_session_var('polls') == 'working')
		{
			// Set up working variables.
			$target_database_type 	= $sessionobject->get_session_var('targetdatabasetype');
			$target_table_prefix  	= $sessionobject->get_session_var('targettableprefix');

			$source_database_type 	= $sessionobject->get_session_var('sourcedatabasetype');
			$source_table_prefix  	= $sessionobject->get_session_var('sourcetableprefix');

			$polls_start_at 		= $sessionobject->get_session_var('pollsstartat');
			$polls_per_page 		= $sessionobject->get_session_var('pollsperpage');

			$class_num				= substr(get_class($this), -3);
			$displayobject->update_basic('displaymodules', 'FALSE');


			if(!$sessionobject->get_session_var($class_num . '_start'))
			{
				$sessionobject->timing($class_num, 'start', $sessionobject->get_session_var('autosubmit'));
			}

			if(intval($polls_per_page) == 0)
			{
				$polls_per_page = 10;
			}

			$polls_array 		= $this->get_eve_polls_details($Db_source, $source_database_type, $source_table_prefix, $polls_start_at, $polls_per_page);
			$thread_ids			= $this->get_threads_ids($Db_target, $target_database_type, $target_table_prefix);

			$to = $polls_start_at + $polls_per_page;
			$last_pass = $sessionobject->get_session_var('last_pass');
			$displayobject->display_now("<h4>Importing " . count($polls_array) . " polls</h4><p><b>From</b> : " . $polls_start_at . " ::  <b>To</b> : " . $to ."</p><p><b>Last pass took</b> : " . $last_pass . " seconds</p>");

			$start = time();
			foreach ($polls_array as $poll_id => $poll)
			{
				$options 		= '';
				$votes 			= '';
				$numberoptions 	= 0;
				$voters 		= 0;

				if($poll['ANSWER_1'])
				{
					$options 	.=  $poll['ANSWER_1'] 			. '|||';
					$votes 		.=  $poll['MEMBER_VOTE_COUNT_1'] . '|||';
					$numberoptions++;
					$voters 	+= $poll['MEMBER_VOTE_COUNT_1'];
				}
				if($poll['ANSWER_2'])
				{
					$options 	.=  $poll['ANSWER_2'] 			. '|||';
					$votes 		.=  $poll['MEMBER_VOTE_COUNT_2'] . '|||';
					$numberoptions++;
					$voters 	+= $poll['MEMBER_VOTE_COUNT_2'];
				}
				if($poll['ANSWER_3'])
				{
					$options 	.=  $poll['ANSWER_3'] 			. '|||';
					$votes 		.=  $poll['MEMBER_VOTE_COUNT_3'] . '|||';
					$numberoptions++;
					$voters 	+= $poll['MEMBER_VOTE_COUNT_3'];
				}
				if($poll['ANSWER_4'])
				{
					$options 	.=  $poll['ANSWER_4'] 			. '|||';
					$votes 		.=  $poll['MEMBER_VOTE_COUNT_4'] . '|||';
					$numberoptions++;
					$voters 	+= $poll['MEMBER_VOTE_COUNT_4'];
				}
				if($poll['ANSWER_5'])
				{
					$options 	.=  $poll['ANSWER_5'] 			. '|||';
					$votes 		.=  $poll['MEMBER_VOTE_COUNT_5'] . '|||';
					$numberoptions++;
					$voters 	+= $poll['MEMBER_VOTE_COUNT_5'];
				}

				$options = substr($options, 0, -3);
				$votes = substr($votes, 0, -3);


				$try = new ImpExData($Db_target, $sessionobject, 'poll');

				$try->set_value('mandatory', 'importpollid',		$poll_id);
				$try->set_value('mandatory', 'question',			$this->html_2_bb($this->get_eve_poll_question_text($Db_source, $source_database_type, $source_table_prefix, $poll['MESSAGE_OID'])));
				$try->set_value('mandatory', 'dateline',			time()); // Oh well ..........
				$try->set_value('mandatory', 'options',				$options);
				$try->set_value('mandatory', 'votes',				$votes);

				$try->set_value('nonmandatory', 'active',			'1');
				$try->set_value('nonmandatory', 'numberoptions',	$numberoptions);
				$try->set_value('nonmandatory', 'timeout',			'0');
				$try->set_value('nonmandatory', 'multiple',			'0');
				$try->set_value('nonmandatory', 'voters',			$voters);
				$try->set_value('nonmandatory', 'public',			'1');


				$result = $try->import_poll($Db_target, $target_database_type, $target_table_prefix);

				$vb_poll_id = $Db_target->insert_id();

				if($result)
				{
					if($try->import_poll_to_thread($Db_target, $target_database_type, $target_table_prefix, $vb_poll_id, $poll['MESSAGE_OID']))
					{
						$displayobject->display_now("<br /><span class=\"isucc\"><b>" . $try->how_complete() . "%</b></span> :: Poll  -> " . $try->get_value('mandatory', 'question'));
						$sessionobject->add_session_var($class_num . '_objects_done', intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1);
					}
					else
					{
						$sessionobject->add_error(
							'warning',
							$this->_modulestring,
							get_class($this) . "::import_poll_to_thread failed for " . $try->get_value('mandatory', 'question'),
							'Check database permissions'
						);
						$displayobject->display_now("<br />Poll " . $try->get_value('mandatory','question') . " and <b>DID </b> imported to the " . $target_database_type . " database but isn't assigned to the thread");
					}
				}
				else
				{
					$sessionobject->add_error(
						'warning',
						$this->_modulestring,
						get_class($this) . "::import_poll failed for " . $try->get_value('mandatory', 'question'),
						'Check database permissions'
					);
					$displayobject->display_now("<br />Poll " . $try->get_value('mandatory','question') . " and <b>DID NOT</b> imported to the " . $target_database_type . " database");
				}
			}

			$the_end = time() - $start;
			$sessionobject->add_session_var('last_pass', $the_end);

			if (count($polls_array) == 0 OR count($polls_array) < $polls_per_page)
			{
				$sessionobject->timing($class_num, 'stop', $sessionobject->get_session_var('autosubmit'));
				$sessionobject->remove_session_var($class_num . '_start');

				$displayobject->update_html($displayobject->module_finished(
					$this->_modulestring,
					$sessionobject->return_stats($class_num, '_time_taken'),
					$sessionobject->return_stats($class_num, '_objects_done'),
					$sessionobject->return_stats($class_num, '_objects_failed')
				));

				$sessionobject->set_session_var($class_num, 'FINISHED');
				$sessionobject->set_session_var('polls', 'done');
				$sessionobject->set_session_var('module', '000');
				$sessionobject->set_session_var('autosubmit', '0');
				$displayobject->update_html($displayobject->print_redirect('index.php', '1'));
			}
			else
			{
			$sessionobject->set_session_var('pollsstartat', $polls_start_at + $polls_per_page);
			$displayobject->update_html($displayobject->print_redirect('index.php'));
			}
		}
		else
		{
			die();
			$displayobject->display_now('Going to the main page...');
			$displayobject->update_html($displayobject->print_redirect('index.php'));
		}
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: [#]zeveuilddate[#]
|| # CVS: $RCSfile: 009.php,v $ - $Revision: 1.16 $
|| ####################################################################
\*======================================================================*/
?>
