<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* phpBB2 Import Ranks
*
* @package 		ImpEx.phpBB2
* @version		$Revision: 1.14 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/04/27 16:59:47 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class phpBB2_012 extends phpBB2_000
{
	var $_version 		= '0.0.1';
	var $_dependent 	= '001';
	var $_modulestring 	= 'Import Ranks';

	function phpBB2_012()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject, $this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source, 'clear_imported_ranks'))
				{
					$this->_restart = FALSE;
					$displayobject->display_now("<h4>Imported ranks have been cleared</h4>");
					// TODO: -
					// clear_imported_usergroups
				}
				else
				{
					$sessionobject->add_error('fatal',
											 $this->_modulestring,
											 get_class($this) . "::restart failed , clear_imported_ranks",
											 'Check database permissions and ranks table');
				}
			}
			$displayobject->update_basic('title','Import ranks');
			$displayobject->update_html($displayobject->do_form_header('index',substr(get_class($this), -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this), -3),'WORKING'));
			$displayobject->update_html($displayobject->make_hidden_code('ranks','working'));
			$displayobject->update_html($displayobject->make_table_header('Import Ranks'));
			$displayobject->update_html($displayobject->make_description('<p>The importer will now start to import the ranks from your phpBB board.</p>'));
			$displayobject->update_html($displayobject->make_description('<p>You will need to link the ranks to usergroups after the import.</p>'));
			$displayobject->update_html($displayobject->make_input_code('Number of ranks to import per cycle','ranksperpage','10'));
			$displayobject->update_html($displayobject->do_form_footer('Import Ranks',''));


			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_done', '0');
			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_failed', '0');


			$sessionobject->add_session_var('ranksstartat','0');
		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index',''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue',''));
			$sessionobject->set_session_var(substr(get_class($this), -3),'FALSE');
			$sessionobject->set_session_var('module','000');
		}
	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		if ($sessionobject->get_session_var('ranks') == 'working')
		{
			// Set up working variables.
			$displayobject->update_basic('displaymodules','FALSE');
			$target_database_type 	= $sessionobject->get_session_var('targetdatabasetype');
			$target_table_prefix  	= $sessionobject->get_session_var('targettableprefix');

			$source_database_type 	= $sessionobject->get_session_var('sourcedatabasetype');
			$source_table_prefix  	= $sessionobject->get_session_var('sourcetableprefix');

			$ranks_start_at			= $sessionobject->get_session_var('ranksstartat');
			$ranks_per_page			= $sessionobject->get_session_var('ranksperpage');

			$class_num				= 	substr(get_class($this) , -3);

			if(!$sessionobject->get_session_var($class_num . '_start'))
			{
				$sessionobject->timing($class_num, 'start', $sessionobject->get_session_var('autosubmit'));
			}

			if(intval($ranks_per_page) == 0)
			{
				$ranks_per_page = 200;
			}

			$ranks_array 		= $this->get_phpbb2_ranks_details($Db_source, $source_database_type, $source_table_prefix, $ranks_start_at, $ranks_per_page);


			$last_pass = $sessionobject->get_session_var('last_pass');
			$displayobject->display_now("<h4>Importing " . count($ranks_array) . " Ranks</h4><p><b>From</b> : " . $ranks_start_at . " ::  <b>To</b> : " . ($ranks_start_at + count($ranks_array)) ."</p><p><b>Last pass took</b> : " . $last_pass . " seconds</p>");

			$start = time();

			$rank_object 		= new ImpExData($Db_target, $sessionobject, 'ranks');
			$usergroup_object	= new ImpExData($Db_target, $sessionobject, 'usergroup');

			foreach ($ranks_array as $rank_id => $rank)
			{
				$new_rank 		= $rank_object;
				$new_usergroup	= $usergroup_object;

				$new_usergroup->set_value('mandatory', 'importusergroupid',	$rank['rank_id']);
				$new_usergroup->set_value('nonmandatory', 'title',			$rank['rank_title']);
				$new_usergroup->set_value('nonmandatory', 'description',	$rank['rank_title']);

				$new_rank->set_value('mandatory', 'importrankid',			$rank_id);

				$new_rank->set_value('nonmandatory', 'minposts',			$rank['rank_min']);
				$new_rank->set_value('nonmandatory', 'rankimg',				$rank['rank_image']);

				//$new_rank->set_value('nonmandatory', 'ranklevel',			'');
				//$new_rank->set_value('nonmandatory', 'usergroupid',			'');
				//$new_rank->set_value('nonmandatory', 'type',				'');

				if($new_usergroup->is_valid())
				{
					$user_group_id = $new_usergroup->import_usergroup($Db_target, $target_database_type, $target_table_prefix);
					if($user_group_id)
					{
						$new_rank->set_value('nonmandatory', 'usergroupid',	$user_group_id);
						if($new_rank->is_valid())
						{
							if($new_rank->import_rank($Db_target, $target_database_type, $target_table_prefix))
							{
								$displayobject->display_now('<br /><b><font color="green">' . $new_rank->how_complete() . '% </font></b>Imported rank : </b>' . $rank['rank_title']);
								$sessionobject->set_session_var($class_num . '_objects_done',$sessionobject->get_session_var($class_num . '_objects_done') + 1 );
							}
							else
							{
								$displayobject->display_now('<br />Imported usergroup, Error with importing rank');
								$sessionobject->add_error('warning', $this->_modulestring,
											get_class($this) . "::import_rank failed for " . $rank['rank_title'],
											'Check database permissions and ranks table');
								$sessionobject->set_session_var($class_num . '_objects_failed',$sessionobject->get_session_var($class_num . '_objects_failed') + 1 );
							}
						}
						else
						{
							$displayobject->display_now("<br />Invalid new usergroup object, skipping." . $new_usergroup->_failedon);
						}
					}
					else
					{
						$displayobject->display_now('<br />Imported import_usergroup, Error with importing pm');
						$sessionobject->add_error('warning', $this->_modulestring,
									get_class($this) . "::import_usergroup failed for " . $rank['rank_title'],
									'Check database permissions and usergroup table');
						$sessionobject->set_session_var($class_num . '_objects_failed',$sessionobject->get_session_var($class_num . '_objects_failed') + 1 );
					}
				}
				else
				{
					$displayobject->display_now("<br />Invalid new usergroup object, skipping." . $new_usergroup->_failedon);
				}
			}

			$the_end = time() - $start;
			$sessionobject->add_session_var('last_pass', $the_end);

			if (count($ranks_array) == 0 OR count($ranks_array) < $ranks_per_page)
			{
				$sessionobject->timing($class_num ,'stop', $sessionobject->get_session_var('autosubmit'));
				$sessionobject->remove_session_var($class_num . '_start');

				$displayobject->update_html($displayobject->module_finished($this->_modulestring,
								$sessionobject->return_stats($class_num , '_time_taken'),
								$sessionobject->return_stats($class_num , '_objects_done'),
								$sessionobject->return_stats($class_num , '_objects_failed')
								));

				$sessionobject->set_session_var($class_num ,'FINISHED');
				$sessionobject->set_session_var('ranks','done');
				$sessionobject->set_session_var('module','000');
				$sessionobject->set_session_var('autosubmit','0');
				$displayobject->update_html($displayobject->print_redirect('index.php','1'));
			}
			else
			{
			$sessionobject->set_session_var('ranksstartat',$ranks_start_at+$ranks_per_page);
			$displayobject->update_html($displayobject->print_redirect('index.php'));
			}
		}
		else
		{
			$displayobject->display_now('Going to the main page...');
			$displayobject->update_html($displayobject->print_redirect('index.php'));
		}
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: 13:19, Thu Oct 21st 2004
|| # CVS: $RCSfile: 012.php,v $ - $Revision: 1.14 $
|| ####################################################################
\*======================================================================*/
?>
