<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* vb3_007 Import Threads
*
* @package 		ImpEx.vb3
* @version		$Revision: 1.2 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/06/16 12:02:02 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/

class vb3_008 extends vb3_000
{
	var $_version 		= '0.0.1';
	var $_dependent 	= '007';
	var $_modulestring 	= 'Import Threads';

	function vb3_008()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject,$this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source,'clear_imported_threads'))
				{
					$displayobject->display_now("<h4>Imported threads have been cleared</h4>");
					$this->_restart = true;
				}
				else
				{
					$sessionobject->add_error('fatal',
											 $this->_modulestring,
											 get_class($this) . "::restart failed , clear_imported_threads",
											 'Check database permissions also the thread table');
				}
			}

			$displayobject->update_basic('title','Import Threads');
			$displayobject->update_html($displayobject->do_form_header('index',substr(get_class($this) , -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this) , -3),'WORKING'));
			$displayobject->update_html($displayobject->make_hidden_code('import_threads','working'));
			$displayobject->update_html($displayobject->make_table_header('Import Threads'));
			$displayobject->update_html($displayobject->make_input_code("Threads to import per cycle (must be greater than 1)","threadsperpage",1000));

			$displayobject->update_html($displayobject->do_form_footer('Continue','Reset'));


			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_done', '0');
			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_failed', '0');


			$sessionobject->add_session_var('threadsstartat','0');
		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index',''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue',''));
			$sessionobject->set_session_var(substr(get_class($this) , -3),'FALSE');
			$sessionobject->set_session_var('module','000');
		}
	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		// Set up working variables.
		$displayobject->update_basic('displaymodules','FALSE');
		$target_database_type	= $sessionobject->get_session_var('targetdatabasetype');
		$target_table_prefix	= $sessionobject->get_session_var('targettableprefix');

		$source_database_type	= $sessionobject->get_session_var('sourcedatabasetype');
		$source_table_prefix	= $sessionobject->get_session_var('sourcetableprefix');

		$threads_start_at	= $sessionobject->get_session_var('threadsstartat');
		$threads_per_page	= $sessionobject->get_session_var('threadsperpage');

		$class_num				= substr(get_class($this) , -3);

		// Start the timing
		if(!$sessionobject->get_session_var($class_num . '_start'))
		{
			$sessionobject->timing($class_num ,'start' ,$sessionobject->get_session_var('autosubmit'));
		}


		$threads_array = $this->get_details($Db_source, $source_database_type, $source_table_prefix, $threads_start_at, $threads_per_page, 'thread', 'threadid');
		$users_ids = $this->get_user_ids($Db_target, $target_database_type, $target_table_prefix);
		$forum_ids = $this->get_forum_ids($Db_target, $target_database_type, $target_table_prefix);

		$thread_object = new ImpExData($Db_target, $sessionobject, 'thread');

		$displayobject->display_now("<h4>Importing " . count($threads_array) . " threads</h4><p><b>From</b> : " . $threads_start_at . " ::  <b>To</b> : " . ($threads_start_at + count($threads_array)) . "</p>");

		foreach ($threads_array as $thread_id => $details)
		{
			$try = $thread_object;

			// Mandatory
			$try->set_value('mandatory', 'title',				$details['title']);
			$try->set_value('mandatory', 'forumid',				$forum_ids["$details[forumid]"]);
			$try->set_value('mandatory', 'importthreadid',		$thread_id);
			$try->set_value('mandatory', 'importforumid',		$details['forumid']);

			// Non Mandatory
			$try->set_value('nonmandatory', 'firstpostid',		$details['firstpostid']);
			$try->set_value('nonmandatory', 'lastpost',			$details['lastpost']);
			$try->set_value('nonmandatory', 'pollid',			$details['pollid']);
			$try->set_value('nonmandatory', 'open',				$details['open']);
			$try->set_value('nonmandatory', 'replycount',		$details['replycount']);
			$try->set_value('nonmandatory', 'postusername',		$details['postusername']);
			$try->set_value('nonmandatory', 'postuserid',		$users_ids["$details[postuserid]"]);
			$try->set_value('nonmandatory', 'lastposter',		$details['lastposter']);
			$try->set_value('nonmandatory', 'dateline',			$details['dateline']);
			$try->set_value('nonmandatory', 'views',			$details['views']);
			$try->set_value('nonmandatory', 'iconid',			$details['iconid']); // Might need changing on custom boards
			$try->set_value('nonmandatory', 'notes',			$details['notes']);
			$try->set_value('nonmandatory', 'visible',			$details['visible']);
			$try->set_value('nonmandatory', 'sticky',			$details['sticky']);
			$try->set_value('nonmandatory', 'votenum',			$details['votenum']);
			$try->set_value('nonmandatory', 'votetotal',		$details['votetotal']);
			$try->set_value('nonmandatory', 'attach',			$details['attach']);
			$try->set_value('nonmandatory', 'similar',			$details['similar']);


			if($try->is_valid())
			{
				if($try->import_thread($Db_target, $target_database_type, $target_table_prefix))
				{
					$displayobject->display_now("<br /><span class=\"isucc\"><b>" . $try->how_complete() . "%</b></span> :: " . $try->get_value('mandatory','title'));
					$sessionobject->add_session_var($class_num . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
					$imported = true;
				}
				else
				{
					$sessionobject->set_session_var($class_num . '_objects_failed',$sessionobject->get_session_var($class_num. '_objects_failed') + 1 );
					$sessionobject->add_error('warning', $this->_modulestring, get_class($this) . "::import_thread failed.", 'Check database permissions and thread table');
					$displayobject->display_now("<br />Found thread " . $try->get_value('mandatory','title') . " and <b>DID NOT</b> imported to the " . $target_database_type . " database");
				}
			}
			else
			{
				$displayobject->display_now("<br />Invalid forum object, skipping." . $try->_failedon);
			}
			unset($try);
		}


		if (count($threads_array) == 0 OR count($threads_array) < $threads_per_page)
		{
			$displayobject->display_now("<p>Updating pollids for new threads</p>");
			$this->update_poll_ids($Db_target, $target_database_type, $target_table_prefix);

			$sessionobject->timing($class_num ,'stop', $sessionobject->get_session_var('autosubmit'));
			$sessionobject->remove_session_var($class_num . '_start');

			$displayobject->update_html($displayobject->module_finished($this->_modulestring,
																		$sessionobject->return_stats($class_num ,'_time_taken'),
																		$sessionobject->return_stats($class_num ,'_objects_done'),
																		$sessionobject->return_stats($class_num ,'_objects_failed')
																		));
			$sessionobject->set_session_var($class_num ,'FINISHED');
			$sessionobject->set_session_var('import_threads','done');
			$sessionobject->set_session_var('module','000');
			$sessionobject->set_session_var('autosubmit','0');
			$displayobject->update_html($displayobject->print_redirect('index.php','1'));
		}
		else
		{
			$displayobject->update_html($displayobject->print_redirect('index.php'));
			$sessionobject->set_session_var('threadsstartat',(intval($threads_start_at)+intval($sessionobject->get_session_var('threadsperpage'))));
		}
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: 13:19, Thu Oct 21st 2004
|| # CVS: $RCSfile: 008.php,v $ - $Revision: 1.2 $
|| ####################################################################
\*======================================================================*/
?>
