<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* eve Import Posts
*
*
* @package 		ImpEx.eve
* @version		$Revision: 1.20 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/10/08 16:06:01 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class eve_008 extends eve_000
{
	var $_version 		= '0.0.1';
	var $_dependent 	= '007';
	var $_modulestring 	= 'Import Posts';

	function eve_008()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject, $this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source, 'clear_imported_posts'))
				{
					$this->_restart = FALSE;
					$displayobject->display_now("<h4>Imported Posts have been cleared</h4>");
				}
				else
				{
					$sessionobject->add_error(
						'fatal',
						$this->_modulestring,
						get_class($this) . "::restart failed , clear_imported_posts",
						'Check database permissions and user table'
					);
				}
			}
			$displayobject->update_basic('title', 'Import posts');
			$displayobject->update_html($displayobject->do_form_header('index', substr(get_class($this), -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this), -3), 'WORKING'));
			$displayobject->update_html($displayobject->make_hidden_code('posts', 'working'));
			$displayobject->update_html($displayobject->make_table_header('Import Posts'));
			$displayobject->update_html($displayobject->make_description("<p>The importer will now start to import posts from your EVE board. Depending on the size of your board, this may take some time.</p>"));
			$displayobject->update_html($displayobject->make_input_code("Number of threads worth of posts to import per cycle", "postsperpage", "100"));
			$displayobject->update_html($displayobject->do_form_footer("Import posts"));
			$sessionobject->add_session_var('todo', $this->get_thread_number($Db_source, $sessionobject->get_session_var('sourcedatabasetype'), $sessionobject->get_session_var('sourcetableprefix')));
			$sessionobject->add_session_var('done', '0');

			$sessionobject->add_session_var('postsstartat', '0');
		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index', ''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue', ''));
			$sessionobject->set_session_var(substr(get_class($this), -3), 'FALSE');
			$sessionobject->set_session_var('module', '000');
		}
	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		if ($sessionobject->get_session_var('posts') == 'working')
		{
			$displayobject->update_basic('displaymodules', 'FALSE');
			// Set up working variables.
			$target_database_type 	= $sessionobject->get_session_var('targetdatabasetype');
			$target_table_prefix  	= $sessionobject->get_session_var('targettableprefix');

			$source_database_type 	= $sessionobject->get_session_var('sourcedatabasetype');
			$source_table_prefix  	= $sessionobject->get_session_var('sourcetableprefix');

			// Called this, though it is actuall the number of threads "worth" of posts per page.
			$posts_start_at 		= $sessionobject->get_session_var('postsstartat');
			$posts_per_page 		= $sessionobject->get_session_var('postsperpage');
$posts_per_page=1000;
			$class_num		= substr(get_class($this), -3);

			if(!$sessionobject->get_session_var(substr(get_class($this), -3) . '_start'))
			{
				$sessionobject->timing(substr(get_class($this), -3), 'start', $sessionobject->get_session_var('autosubmit'));
			}

			if(intval($posts_per_page) == 0)
			{
				$posts_per_page = 10;
			}

			$thead_id_array			= $this->get_eve_thread_ids($Db_source, $source_database_type, $source_table_prefix, $posts_start_at, $posts_per_page);
			$thread_ids				= $this->get_threads_ids($Db_target, $target_database_type, $target_table_prefix);
			$users_ids 				= $this->get_user_ids($Db_target, $target_database_type, $target_table_prefix);
			$user_names				= $this->get_username($Db_target, $target_database_type, $target_table_prefix);

			$displayobject->display_now("<h4>Done " . $sessionobject->get_session_var('done') . "</h4>");

			$start = time();
			foreach ($thead_id_array as $thread_id)
			{
				// Store the vb post id of the post with its threading order
				// ['threading_order'] => ['vb_post_id']

				$import_message_id_array = array();
				// Get the posts array for this thread id.


				$post_array = $this->get_eve_posts_details($Db_source, $source_database_type, $source_table_prefix, $thread_id);

				$to = $posts_start_at + $posts_per_page;
				$last_pass = $sessionobject->get_session_var('last_pass');
				$displayobject->display_now("<h4>Importing posts for thread " . $thread_ids["$thread_id"] . "</h4>");

				$post_object = new ImpExData($Db_target, $sessionobject,'post');

				foreach($post_array as $post_id => $post)
				{

					$try = $post_object;

					$try->set_value('mandatory', 'threadid', 			$thread_ids[$post['TOPIC_MESSAGE_OID']]);
					$try->set_value('mandatory', 'userid', 				$users_ids[$post['AUTHOR_OID']]);
					$try->set_value('mandatory', 'importthreadid', 		$thread_id);


					if(strlen($datestamp) == 19)
					{
						$try->set_value('nonmandatory', 'dateline',		$this->parse_eve_time($post['DATETIME_POSTED']));
					}
					else
					{
						$try->set_value('nonmandatory', 'dateline',			strtotime($post['DATETIME_POSTED']));
					}


					$try->set_value('nonmandatory', 'showsignature', 	$this->option2bin($post['ENABLE_SIGNATURE']));
					$try->set_value('nonmandatory', 'username', 		$user_names[$post['AUTHOR_OID']]);
					$try->set_value('nonmandatory', 'pagetext', 		$this->html_2_bb($this->eve_html($post['MESSAGE_BODY'])));
					$try->set_value('nonmandatory', 'title', 			$page_text['SUBJECT']);
					$try->set_value('nonmandatory', 'ipaddress',		$post['POSTER_IP']);
					$try->set_value('nonmandatory', 'visible',			'1');
					$try->set_value('nonmandatory', 'importpostid',		$post_id);

					if(strlen($post['THREADING_ORDER']) == 6)
					{
						$try->set_value('nonmandatory', 'parentid', '0');
					}
					else
					{
						$try->set_value('nonmandatory', 'parentid', $import_message_id_array[(intval(substr($post['THREADING_ORDER'], 6, 12)) -1)]);
					}

					/*
					$try->set_value('nonmandatory', 'iconid',);
					$try->set_value('nonmandatory', 'attach',);
					$try->set_value('nonmandatory', 'allowsmilie',);

					// TODO: -
					put into an edit log once the postid has been got.
					DATE_EDITED

					Find a mapping between them
					MESSAGE_ICON
					*/


					if($try->is_valid())
					{
						$post_id = $try->import_post($Db_target, $target_database_type, $target_table_prefix);

						if($post_id)
						{
							// Get the post id with the thread order, because the children will need it
							$import_message_id_array[intval(substr($post['THREADING_ORDER'], 6, 12))] = $Db_target->insert_id();
							$displayobject->display_now("<br /><span class=\"isucc\"><b>" . $try->how_complete() . "%</b></span> :: Post from -> " . $try->get_value('nonmandatory', 'username'));
							$sessionobject->add_session_var(substr(get_class($this), -3) . '_objects_done', intval($sessionobject->get_session_var(substr(get_class($this), -3) . '_objects_done')) + 1);
							$imported = true;
						}
						else
						{
							$sessionobject->add_error(
								'warning',
								$this->_modulestring,
								get_class($this) . "::import_thread failed for " . $cat['cat_title'] . " get_phpbb2_categories_details was ok.",
								'Check database permissions and user table'
							);
							$sessionobject->set_session_var(substr(get_class($this), -3) . '_objects_failed', $sessionobject->get_session_var(substr(get_class($this), -3). '_objects_failed') + 1);
							$displayobject->display_now("<br />Got thread " . $cat['cat_title'] . " and <b>DID NOT</b> imported to the " . $target_database_type . " database");
						}
					}
					else
					{
						$displayobject->display_now("<br />Invalid object, skipping.");
					}
				}
			}

			$the_end = time() - $start;
			$sessionobject->add_session_var('last_pass', $the_end);

			$sessionobject->set_session_var('done', $sessionobject->get_session_var('done') + $posts_per_page);

			if ($sessionobject->get_session_var('done') > $sessionobject->get_session_var('todo'))
			{
				$displayobject->display_now('Updating parent ids to allow for threaded view....');

				if ($this->update_post_parent_ids($Db_target, $target_database_type, $target_table_prefix))
				{
					$displayobject->display_now('Done !');
				}
				else
				{
					$displayobject->display_now('Error updating parent ids');
				}

				// TODO :  redo the image cache so the smilies display
				// adminfunctions.php, build_image_cache($table)


				$sessionobject->timing(substr(get_class($this), -3), 'stop', $sessionobject->get_session_var('autosubmit'));
				$sessionobject->remove_session_var(substr(get_class($this), -3) . '_start');

				$displayobject->update_html($displayobject->module_finished(
					$this->_modulestring,
					$sessionobject->return_stats(substr(get_class($this) , -3), '_time_taken'),
					$sessionobject->return_stats(substr(get_class($this) , -3), '_objects_done'),
					$sessionobject->return_stats(substr(get_class($this) , -3), '_objects_failed')
				));

				$sessionobject->set_session_var(substr(get_class($this), -3), 'FINISHED');
				$sessionobject->set_session_var('posts', 'done');
				$sessionobject->set_session_var('module', '000');
				$sessionobject->set_session_var('autosubmit', '0');
				$displayobject->update_html($displayobject->print_redirect('index.php', '1'));
			}
			else
			{
			$sessionobject->set_session_var('postsstartat', $posts_start_at+$posts_per_page);
			$displayobject->update_html($displayobject->print_redirect('index.php'));
			}
		}
		else
		{
			$displayobject->display_now('Going to the main page...');
			$displayobject->update_html($displayobject->print_redirect('index.php'));
		}
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: [#]zeveuilddate[#]
|| # CVS: $RCSfile: 008.php,v $ - $Revision: 1.20 $
|| ####################################################################
\*======================================================================*/
?>
