<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* vb3_006 Import Avatars
*
* @package 		ImpEx.vb3
* @version		$Revision: 1.2 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/10/11 18:42:46 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/

class vb3_006 extends vb3_000
{
	var $_version 		= '0.0.1';
	var $_dependent 	= '004';
	var $_modulestring 	= 'Import Custom Profile Pics';

	function vb3_006()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject,$this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source,'clear_imported_custom_pics'))
				{
					$displayobject->display_now("<h4>Imported custom pics have been cleared</h4>");
					$this->_restart = true;
				}
				else
				{
					$sessionobject->add_error('fatal',
											 $this->_modulestring,
											 get_class($this) . "::restart failed , clear_imported_custom_pics",
											 'Check database permissions also the customprofilepic table');
				}
			}

			$displayobject->update_basic('title','Import avatars');
			$displayobject->update_html($displayobject->do_form_header('index',substr(get_class($this) , -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this) , -3),'WORKING'));
			$displayobject->update_html($displayobject->make_hidden_code('import_custom_pics','working'));
			$displayobject->update_html($displayobject->make_table_header('Import Custom Profile Pics'));
			$displayobject->update_html($displayobject->make_input_code("Custom pics to import per cycle (must be greater than 1)","custompicsperpage",50));

			$displayobject->update_html($displayobject->do_form_footer('Continue','Reset'));


			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_done', '0');
			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_failed', '0');


			$sessionobject->add_session_var('custompicsstartat','0');
			$sessionobject->add_session_var('avatarsdone','0');
		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index',''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue',''));
			$sessionobject->set_session_var(substr(get_class($this) , -3),'FALSE');
			$sessionobject->set_session_var('module','000');
		}
	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		// Set up working variables.
		$displayobject->update_basic('displaymodules','FALSE');
		$target_database_type	= $sessionobject->get_session_var('targetdatabasetype');
		$target_table_prefix	= $sessionobject->get_session_var('targettableprefix');

		$source_database_type	= $sessionobject->get_session_var('sourcedatabasetype');
		$source_table_prefix	= $sessionobject->get_session_var('sourcetableprefix');

		$custom_pics_start_at	= $sessionobject->get_session_var('custompicsstartat');
		$custom_pics_per_page	= $sessionobject->get_session_var('custompicsperpage');
		$class_num				= substr(get_class($this) , -3);

		// Start the timing
		if(!$sessionobject->get_session_var($class_num . '_start'))
		{
			$sessionobject->timing($class_num ,'start' ,$sessionobject->get_session_var('autosubmit'));
		}


		$customprofilepic_array = $this->get_details($Db_source, $source_database_type, $source_table_prefix, $custom_pics_start_at, $custom_pics_per_page, 'customprofilepic', 'userid');
		$users_ids = $this->get_user_ids($Db_target, $target_database_type, $target_table_prefix);

		$customprofilepic_object = new ImpExData($Db_target, $sessionobject, 'customprofilepic');

		$displayobject->display_now("<h4>Importing " . count($customprofilepic_array) . " custom profile pic</h4><p><b>From</b> : " . $custom_pics_start_at . " ::  <b>To</b> : " . ($custom_pics_start_at + count($customprofilepic_array)) . "</p>");

		foreach ($customprofilepic_array as $cust_pic_id => $cus_pic)
		{
			$try = $customprofilepic_object;

			$try->set_value('mandatory', 'importcustomprofilepicid',		$cust_pic_id);
			$try->set_value('nonmandatory', 'userid',						$users_ids["$cus_pic[userid]"]);
			$try->set_value('nonmandatory', 'profilepicdata',				$Db_target->escape_string($cus_pic['profilepicdata']));
			$try->set_value('nonmandatory', 'dateline',						$cus_pic['dateline']);
			$try->set_value('nonmandatory', 'filename',						$cus_pic['filename']);
			$try->set_value('nonmandatory', 'visible',						$cus_pic['visible']);

			if($try->is_valid())
			{
				if($try->import_custom_profile_pic($Db_target, $target_database_type, $target_table_prefix))
				{
					$displayobject->display_now("<br /><span class=\"isucc\"><b>" . $try->how_complete() . "%</b></span> :: Filename -> " . $try->get_value('nonmandatory','filename'));
					$sessionobject->add_session_var($class_num . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
					$imported = true;
				}
				else
				{
					$sessionobject->set_session_var($class_num . '_objects_failed',$sessionobject->get_session_var($class_num. '_objects_failed') + 1 );
					$sessionobject->add_error('warning', $this->_modulestring, get_class($this) . "::import_custom_profile_pic failed.", 'Check database permissions and user table');
					$displayobject->display_now("<br />Found avatar " . $try->get_value('nonmandatory','title') . " and <b>DID NOT</b> imported to the " . $target_database_type . " database");
				}
			}
			else
			{
				$displayobject->display_now("<br />Invalid avatar object, skipping." . $try->_failedon);
			}
			unset($try);
		}


		if (count($customprofilepic_array) == 0 OR count($customprofilepic_array) < $custom_pics_per_page)
		{
			$sessionobject->timing($class_num ,'stop', $sessionobject->get_session_var('autosubmit'));
			$sessionobject->remove_session_var($class_num . '_start');

			$displayobject->update_html($displayobject->module_finished($this->_modulestring,
																		$sessionobject->return_stats($class_num ,'_time_taken'),
																		$sessionobject->return_stats($class_num ,'_objects_done'),
																		$sessionobject->return_stats($class_num ,'_objects_failed')
																		));
			$sessionobject->set_session_var($class_num ,'FINISHED');
			$sessionobject->set_session_var('import_custom_pics','done');
			$sessionobject->set_session_var('module','000');
			$sessionobject->set_session_var('autosubmit','0');
			$displayobject->update_html($displayobject->print_redirect('index.php','1'));
		}
		else
		{
			$displayobject->update_html($displayobject->print_redirect('index.php'));
			$sessionobject->set_session_var('custompicsstartat',(intval($custom_pics_start_at)+intval($sessionobject->get_session_var('custompicsperpage'))));
		}
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: 13:19, Thu Oct 21st 2004
|| # CVS: $RCSfile: 006.php,v $ - $Revision: 1.2 $
|| ####################################################################
\*======================================================================*/
?>
