<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

/**
* Common specific vB functions.
*
* If a function is used in more that two places it goes here.
*
* @package 		ImpEx
* @version		$Revision: 1.41 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/09/06 16:09:00 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class ImpExFunction
{
	var $_version = '0.0.1';


	var $_smilies = array(
		'smiles.gif'		=>	':)',
		'wink.gif'			=>	';)',
		'rolleyes.gif' 		=>	':rolleyes:',
		'icon_rolleyes.gif' =>	':rolleyes:',
		'wink.gif'			=>	';)',
		'biggrin.gif'		=>	':D',
		'razz.gif'			=>	':razz:',
		'mad.gif'			=>	':mad:',
		'confused.gif' 		=>	':confused:',
		'cool.gif'			=>	':cool:',
		'eek.gif'			=>	':eek:',
		'frown.gif'			=>	':(',
		'icon_wink.gif'		=>	';)',
		'icon_biggrin.gif'	=>	':D',
		'icon_razz.gif'		=>	':razz:',
		'icon_mad.gif'		=>	':mad:',
		'icon_confused.gif' =>	':confused:',
		'icon_smile.gif'	=>	':)',
		'icon_cool.gif'		=>	':cool:',
		'icon_eek.gif'		=>	':eek:',
		'icon_frown.gif'	=>	':('
	);


	function ImpExFunction()
	{
	}



	/**
	* Returns unix timestamp from a timestamp(14)
	*
	* @param	string	mixed			The string to parse
	*
	* @return	array
	*/
	function time_to_stamp($old_date)
	{
		return mktime (substr($old_date, 8, 2), substr($old_date, 10, 2), substr($old_date, 12, 2), substr($old_date, 4, 2), substr($old_date, 6, 2), substr($old_date, 0, 4));
	}


	function option2bin($optionstring)
	{
		$optionstring = strtolower(trim($optionstring));
		switch ($optionstring)
		{
			case 'yes':
			case 'is':
			case 'one':
			case 'on':
			case 'true':
			case 'y':
				return 1;

			case 'no':
			case 'is not':
			case 'off':
			case 'false':
			case 'n':
				return 0;

			default:
				return $optionstring;
		}
	}

	// YYYY-MM-DD or TIMESTAMP

	function is_coppa($birthday)
	{
		$return_array = array( 'status' 	=> false,
							   'is_coppa'	=> true);

		$date_bits = array();
		$unix_ts = 0;

		if(stristr($birthday,"-"))
		{
			//Its YYYY-MM-DD
			$date_bits = explode('-',$birthday);

			if(!checkdate(intval($date_bits[1]), intval($date_bits[2]), intval($date_bits[0])))
			{
				return $return_array;
			}

			$birthday = mktime(0,0,0,$date_bits[1],$date_bits[0],$date_bits[2]);
		}

		// 410240038 13 years of seconds
		if( $birthday > (time() - 410240038))
		{
			$return_array['status'] = true;
			$return_array['is_coppa'] = true;
		}
		else
		{
			$return_array['status'] = true;
			$return_array['is_coppa'] = false;
		}

		return $return_array;
	}


	function iif($expression, $returntrue, $returnfalse = '')
	{
		return $expression ? $returntrue : $returnfalse;
	}


	function unhtmlspecialchars($text)
	{
		return str_replace(array('&lt;', '&gt;', '&quot;', '&amp;'), array('<', '>', '"', '&'), $text);
	}


	function vb_parse_url($messagetext)
	{ // the auto parser - adds [url] tags around neccessary things

		static $urlSearchArray, $urlReplaceArray, $emailSearchArray, $emailReplaceArray;

		if (!$urlSearchArray)
		{
			$taglist = '\[b|\[i|\[u|\[color|\[size|\[font|\[left|\[center|\[right|\[indent|\[quote|\[highlight|\[\*';
			$urlSearchArray = array(
				"#(^|(?<=[^_a-z0-9-=\]\"'/@]|(?<=" . $taglist . ")\]))((https?|ftp|gopher|news|telnet)://|www\.)((\[(?!/)|[^\s[()^$!`\"'|{}<>])+)(?!\[/url|\[/img)(?=[,.]*([\s)[]|$))#siU"
			);

			$urlReplaceArray = array(
				"[url]\\2\\4[/url]"
			);

			$emailSearchArray = array(
				"/([ \n\r\t])([_a-z0-9-]+(\.[_a-z0-9-]+)*@[^\s]+(\.[a-z0-9-]+)*(\.[a-z]{2,4}))/si",
				"/^([_a-z0-9-]+(\.[_a-z0-9-]+)*@[^\s]+(\.[a-z0-9-]+)*(\.[a-z]{2,4}))/si"
			);

			$emailReplaceArray = array(
				"\\1[email]\\2[/email]",
				"[email]\\0[/email]"
			);
		}

		$text = preg_replace($urlSearchArray, $urlReplaceArray, $messagetext);
		if (strpos($text, '@'))
		{
			$text = preg_replace($emailSearchArray, $emailReplaceArray, $text);
		}

		return $text;
	}


	function vb_file_get_contents($filename)
	{
		if (function_exists('file_get_contents'))
		{
			return file_get_contents($filename);
		}
		else
		{
			if ($handle = @fopen ($filename, "rb"))
			{
				do
				{
					$data = fread($handle, 1);
					if (strlen($data) == 0)
					{
						break;
					}
					$contents .= $data;
				} while(true);
				@fclose ($handle);
				return $contents;
			}
		}
		return false;
	}


	function return_style_array($section)
	{
		$_sections_array = array (
		'body', '.page', 'td', 'th', 'p', 'li', '.tborder', '.tcat', '.thead', '.tfoot', '.alt1', '.alt1Active', '.alt2',
		'.alt2Active', '.wysiwyg', 'textarea', '.bginput', '.button', 'select', '.smallfont', '.time', '.navbar', '.highlight',
		'.panelsurround', '.panel', 'legend', '.vbmenu_control', '.vbmenu_popup', '.vbmenu_option', '.vbmenu_hilite', '.fjsel',
		'.fjdpth0', '.fjdpth1', '.fjdpth2', '.fjdpth3', '.fjdpth4');

		$_style_array = array(
			'background'	=> '',
			'color'			=> '',
			'font'			=> array(
					'style'			=> '',
					'size' 			=> '',
					'family' 		=> ''
				),
			'EXTRA' 		=> '',
			'LINK_N'		=>array(
					'background' 	=> '',
					'color' 		=> '',
					'text-decoration' => ''
				),
			'LINK_V'		=> array(
					'background' 	=> '',
					'color' 		=> '',
					'text-decoration' => ''
				),
			'LINK_M'		=> array(
					'background' 	=> '',
					'color' 		=> '',
					'text-decoration' => ''
				)
		);

		$_end_array = array
		(
			'EXTRA'			=> array(
					'all' 			=> ''
				),
			'EXTRA2'		=> array(
					'all' 			=> ''
				)
		);

		if (in_array($section, $_sections_array))
		{
			return $_style_array;
		}
		else if ($section == 'all')
		{
			$_return_value = array();

			foreach ($_sections_array as $_section)
			{
				$_temp_array = array($_section => $this->return_style_array($_section));

				$_return_value = array_merge($_return_value,$_temp_array);
			}

			return array_merge($_return_value,$_end_array);
		}
		else
		{
			return false;
		}
	}


	function html_2_bb($htmlcode, $parse_smilies = 1, $parse_urls = 1)
	{
		$smilies = $this->_smilies;

		if(!function_exists('parse_smilie_callback'))
		{
			function parse_smilie_callback($imgsrc, $fulltag,$smilies)
			{
				// strip extra quotes added by /e modifier
				$imgsrc = str_replace('\"', '"', $imgsrc);
				$fulltag = str_replace('\"', '"', $fulltag);

				if (isset($smilies["$imgsrc"]))
				{
					// found this smilie by image location, replace it
					return $smilies["$imgsrc"];
				}
				else
				{
					// didn't find a smilie, so it probably isn't one
					return $fulltag;
				}
			}
		}
		// line breaks
		$htmlcode = preg_replace('#<br\s*/?>#i', "\n", $htmlcode);
		$htmlcode = preg_replace('#<p\s*/?>#i', "\n\n", $htmlcode);


		// do smilies
		if ($parse_smilies == 1)
		{
			// as generic as possible
			$htmlcode = preg_replace('#<img[^>]*src=("|\')(.*)\\1[^>]*/??>#iUe', "parse_smilie_callback('\\2', '\\0', \$smilies)", $htmlcode);
			$htmlcode = preg_replace('#<img[^>]*src=([^"\' ]*) [^>]*/??>#iUe', "parse_smilie_callback('\\1', '\\0', \$smilies)", $htmlcode);
		}

		// images (beyond any smilies stripped above)
		$htmlcode = preg_replace('#<img[^>]*src=("|\')(.*)\\1[^>]*/??>#iU', '[img]$2[/img]', $htmlcode);

		// bold and italics
		$htmlcode = preg_replace('#<(/?(b|i))>#i', '[$1]', $htmlcode);
		$htmlcode = preg_replace('#<(/?)strong>#i', '[$1b]', $htmlcode);
		$htmlcode = preg_replace('#<(/?)em>#i', '[$1i]', $htmlcode);

		// catch pretty much any email address...
		$htmlcode = preg_replace('#<a[^>]*href=("|\')mailto:(.*)\\1[^>]*>(.*)</a>#iU', '[email=$1$2$1]$3[/email]', $htmlcode);
		$htmlcode = preg_replace('#<a[^>]*href=mailto:([^"\' ]*) [^>]*>(.*)</a>#iU', '[email="$1"]$2[/email]', $htmlcode);

		// ...same with urls
		$htmlcode = preg_replace('#<a[^>]*href=("|\')(.*)\\1[^>]*>(.*)</a>#iU', '[url=$1$2$1]$3[/url]', $htmlcode);
		$htmlcode = preg_replace('#<a[^>]*href=([^"\' ]*) [^>]*>(.*)</a>#iU', '[url="$1"]$2[/url]', $htmlcode);

		// do code tags
		$htmlcode = preg_replace('#<BLOCKQUOTE><font[^>]*>code:</font><hr(\s+/)?><pre>(.*)</pre><hr(\s+/)?></BLOCKQUOTE>#siU', '[code]$1[/code]', $htmlcode);

		// do quotes
		$htmlcode = preg_replace('#<blockquote><font[^>]*>quote:<hr(\s+/)?><font[^>]*>(.*)</font><hr(\s+/)?></blockquote>(<font[^>]*>)?#siU', '[quote]$3[/quote]', $htmlcode);
		$htmlcode = preg_replace('#(</font>)?<blockquote><font[^>]*>quote:</font><hr(\s+/)?><font[^>]*>(.*)</font><hr(\s+/)?></blockquote>(<font[^>]*>)?#siU', '[quote]$3[/quote]', $htmlcode);

		// Final catch !
		$htmlcode = preg_replace('#</font><blockquote><font class="small">Quote:</font><hr />#','[ QUOTE ]',$htmlcode);
		$htmlcode = preg_replace('#<hr /></blockquote><font class="post">#','[/ QUOTE ]',$htmlcode);

		// umm.. this one's pretty ugly :)
		$htmlcode = eregi_replace("</p> <small> </small> <pre style=\"font-size:x-small; font-family: monospace;\"> </pre> <STRONG> </strong> <blockquote><font size=\"1\" face=\"([^\"]*)\">quote:</font><hr /><font size=\"2\" face=\"([^\"]*)\"> <hr /></blockquote>", "[quote]", $htmlcode);

		// do lists
		$htmlcode = preg_replace('#<ul(\s+type=("?)square\\1)>#iU', '[list]', $htmlcode);
		$htmlcode = preg_replace('#<ol type=("?)(a|A|i|I|1)\\1>#iU', '[list=$2]', $htmlcode);
		$htmlcode = preg_replace('#<ol[^>]*>#iU', '[list=1]', $htmlcode);
		$htmlcode = preg_replace('#</(ol|ul)>#i', '[/list]', $htmlcode);
		$htmlcode = preg_replace('#<li>#U', '[*]', $htmlcode);
		$htmlcode = preg_replace('#</li>#U', '', $htmlcode);

		// any stray comments
		$htmlcode = preg_replace('#<!--.*-->#U', '', $htmlcode);

		// misc stuff
		$htmlcode = preg_replace('#<small>(.*)</small>#siU', '[size="1"]$1[/size]', $htmlcode);

		if ($parse_urls)
		{
			$htmlcode=$this->vb_parse_url($htmlcode);
		}

		return $htmlcode;
	}

	function all_your_posts_are_belong_to_us($post)
	{
		return $post;
	}


	/**
	* Simple path checker
	*
	* @param	object	displayobject	The displayobject
	* @param	object	sessionobject	The current session object
	* @param	string	mixed			The full path
	*
	* @return	boolean
	*/
	function check_path(&$displayobject, &$sessionobject, &$path)
	{
		if($path == null) { return false; }
		// TODO: This could be a lot better
		if (is_dir($path))
		{
			$displayobject->display_now("\n<br /><b>path</b> - $path <font color=\"green\"><i>OK</i></font>");
			return true;
		}
		else
		{
			$displayobject->display_now("\n<br /><b>$path</b> - <font color=\"red\"><i>NOT OK</i></font>");
			$sessionobject->add_error('fatal',
									 $this->_modulestring,
									 "$path is incorrect",
									 'Check the file structe of the  board');
			return false;
		}
	}


	/**
	* Simple file checker
	*
	* @param	object	displayobject	The displayobject
	* @param	object	sessionobject	The current session object
	* @param	string	mixed			The full path and filename
	*
	* @return	boolean
	*/
	function check_file(&$displayobject, &$sessionobject, &$file)
	{
		// TODO: This could be a lot better
		if (is_file($file))
		{
			$displayobject->display_now("\n<br /><b>file</b> - $file <font color=\"green\"><i>OK</i></font>");
			return true;
		}
		else
		{
			$displayobject->display_now("\n<br /><b>$file</b> - <font color=\"red\"><i>NOT OK</i></font>");
			$sessionobject->add_error('fatal',
									 $this->_modulestring,
									 "$path is incorrect",
									 'Check the file structe of the  board');
			return false;
		}
	}

	function scandir($dirstr)
	{
		if(!function_exists("scandir"))
		{
			$files = array();
			if(is_dir($dirstr))
			{
				$fh = opendir($dirstr);

				while (false !== ($filename = readdir($fh)))
				{
					array_push($files, $filename);
				}

				closedir($fh);
				return $files;
			}
			else
			{
				return false;
			}
		}
		else
		{
			return scandir($dirstr);
		}
	}


}


/*======================================================================*\
|| ####################################################################
|| # Downloaded: 13:19, Thu Oct 21st 2004
|| # CVS: $RCSfile: ImpExFunction.php,v $ - $Revision: 1.41 $
|| ####################################################################
\*======================================================================*/
?>
