<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
require_once ($systempath . 'impex/ImpExDatabase.php');
/**
* Core module that needs to be exeteded by the diffrent import systems.
*
* Is the base module class that all the import systems must extend to be
* controlled by ImpEx core, it maintains the dependacy controll amongst the
* modules and defines the functions that the core will call and that which
* be overridden.
*
* @package 		ImpEx
* @version		$Revision: 1.13 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/05/05 01:04:53 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class ImpExModule extends ImpExDatabase
{
	/**
	* Class version
	*
	* This will allow the checking for interoprability of class version in diffrent
	* versions of ImpEx
	*
	* @var    string
	*/
	var $_version = '0.0.1';

	/**
	* State variable
	*
	* Allows the object to know if it has been restarted or not.
	* versions of ImpEx
	*
	* @var    boolean
	*/
	var $_restart = FALSE;

	/**
	* Error stack
	*
	* Array used by add_error to hold error information internal to the object
	* to be delt with , this is for internal usage where as the error in ImpExSession
	* is for display.
	*
	* @var    boolean
	*/
	var $_error = array();

	/**
	* Constructor
	*
	* Empty
	*
	*/
	function ImpExModule()
	{
	}

	/**
	* Instantiates a class of the child module being called by index.php
	*
	* @param	object	sessionobject	The current sessionobject.
	* @param	object	displayobject	The display object that needs updating for the output.
	* @param	object	databaseobject	The target database (the one that the imported data is going to be put into).
	* @param	object	databaseobject	The source database (the one that the origional data has come from, i.e. the old board)
	* @param	boolean	boolean			Indicating whether the object has already been started and is being resumed.
	*
	* @return	none
	*/
	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source, $resume = FALSE)
	{
		$modulenumber = substr(get_class($this), 7);
		$currentmoduleworking = $sessionobject->get_session_var('system');

		$name = 'systems/' . $currentmoduleworking . '/' . $modulenumber .'.php';

		if (file_exists($name))
		{
			include $name;
		}
		else
		{
			$sessionobject->add_error(
				'fatal',
				'ImpExModule',
				"ImpExModule::init failed trying to find file $name",
				'Check the path and that the file is accessable by the web server'
			);
		}

		$classname = $currentmoduleworking . '_' . $modulenumber;

		$ModuleCall = new $classname($Db_target, $sessionobject);

		if ($resume)
		{
			$ModuleCall->resume($sessionobject, $displayobject, $Db_target, $Db_source);
		}
		else
		{
			$ModuleCall->init($sessionobject, $displayobject, $Db_target, $Db_source);
		}
	}

	/**
	* Calls the various restart functions for the modules to be able to clean up and start again
	*
	* @param	object	sessionobject	The current sessionobject.
	* @param	object	displayobject	The display object that needs updating for the output.
	* @param	object	databaseobject	The target database (the one that the imported data is going to be put into).
	* @param	object	databaseobject	The source database (the one that the origional data has come from, i.e. the old board)
	* @param	string	mixed			The functions name of the clean up function to call
	*
	* @return	none
	*/
	function restart(&$sessionobject, &$displayobject, &$Db_target, &$Db_source, $function)
	{
		if ($this->$function(
			$Db_target,
			$sessionobject->get_session_var('targetdatabasetype'),
			$sessionobject->get_session_var('targettableprefix')
		))
		{
			if(!$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_done', '0'))
			{
				return false;
			}

			if(!$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_failed', '0'))
			{
				return false;
			}

			return true;
		}
		else
		{
			return false;
		}
	}

	/**
	* Checks if a module can run, by checking the state of its dependent
	*
	* @param	object	sessionobject	The current sessionobject.
	* @param	string	$dependent		the three digit module number i.e. '004'
	* @return	boolean
	*/
	function check_order(&$sessionobject, $dependent)
	{
		if ($sessionobject->get_session_var($dependent) != 'FINISHED')
		{
			$sessionobject->set_session_var(substr(get_class($this), -3), 'FALSE');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}

	/**
	* Sets the module number of the instantiated class to working in the sessionobject
	*
	* @param	object	sessionobject	The current sessionobject.
	*/
	function using(&$sessionobject)
	{
		$sessionobject->set_session_var(substr(get_class($this), (intval(strlen(get_class($this))) - 3)), 'WORKING');
	}

	/**
	* Calls the init of the current class and passes TRUE init boolean call
	*
	* @param	object	sessionobject	The current sessionobject.
	* @param	object	displayobject	The display object that needs updating for the output.
	* @param	object	databaseobject	The target database (the one that the imported data is going to be put into).
	* @param	object	databaseobject	The source database (the one that the origional data has come from, i.e. the old board)
	*
	* @return	none
	*/
	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$this->init($sessionobject, $displayobject, $Db_target, $Db_source, TRUE);
	}

	/**
	* Accessor: Sets the private memeber variable _restart to true
	*
	*/
	function restarted()
	{
		$this->_restart = true;
	}

	/**
	* Accessor: adds an error string to the error array
	*
	* @param	string	mixed	An error string for the internal error stack
	*/
	function add_module_error($text)
	{
		$this->_error = $this->_error + array(count($this->_error), $text);
	}

	/**
	* Accessor: adds an error string to the error array
	*
	* @param	string	mixed	The directory to find all the modules of a system in.
	*
	* @return	array	string	An array of all the modules names of a system
	*/
	function get_class_list($dir)
	{
		$moduleclassarray = array();
		$count = 0;
		$line = array();
		if (is_dir($dir))
		{
			if ($dh = opendir($dir))
			{
				while (($filename = readdir($dh)) !== false)
				{
					if (($filename != '.') && ($filename != '..') && ($filename != 'CVS'))
					{
						//open the file
						$filetext = file($dir .'/'. $filename);
						//find the line with class
						foreach ($filetext as $value)
						{
							if (strpos($value, 'extends'))
							{
								$line=explode(' ', $value);
								break;
							}
						}
						$tempArray = array($line[1] => $filename);
						$moduleclassarray = array_merge($moduleclassarray, $tempArray);
					}
				}
				closedir($dh);
			}
		}
		return $moduleclassarray;
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: 13:19, Thu Oct 21st 2004
|| # CVS: $RCSfile: ImpExModule.php,v $ - $Revision: 1.13 $
|| ####################################################################
\*======================================================================*/
?>
