<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* ipb_004 Import Users groups
*
*
* @package 		ImpEx.ipb
* @version		$Revision: 1.21 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/09/06 14:29:58 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class ipb_004 extends ipb_000
{
	var $_version 		= '0.0.1';
	var $_dependent 	= '001';
	var $_modulestring 	= 'Import Users';

	function ipb_003()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject,$this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source,'clear_imported_users'))
				{
					$this->_restart = true;
					$displayobject->display_now("<h4>Imported users have been cleared</h4>");
				}
				else
				{
					$sessionobject->add_error('fatal',
											 $this->_modulestring,
											 get_class($this) . "::restart failed , clear_non_admin_users",
											 'Check database permissions and user table');
				}
			}

			$displayobject->update_basic('title','Import users');
			$displayobject->update_html($displayobject->do_form_header('index',substr(get_class($this) , -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this) , -3),'WORKING'));
			$displayobject->update_html($displayobject->make_hidden_code('import_users','working'));
			$displayobject->update_html($displayobject->make_table_header('Import Users'));
			$displayobject->update_html($displayobject->make_input_code("Users to import per cycle (must be greater than 1)","usersperpage",500));
			$displayobject->update_html($displayobject->make_input_code('Path to avatar upload folder','avatarfolder',$sessionobject->get_session_var('avatarfolder'),1,60));
			$displayobject->update_html($displayobject->make_description('<b>WARNING</b> Backup your target database if you have not<b>WARNING</b>'));
			$displayobject->update_html($displayobject->make_description('<b>WARNING</b> If you auto merge the origional users will get a importuserid, if you RERUN the import user module, this will delete the origional users during the cleanup <b>WARNING</b>'));
			$displayobject->update_html($displayobject->make_yesno_code("Would you like to associated imported users with existing users if the email address matches ?","email_match",0));

			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_done', '0');
			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_failed', '0');


			$displayobject->update_html($displayobject->do_form_footer('Continue','Reset'));

			$sessionobject->add_session_var('usersstartat','0');
			$sessionobject->add_session_var('totalusersdone','0');
		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index',''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue',''));
			$sessionobject->set_session_var(substr(get_class($this) , -3),'FALSE');
			$sessionobject->set_session_var('module','000');
		}
	}


	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		// Set up working variables.
		$displayobject->update_basic('displaymodules','FALSE');
		$target_database_type 	= $sessionobject->get_session_var('targetdatabasetype');
		$target_table_prefix  	= $sessionobject->get_session_var('targettableprefix');

		$source_database_type 	= $sessionobject->get_session_var('sourcedatabasetype');
		$source_table_prefix  	= $sessionobject->get_session_var('sourcetableprefix');

		$user_start_at 			= $sessionobject->get_session_var('usersstartat');
		$user_per_page 			= $sessionobject->get_session_var('usersperpage');
		$class_num				= substr(get_class($this) , -3);

		// Start the timing
		if(!$sessionobject->get_session_var($class_num . '_start'))
		{
			$sessionobject->timing($class_num ,'start' ,$sessionobject->get_session_var('autosubmit'));
		}

		// Check and clear the NON admin users
		if ($sessionobject->get_session_var('clear_non_admin_users') == 1)
		{
			if ($this->clear_non_admin_users($Db_target,$target_database_type,$target_table_prefix))
			{
				$displayobject->display_now("<b>All users deleted</b>");
				$sessionobject->set_session_var('clear_non_admin_users','0');
			}
			else
			{
				$sessionobject->add_error('fatal', $this->_modulestring,
							get_class($this) . "::resume failed , clear_non_admin_users",
							'Check database permissions and user table');
			}
		}

		// Get the arrays well need to sort the out
		$user_group_ids =  $this->get_imported_group_ids($Db_target, $target_database_type, $target_table_prefix);
		$bannedgroup 	=  $this->get_banned_group($Db_target, $target_database_type, $target_table_prefix);
		$doneusers	 	=  $this->get_done_user_ids($Db_target, $target_database_type, $target_table_prefix);

		// Get a page worths of users
		$user_array  =  $this->get_ipb_user_details($Db_source, $source_database_type, $source_table_prefix, $user_start_at, $user_per_page);

		$to = $user_start_at + count($user_array);
		$displayobject->display_now("<h4>Importing " . count($user_array) . " users</h4><p><b>From</b> : " . $user_start_at . " ::  <b>To</b> : " . $to ."</p>");

		$user_object = new ImpExData($Db_target, $sessionobject, 'user');

		foreach ($user_array as $user_id => $user)
		{
			// Have we already associated them, or imported them by mistake etc.
			if (!array_key_exists ($user_id, $doneusers))
			{
				// Get a copy of a default user object
				$try = $user_object;

				// Auto associate
				if ($sessionobject->get_session_var('email_match'))
				{
					$try->_auto_email_associate = true;
				}

				$usersettings = 0;

				if($user['view_sigs'])			{$usersettings + 1;}
				if($user['view_avs'])			{$usersettings + 2;}
				if($user['view_img'])			{$usersettings + 4;}
				if($user['view_sigs'])			{$usersettings + 1;}
				if($user['coppa_user'])			{$usersettings + 8;}
				if($user['allow_admin_mails'])	{$usersettings + 16;}
				if(!$user['hide_email']) 		{$usersettings + 256;}

				// Mandatory
				$try->set_value('mandatory', 'username',			addslashes($user['name']));
				$try->set_value('mandatory', 'email',				$user['email']);
				$try->set_value('mandatory', 'usergroupid',			$user_group_ids[$user['mgroup']]);
				$try->set_value('mandatory', 'importuserid',		$user['id']);

				// Non mandatory
				$try->_password_md5_already = true;
				$try->set_value('nonmandatory', 'password',			$user['password']);
				$try->set_value('nonmandatory', 'joindate',			$user['joined']);

				if($user['avatar'] != 'noavatar')
				{
					if(substr($moo,0,7) == 'upload:')
					{
						$try->set_value('nonmandatory', 'avatar',	$sessionobject->get_session_var('avatarfolder') . $user['avatar']);
					}
					else
					{
						$try->set_value('nonmandatory', 'avatar',	$user['avatar']);
					}
				}

				$try->set_value('nonmandatory', 'homepage',			addslashes($user['website']));
				$try->set_value('nonmandatory', 'icq',				addslashes($user['icq_number']));
				$try->set_value('nonmandatory', 'aim',				addslashes($user['aim_name']));
				$try->set_value('nonmandatory', 'msn',				addslashes($user['msnname']));

				// Its pointless if its garbage
				if($user['bday_day'] != null AND $user['bday_month'] != null AND $user['bday_year'] != null)
				{
					$try->set_value('nonmandatory', 'birthday',			strtotime($user['bday_day'] . "-" . $user['bday_month'] . "-" . $user['bday_year']));
					$try->set_value('nonmandatory', 'birthday_search',	$user['bday_year'] . "-" . $user['bday_month'] . "-" . $user['bday_day']);
				}

				$try->set_value('nonmandatory', 'ipaddress',		$user['ip_address']);
				$try->set_value('nonmandatory', 'lastvisit',		$user['last_visit']);
				$try->set_value('nonmandatory', 'lastactivity',		$user['last_activity']);

				$try->set_value('nonmandatory', 'usertitle',		addslashes($user['title']));
				$try->set_value('nonmandatory', 'posts',			$user['posts']);
				$try->set_value('nonmandatory', 'lastpost',			$user['last_post']);

				$try->set_value('nonmandatory', 'passworddate',		'');
				$try->set_value('nonmandatory', 'membergroupids',	'');
				$try->set_value('nonmandatory', 'displaygroupid',	'');

				// Hmm, where is this hidden
				//$try->set_value('nonmandatory', 'parentemail',		$user['']);

				// Default values
				$try->add_default_value('signature', 				addslashes($this->html_2_bb($user['signature'])));
				$try->add_default_value('Location',		 			addslashes($user['location']));
				$try->add_default_value('Interests', 				addslashes($user['interests']));

				/*

				yahoo
				title
				time_offset
				skin
				warn_level
				warn_lastwarn
				language
				dst_in_use
				view_prefs

				mod_posts
				auto_track
				use_shout
				org_supmod
				org_perm_id
				temp_ban
				integ_msg
				sub_end

				// Settings
				email_pm
				email_full
				restrict_post

				// PM's
				new_msg
				msg_from_id
				msg_msg_id
				msg_total
				vdirs
				show_popup
				misc
				*/

				if($try->is_valid())
				{
					if($try->import_user($Db_target,$target_database_type,$target_table_prefix))
					{
						$displayobject->display_now("<br /><span class=\"isucc\"><b>" . $try->how_complete() . "%</b></span> :: " . $try->get_value('mandatory','username'));
						$sessionobject->add_session_var($class_num . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
					}
					else
					{
						$sessionobject->add_error('warning', $this->_modulestring,
									 get_class($this) . "::import_user failed for " . $user['USERNAME'],
									 'Check database permissions and user table');
						$displayobject->display_now("<br />Got user " . $try->get_value('mandatory','username') . " and <b>DID NOT</b> imported to the " . $target_database_type . " database");
					}
				}
				else
				{
					$displayobject->display_now("<br />Invalid object, skipping.");
				}
			}
			else
			{
				// User already been imported or assosaited
				// Mark it as failed, though really its already been done, though we have to show that is wasn't a sucssfull
				// import in this sense of the word.
				$sessionobject->set_session_var($class_num . '_objects_failed',$sessionobject->get_session_var($class_num. '_objects_failed') + 1 );
				$displayobject->display_now("<br />Already imported or associated -> <span class=\"isucc\">" . $user['name'] . "</span> ");
			}
			unset($try);
		}

		if (count($user_array) == 0 OR count($user_array) < $user_per_page)
		{
			// build_user_statistics();
			$this->build_user_statistics($Db_target, $target_database_type, $target_table_prefix);

			$sessionobject->timing($class_num ,'stop', $sessionobject->get_session_var('autosubmit'));
			$sessionobject->remove_session_var($class_num . '_start');

			$displayobject->update_html($displayobject->module_finished($this->_modulestring,
																		$sessionobject->return_stats($class_num ,'_time_taken'),
																		$sessionobject->return_stats($class_num ,'_objects_done'),
																		$sessionobject->return_stats($class_num ,'_objects_failed')
																		));

			$sessionobject->set_session_var($class_num ,'FINISHED');
			$sessionobject->set_session_var('import_users','done');
			$sessionobject->set_session_var('module','000');
			$sessionobject->set_session_var('autosubmit','0');
			$displayobject->update_html($displayobject->print_redirect('index.php','1'));
		}
		else
		{
			$sessionobject->add_session_var('totalusersdone',($sessionobject->get_session_var('totalusersdone') + $doneperpass));
			$displayobject->update_html($displayobject->print_redirect('index.php'));
			$sessionobject->set_session_var('usersstartat',(intval($user_start_at)+intval($sessionobject->get_session_var('usersperpage'))));
		}
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: [#]zeveuilddate[#]
|| # CVS: $RCSfile: 004.php,v $ - $Revision: 1.21 $
|| ####################################################################
\*======================================================================*/
?>
