<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* ipb Import Styles
*
* The ubb users are stored in files with each lines corresponding to a
* diffrent values.
*
* @package 		ImpEx.ipb
* @version		$Revision: 1.9 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/04/15 00:29:34 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class ipb_005 extends ipb_000
{
	var $_version		= '0.0.1';
	var $_dependent 	= '001';
	var $_modulestring 	= 'Import Styles';

	function ipb_005()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject,$this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source, 'clear_imported_styles'))
				{
					$this->_restart = FALSE;
					$displayobject->display_now("<h4>Imported styles have been cleared</h4>");
				}
				else
				{
					$sessionobject->add_error('fatal',
											 $this->_modulestring,
											 get_class($this) . "::restart failed , clear_styles",
											 'Check database permissions and user table');
				}
			}

			$displayobject->update_basic('title','Import styles');
			$displayobject->update_html($displayobject->do_form_header('index',substr(get_class($this) , -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this) , -3),'WORKING'));
			$displayobject->update_html($displayobject->make_table_header('Import Style Settings'));
			$displayobject->update_html($displayobject->make_yesno_code("Import the styles","importstyles",1));


			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_done', '0');
			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_failed', '0');


			$displayobject->update_html($displayobject->do_form_footer("Import Styles"));
		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index',''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue',''));
			$sessionobject->set_session_var(substr(get_class($this) , -3),'FALSE');
			$sessionobject->set_session_var('module','000');
		}

	}


	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$displayobject->update_basic('displaymodules','FALSE');
		if ($sessionobject->get_session_var('importstyles') == 1)
		{
			// Set up working variables.
			$target_database_type 	= $sessionobject->get_session_var('targetdatabasetype');
			$target_table_prefix  	= $sessionobject->get_session_var('targettableprefix');

			$source_database_type 	= $sessionobject->get_session_var('sourcedatabasetype');
			$source_table_prefix  	= $sessionobject->get_session_var('sourcetableprefix');

			$user_start_at 			= $sessionobject->get_session_var('usersstartat');
			$user_per_page 			= $sessionobject->get_session_var('usersperpage');
			$class_num				= substr(get_class($this) , -3);

			if(!$sessionobject->get_session_var($class_num . '_start'))
			{
				$sessionobject->timing($class_num,'start' ,$sessionobject->get_session_var('autosubmit'));
			}

			// Get the phpBB styles
			$get_css_array  =  $this->get_ipb_css($Db_source, $source_database_type, $source_table_prefix);

			// Sort each one out
			foreach ($get_css_array as $css_id => $css)
			{
				// Get a style array to fill up.
				$style_array = $this->return_style_array('all');

				$test = explode('.',$css['css_text']);


				/*
				// TODO: Parse out this ........
				foreach ($test as $value)
				{
					$line =  explode(' ',$value);
					echo "<br />" . $line[0] . "-" . $line[2] . "-" . strtolower($line[3]);
				}

				*/

				if($this->import_style_array($Db_target, $source_database_type, $source_table_prefix, $style_array))
				{
					$displayobject->display_now("\n<br /><b>Imported</b> - style " . $css['css_name'] . "  <b>OK</b>");
					$sessionobject->add_session_var($class_num . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
				}
				else
				{
					$displayobject->display_now("\n<br /><b>Found</b> - style <b>" . $css['css_name'] . "</b> but <i>NOT</i> imported.");
					$sessionobject->set_session_var($class_num . '_objects_failed',$sessionobject->get_session_var($class_num . '_objects_failed') + 1 );
					$sessionobject->add_error('warning',
											 $this->_modulestring,
											 get_class($this) . "::failed importing style",
											 'Check array mappings and dB table is not corrupt');
				}
			}

			$sessionobject->timing($class_num,'stop', $sessionobject->get_session_var('autosubmit'));
			$sessionobject->remove_session_var($class_num . '_start');

			$displayobject->update_html($displayobject->module_finished($this->_modulestring,
																		$sessionobject->return_stats($class_num,'_time_taken'),
																		$sessionobject->return_stats($class_num,'_objects_done'),
																		$sessionobject->return_stats($class_num,'_objects_failed')
																		)
										);

			$displayobject->update_html($displayobject->make_hidden_code('importstyles','done'));
			$sessionobject->set_session_var($class_num,'FINISHED');
			$sessionobject->set_session_var('module','000');
			$displayobject->update_html($displayobject->print_redirect('index.php','2'));
		}
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: [#]zeveuilddate[#]
|| # CVS: $RCSfile: 005.php,v $ - $Revision: 1.9 $
|| ####################################################################
\*======================================================================*/
?>
