<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* ipb Import Threads
*
* The ubb users are stored in files with each lines corresponding to a
* diffrent values.
*
* @package 		ImpEx.ipb
* @version		$Revision: 1.13 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/05/12 00:19:23 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class ipb_007 extends ipb_000
{
	var $_version 		= '0.0.1';
	var $_dependent 	= '006';
	var $_modulestring 	= 'Import Threads';

	function ipb_007()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject, $this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source,'clear_imported_threads'))
				{
					$displayobject->display_now("<h4>Imported Threads have been cleared</h4>");
					$this->_restart = FALSE;
				}
				else
				{
					$sessionobject->add_error('fatal',
											 $this->_modulestring,
											 get_class($this) . "::restart failed , clear_imported_threads",
											 'Check database permissions and user table');
				}
			}
			$displayobject->update_basic('title','Import threads');
			$displayobject->update_html($displayobject->do_form_header('index',substr(get_class($this), -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this), -3),'WORKING'));
			$displayobject->update_html($displayobject->make_hidden_code('threads','working'));
			$displayobject->update_html($displayobject->make_table_header('Import Threads'));
			$displayobject->update_html($displayobject->make_description("<p>The importer will now start to import threads from your IPB board. Depending on the size of your board, this may take some time.</p>"));
			$displayobject->update_html($displayobject->make_input_code("Number of threads to import per cycle","threadsperpage","500"));
			$displayobject->update_html($displayobject->do_form_footer("Import Threads"));


			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_done', '0');
			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_failed', '0');


			$sessionobject->add_session_var('threadstartat','0');
		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index',''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue',''));
			$sessionobject->set_session_var(substr(get_class($this), -3),'FALSE');
			$sessionobject->set_session_var('module','000');
		}
	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
			// Set up working variables.
			$displayobject->update_basic('displaymodules','FALSE');
			$target_database_type 	= $sessionobject->get_session_var('targetdatabasetype');
			$target_table_prefix  	= $sessionobject->get_session_var('targettableprefix');

			$source_database_type 	= $sessionobject->get_session_var('sourcedatabasetype');
			$source_table_prefix  	= $sessionobject->get_session_var('sourcetableprefix');

			$thread_start_at 		= $sessionobject->get_session_var('threadstartat');
			$threads_per_page 		= $sessionobject->get_session_var('threadsperpage');

			$class_num		= substr(get_class($this) , -3);


			// Start at and timing
			if(!$sessionobject->get_session_var('threadsperpage'))
			{
				$threads_per_page = 0;
			}

			if(!$sessionobject->get_session_var($class_num . '_start'))
			{
				$sessionobject->timing($class_num ,'start' ,$sessionobject->get_session_var('autosubmit'));
			}

			// Get all the first messagese that make up the beginning of the threads in that forum.
			$threads_array			= $this->get_ipb_thread_details($Db_source, $source_database_type, $source_table_prefix, $thread_start_at, $threads_per_page);
			$forum_ids 				= $this->get_forum_ids($Db_target, $target_database_type, $target_table_prefix);
			$users_ids 				= $this->get_user_ids($Db_target, $target_database_type, $target_table_prefix);
			$user_names				= $this->get_username($Db_target, $target_database_type, $target_table_prefix);


			// Sort out the threads
			$displayobject->display_now("<h4>Importing " . count($threads_array) . " threads</h4><p><b>From</b> : " . $thread_start_at . " ::  <b>To</b> : " . ($thread_start_at + count($threads_array)) ."</p>");

			$thread_object = $try = new ImpExData($Db_target, $sessionobject, 'thread');

			foreach ($threads_array as $thread_id => $thread)
			{
				$try = $thread_object;

				$try->set_value('mandatory', 'title', 			$thread['title']);
				$try->set_value('mandatory', 'forumid', 		$forum_ids[$thread['forum_id']]);
				$try->set_value('mandatory', 'importthreadid', 	$thread_id);
				$try->set_value('mandatory', 'importforumid', 	$thread['forum_id']);


				$try->set_value('nonmandatory', 'notes', 		$thread['description']);
				$try->set_value('nonmandatory', 'replycount', 	$thread['posts']);
				$try->set_value('nonmandatory', 'postusername',	$user_names['starter_name']);
				$try->set_value('nonmandatory', 'postuserid', 	$users_ids[$thread['starter_id']]);
				$try->set_value('nonmandatory', 'dateline', 	$thread['start_date']);
				$try->set_value('nonmandatory', 'lastpost', 	$thread['last_poster_name']);
				$try->set_value('nonmandatory', 'views', 		$thread['views']);
				$try->set_value('nonmandatory', 'sticky', 		$thread['pinned']);
				$try->set_value('nonmandatory', 'votetotal', 	$thread['total_votes']);

				if ($thread['state'] == 'open')
				{
					$try->set_value('nonmandatory', 'open', 	'1');
				}
				else if ($thread['state'] == 'closed')
				{
					$try->set_value('nonmandatory', 'open', 	'0');
				}/*
				else if ($thread['state'] == 'link')
				{	// What to do ?
					$try->set_value('nonmandatory', 'open', 	'');
				}
				*/
				$try->set_value('nonmandatory', 'visible', '1');

				// Would need first ['importpostid'] => ['postid'] Probally not going to haoppen
				// Update counters can take care of it
				#$try->set_value('nonmandatory', 'firstpostid', 	$thread['']);
				#$try->set_value('nonmandatory', 'lastpost', 	$thread['last_post']);

				// This is the IPB icon, need the equiv vB one
				#$try->set_value('nonmandatory', 'iconid', $thread['icon_id']);

				/*
				vB
				$try->set_value('nonmandatory', 'pollid', );
				$try->set_value('nonmandatory', 'lastposter', );
				$try->set_value('nonmandatory', 'visible', );
				$try->set_value('nonmandatory', 'votenum', );
				$try->set_value('nonmandatory', 'attach', );
				$try->set_value('nonmandatory', 'similar', );

				IPB
				poll_state  varchar(8)   Yes  NULL
				last_vote  int(10)   Yes  NULL
				author_mode  tinyint(1)   Yes  NULL
				moved_to  varchar(64)   Yes  NULL
				rating  text   Yes  NULL
				*/


				if($try->is_valid())
				{
					if($try->import_thread($Db_target,$target_database_type,$target_table_prefix))
					{
						$displayobject->display_now("<br /><span class=\"isucc\"><b>" . $try->how_complete() . "%</b></span> :: " . $try->get_value('mandatory','title'));
						$sessionobject->add_session_var($class_num . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
						$imported = true;
					}
					else
					{
						$sessionobject->add_error('warning',
												 $this->_modulestring,
												 get_class($this) . "::import_thread failed for " . $cat['cat_title'] . " get_phpbb2_categories_details was ok.",
												 'Check database permissions and user table');
						$sessionobject->set_session_var($class_num . '_objects_failed',$sessionobject->get_session_var($class_num . '_objects_failed') + 1 );
						$displayobject->display_now("<br />Got thread " . $cat['cat_title'] . " and <b>DID NOT</b> imported to the " . $target_database_type . " database");
					}
				}
				else
				{
					$displayobject->display_now("<br />Invalid object, skipping.");
				}
				unset($try);
			}


			if (count($threads_array) == 0 OR count($threads_array) < $threads_per_page)
			{
				$sessionobject->timing($class_num,'stop', $sessionobject->get_session_var('autosubmit'));
				$sessionobject->remove_session_var($class_num . '_start');

				$displayobject->update_html($displayobject->module_finished($this->_modulestring,
																			$sessionobject->return_stats($class_num, '_time_taken'),
																			$sessionobject->return_stats($class_num, '_objects_done'),
																			$sessionobject->return_stats($class_num, '_objects_failed')
																			));

				$sessionobject->set_session_var($class_num, 'FINISHED');
				$sessionobject->set_session_var('threads','done');
				$sessionobject->set_session_var('module','000');
				$sessionobject->set_session_var('autosubmit','0');
			}

			$sessionobject->add_session_var('threadstartat',$thread_start_at+$threads_per_page);
			$displayobject->update_html($displayobject->print_redirect('index.php','1'));
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: [#]zeveuilddate[#]
|| # CVS: $RCSfile: 007.php,v $ - $Revision: 1.13 $
|| ####################################################################
\*======================================================================*/
?>
