<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* ipb Import Buddy lists
*
*
* @package 		ImpEx.ipb
* @version		$Revision: 1.13 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/05/12 00:39:55 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class ipb_011 extends ipb_000
{
	var $_version 		= '0.0.1';
	var $_dependent 	= '004';
	var $_modulestring 	= 'Import Buddy & Ignore Lists';

	function ipb_011()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject,$this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source,'clear_imported_buddy_list'))
				{
					$this->_restart = FALSE;
					$displayobject->display_now("<h4>Imported  Buddy & Ignore Lists have been cleared</h4>");
				}
				else
				{
					$sessionobject->add_error('fatal',
											 $this->_modulestring,
											 get_class($this) . "::restart failed , clear_imported_buddy_list",
											 'Check database permissions and user table');
				}
			}
			$displayobject->update_basic('title','Import PMs');
			$displayobject->update_html($displayobject->do_form_header('index',substr(get_class($this), -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this), -3),'WORKING'));
			$displayobject->update_html($displayobject->make_hidden_code('list','working'));
			$displayobject->update_html($displayobject->make_table_header('Import & Ignore Buddy Lists'));
			$displayobject->update_html($displayobject->make_description('<p>The importer will now start to import the buddy & ignore lists from your IPB board.</p>'));
			$displayobject->update_html($displayobject->make_input_code('Number of list to import per cycle','listperpage','100'));
			$displayobject->update_html($displayobject->do_form_footer('Import Buddy & Ignore Lists'));


			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_done', '0');
			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_failed', '0');


			$sessionobject->add_session_var('liststartat','0');
		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index',''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue',''));
			$sessionobject->set_session_var(substr(get_class($this), -3),'FALSE');
			$sessionobject->set_session_var('module','000');
		}
	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{

		if ($sessionobject->get_session_var('list') == 'working')
		{
			// Set up working variables.
			$displayobject->update_basic('displaymodules','FALSE');
			$target_database_type 	= $sessionobject->get_session_var('targetdatabasetype');
			$target_table_prefix  	= $sessionobject->get_session_var('targettableprefix');

			$source_database_type 	= $sessionobject->get_session_var('sourcedatabasetype');
			$source_table_prefix  	= $sessionobject->get_session_var('sourcetableprefix');

			$list_start_at 			= $sessionobject->get_session_var('liststartat');
			$list_per_page 			= $sessionobject->get_session_var('listperpage');

			$class_num				= substr(get_class($this) , -3);

			if(!$sessionobject->get_session_var($class_num . '_start'))
			{
				$sessionobject->timing($class_num,'start' ,$sessionobject->get_session_var('autosubmit'));
			}

			if(intval($list_per_page) == 0)
			{
				$list_per_page = 150;
			}

			$list_array 		= $this->get_ipb_buddy_ignore_lists($Db_source, $source_database_type, $source_table_prefix, $list_start_at, $list_per_page);
			$users_ids 			= $this->get_user_ids($Db_target, $target_database_type, $target_table_prefix);
			$user_names			= $this->get_username($Db_target, $target_database_type, $target_table_prefix);

			$to = $list_start_at + count($list_array);
			$last_pass = $sessionobject->get_session_var('last_pass');
			$displayobject->display_now("<h4>Importing " . count($list_array) . " buddies </h4><p><b>From</b> : " . $list_start_at . " ::  <b>To</b> : " . $to ."</p><p><b>Last pass took</b> : " . $last_pass . " seconds</p>");

			$vB_pm_text = new ImpExData($Db_target, $sessionobject,'pmtext');

			$start = time();
			$buddy_ignore_array = array();

			// Put them all in an array
			foreach ($list_array as $buddy_id => $buddy)
			{
				if ($buddy['allow_msg'] == 1)
				{
					$buddy_ignore_array[$users_ids["$buddy[member_id]"]]['buddylist'] .= ' ' . $users_ids["$buddy[contact_id]"];
				}

				if ($buddy['allow_msg'] == 0)
				{
					$buddy_ignore_array[$users_ids["$buddy[member_id]"]]['ignorelist'] .= ' ' . $users_ids["$buddy[contact_id]"];
				}
			}

			// Go through it importing for each of the users.
			foreach ($buddy_ignore_array as $key => $value)
			{
				$value['userid'] = $key;

				if($this->import_buddy_ignore($Db_target, $target_database_type, $target_table_prefix, $value))
				{
					$sessionobject->add_session_var($class_num . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
					$displayobject->display_now('<br /><font color="green">Imported for </font> <b>' . $user_names[$key] . '</b>');
				}
				else
				{
					$sessionobject->add_session_var($class_num . '_objects_failed',intval($sessionobject->get_session_var($class_num . '_objects_failed')) + 1 );
					$sessionobject->add_error('warning',
											  $this->_modulestring,
											  get_class($this) . "::import_buddy_ignore failed for :: " . $user_names[$key],
											  'Check database permissions');
					$displayobject->display_now("<br />Error with the dB Import");
				}
			}

			$the_end = time() - $start;
			$sessionobject->add_session_var('last_pass', $the_end);

			if (count($list_array) == 0 OR count($list_array) < $list_per_page)
			{
				$sessionobject->timing($class_num ,'stop', $sessionobject->get_session_var('autosubmit'));
				$sessionobject->remove_session_var($class_num . '_start');$sessionobject->remove_session_var($class_num . '_start');

				$displayobject->update_html($displayobject->module_finished($this->_modulestring,
								$sessionobject->return_stats($class_num , '_time_taken'),
								$sessionobject->return_stats($class_num , '_objects_done'),
								$sessionobject->return_stats($class_num , '_objects_failed')
								));

				$sessionobject->set_session_var($class_num ,'FINISHED');
				$sessionobject->set_session_var('list','done');
				$sessionobject->set_session_var('module','000');
				$sessionobject->set_session_var('autosubmit','0');
				$displayobject->update_html($displayobject->print_redirect('index.php','1'));
			}
			else
			{
				$sessionobject->set_session_var('liststartat',$list_start_at+$list_per_page);
				$displayobject->update_html($displayobject->print_redirect('index.php','1'));
			}
		}
		else
		{
			$sessionobject->set_session_var($class_num ,'FINISHED');
			$sessionobject->set_session_var('list','done');
			$sessionobject->set_session_var('module','000');
			$sessionobject->set_session_var('autosubmit','0');
			$displayobject->update_html($displayobject->print_redirect('index.php',''));
		}
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: 13:19, Thu Oct 21st 2004
|| # CVS: $RCSfile: 011.php,v $ - $Revision: 1.13 $
|| ####################################################################
\*======================================================================*/
?>
