<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* vb3_005 Import Avatars
*
* @package 		ImpEx.vb3
* @version		$Revision: 1.1 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/05/20 22:09:41 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/

class vb3_005 extends vb3_000
{
	var $_version 		= '0.0.1';
	var $_dependent 	= '004';
	var $_modulestring 	= 'Import Avatars';

	function vb3_005()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject,$this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source,'clear_imported_avatars'))
				{
					$displayobject->display_now("<h4>Imported avatars have been cleared</h4>");
					$this->_restart = true;
				}
				else
				{
					$sessionobject->add_error('fatal',
											 $this->_modulestring,
											 get_class($this) . "::restart failed , clear_imported_avatars",
											 'Check database permissions also the avatar & customavatar table');
				}
			}

			$displayobject->update_basic('title','Import avatars');
			$displayobject->update_html($displayobject->do_form_header('index',substr(get_class($this) , -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this) , -3),'WORKING'));
			$displayobject->update_html($displayobject->make_hidden_code('import_avatars','working'));
			$displayobject->update_html($displayobject->make_table_header('Import Avatars'));
			$displayobject->update_html($displayobject->make_input_code("Avatars to import per cycle (must be greater than 1)","avatarsperpage",50));

			$displayobject->update_html($displayobject->do_form_footer('Continue','Reset'));


			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_done', '0');
			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_failed', '0');


			$sessionobject->add_session_var('avatarsstartat','0');
			$sessionobject->add_session_var('avatarsdone','0');
		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index',''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue',''));
			$sessionobject->set_session_var(substr(get_class($this) , -3),'FALSE');
			$sessionobject->set_session_var('module','000');
		}
	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		// Set up working variables.
		$displayobject->update_basic('displaymodules','FALSE');
		$target_database_type	= $sessionobject->get_session_var('targetdatabasetype');
		$target_table_prefix	= $sessionobject->get_session_var('targettableprefix');

		$source_database_type	= $sessionobject->get_session_var('sourcedatabasetype');
		$source_table_prefix	= $sessionobject->get_session_var('sourcetableprefix');

		$avatar_start_at			= $sessionobject->get_session_var('avatarsstartat');
		$avatar_per_page			= $sessionobject->get_session_var('avatarsperpage');
		$class_num				= substr(get_class($this) , -3);

		// Start the timing
		if(!$sessionobject->get_session_var($class_num . '_start'))
		{
			$sessionobject->timing($class_num ,'start' ,$sessionobject->get_session_var('autosubmit'));
		}



		// ************
		// Do the normal avatars first
		// ************

		$avatar_array = $this->get_details($Db_source, $source_database_type, $source_table_prefix, 0, -1, 'avatar', 'avatarid');

		$avatar_object = new ImpExData($Db_target, $sessionobject, 'avatar');

		foreach ($avatar_array as $avatar_id => $avatar)
		{
			$try = $avatar_object;

			$try->set_value('mandatory', 'importavatarid',		$avatar_id);
			$try->set_value('nonmandatory', 'title',			$avatar['title']);
			$try->set_value('nonmandatory', 'minimumposts',		$avatar['minimumposts']);
			$try->set_value('nonmandatory', 'avatarpath',		$avatar['avatarpath']);
			$try->set_value('nonmandatory', 'imagecategoryid',	$avatar['imagecategoryid']);
			$try->set_value('nonmandatory', 'displayorder',		$avatar['displayorder']);

			if($try->is_valid())
			{
				if($try->import_vb3_avatar($Db_target, $target_database_type, $target_table_prefix))
				{
					$displayobject->display_now("<br /><span class=\"isucc\"><b>" . $try->how_complete() . "%</b></span> :: Avatar -> " . $try->get_value('nonmandatory','title'));
					$sessionobject->add_session_var($class_num . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
					$imported = true;
				}
				else
				{
					$sessionobject->set_session_var($class_num . '_objects_failed',$sessionobject->get_session_var($class_num. '_objects_failed') + 1 );
					$sessionobject->add_error('warning', $this->_modulestring, get_class($this) . "::import_vb3_avatar failed.", 'Check database permissions and user table');
					$displayobject->display_now("<br />Found avatar " . $try->get_value('nonmandatory','title') . " and <b>DID NOT</b> imported to the " . $target_database_type . " database");
				}
			}
			else
			{
				$displayobject->display_now("<br />Invalid avatar object, skipping." . $try->_failedon);
			}
			unset($try);
		}


		// ************
		// Now do the custom ones
		// ************

		$customavatar_object = new ImpExData($Db_target, $sessionobject, 'customavatar');

		$custom_avatar_array = $this->get_details($Db_source, $source_database_type, $source_table_prefix, $avatar_start_at, $avatar_per_page, 'customavatar', 'userid');
		$users_ids = $this->get_user_ids($Db_target, $target_database_type, $target_table_prefix);

		$displayobject->display_now("<h4>Importing " . count($custom_avatar_array) . " custom avatars</h4><p><b>From</b> : " . $avatar_start_at . " ::  <b>To</b> : " . ($avatar_start_at + count($custom_avatar_array)) . "</p>");

		foreach ($custom_avatar_array as $avatar_id => $avatar)
		{
			$try = $customavatar_object;

			$try->set_value('mandatory', 'importcustomavatarid',	$avatar_id);

			$try->set_value('nonmandatory', 'userid',				$users_ids["$avatar[userid]"]);
			$try->set_value('nonmandatory', 'avatardata',			$Db_target->escape_string($avatar['avatardata']));
			$try->set_value('nonmandatory', 'dateline',				$avatar['dateline']);
			$try->set_value('nonmandatory', 'filename',				$avatar['filename']);
			$try->set_value('nonmandatory', 'visible',				$avatar['visible']);
			$try->set_value('nonmandatory', 'filesize',				$avatar['filesize']);

			if($try->is_valid())
			{
				if($try->import_vb3_customavatar($Db_target, $target_database_type, $target_table_prefix))
				{
					$displayobject->display_now("<br /><span class=\"isucc\"><b>" . $try->how_complete() . "%</b></span> :: Custom avatar -> " . $try->get_value('nonmandatory','filename'));
					$sessionobject->add_session_var($class_num . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
					$imported = true;
				}
				else
				{
					$sessionobject->set_session_var($class_num . '_objects_failed',$sessionobject->get_session_var($class_num. '_objects_failed') + 1 );
					$sessionobject->add_error('warning', $this->_modulestring, get_class($this) . "::import_vb3_avatar failed.", 'Check database permissions and user table');
					$displayobject->display_now("<br />Found customavatar " . $try->get_value('nonmandatory','filename') . " and <b>DID NOT</b> imported to the " . $target_database_type . " database");
				}
			}
			else
			{
				$displayobject->display_now("<br />Invalid customavatar object, skipping." . $try->_failedon);
			}
			unset($try);
		}


		if (count($custom_avatar_array) == 0 OR count($custom_avatar_array) < $avatar_per_page)
		{
			$sessionobject->timing($class_num ,'stop', $sessionobject->get_session_var('autosubmit'));
			$sessionobject->remove_session_var($class_num . '_start');

			$displayobject->update_html($displayobject->module_finished($this->_modulestring,
																		$sessionobject->return_stats($class_num ,'_time_taken'),
																		$sessionobject->return_stats($class_num ,'_objects_done'),
																		$sessionobject->return_stats($class_num ,'_objects_failed')
																		));
			$sessionobject->set_session_var($class_num ,'FINISHED');
			$sessionobject->set_session_var('import_avatars','done');
			$sessionobject->set_session_var('module','000');
			$sessionobject->set_session_var('autosubmit','0');
			$displayobject->update_html($displayobject->print_redirect('index.php','1'));
		}
		else
		{
			$displayobject->update_html($displayobject->print_redirect('index.php'));
			$sessionobject->set_session_var('avatarsstartat',(intval($avatar_start_at)+intval($sessionobject->get_session_var('avatarsperpage'))));
		}
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: 13:19, Thu Oct 21st 2004
|| # CVS: $RCSfile: 005.php,v $ - $Revision: 1.1 $
|| ####################################################################
\*======================================================================*/
?>
