<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* vb3 Import Posts
*
* @package 		ImpEx.vb3
* @version		$Revision: 1.2 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/07/05 23:19:10 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class vb3_009 extends vb3_000
{
	var $_version 		= '0.0.1';
	var $_dependent 	= '007';
	var $_modulestring 	= 'Import Posts';

	function vb3_009()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject, $this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source, 'clear_imported_posts'))
				{
					$this->_restart = FALSE;
					$displayobject->display_now("<h4>Imported Posts have been cleared</h4>");
				}
				else
				{
					$sessionobject->add_error('fatal',
											 $this->_modulestring,
											 get_class($this) . "::restart failed , clear_imported_posts",
											 'Check database permissions and user table');
				}
			}
			$displayobject->update_basic('title','Import posts');
			$displayobject->update_html($displayobject->do_form_header('index',substr(get_class($this), -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this), -3),'WORKING'));
			$displayobject->update_html($displayobject->make_hidden_code('posts','working'));
			$displayobject->update_html($displayobject->make_table_header('Import Posts'));
			$displayobject->update_html($displayobject->make_description("<p>The importer will now start to import posts from your vb3 board. Depending on the size of your board, this may take some time.</p>"));
			$displayobject->update_html($displayobject->make_input_code("Number of posts to import per cycle","postsperpage","2000"));
			$displayobject->update_html($displayobject->do_form_footer("Import posts"));


			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_done', '0');
			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_failed', '0');


			$sessionobject->add_session_var('postsstartat','0');
		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index',''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue',''));
			$sessionobject->set_session_var(substr(get_class($this), -3),'FALSE');
			$sessionobject->set_session_var('module','000');
		}
	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		if ($sessionobject->get_session_var('posts') == 'working')
		{
			// Set up working variables.
			$displayobject->update_basic('displaymodules','FALSE');
			$target_database_type 	= $sessionobject->get_session_var('targetdatabasetype');
			$target_table_prefix  	= $sessionobject->get_session_var('targettableprefix');

			$source_database_type 	= $sessionobject->get_session_var('sourcedatabasetype');
			$source_table_prefix  	= $sessionobject->get_session_var('sourcetableprefix');

			$posts_start_at 		= $sessionobject->get_session_var('postsstartat');
			$posts_per_page 		= $sessionobject->get_session_var('postsperpage');

			$class_num				= substr(get_class($this) , -3);

			if(!$sessionobject->get_session_var($class_num . '_start'))
			{
				$sessionobject->timing($class_num,'start' ,$sessionobject->get_session_var('autosubmit'));
			}


			if(intval($posts_per_page) == 0)
			{
				$posts_per_page = 150;
			}

			$posts_array 			= $this->get_details($Db_source, $source_database_type, $source_table_prefix, $posts_start_at, $posts_per_page, 'post', 'postid');
			$thread_ids				= $this->get_threads_ids($Db_target, $target_database_type, $target_table_prefix);
			$users_ids 				= $this->get_user_ids($Db_target, $target_database_type, $target_table_prefix);
			$post_ids				= $this->get_posts_ids($Db_target, $target_database_type, $target_table_prefix);

			$last_pass = $sessionobject->get_session_var('last_pass');
			$displayobject->display_now("<h4>Importing " . count($posts_array) . " posts</h4><p><b>From</b> : " . $posts_start_at . " ::  <b>To</b> : " . ($posts_start_at + count($posts_array)) ."</p><p><b>Last pass took</b> : " . $last_pass . " seconds</p>");

			$start = time();

			$post_object = new ImpExData($Db_target, $sessionobject, 'post');

			foreach ($posts_array as $post_id => $details)
			{
				$try = $post_object;

				// Mandatory
				$try->set_value('mandatory', 'threadid',			$thread_ids["$details[threadid]"]);
				$try->set_value('mandatory', 'userid',				$users_ids["$details[userid]"]);
				$try->set_value('mandatory', 'importthreadid',		$details['threadid']);
/*
				// Non Mandatory
				if($details['parentid'] != '0')
				{
					if($post_ids["$details[parentid]"])
					{
						$try->set_value('nonmandatory', 'parentid', $post_ids["$details[parentid]"]);
					}
					else
					{
						$try->set_value('nonmandatory', 'parentid',	$this->get_post_parent_id($Db_target, $target_database_type, $target_table_prefix, $details['parentid']));
					}
				}
				else
				{
					$try->set_value('nonmandatory', 'parentid',		'0');
				}
*/
				$try->set_value('nonmandatory', 'username',			$details['username']);
				$try->set_value('nonmandatory', 'title',			$details['title']);
				$try->set_value('nonmandatory', 'dateline',			$details['dateline']);
				$try->set_value('nonmandatory', 'pagetext',			$details['pagetext']);
				$try->set_value('nonmandatory', 'allowsmilie',		$details['allowsmilie']);
				$try->set_value('nonmandatory', 'showsignature',	$details['showsignature']);
				$try->set_value('nonmandatory', 'ipaddress',		$details['ipaddress']);
				$try->set_value('nonmandatory', 'iconid',			$details['iconid']);
				$try->set_value('nonmandatory', 'visible',			$details['visible']);
				$try->set_value('nonmandatory', 'attach',			$details['attach']);
				$try->set_value('nonmandatory', 'importpostid',		$details['postid']);

				if($try->is_valid())
				{
					if($try->import_post($Db_target, $target_database_type, $target_table_prefix))
					{
						$displayobject->display_now("<br /><span class=\"isucc\"><b>" . $try->how_complete() . "%</b></span> :: Post from -> " . $try->get_value('nonmandatory','username'));
						$sessionobject->add_session_var($class_num . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
						$imported = true;
					}
					else
					{
						$sessionobject->add_error('warning',
												 $this->_modulestring,
												 get_class($this) . "::import_thread failed for " . $cat['cat_title'] . " get_vb32_categories_details was ok.",
												 'Check database permissions and user table');
						$sessionobject->set_session_var($class_num . '_objects_failed',$sessionobject->get_session_var($class_num. '_objects_failed') + 1 );
						$displayobject->display_now("<br />Got thread " . $cat['cat_title'] . " and <b>DID NOT</b> imported to the " . $target_database_type . " database");
					}
				}
				else
				{
					$displayobject->display_now("<br />Invalid post object, skipping." . $try->_failedon);
				}
				unset($try);
			}

			$the_end = time() - $start;
			$sessionobject->add_session_var('last_pass', $the_end);


			if (count($posts_array) == 0 OR count($posts_array) < $posts_per_page)
			{
				$displayobject->display_now('Updateing parent ids to allow for a threaded view....');


				$sessionobject->timing($class_num,'stop', $sessionobject->get_session_var('autosubmit'));
				$sessionobject->remove_session_var($class_num . '_start');

				$displayobject->update_html($displayobject->module_finished($this->_modulestring,
																			$sessionobject->return_stats($class_num, '_time_taken'),
																			$sessionobject->return_stats($class_num, '_objects_done'),
																			$sessionobject->return_stats($class_num, '_objects_failed')
																			));
				$sessionobject->set_session_var($class_num,'FINISHED');
				$sessionobject->set_session_var('posts','done');
				$sessionobject->set_session_var('module','000');
				$sessionobject->set_session_var('autosubmit','0');
				$displayobject->update_html($displayobject->print_redirect('index.php','1'));
			}
			else
			{
			$sessionobject->set_session_var('postsstartat',$posts_start_at+$posts_per_page);
			$displayobject->update_html($displayobject->print_redirect('index.php'));
			}
		}
		else
		{
			$displayobject->display_now('Going to the main page...');
			$displayobject->update_html($displayobject->print_redirect('index.php'));
		}
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: 13:19, Thu Oct 21st 2004
|| # CVS: $RCSfile: 009.php,v $ - $Revision: 1.2 $
|| ####################################################################
\*======================================================================*/
?>
