<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* eve_000
*
*
* @package 		ImpEx.eve
* @version		$Revision: 1.21 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/09/10 14:11:50 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class eve_000 extends ImpExModule
{
	/**
	* Supported version
	*
	* @var    string
	*/
	var $_version = '4.0x';

	/**
	* Module string
	*
	* @var    array
	*/
	var $_modulestring 	= 'Infopop eve';
	var $_homepage = 'http://www.infopop.com/eve_platform/index.php';


	/**
	* Valid Database Tables
	*
	* @var    array
	*/
	var $_valid_tables = array (
		'ACTIVITY_LOG', 'ACTIVITY_TYPES', 'APPLICATION_TEXT', 'AUTO_LINKS', 'AVATARS', 'BANNED_EMAILS', 'BANNED_IPS', 'BOARDS', 'CACHE',
		'CHARSETS', 'CONTENT_ISLANDS', 'CONTENT_SUBSCRIPTIONS', 'CURRENT_DB_VERSION', 'C_CATEGORIES', 'C_ITEMS', 'C_REVISIONS', 'C_REVISION_LOGS',
		'C_STAGING', 'C_TAGS', 'C_TAG_TO_REV_JOIN', 'DATABASE_INFO', 'DATABASE_LOCKS', 'D_FORUM_POST_COUNTS', 'D_FORUM_POST_TIMES', 'D_FORUM_TOPIC_COUNTS',
		'D_TOPIC_POST_COUNTS', 'D_TOPIC_POST_TIMES', 'D_USER_POST_COUNTS', 'D_USER_TYPES', 'FORUMS', 'FORUM_STATISTICS', 'GROUPS', 'GROUP_RIGHTS',
		'GROUP_TOPICS',	'GROUP_TOPIC_EVENTS', 'GROUP_TOPIC_PARTICIPANTS', 'IGNORED_USERS', 'IP_ALBUMS', 'IP_ALBUM_IMAGES', 'IP_ARCHIVED_TOPICS',
		'IP_BANNED_USERS', 'IP_CHAT_TOPICS', 'IP_CHAT_TOPIC_MESSAGES', 'IP_CHAT_TOPIC_UNMOD_QUEUE', 'IP_CLONE_SOURCE_AND_DEST', 'IP_CONTENT_SUBSCRIPTIONS',
		'IP_CUSTOM_CODES', 'IP_CUSTOM_PROFILE_FIELDS', 'IP_DISPLAY_OPTIONS', 'IP_DISPLAY_RESOURCES', 'IP_DISPLAY_RES_ASSOCIATIONS', 'IP_EVENT_LOG',
		'IP_GROUPS', 'IP_GROUP_USERS', 'IP_HIGHLIGHTED_TOPICS', 'IP_IGNORED_USERS', 'IP_IM_ACTIVE_MENUS', 'IP_IM_PARTICIPANTS', 'IP_INDEXED_WORDS',
		'IP_KARMA_LEVELS', 'IP_MESSAGE_ALERTS', 'IP_PERMISSIONS', 'IP_PREMIUM_GROUP_SETTINGS', 'IP_PROFILES', 'IP_RESOURCES', 'IP_RIGHTS', 'IP_RW_LOCKS',
		'IP_SESSION_ACTIVITY', 'IP_SETTINGS', 'IP_SITE_OC_SETTINGS', 'IP_SS_IMAGE_DIMENSIONS', 'IP_STATISTICS', 'IP_STREET_ADDRESSES', 'IP_STYLE_SETS',
		'IP_STYLE_SETTINGS', 'IP_TEMPLATE_FILES', 'IP_TEMPLATE_PAGE_TYPES', 'IP_TEMPLATE_SETS', 'IP_TEMPLATE_SET_USAGE', 'IP_TEMPLATE_SUPPORT_INFO',
		'IP_TOPICS', 'IP_UNCONFIRMED_USERS', 'IP_USERS', 'IP_USER_CONTACT_INFO', 'IP_USER_FAVORITES', 'IP_WORDLETS', 'IP_WORDLET_SETS', 'LANGS',
		'MESSAGES', 'POLLS', 'RIGHTS', 'RIGHT_SECURITY_LEVELS', 'SESSION_ACTIVITY_SETTINGS', 'SITES', 'SITE_EVENTS', 'SITE_REQ_TYPE_STATISTICS',
		'SITE_STATISTICS', 'SITE_USER_TYPES', 'STYLES', 'STYLES2', 'STYLES3', 'STYLE_SHEETS', 'STYLE_SHEET_TYPES', 'TEMP_GROUPS', 'TEMP_USER_GROUPS',
		'TOPIC_INFO', 'UNMOD_MESSAGE_QUEUE', 'UPLOADS', 'URL_LOOKUP', 'USERS', 'USER_CONTACTS', 'USER_GROUPS', 'USER_INFO', 'USER_INTEREST_LOG',
		'USER_STATISTICS', 'XFACE_OPTIONS_SETS', 'XFACE_OPTIONS_SET_ASSOC', 'XFACE_OPTIONS_SET_TYPES', 'XSL_SCHEMES'
	);


	/**
	* Constructor
	*
	* @return	none
	*/
	function eve_000()
	{
	}


	/**
	* Returns the userid to user name array
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	int		mixed			Start point
	* @param	int		mixed			End point
	*
	* @return	array
	*/
	function get_eve_members_list(&$Db_object, &$databasetype, &$tableprefix, &$start, &$per_page)
	{
		$return_array = array();

		// Check that there isn't a empty value
		if(empty($per_page)) { return $return_array; }

		if ($databasetype == 'mysql')
		{
			// TODO: ORDER BY to ensure consistant listings
			$user_list = $Db_object->query("SELECT USER_OID,USERNAME FROM " . $tableprefix . "USERS LIMIT " . $start . "," . $per_page);

			while ($user = $Db_object->fetch_array($user_list))
			{
					$tempArray = array($user['USER_OID'] => $user['USERNAME']);
					$return_array = $return_array + $tempArray;
			}
			return $return_array;
		}
		else
		{
			return false;
		}
	}


	/**
	* Returns the userid to user details array
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table prefix
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	int		mixed			Start point
	* @param	int		mixed			End point
	*
	* @return	array
	*/
	function get_eve_user_details(&$DB_object, &$database_type, &$table_prefix, &$user_start_at, &$user_per_page)
	{
		$return_array = array();

		// Check that there isn't a empty value
		if(empty($user_per_page)) { return $return_array; }


		if ($database_type == 'mysql')
		{
			if($this->check_table($DB_object, $database_type, $table_prefix, 'USERS'))
			{
				$users = $DB_object->query("
					SELECT *
					FROM {$table_prefix}USERS
					LIMIT $user_start_at, $user_per_page
				");

				while ($user = $DB_object->fetch_array($users))
				{
					// TODO: Should probally do something else with - IS_PRIMARY_ADMIN
					if($user['IS_ADMINISTRATOR'] == 'Y' OR $user['IS_PRIMARY_ADMIN'] == 'Y')
					{
						$user['USERGROUPID'] = 6;
					}
					else
					{
						$user['USERGROUPID'] = 2;
					}

					$return_array["$user[USER_OID]"] = $user;
				}
			}

			if(
				$this->check_table($DB_object, $database_type, $table_prefix, 'IP_USERS') AND
				$this->check_table($DB_object, $database_type, $table_prefix, 'IP_USER_CONTACT_INFO') AND
				$this->check_table($DB_object, $database_type, $table_prefix, 'IP_PROFILES')
				)
			{
				// Its the other nasty kind of dB so do the joined data bit.

				$users = $DB_object->query("
					SELECT *
					FROM {$table_prefix}IP_USERS
					ORDER BY USER_OID
					LIMIT $user_start_at, $user_per_page
				");

				while ($user = $DB_object->fetch_array($users))
				{
					$contact_details = $DB_object->query_first("
						SELECT CONTACT_INFO_ADDRESS
						FROM {$table_prefix}IP_USER_CONTACT_INFO
						WHERE CONTACT_INFO_TYPE = 'EMAIL'
						AND `USER_OID`
						LIKE '".$user['USER_OID']."'
					");

					$profile_details = $DB_object->query("
						SELECT * FROM {$table_prefix}IP_PROFILES
						WHERE USER_OID LIKE '".$user['USER_OID']."'
					");

					while ($line = $DB_object->fetch_array($profile_details))
					{
							$user[$name] = $line[$name];
					}


					$user['EMAIL'] = $contact_details[0];
					$user['USERNAME'] = $user['LOGIN'];

					$return_array["$user[USER_OID]"] = $user;
				}

			}


		}
		else
		{
			return false;
		}

		return $return_array;
	}



	/**
	* Imports a list with error handeling
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	object	displayobject	The display object
	* @param	object	sessionobject	The prefix to the table name i.e. 'vb3_'
	* @param	string	mixed			The type of list being imported
	* @param	array	mixed			The user ids to match up with the IP's etc
	*
	* @return	none
	*/
	function get_list(&$Db_object, &$database_type, &$table_prefix, $type, $user_ids_array = null)
	{
		$return_array = array();

		if ($database_type == 'mysql')
		{
			if($this->check_table($Db_object, $database_type, $table_prefix, 'USERS'))
			{
				if ($type == 'userid')
				{
					$ban_list = $Db_object->query("
						SELECT USER_OID
						FROM {$table_prefix}USERS
						WHERE IS_BANNED = 'Y'
					");

					while ($ban = $Db_object->fetch_array($ban_list))
					{
						$return_array["$ban[0]"] = $user_ids_array["$ban[0]"];
					}
					return $return_array;
				}
				else if ($type == 'ip')
				{
					$ban_list = $Db_object->query("
						SELECT users.IP_AT_REGISTRATION
						FROM {$table_prefix}USERS AS users, {$table_prefix}IP_BANNED_USERS AS ip_banned_users
						WHERE users.USER_OID = ip_banned_users.USER_OID;
					");

					while ($ban = $Db_object->fetch_array($ban_list))
					{
						$return_array["$ban[0]"] = $ban[0];
					}

					return $return_array;
				}
				else if ($type == 'email')
				{
					$ban_list = $Db_object->query("
						SELECT BANNED_EMAIL
						FROM {$table_prefix}BANNED_EMAILS
					");

					while ($ban = $Db_object->fetch_array($ban_list))
					{
						$return_array["$ban_list[BANNED_EMAIL]"] = $ban_list[0];
					}

					return $return_array;
				}
			}
		}
		else
		{
			return false;
		}
		return $return_array;
	}

	/**
	* Imports a list with error handeling
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	object	displayobject	The display object
	* @param	object	sessionobject	The prefix to the table name i.e. 'vb3_'
	* @param	array	mixed			The list to be imported
	* @param	string	mixed			The type of list being imported
	*
	* @return	none
	*/
	function do_list(&$Db_target, &$displayobject, &$sessionobject,$list,$type)
	{
		// TODO: boolean return type
		$result = $this->import_ban_list(
			$Db_target,
			$sessionobject->get_session_var('targetdatabasetype'),
			$sessionobject->get_session_var('targettableprefix'),
			$list,
			$type
		);

		if (!$result)
		{
			$sessionobject->add_session_var($class_num . '_objects_faild', intval($sessionobject->get_session_var($class_num . '_objects_failed')) + 1);
			$sessionobject->add_error(
				'warning',
				$this->_modulestring,
				$class_num . "::import_ban_list failed on $type - $list",
				"Check for format of the $type $list"
			);
			$displayobject->update_html("<b>There was an error with the import of the $type ban list.</b>");
		}
		else
		{
			$sessionobject->add_session_var($class_num . '_objects_done', intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1);
			$displayobject->update_html("<br /><b>$type</b> Ban list <i>imported.</i>");
		}
	}


	/**
	* Returns the style id to the style array
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	*
	* @return	array
	*/
	function get_eve_styles(&$DB_object, &$database_type, &$table_prefix)
	{
		$return_array = array();
		if ($database_type == 'mysql')
		{
			$styles = $DB_object->query("SELECT * FROM {$table_prefix}STYLES");
			while ($style = $DB_object->fetch_array($styles))
			{
				$return_array["$style[STYLE_OID]"] = $style;
			}
		}
		else
		{
			return false;
		}

		return $return_array;
	}


	/**
	* Returns the forum id to the forum details array
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	int		mixed			Start point
	* @param	int		mixed			End point
	*
	* @return	array
	*/
	function get_eve_forum_details(&$DB_object, &$database_type, &$table_prefix, &$forum_start_at, &$forum_per_page)
	{
		$return_array = array();

		// Check that there isn't a empty value
		if(empty($forum_per_page)) { return $return_array; }


		if ($database_type == 'mysql')
		{
			$forums = $DB_object->query("
				SELECT *
				FROM {$table_prefix}FORUMS
				WHERE FORUM_NAME != 'Private Messaging Forum'
				ORDER BY THREADING_ORDER
				LIMIT $forum_start_at, $forum_per_page
			");

			while ($forum = $DB_object->fetch_array($forums))
			{
				$return_array["$forum[FORUM_OID]"] = $forum;
			}
		}
		else
		{
			return false;
		}

		return $return_array;
	}


	/**
	* Returns the importedstyleid keyed to the vb styleid
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	*
	* @return	array
	*/
	function get_imported_eve_style_ids(&$DB_object, &$database_type, &$table_prefix)
	{
		// TODO: I'm sure this is or should be in the core some where !
		$return_array = array();

		if ($database_type == 'mysql')
		{
			$styles = $DB_object->query("
				SELECT importstyleid, styleid
				FROM {$table_prefix}style
			");

			while ($style = $DB_object->fetch_array($styles))
			{
				$return_array["$style[importstyleid]"] = $style['styleid'];
			}
		}
		else
		{
			return false;
		}

		return $return_array;
	}


	/**
	* Returns the parent forum id
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	string	mixed			The import forumid
	*
	* @return	string
	*/
	function get_eve_parent_forum_id(&$DB_object, &$database_type, &$table_prefix, &$import_forum_id)
	{
		$return_array = array();

		if ($database_type == 'mysql')
		{
			$forumid = $DB_object->query_first("
				SELECT forumid
				FROM {$table_prefix}forum
				WHERE importcategoryid = '$import_forum_id'
			");

			return $forumid['forumid'];
		}
		else
		{
			return false;
		}

		return $return_array;
	}


	/**
	* Returns the importedstyleid keyed to the vb styleid
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	string	mixed			The index (number) of the eve forum to get
	*
	* @return	array
	*/
	function get_eve_forum_id(&$DB_object, &$database_type, &$table_prefix, &$forum_get)
	{
		$return_array = array();
		if ($database_type == 'mysql')
		{
			$forum_id = $DB_object->query_first("
				SELECT FORUM_OID
				FROM {$table_prefix}FORUMS
				ORDER BY FORUM_OID ASC
				LIMIT $forum_get, 1
			");
			return $forum_id['FORUM_OID'];
		}
		else
		{
			return false;
		}

		return $return_array;
	}

	/**
	* Returns the thread details for an even thread
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	string	mixed			The forum id to return
	*
	* @return	array
	*/
	function get_eve_thread_details(&$DB_object, &$database_type, &$table_prefix, &$forum_id)
	{
		$return_array = array();
		if ($database_type == 'mysql')
		{
			$forums = $DB_object->query("
				SELECT TOPIC_MESSAGE_OID, REVERSE_TOPIC_INDEX
				FROM {$table_prefix}TOPIC_INFO
				WHERE FORUM_OID LIKE '$forum_id'
			");
			while ($forum = $DB_object->fetch_array($forums))
			{
				$return_array[$forum['REVERSE_TOPIC_INDEX']] = $this->get_eve_message_details($DB_object, $database_type, $table_prefix, $forum['TOPIC_MESSAGE_OID']);
			}
		}
		else
		{
			return false;
		}
		return $return_array;
	}

	/**
	* Returns an eve message
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	string	mixed			The message id to return
	*
	* @return	array
	*/
	function get_eve_message_details(&$DB_object, &$database_type, &$table_prefix, &$message_id)
	{
		$return_array = array();
		if ($database_type == 'mysql')
		{
			return $DB_object->query_first("
				SELECT *
				FROM {$table_prefix}MESSAGES
				WHERE MESSAGE_OID LIKE '$message_id'
			");

		}
		else
		{
			return false;
		}
		return $return_array;
	}


	/**
	* Returns the number of eve forums
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	*
	* @return	int
	*/
	function get_forum_number(&$DB_object, &$database_type, &$table_prefix)
	{
		$return_array = array();
		if ($database_type == 'mysql')
		{
			$number = $DB_object->query("SELECT DISTINCT FORUM_OID FROM {$table_prefix}FORUMS");
			return $DB_object->num_rows($number);
		}
		else
		{
			return false;
		}
		return $return_array;
	}


	/**
	* Returns the post for a given eve thread
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	string	mixed			The topic_message_oid to return (i.e. a thread)
	*
	* @return	array
	*/
	function get_eve_posts_details($DB_object, $database_type, $table_prefix, $thread_id)
	{
		$return_array = array();
		if ($database_type == 'mysql')
		{
			$posts = $DB_object->query("SELECT * FROM {$table_prefix}MESSAGES WHERE TOPIC_MESSAGE_OID = '$thread_id'");

			while ($post = $DB_object->fetch_array($posts))
			{
				$return_array["$post[MESSAGE_OID]"] = $post;
			}
		}
		else
		{
			return false;
		}

		return $return_array;
	}


	/**
	* Returns the thread ids
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	int		mixed			Start point
	* @param	int		mixed			End point
	*
	* @return	array
	*/
	function get_eve_thread_ids($DB_object, $database_type, $table_prefix, $forum_start_at, $forum_pre_page)
	{
		$return_array = array();

		// Check that there isn't a empty value
		#if(empty($forum_per_page)) { return $return_array; }


		if ($database_type == 'mysql')
		{

			$sql = "
				SELECT TOPIC_MESSAGE_OID
				FROM {$table_prefix}TOPIC_INFO
				ORDER BY  TOPIC_MESSAGE_OID
				LIMIT $forum_start_at, $forum_pre_page
			";
			$threads = $DB_object->query($sql);

			while ($thread = $DB_object->fetch_array($threads))
			{
				$return_array["$thread[TOPIC_MESSAGE_OID]"] = $thread['TOPIC_MESSAGE_OID'];
			}

		}
		else
		{
			return false;
		}

		return $return_array;
	}


	/**
	* Returns number of threads
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	*
	* @return	array
	*/
	function get_thread_number($DB_object, $database_type, $table_prefix)
	{
		$return_array = array();
		if ($database_type == 'mysql')
		{
			$number = $DB_object->query_first("SELECT COUNT(*) AS count FROM {$table_prefix}TOPIC_INFO");

			return $number['count'];
		}
		else
		{
			return false;
		}
		return $return_array;
	}


	/**
	* Parses eve html
	*
	* @param	string	mixed			The html to parse
	*
	* @return	string
	*/
	function eve_html($html)
	{
		// NOTE: Not a lot going on in here !
		return $html;
	}


	/**
	* Returns an array of eve polls
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	int		mixed			Start point
	* @param	int		mixed			End point
	*
	* @return	array
	*/
	function get_eve_polls_details(&$DB_object, &$database_type, &$table_prefix, &$poll_start_at, &$poll_per_page)
	{
		$return_array = array();

		// Check that there isn't a empty value
		if(empty($poll_per_page)) { return $return_array; }

		if ($database_type == 'mysql')
		{
			$poll_start_at = $this->iif($poll_start_at == '', '0', $poll_start_at);

			$polls = $DB_object->query("SELECT * FROM {$table_prefix}POLLS LIMIT $poll_start_at, $poll_per_page");

			while ($poll = $DB_object->fetch_array($polls))
			{
				$return_array["$poll[POLL_OID]"] = $poll;
			}
		}
		else
		{
			return false;
		}
		return $return_array;
	}


	/**
	* Returns the question text of an eve poll
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	string		mixed			Start point
	*
	* @return	array
	*/
	function get_eve_poll_question_text(&$DB_object, &$database_type, &$table_prefix, &$message_id)
	{
		$return_array = array();
		if ($database_type == 'mysql')
		{
			if($message_id === null)
			{
				return false;
			}

			$subject_text = $DB_object->query_first("
				SELECT SUBJECT
				FROM {$table_prefix}MESSAGES
				WHERE MESSAGE_OID = '$message_id'
			");

			return $subject_text['SUBJECT'];
		}
		else
		{
			return false;
		}
		return $return_array;
	}


	/**
	* Returns the reverse topic id to the topic_message_id from the  'Private Messaging Forum'
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	string	mixed			Start point
	* @param	string	mixed			End point
	*
	* @return	array
	*/
	function get_eve_pm_ids($Db_object, $database_type, $table_prefix, $pm_start_at, $pm_per_page)
	{
		$return_array = array();

		// Check that there isn't a empty value
		if(empty($pm_per_page)) { return $return_array; }


		if ($database_type == 'mysql')
		{
			#Get the forum id
			$sql = "SELECT * FROM " . $table_prefix . "FORUMS
					WHERE FORUM_NAME = 'Private Messaging Forum'";

			$pm_forum_id = $Db_object->query_first($sql);

			$sql = "SELECT * FROM " . $table_prefix . "TOPIC_INFO
					WHERE FORUM_OID = '" . $pm_forum_id['FORUM_OID'] . "'
					LIMIT " .
					$pm_start_at . "," . $pm_per_page
					;

			$pms = $Db_object->query($sql);

			while ($pm = $Db_object->fetch_array($pms))
			{
				$return_array["$pm[REVERSE_TOPIC_INDEX]"] = $pm['TOPIC_MESSAGE_OID'];
			}
		}
		else
		{
			return false;
		}
		return $return_array;
	}


	/**
	* Returns the text of an eve message
	*
	* @param	object	databaseobject	The database object to run the query against
	* @param	string	mixed			Table database type
	* @param	string	mixed			The prefix to the table name i.e. 'vb3_'
	* @param	string	mixed			Start point
	*
	* @return	array
	*/
	function get_eve_pm_text($DB_object, $database_type, $table_prefix, $pm_id)
	{
		if ($database_type == 'mysql')
		{
			$sql = "
			SELECT *
			FROM " . $table_prefix . "MESSAGES
			WHERE MESSAGE_OID = '" . $pm_id . "'"
			;

			$pms = $DB_object->query_first($sql);

			return $pms;
		}
		else
		{
			return false;
		}
		return $return_array;
	}

	function parse_eve_time($datestamp)
	{
		$datestamp = explode(' ',$datestamp);

		$year = $datestamp[0];
		$time = $datestamp[1];

		$year = explode('-', $year);
		$time = explode(':', $time);

		$new_time = mktime($time[0], $time[1], $time[2], $year[1], $year[2], $year[0]);

		$new_time = date("F j, Y, g:i a", $new_time);

		return $new_time;
	}

}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: [#]zeveuilddate[#]
|| # CVS: $RCSfile: 000.php,v $ - $Revision: 1.21 $
|| ####################################################################
\*======================================================================*/
?>
