<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* eve Import Styles
*
* The ubb users are stored in files with each lines corresponding to a
* diffrent values.
*
* @package 		ImpEx.eve
* @version		$Revision: 1.12 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/04/15 00:29:34 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class eve_005 extends eve_000
{
	var $_version		= '0.0.1';
	var $_dependent 	= '001';
	var $_modulestring 	= 'Import Styles';

	function eve_005()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject,$this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source, 'clear_imported_styles'))
				{
					$this->_restart = FALSE;
					$displayobject->display_now("<h4>Imported styles have been cleared</h4>");
				}
				else
				{
					$sessionobject->add_error(
						'fatal',
						$this->_modulestring,
						get_class($this) . "::restart failed , clear_styles",
						'Check database permissions and user table'
					);
				}
			}

			$displayobject->update_basic('title', 'Import styles');
			$displayobject->update_html($displayobject->do_form_header('index', substr(get_class($this), -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this), -3), 'WORKING'));
			$displayobject->update_html($displayobject->make_table_header('Import Style Settings'));
			$displayobject->update_html($displayobject->make_yesno_code("Import the styles", "importstyles", 1));

			$displayobject->update_html($displayobject->do_form_footer("Import Styles"));
		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index', ''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue', ''));
			$sessionobject->set_session_var(substr(get_class($this), -3), 'FALSE');
			$sessionobject->set_session_var('module', '000');
		}

	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$displayobject->update_basic('displaymodules', 'FALSE');
		if ($sessionobject->get_session_var('importstyles') == 1)
		{
			if(!$sessionobject->get_session_var(substr(get_class($this), -3) . '_start'))
			{
				$sessionobject->timing(substr(get_class($this), -3), 'start', $sessionobject->get_session_var('autosubmit'));
			}

			// Get the eve styles
			$get_styles_array  =  $this->get_eve_styles(
				$Db_source,
				$sessionobject->get_session_var('sourcedatabasetype'),
				$sessionobject->get_session_var('sourcetableprefix')
			);

			// Sort each one out
			foreach ($get_styles_array as $style_name => $style)
			{
				// Get a style array to fill up.
				$style_array = $this->return_style_array('all');

				$style_array["body"]["LINK_N"]["color"]			=	$style['FMT_COLOR_ACTIVE_LINK'];
				$style_array["body"]["LINK_M"]["color"]			=	$style['FMT_COLOR_ACTIVE_LINK'];
				$style_array["body"]["LINK_V"]["color"]			=	$style['FMT_COLOR_LINK'];

				$style_array["body"]["font"]["family"]			=	$style['FMT_FONT_FACE'];
				$style_array[".page"]["background"]				=	$style['FMT_COLOR_PAGE_BACK'];

				$style_array[".tcat"]["color"]					=	$style['FMT_COLOR_CATEGORY_STRIP_TEXT'];

				$style_array[".alt1"]["background"]["color"]	=	$style['FMT_COLOR_TABLE_FIRST_ROW'];
				$style_array[".alt2"]["background"]["color"]	=	$style['FMT_COLOR_TABLE_SECOND_ROW'];

				$style_array["th"]["background"]				=	$style['FMT_COLOR_TABLE_HDR_STRIP_BACK'];
				$style_array["th"]["color"]						=	$style['FMT_COLOR_TABLE_HDR_STRIP_TEXT'];

				$style_array[".tborder"]["color"]				=	$style['FMT_COLOR_TABLE_BORDER'];
				$style_array[".time"]["color"]					=	$style['FMT_COLOR_TIME'];

						/*
						FMT_COLOR_BB_TITLE: #c77100
						FMT_COLOR_CATEGORY_STRIP_BACK: #000002

						FMT_COLOR_COPYRIGHT_TEXT: #f5f5f5

						FMT_COLOR_TEXT: #d5d4d4
						*/

				if($this->import_style_array(
					$Db_target,
					$sessionobject->get_session_var('sourcedatabasetype'),
					$sessionobject->get_session_var('sourcetableprefix'),
					$style_array
				))
				{
					$displayobject->display_now("\n<br /><b>Imported</b> - style " . $style['STYLE_NAME'] . "  <b>OK</b>");
					$sessionobject->add_session_var(substr(get_class($this), -3) . '_objects_done', intval($sessionobject->get_session_var(substr(get_class($this), -3) . '_objects_done')) + 1);
				}
				else
				{
					$displayobject->display_now("\n<br /><b>Found</b> - style <b>" . $theme['template_name'] . "</b> but <i>NOT</i> imported.");
					$sessionobject->set_session_var(substr(get_class($this), -3) . '_objects_failed', $sessionobject->get_session_var(substr(get_class($this) , -3) . '_objects_failed') + 1);
					$sessionobject->add_error(
						'warning',
						$this->_modulestring,
						get_class($this) . "::failed importing style",
						'Check array mappings and dB table is not corrupt'
					);
				}
			}

			$sessionobject->timing(substr(get_class($this), -3), 'stop', $sessionobject->get_session_var('autosubmit'));
			$sessionobject->remove_session_var(substr(get_class($this), -3) . '_start');

			$displayobject->update_html($displayobject->module_finished(
				$this->_modulestring,
				$sessionobject->return_stats(substr(get_class($this) , -3),'_time_taken'),
				$sessionobject->return_stats(substr(get_class($this) , -3),'_objects_done'),
				$sessionobject->return_stats(substr(get_class($this) , -3),'_objects_failed')
			));

			$displayobject->update_html($displayobject->make_hidden_code('importstyles', 'done'));
			$sessionobject->set_session_var(substr(get_class($this), -3), 'FINISHED');
			$sessionobject->set_session_var('module', '000');
			$displayobject->update_html($displayobject->print_redirect('index.php', '2'));

			/*
			$sessionobject->set_session_var('importstyles','done');
			$sessionobject->set_session_var(substr(get_class($this) , -3),'FINISHED');
			$sessionobject->set_session_var('module','000');
			echo "<h1>substr(get_class($this) , -3)</h1>";
			$displayobject->update_html($displayobject->print_redirect('index.php','2'));
			*/
		}
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: [#]zeveuilddate[#]
|| # CVS: $RCSfile: 005.php,v $ - $Revision: 1.12 $
|| ####################################################################
\*======================================================================*/
?>
