<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* eve Import Forums
*
* The ubb users are stored in files with each lines corresponding to a
* diffrent values.
*
* @package 		ImpEx.eve
* @version		$Revision: 1.20 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/06/15 15:57:00 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class eve_006 extends eve_000
{
	var $_version 		= '0.0.1';
	var $_dependent 	= '003';
	var $_modulestring 	= 'Import Forums';

	function eve_006()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject,$this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source, 'clear_imported_forums'))
				{
					$this->_restart = FALSE;
					$displayobject->display_now("<h4>Imported Forums have been cleared</h4>");
					// TODO: Categories
				}
				else
				{
					$sessionobject->add_error(
						'fatal',
						$this->_modulestring,
						substr(get_class($this), -3) . "::restart failed , clear_imported_forums",
						'Check database permissions and user table'
					);
				}
			}

			$displayobject->update_basic('title', 'Import forums');
			$displayobject->update_html($displayobject->do_form_header('index', substr(get_class($this), -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this), -3), 'WORKING'));
			$displayobject->update_html($displayobject->make_table_header('Import Forums'));
			$displayobject->update_html($displayobject->make_hidden_code('forums', 'working'));
			$displayobject->update_html($displayobject->make_description("<p>Import the EVE forums.</p>"));

			$displayobject->update_html($displayobject->make_input_code('Forums to import per cycle (must be greater than 1)', 'forumsperpage', 10));

			$displayobject->update_html($displayobject->do_form_footer('Import Forums'));

			$sessionobject->add_session_var('forumsstartat', '0');

		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index', ''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue', ''));
			$sessionobject->set_session_var(substr(get_class($this), -3), 'FALSE');
			$sessionobject->set_session_var('module', '000');
		}

	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		// Set up working variables.
		$displayobject->update_basic('displaymodules', 'FALSE');
		$target_database_type = $sessionobject->get_session_var('targetdatabasetype');
		$target_table_prefix  = $sessionobject->get_session_var('targettableprefix');

		$source_database_type = $sessionobject->get_session_var('sourcedatabasetype');
		$source_table_prefix  = $sessionobject->get_session_var('sourcetableprefix');

		$forum_start_at = $sessionobject->get_session_var('forumsstartat');
		$forum_per_page = $sessionobject->get_session_var('forumsperpage');

		$class_num		= substr(get_class($this), -3);

		$displayobject->update_basic('displaymodules', 'FALSE');

		if(!$sessionobject->get_session_var($class_num . '_start'))
		{
			$sessionobject->timing($class_num, 'start', $sessionobject->get_session_var('autosubmit'));
		}

		// Get the details and some refrence arrays
		$forum_array  	=  $this->get_eve_forum_details($Db_source, $source_database_type, $source_table_prefix, $forum_start_at, $forum_per_page);
		$styles_array  	=  $this->get_imported_eve_style_ids($Db_target, $target_database_type, $target_table_prefix);

		$to = $forum_start_at + count($forum_array);
		$displayobject->display_now("<h4>Importing " . count($forum_array) . " forums</h4><p><b>From</b> : " . $forum_start_at . " ::  <b>To</b> : " . $to ."</p>");

		foreach ($forum_array as $forum_id => $forum)
		{

			$try = new ImpExData($Db_target, $sessionobject,'forum');

			if($forum['SUPER_FORUM_OID'])
			{
				$try->set_value('mandatory', 'parentid', $this->get_eve_parent_forum_id($Db_target, $target_database_type, $target_table_prefix, $forum['SUPER_FORUM_OID']));

			}
			else
			{
				$try->set_value('mandatory', 'parentid', '-1');
			}

			// Its a forum
			if($try->get_value('mandatory', 'parentid') != '-1')
			{
				$try->set_value('mandatory', 'title', 				$forum['FORUM_NAME']);

				$try->set_value('mandatory', 'displayorder',		intval(substr($forum['THREADING_ORDER'], 6, 12)) + 1);
				$try->set_value('mandatory', 'importforumid',		$forum_id);
				$try->set_value('mandatory', 'importcategoryid',	'0');
				$try->set_value('nonmandatory', 'styleid',			$styles_array["$forum[STYLE_OID]"]);
				$try->set_value('nonmandatory', 'description', 		$forum['FORUM_DESCRIPTION']);

				/*
				$try->set_value('nonmandatory', 'replycount','');
				$try->set_value('nonmandatory', 'lastpost','');
				$try->set_value('nonmandatory', 'lastposter','');	// TODO: LATEST_FORUM_POST_OID
				$try->set_value('nonmandatory', 'lastthread','');
				$try->set_value('nonmandatory', 'lastthreadid','');	// TODO: LATEST_FORUM_TOPIC_OID
				$try->set_value('nonmandatory', 'lasticonid','');
				$try->set_value('nonmandatory', 'threadcount','');
				$try->set_value('nonmandatory', 'daysprune','');
				$try->set_value('nonmandatory', 'newpostemail','');
				$try->set_value('nonmandatory', 'newthreademail','');
				$try->set_value('nonmandatory', 'parentlist','');
				$try->set_value('nonmandatory', 'password','');
				$try->set_value('nonmandatory', 'link','');
				$try->set_value('nonmandatory', 'childlist','');
				*/

				if($try->is_valid())
				{
					if($try->import_forum($Db_target, $target_database_type, $target_table_prefix))
					{
						$displayobject->display_now("<br /><span class=\"isucc\"><b>" . $try->how_complete() . "%</b></span> :: FORUM - " . $try->get_value('mandatory', 'title'));
						$sessionobject->add_session_var($class_num  . '_objects_done', intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1);
					}
					else
					{
						$sessionobject->add_error(
							'warning',
							$this->_modulestring,
							get_class($this) . "::import_category failed for " . $cat['cat_title'] . " get_phpbb2_categories_details was ok.",
							'Check database permissions and user table'
						);
						$sessionobject->set_session_var($class_num. '_objects_failed', $sessionobject->get_session_var($class_num . '_objects_failed') + 1);
						$displayobject->display_now("<br />Got category " . $cat['cat_title'] . " and <b>DID NOT</b> imported to the " . $target_database_type . " database");
					}
				}
				else
				{
					$displayobject->display_now("<br />Invalid object, skipping." . $try->_failedon);
				}
			}
			else
			{
				// Its a category
				$try->set_value('mandatory', 'title', 			$forum['FORUM_NAME']);
				$try->set_value('mandatory', 'displayorder',	intval(substr($forum['THREADING_ORDER'], 6, 12))+1);
				$try->set_value('mandatory', 'parentid',		'-1');
				$try->set_value('mandatory', 'importforumid',	'NULL');
				$try->set_value('mandatory', 'importcategoryid', $forum_id);

				$try->set_value('nonmandatory', 'description', $forum['FORUM_DESCRIPTION']);


				if($try->import_category($Db_target, $target_database_type, $target_table_prefix))
				{
					$displayobject->display_now("<br /><span class=\"isucc\"><b>" . $try->how_complete() . "%</b></span> :: CATEGORY - " . $try->get_value('mandatory', 'title'));
					$sessionobject->add_session_var($class_num  . '_objects_done', intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1);

				}
				else
				{
					$sessionobject->add_error(
						'warning',
						$this->_modulestring,
						get_class($this) . "::import_category failed for " . $cat['cat_title'] . " get_phpbb2_categories_details was ok.",
						'Check database permissions and user table'
					);
					$sessionobject->set_session_var($class_num. '_objects_failed', $sessionobject->get_session_var($class_num . '_objects_failed') + 1);
					$displayobject->display_now("<br />Got category " . $cat['cat_title'] . " and <b>DID NOT</b> imported to the " . $target_database_type . " database");
				}
			}
			unset($try);
		}


			/* Eve
				// TODO:

				CONVERT_SMILIE_TO_GRAPHIC
				USE_CHRONOLOGICAL_TOPIC_ORDER - threading
				FORUM_INTRO

				Permissions
			-----------------------------
			IS_MESSAGE_FEEDBACK_ENABLED
			IS_SHOWING_MESSAGE_VIEW_COUNTS
			IS_FORUM_ENABLED
			IS_FORUM_READ_ONLY
			IS_UBB_CODE_ALLOWED
			IS_UBB_CODE_IMAGES_ALLOWED
			IS_TOPICS_ALLOWED
			IS_TOPICS_MODERATED
			IS_REPLIES_MODERATED
			IS_ATTACHMENTS_MODERATED
			IS_SIGNATURE_ENABLED
			IS_ICON_POSTING_ENABLED
			ACCEPTED_POST_TYPES
			IS_TOPIC_LEAD_ENABLED
			IS_MESSAGE_ATTACHMENT_ALLOWED
			IS_IMAGE_SHOWN_WITH_POSTS
			IS_ANY_ATTACHMENT_ALLOWED
			IS_IMAGE_ATTACHMENT_ALLOWED
			IS_ZIP_ATTACHMENT_ALLOWED
			IS_TEXT_ATTACHMENT_ALLOWED
			ATTACHMENT_BYTE_LIMIT
			IS_USER_ABLE_TO_DELETE
			IS_USER_ABLE_TO_CLOSE_TOPICS
			ENABLE_T_NOTIF_FOR_AUTHORS
			IS_AUTO_LINKING_POSTS
			MAX_TOPICS_PER_PAGE
			MAX_MESSAGES_PER_PAGE

				Settings
			-----------------------------
			ORDER_TOPICS_BY_TOPIC_POST
			FORUM_CREATED_BY_USER_OID
			IS_HTML_ENABLED
			DATE_FORUM_CREATED

				Moderators
			-----------------------------
			MODERATOR_1_OID
			MODERATOR_2_OID
			MODERATOR_3_OID
			MODERATOR_4_OID
			FORUM_KEY_WORDS
			FORUM_CATEGORIES

				Not used
			-----------------------------
			USE_INLINE_FRAME_ON_REPLY
			FORUM_CUSTOM_1
			FORUM_CUSTOM_2
			FORUM_CUSTOM_3
			FORUM_CUSTOM_4
			IMG_FORUM_GRAPHIC_URL
			IMG_FORUM_GRAPHIC_W
			IMG_FORUM_GRAPHIC_H
			FORUM_TYPE
			IS_MODERATION_LIVE
			MODERATED_CONTENT_TYPES
			*/

			if (count($forum_array) == 0 OR count($forum_array) < $forum_per_page)
			{
				// Have to update the parent_id's from the SUPER_FORUM_OID into the vB_forum id
				$this->build_forum_child_lists($Db_target, $target_database_type, $target_table_prefix);

				$sessionobject->timing($class_num, 'stop', $sessionobject->get_session_var('autosubmit'));
				$sessionobject->remove_session_var($class_num . '_start');

				$displayobject->update_html($displayobject->module_finished(
					$this->_modulestring,
					$sessionobject->return_stats($class_num ,'_time_taken'),
					$sessionobject->return_stats($class_num ,'_objects_done'),
					$sessionobject->return_stats($class_num ,'_objects_failed')
				));

				$sessionobject->set_session_var($class_num, 'FINISHED');
				$sessionobject->set_session_var('forums', 'done');
				$sessionobject->set_session_var('module', '000');
				$sessionobject->set_session_var('autosubmit', '0');
			}


		$sessionobject->set_session_var('forumsstartat', $forum_start_at + $forum_per_page);
		$displayobject->update_html($displayobject->print_redirect('index.php', '1'));
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: [#]zeveuilddate[#]
|| # CVS: $RCSfile: 006.php,v $ - $Revision: 1.20 $
|| ####################################################################
\*======================================================================*/
?>
