<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* ipb Import Posts
*
*
* @package 		ImpEx.ipb
* @version		$Revision: 1.16 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/06/29 12:13:25 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class ipb_008 extends ipb_000
{
	var $_version 		= '0.0.1';
	var $_dependent 	= '007';
	var $_modulestring 	= 'Import Posts';

	function ipb_008()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject,$this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source,'clear_imported_posts'))
				{
					$this->_restart = FALSE;
					$displayobject->display_now("<h4>Imported Posts have been cleared</h4>");
				}
				else
				{
					$sessionobject->add_error('fatal',
											 $this->_modulestring,
											 get_class($this) . "::restart failed , clear_imported_posts",
											 'Check database permissions and user table');
				}
			}
			$displayobject->update_basic('title','Import posts');
			$displayobject->update_html($displayobject->do_form_header('index',substr(get_class($this), -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this), -3),'WORKING'));
			$displayobject->update_html($displayobject->make_hidden_code('posts','working'));
			$displayobject->update_html($displayobject->make_table_header('Import Posts'));
			$displayobject->update_html($displayobject->make_description("<p>The importer will now start to import posts from your IPB board. Depending on the size of your board, this may take some time.</p>"));
			$displayobject->update_html($displayobject->make_input_code("Number of threads worth of posts to import per cycle","postsperpage","500"));
			$displayobject->update_html($displayobject->do_form_footer("Import posts"));


			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_done', '0');
			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_failed', '0');


			$sessionobject->add_session_var('poststartat','0');
		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index',''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue',''));
			$sessionobject->set_session_var(substr(get_class($this), -3),'FALSE');
			$sessionobject->set_session_var('module','000');
		}
	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$displayobject->update_basic('displaymodules','FALSE');
		// Set up working variables.
		$target_database_type 	= $sessionobject->get_session_var('targetdatabasetype');
		$target_table_prefix  	= $sessionobject->get_session_var('targettableprefix');

		$source_database_type 	= $sessionobject->get_session_var('sourcedatabasetype');
		$source_table_prefix  	= $sessionobject->get_session_var('sourcetableprefix');

		// Called this, though it is actuall the number of threads "worth" of posts per page.
		$post_start_at 			= $sessionobject->get_session_var('poststartat');
		$posts_per_page 		= $sessionobject->get_session_var('postsperpage');

		$class_num				= substr(get_class($this), -3);

		if(!$sessionobject->get_session_var($class_num . '_start'))
		{
			$sessionobject->timing($class_num,'start' ,$sessionobject->get_session_var('autosubmit'));
		}

		if(intval($posts_per_page) == 0)
		{
			$posts_per_page = 500;
		}

		$posts_array			= $this->get_ipb_posts_details($Db_source, $source_database_type, $source_table_prefix, $post_start_at, $posts_per_page);
		$thread_ids				= $this->get_threads_ids($Db_target, $target_database_type, $target_table_prefix);
		$users_ids 				= $this->get_user_ids($Db_target, $target_database_type, $target_table_prefix);


		$displayobject->display_now("<h4>Importing " . count($posts_array) . " posts</h4><p><b>From</b> : " . $post_start_at . " ::  <b>To</b> : " . ($post_start_at + count($posts_array)) ."</p>");
		if($sessionobject->get_session_var('last_pass'))
		{
			$displayobject->display_now("<b>Last pass took " . $sessionobject->get_session_var('last_pass') . " seconds</b><br />");
		}


		$start = time();
		$post_object = new ImpExData($Db_target,$sessionobject,'post');

		foreach($posts_array as $post_id => $post)
		{
			$try = $post_object;

			$try->set_value('mandatory', 'threadid', 			$thread_ids[$post['topic_id']]);
			$try->set_value('mandatory', 'userid', 				$users_ids[$post['author_id']]);
			$try->set_value('mandatory', 'importthreadid', 		$post['topic_id']);

			$try->set_value('nonmandatory', 'importpostid',		$post_id);
			$try->set_value('nonmandatory', 'dateline',			$post['post_date']);
			$try->set_value('nonmandatory', 'showsignature', 	$post['use_sig']);
			$try->set_value('nonmandatory', 'username', 		$post['author_name']);
			$try->set_value('nonmandatory', 'allowsmilie',		$post['use_emo']);
			$try->set_value('nonmandatory', 'ipaddress',		$post['ip_address']);
			$try->set_value('nonmandatory', 'pagetext', 		$this->html_2_bb($this->ipb_html($post['post'])));
			if(!$page_text['post_title'])
			{
				$try->set_value('nonmandatory', 'title', 			$page_text['post_title']);
			}

			$try->set_value('nonmandatory', 'visible',			'1');

			// This is the IPB icon id, need the vB equiv
			#$try->set_value('nonmandatory', 'iconid',			$post['icon_id']);

			/*
			$try->set_value('nonmandatory', 'attach',);


			// TODO: This goes else where
			edit_time  int(10)   Yes  NULL
			new_topic  tinyint(1)   Yes  0
			edit_name  varchar(255)   Yes  NULL


			append_edit  tinyint(1)   Yes  0
			attach_id  varchar(64)   Yes  NULL
			attach_hits  int(10)   Yes  NULL
			attach_type  varchar(128)   Yes  NULL
			attach_file  varchar(255)   Yes  NULL


			??
			queued  tinyint(1)   Yes  NULL


			//Not needed
			forum_id  smallint(5)   No  0
			*/

			if($try->is_valid())
			{
				if($try->import_post($Db_target,$target_database_type,$target_table_prefix))
				{
					// Get the post id with the thread order, because the children will need it

					$displayobject->display_now("<br /><span class=\"isucc\"><b>" . $try->how_complete() . "%</b></span> :: Post from -> " . $try->get_value('nonmandatory','username'));
					$sessionobject->add_session_var($class_num . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
					$imported = true;
				}
				else
				{
					$sessionobject->add_error('warning',
											 $this->_modulestring,
											 get_class($this) . "::import_post failed for " . $post['author_name'],
											 'Check database permissions and user table');
					$sessionobject->set_session_var($class_num . '_objects_failed',$sessionobject->get_session_var($class_num. '_objects_failed') + 1 );
					$displayobject->display_now("<br />Got post " . $post['author_name'] . " and <b>DID NOT</b> imported to the " . $target_database_type . " database");
				}
			}
			else
			{
				$displayobject->display_now("<br />Invalid object, skipping.");
			}
			unset($try);
		}



		$the_end = time() - $start;
		$sessionobject->add_session_var('last_pass', $the_end);

		if (count($posts_array) == 0 OR count($posts_array) < $posts_per_page)
		{
			$displayobject->display_now('Updateing parent ids to allow for a threaded view....');

			if ($this->update_post_parent_ids($Db_target,$target_database_type,$target_table_prefix))
			{
				$displayobject->display_now('Done !');
			}
			else
			{
				$displayobject->display_now('Error updating parent ids');
			}


			$sessionobject->timing($class_num,'stop', $sessionobject->get_session_var('autosubmit'));
			$sessionobject->remove_session_var($class_num . '_start');

			$displayobject->update_html($displayobject->module_finished($this->_modulestring,
																		$sessionobject->return_stats($class_num, '_time_taken'),
																		$sessionobject->return_stats($class_num, '_objects_done'),
																		$sessionobject->return_stats($class_num, '_objects_failed')
																		));

			$sessionobject->set_session_var($class_num, 'FINISHED');
			$sessionobject->set_session_var('posts','done');
			$sessionobject->set_session_var('module','000');
			$sessionobject->set_session_var('autosubmit','0');
		}
		$sessionobject->add_session_var('poststartat',$post_start_at+$posts_per_page);
		$displayobject->update_html($displayobject->print_redirect('index.php'));
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: [#]zeveuilddate[#]
|| # CVS: $RCSfile: 008.php,v $ - $Revision: 1.16 $
|| ####################################################################
\*======================================================================*/
?>
