<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* phpBB2 Import Styles
*
* @package 		ImpEx.phpBB2
* @version		$Revision: 1.12 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout		$Name:  $
* @date 		$Date: 2004/04/22 13:23:35 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class phpBB2_005 extends phpBB2_000
{
	var $_version		= '0.0.1';
	var $_dependent 	= '001';
	var $_modulestring 	= 'Import Styles';

	function phpBB2_005()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject,$this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source, 'clear_imported_styles'))
				{
					$this->_restart = FALSE;
					$displayobject->display_now("<h4>Imported Styles have been cleared</h4>");
				}
				else
				{
					$sessionobject->add_error('fatal',
											 $this->_modulestring,
											 get_class($this) . "::restart failed , clear_styles",
											 'Check database permissions and user table');
				}
			}

			$displayobject->update_basic('title','Import styles');
			$displayobject->update_html($displayobject->do_form_header('index',substr(get_class($this) , -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this) , -3),'WORKING'));
			$displayobject->update_html($displayobject->make_table_header('Import Style Settings'));
			$displayobject->update_html($displayobject->make_yesno_code("Import the styles","importstyles",1));

			$displayobject->update_html($displayobject->do_form_footer("Import Styles"));


			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_done', '0');
			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_failed', '0');
		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index',''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue',''));
			$sessionobject->set_session_var(substr(get_class($this) , -3),'FALSE');
			$sessionobject->set_session_var('module','000');
		}

	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$displayobject->update_basic('displaymodules','FALSE');
		if ($sessionobject->get_session_var('importstyles') == 1)
		{
			// Set up working variables.
			$displayobject->update_basic('displaymodules','FALSE');
			$target_database_type	= $sessionobject->get_session_var('targetdatabasetype');
			$target_table_prefix	= $sessionobject->get_session_var('targettableprefix');

			$source_database_type	= $sessionobject->get_session_var('sourcedatabasetype');
			$source_table_prefix	= $sessionobject->get_session_var('sourcetableprefix');

			$class_num				= substr(get_class($this) , -3);

			if(!$sessionobject->get_session_var($class_num . '_start'))
			{
				$sessionobject->timing($class_num, 'start' ,$sessionobject->get_session_var('autosubmit'));
			}


			// Get the phpBB styles
			$styles_array  =  $this->get_phpbb_styles($Db_source, $source_database_type, $source_table_prefix);

			// Sort each one out
			foreach ($styles_array as $theme_id => $theme)
			{
				// Get a style array to fill up.
				$style_array = $this->return_style_array('all');

				// Don't know if we are going to need these.

				$theme['template_name'];
				$theme['style_name'];
				$theme['head_stylesheet'];
				$theme['img_size_poll'];
				$theme['img_size_privmsg'];

				// Mappings so far

				$style_array['body']['background']		=	$theme['body_background'];		//
				$style_array['body']['color']			=	$theme['body_bgcolor'];			// E5E5E5

				$theme['body_text'];														// 000000
				$theme['body_link'];														// 006699

				$style_array['body']['LINK_V']['color']	=	$theme['body_vlink'];			// 5493B4
				$style_array['body']['LINK_N']['color']	=	$theme['body_alink'];			//
				$style_array['body']['LINK_M']['color']	=	$theme['body_hlink'];			// DD6900

				$theme['tr_color1'];														// EFEFEF
				$theme['tr_color2'];														// DEE3E7
				$theme['tr_color3'];														// D1D7DC

				$theme['tr_class1'];
				$theme['tr_class2'];
				$theme['tr_class3'];

				$style_array['body']['color']			=	$theme['th_color1'];			// 98AAB1
				$theme['th_color2'];														// 006699
				$theme['th_color3'];														// FFFFFF

				$theme['th_class1'];														// cellpic1.gif
				$theme['th_class2'];														// cellpic3.gif
				$theme['th_class3'];														// cellpic2.jpg

				$style_array['td']['color']				= 	$theme['td_color1'];			// FAFAFA
				$theme['td_color2'];														// FFFFFF
				$theme['td_color3'];

				$theme['td_class1'];														// row1
				$theme['td_class2'];														// row2
				$theme['td_class3'];

				$style_array['body']['font']['family']	=	$theme['fontface1'];			// Verdana, Arial, Helvetica, sans-serif
				$theme['fontface2'];														// Trebuchet MS
				$theme['fontface3'];														// Courier, 'Courier New', sans-serif

				$theme['fontsize1'];														// 10
				$theme['fontsize2'];														// 11
				$theme['fontsize3'];														// 12

				$theme['fontcolor1'];														// 444444
				$theme['fontcolor2'];														// 006600
				$theme['fontcolor3'];														// FFA34F

				$theme['span_class1'];
				$theme['span_class2'];
				$theme['span_class3'];


				if($this->import_style_array($Db_target,
											 $sessionobject->get_session_var('sourcedatabasetype'),
											 $sessionobject->get_session_var('sourcetableprefix'),
											 $style_array))
				{
					$displayobject->display_now("\n<br /><b>Imported</b> - style " . $theme['template_name'] . " <b>OK</b>");
					$sessionobject->add_session_var($class_num . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
				}
				else
				{
					$displayobject->display_now("\n<br /><b>Found</b> - style <b>" . $theme['template_name'] . "</b> but <i>NOT</i> imported.");
					$sessionobject->set_session_var($class_num . '_objects_failed',$sessionobject->get_session_var($class_num . '_objects_failed') + 1 );
					$sessionobject->add_error('warning',
											 $this->_modulestring,
											 get_class($this) . "::failed importing style",
											 'Check array mappings and dB table is not corrupt');
				}
				unset($style_array);
			}



			$sessionobject->timing($class_num, 'stop', $sessionobject->get_session_var('autosubmit'));
			$sessionobject->remove_session_var($class_num . '_start');

			$displayobject->update_html($displayobject->module_finished($this->_modulestring,
																		$sessionobject->return_stats($class_num, '_time_taken'),
																		$sessionobject->return_stats($class_num, '_objects_done'),
																		$sessionobject->return_stats($class_num, '_objects_failed')
																		));

			$displayobject->update_html($displayobject->make_hidden_code('importstyles','done'));
			$sessionobject->set_session_var($class_num,'FINISHED');
			$sessionobject->set_session_var('module','000');
			$displayobject->update_html($displayobject->print_redirect('index.php','2'));
		}
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: 13:19, Thu Oct 21st 2004
|| # CVS: $RCSfile: 005.php,v $ - $Revision: 1.12 $
|| ####################################################################
\*======================================================================*/
?>
