<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* snitz_003 Import User module
*
* @package			ImpEx.snitz
* @version			$Revision: 1.5 $
* @author			Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout		$Name:  $
* @date				$Date: 2004/09/30 07:41:36 $
* @copyright		http://www.vbulletin.com/license.html
*
*/
class snitz_003 extends snitz_000
{
	var $_version 		= '0.0.1';
	var $_dependent 	= '001';
	var $_modulestring 	= 'Import User';


	function snitz_003()
	{
		// Constructor
	}


	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		if ($this->check_order($sessionobject,$this->_dependent))
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source,'clear_imported_users'))
				{
					$displayobject->display_now('<h4>Imported users have been cleared</h4>');
					$this->_restart = true;
				}
				else
				{
					$sessionobject->add_error('fatal',
											 $this->_modulestring,
											 get_class($this) . '::restart failed , clear_imported_users','Check database permissions');
				}
			}


			// Start up the table
			$displayobject->update_basic('title','Import User');
			$displayobject->update_html($displayobject->do_form_header('index',substr(get_class($this) , -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this) , -3),'WORKING'));
			$displayobject->update_html($displayobject->make_hidden_code('import_user','working'));
			$displayobject->update_html($displayobject->make_table_header($this->_modulestring));


			// Ask some questions
			$displayobject->update_html($displayobject->make_input_code('Users to import per cycle (must be greater than 1)','userperpage',500));


			// End the table
			$displayobject->update_html($displayobject->do_form_footer('Continue','Reset'));


			// Reset/Setup counters for this
			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_done', '0');
			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_failed', '0');
			$sessionobject->add_session_var('userstartat','0');
			$sessionobject->add_session_var('userdone','0');
		}
		else
		{
			// Dependant has not been run
			$displayobject->update_html($displayobject->do_form_header('index',''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue',''));
			$sessionobject->set_session_var(substr(get_class($this) , -3),'FALSE');
			$sessionobject->set_session_var('module','000');
		}
	}


	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		// Set up working variables.
		$displayobject->update_basic('displaymodules','FALSE');
		$target_database_type	= $sessionobject->get_session_var('targetdatabasetype');
		$target_table_prefix	= $sessionobject->get_session_var('targettableprefix');
		$source_database_type	= $sessionobject->get_session_var('sourcedatabasetype');
		$source_table_prefix	= $sessionobject->get_session_var('sourcetableprefix');


		// Per page vars
		$user_start_at			= $sessionobject->get_session_var('userstartat');
		$user_per_page			= $sessionobject->get_session_var('userperpage');
		$class_num				= substr(get_class($this) , -3);


		// Start the timing
		if(!$sessionobject->get_session_var($class_num . '_start'))
		{
			$sessionobject->timing($class_num ,'start' ,$sessionobject->get_session_var('autosubmit'));
		}


		// Get an array of user details
		$user_array 	= $this->get_snitz_user_details($Db_source, $source_database_type, $source_table_prefix, $user_start_at, $user_per_page);


		$user_group_ids_array = $this->get_imported_group_ids($Db_target, $target_database_type, $target_table_prefix);


		// Display count and pass time
		$displayobject->display_now('<h4>Importing ' . count($user_array) . ' users</h4><p><b>From</b> : ' . $user_start_at . ' ::  <b>To</b> : ' . ($user_start_at + count($user_array)) . '</p>');


		$user_object = new ImpExData($Db_target, $sessionobject, 'user');


		foreach ($user_array as $user_id => $user_details)
		{
			$try = $user_object;
			// Mandatory
			$try->set_value('mandatory', 'usergroupid',				$user_group_ids_array['69']);
			$try->set_value('mandatory', 'username',				$user_details['M_NAME']);
			$try->set_value('mandatory', 'email',					$user_details['M_EMAIL']);
			$try->set_value('mandatory', 'importuserid',			$user_details['MEMBER_ID']);


			// Non Mandatory
			// TODO : Can it be saved ? looks like 2 md5's
			#$try->set_value('nonmandatory', 'password',			$user_details['password']);
			// Put a random string in there for the moment
			$try->set_value('nonmandatory', 'password',				addslashes($this->fetch_user_salt()));
			$try->set_value('nonmandatory', 'passworddate',			time());


			$try->set_value('nonmandatory', 'homepage',				addslashes($user_details['M_HOMEPAGE']));
			$try->set_value('nonmandatory', 'icq',					addslashes($user_details['M_ICQ']));
			$try->set_value('nonmandatory', 'aim',					addslashes($user_details['M_AIM']));
			$try->set_value('nonmandatory', 'yahoo',				addslashes($user_details['M_YAHOO']));
			$try->set_value('nonmandatory', 'msn',					addslashes($user_details['M_MSN']));
			$try->set_value('nonmandatory', 'usertitle',			addslashes($user_details['M_TITLE']));

			$try->set_value('nonmandatory', 'joindate',				$this->time_to_stamp($user_details['M_DATE']));
			$try->set_value('nonmandatory', 'lastvisit',			$this->time_to_stamp($user_details['M_LASTPOSTDATE']));
			$try->set_value('nonmandatory', 'lastactivity',			$this->time_to_stamp($user_details['M_LASTPOSTDATE']));
			$try->set_value('nonmandatory', 'lastpost',				$this->time_to_stamp($user_details['M_LASTPOSTDATE']));
			$try->set_value('nonmandatory', 'posts',				$user_details['M_POSTS']);

			unset($dob);
			unset($coppa);
			$dob = substr($user_details['M_DOB'], 0, 4) . "-" . substr($user_details['M_DOB'], 4, 2) . "-" . substr($user_details['M_DOB'], 6, 2);
			$birthday = substr($user_details['M_DOB'], 4, 2) . "-" . substr($user_details['M_DOB'], 6, 2) . "-" . substr($user_details['M_DOB'], 0, 4);
			$coppa = $this->is_coppa($dob);

			$options = 3159;

			if($coppa['status'])
			{
				if($coppa['is_coppa'])
				{
					$options -= 8;
				}
			}

			$try->set_value('nonmandatory', 'options',				$options);


			$try->set_value('nonmandatory', 'birthday',				$birthday);
			$try->set_value('nonmandatory', 'birthday_search',		$dob);

			$try->set_value('nonmandatory', 'ipaddress',			$user_details['M_IP']);


			// TODO : avataaaaaaaaaaars
			#$try->set_value('nonmandatory', 'avatar',		$user_details['avatar']);

			unset($location);
			if($user_details['M_CITY'])
			{
				$location .= $user_details['M_CITY'] . ", ";
			}
			if($user_details['M_STATE'])
			{
				$location .= $user_details['M_STATE'] . ", ";
			}
			if($user_details['M_COUNTRY'])
			{
				$location .= $user_details['M_COUNTRY'] . ", ";
			}

			$location = substr($location, 0, -2);
			$location = substr($location, 0, 248);
			$location .=  ".";

			$try->add_default_value('Location', 					addslashes(trim($location)));
			$try->add_default_value('Interests', 					addslashes(trim($user_details['M_HOBBIES'])));
			$try->add_default_value('Occupation', 					addslashes(trim($user_details['M_OCCUPATION'])));

			$try->add_default_value('signature', 					addslashes(trim($user_details['M_SIG'])));



			// Check if user object is valid
			if($try->is_valid())
			{
				if($try->import_user($Db_target, $target_database_type, $target_table_prefix))
				{
					$displayobject->display_now('<br /><span class="isucc"><b>' . $try->how_complete() . '%</b></span> :: user -> ' . $user_details['M_NAME']);
					$sessionobject->add_session_var($class_num . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
				}
				else
				{
					$sessionobject->set_session_var($class_num . '_objects_failed',$sessionobject->get_session_var($class_num. '_objects_failed') + 1 );
					$sessionobject->add_error('warning', $this->_modulestring, get_class($this) . '::import_custom_profile_pic failed.', 'Check database permissions and database table');
					$displayobject->display_now("<br />Found avatar user and <b>DID NOT</b> imported to the  {$target_database_type} database");
				}
			}
			else
			{
				$displayobject->display_now("<br />Invalid user object, skipping." . $try->_failedon);
			}
			unset($try);
		}// End resume


		// Check for page end
		if (count($user_array) == 0 OR count($user_array) < $user_per_page)
		{
			$this->build_user_statistics($Db_target, $target_database_type, $target_table_prefix);
			$sessionobject->timing($class_num,'stop', $sessionobject->get_session_var('autosubmit'));
			$sessionobject->remove_session_var($class_num . '_start');


			$displayobject->update_html($displayobject->module_finished($this->_modulestring,
										$sessionobject->return_stats($class_num, '_time_taken'),
										$sessionobject->return_stats($class_num, '_objects_done'),
										$sessionobject->return_stats($class_num, '_objects_failed')
										));


			$sessionobject->set_session_var($class_num ,'FINISHED');
			$sessionobject->set_session_var('import_user','done');
			$sessionobject->set_session_var('module','000');
			$sessionobject->set_session_var('autosubmit','0');
			$displayobject->update_html($displayobject->print_redirect('index.php','1'));
		}


		$sessionobject->set_session_var('userstartat',$user_start_at+$user_per_page);
		$displayobject->update_html($displayobject->print_redirect('index.php'));
	}// End resume
}//End Class
# Autogenerated on : May 20, 2004, 12:45 am
# By ImpEx-generator 1.0.
/*======================================================================*\
|| ####################################################################
|| # Downloaded: 13:19, Thu Oct 21st 2004
|| # CVS: $RCSfile: 003.php,v $ - $Revision: 1.5 $
|| ####################################################################
\*======================================================================*/
?>
