<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* Ubb Import Users module
*
* The ubb users are stored in files with each lines corresponding to a
* diffrent values.
*
* @package 		ImpEx.ubb_classic
* @version		$Revision: 1.18 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/09/30 08:15:27 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class ubb_classic_003 extends ubb_classic_000
{
	var $_version 		= '0.0.1';
	var $_dependent 	= '001';
	var $_modulestring 	= 'Import Users';

	function ubb_classic_003()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject, $this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source, 'clear_imported_users'))
				{
					$this->_restart = true;
					$displayobject->display_now("<h4>Imported users have been cleared</h4>");
				}
				else
				{
					$sessionobject->add_error('fatal',
											 $this->_modulestring,
											 get_class($this) . "::restart failed , clear_imported_users",
											 'Check database permissions and user table');
				}
			}

			$displayobject->update_basic('title','Import users');
			$displayobject->update_html($displayobject->do_form_header('index',substr(get_class($this) , -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this) , -3),'WORKING'));
			$displayobject->update_html($displayobject->make_hidden_code('import_users','working'));
			$displayobject->update_html($displayobject->make_table_header('Import Users'));
			$displayobject->update_html($displayobject->make_input_code("Users to import per cycle (must be greater than 1)","usersperpage",5000));

			$displayobject->update_html($displayobject->make_description("<b>Note</b> - The <i>username, displayname, forename</i> and <i>surname</i> are imported and stored as userfields in the database if you wish to use them at a later date."));
			$displayobject->update_html($displayobject->make_description("UBB has two names, a display name and a login name, vB has one username. Both are imported, though the loginname is used for the vB username, you have to modify the templates to make use of both. "));
			$displayobject->update_html($displayobject->make_yesno_code("Click yes to use the disaply name as the vB username, or no to use the login name.","use_display_name",1));
			$displayobject->update_html($displayobject->make_description("<b>If the display name is chosen and dosn't exsist the importer will default to the login name</b> . "));
			$displayobject->update_html($displayobject->make_yesno_code("Would you like to empty your existing vBulletin members database?","clear_non_admin_users",0));
			$displayobject->update_html($displayobject->make_yesno_code("Would you like to import the custom avatars ","importcustomavatars",0));
			$displayobject->update_html($displayobject->make_description('<b>WARNING</b> If the importer has to retrieve images from slow or servers that it can connect to it WILL time out the script. If you really want to change the php.ini timeout to 0 if you can, then change is back after you have finished the import.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue','Reset'));


			$sessionobject->add_session_var('usersstartat','0');
			$sessionobject->add_session_var('totalusersdone','0');


			// Add all the custom fields we want to import
			$tdt = $sessionobject->get_session_var('targetdatabasetype');
			$ttp = $sessionobject->get_session_var('targettableprefix');

			$this->add_custom_field($Db_target, $tdt, $ttp, 'displayname','the ubb displayname');
			$this->add_custom_field($Db_target, $tdt, $ttp, 'loginname','the ubb loginname');
			$this->add_custom_field($Db_target, $tdt, $ttp, 'forename','the ubb forename');
			$this->add_custom_field($Db_target, $tdt, $ttp, 'surname','the ubb surname');

			$sessionobject->add_session_var('usersstartat','0');
			$sessionobject->add_session_var('totalusersdone','0');
		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index',''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue',''));
			$sessionobject->set_session_var(substr(get_class($this) , -3),'FALSE');
			$sessionobject->set_session_var('module','000');
		}
	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		// Set up working variables.
		$displayobject->update_basic('displaymodules','FALSE');
		$target_database_type 	= $sessionobject->get_session_var('targetdatabasetype');
		$target_table_prefix  	= $sessionobject->get_session_var('targettableprefix');

		$user_start_at			= $sessionobject->get_session_var('usersstartat');
		$user_per_page			= $sessionobject->get_session_var('usersperpage');

		$ubbmemberspath 		= $sessionobject->get_session_var('ubbmemberspath');

		$class_num				= substr(get_class($this) , -3);


		if(!$sessionobject->get_session_var($class_num . '_start'))
		{
			$sessionobject->timing($class_num, 'start' ,$sessionobject->get_session_var('autosubmit'));
		}

		if ($sessionobject->get_session_var('clear_non_admin_users') == 1)
		{
			if ($this->clear_non_admin_users($Db_target, $target_database_type, $target_table_prefix))
			{
				$displayobject->display_now("<b>All users deleted</b>");
				$sessionobject->set_session_var('clear_non_admin_users','0');
			}
			else
			{
				$sessionobject->add_error('fatal',
										 $this->_modulestring,
										 get_class($this) . "::resume failed , clear_non_admin_users",
										 'Check database permissions and user table');
			}
		}


		$bannedgroup 	= $this->get_banned_group($Db_target, $target_database_type, $target_table_prefix);
		$user_array 	= $this->get_members_list($ubbmemberspath, $user_start_at, $user_per_page);
		$doneuserids 	= $this->get_done_user_ids($Db_target, $target_database_type, $target_table_prefix);
		$user_object 	= new ImpExData($Db_target, $sessionobject, 'user');


		$displayobject->display_now("<h4>Importing " . (count($user_array)-1) . " users</h4><p><b>From</b> : " . $user_start_at . " ::  <b>To</b> : " . ($user_start_at + count($user_array) -1) . "</p>");


		foreach ($user_array as $usernumber => $userfile)
		{
			$try = $user_object;

			if (array_key_exists(intval($usernumber), $doneuserids))
			{
				# Skipping the 1st in the loop as they are the same as the last in the previous, or associated users
			}
			else
			{
				$userarray = file("$ubbmemberspath/$userfile");

				$datebits = explode("-",trim($userarray[10]));
				$date = mktime(0,0,0,$datebits[0],$datebits[1],$datebits[2]);


				if($sessionobject->get_session_var('use_display_name'))
				{
					// If the display name is null, use the loginname
					$try->set_value('mandatory', 'username', $this->iif(trim($userarray[15])== '',trim($userarray[0]),trim($userarray[15])));
				}
				else
				{
					$try->set_value('mandatory', 'username', trim($userarray[0]));
				}

				$try->set_value('mandatory', 'email', 			trim($userarray[2]));
				$try->set_value('mandatory', 'usergroupid', 	$this->getubbperms(trim($userarray[4]),$bannedgroup[id]));
				$try->set_value('mandatory', 'importuserid', 	intval($usernumber));

				$try->set_value('nonmandatory', 'password', 	trim($userarray[1]));
				$try->set_value('nonmandatory', 'homepage',		$this->iif (trim($userarray[3]) == "http://",'',trim($userarray[3])));
				$try->set_value('nonmandatory', 'posts',		trim($userarray[7]));
				$try->set_value('nonmandatory', 'joindate', 	$date);
				$try->set_value('nonmandatory', 'icq', 			trim($userarray[13]));
				$try->set_value('nonmandatory', 'daysprune',	trim($userarray[21]));
				$try->set_value('nonmandatory', 'aim', 			trim($userarray[22]));

				// $userarray[20] is the profile image
				//options = 2135
				if ($sessionobject->get_session_var('importcustomavatars'))
				{
					$try->set_value('nonmandatory', 'avatar',$this->iif ( trim($userarray[37]) == "http://",'',trim($userarray[37])));
				}
				else
				{
					$try->set_value('nonmandatory', 'avatar',NULL);
				}


				// $userarray[13] is the signature

				$try->add_custom_value('loginname', trim($userarray[15]));
				$try->add_custom_value('displayname', trim($userarray[0]));
				$try->add_custom_value('forename', trim($userarray[16]));
				$try->add_custom_value('surname', trim($userarray[17]));

				$try->add_default_value('Location', trim($userarray[6]));
				$try->add_default_value('Interests', trim($userarray[9]));
				$try->add_default_value('Occupation', trim($userarray[5]));

				$try->add_default_value('signature', addslashes(trim($userarray[12])));


				// TODO: Clean up all this and find out where things go !

				//$user[usertitle] = trim($userarray[8]);
				// permissions ?
				// $user[showemail] = option2bin(trim($userarray[11]));
				// where ?
				// $user[signature] = html2bb(trim($userarray[12]));

				// $user[adminemail] =  option2bin(trim($userarray[14]));  // its a yes or no, i.e. recive the mail or not

				// reputation ?
				// $user[showrating] =  option2bin(trim($userarray[25]));

				// permissions ?
				// $user[receivepm] =  option2bin(trim($userarray[27]));

				// permissions ?
				// $user[emailnotification] =  option2bin(trim($userarray[28]));
				// $user[adminallowpm] =  option2bin(trim($userarray[29]));

				// parse stuff into _VALUES using the 001 parsing function
				// If we get all the mandatory ones we can use is_valid to return the TRUE or FALSE

				if($try->is_valid())
				{
					if($try->import_user($Db_target, $target_database_type, $target_table_prefix))
					{
						$displayobject->display_now("<br /><span class=\"isucc\"><b>" . $try->how_complete() . "%</b></span> :: " . $try->get_value('mandatory','username'));
						$sessionobject->add_session_var($class_num . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
						$imported = true;
					}
					else
					{
						$sessionobject->add_error('warning', $this->_modulestring,
									 get_class($this) . "::import_user failed for $ubbmemberspath/$userfile. getUserDetails was ok.",
									 'Check database permissions and user table');
						$displayobject->display_now("<br />Got user " . $try->get_value('mandatory','username') . " and <b>DID NOT</b> imported to the " . $target_database_type . " database");
					}
				}
				else
				{
					$displayobject->display_now("<br />Invalid user object, skipping." . $try->_failedon);
				}
				unset($try);
			}
		}


		$timetaken = date('s' ,(time() - $start));

		if (count($user_array) == 0 OR count($user_array) < $user_per_page)
		{
			// build_user_statistics();
			$this->build_user_statistics($Db_target, $target_database_type, $target_table_prefix);

			$sessionobject->timing($class_num,'stop', $sessionobject->get_session_var('autosubmit'));
			$sessionobject->remove_session_var($class_num . '_start');

			$displayobject->update_html($displayobject->module_finished($this->_modulestring,
																		$sessionobject->return_stats($class_num, '_time_taken'),
																		$sessionobject->return_stats($class_num, '_objects_done'),
																		$sessionobject->return_stats($class_num, '_objects_failed')
																		)
										);

			$sessionobject->set_session_var($class_num, 'FINISHED');
			$sessionobject->set_session_var('import_users','done');
			$sessionobject->set_session_var('module','000');
			$sessionobject->set_session_var('autosubmit','0');
			$displayobject->update_html($displayobject->print_redirect('index.php','1'));
		}
		else
		{
			$sessionobject->add_session_var('totalusersdone',($sessionobject->get_session_var('totalusersdone') + $doneperpass));
			$displayobject->update_html($displayobject->print_redirect('index.php',''));
			$sessionobject->set_session_var('usersstartat',$user_start_at+$user_per_page);
		}
	}

}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: 13:19, Thu Oct 21st 2004
|| # CVS: $RCSfile: 003.php,v $ - $Revision: 1.18 $
|| ####################################################################
\*======================================================================*/
?>
