<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* Ubb Import Styles
*
* The ubb users are stored in files with each lines corresponding to a
* diffrent values.
*
* @package 		ImpEx.ubb_classic
* @version		$Revision: 1.9 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/04/15 00:29:34 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class ubb_classic_005 extends ubb_classic_000
{
	var $_version		= '0.0.1';
	var $_dependent 	= '001';
	var $_modulestring 	= 'Import Styles';

	function ubb_classic_005()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject,$this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source, 'clear_imported_styles'))
				{
					$this->_restart = FALSE;
				}
				else
				{
					$sessionobject->add_error('fatal',
											 $this->_modulestring,
											 get_class($this) . "::restart failed , clear_styles",
											 'Check database permissions and user table');
				}
			}

			$displayobject->update_basic('title','Import styles');
			$displayobject->update_html($displayobject->do_form_header('index',substr(get_class($this) , -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this) , -3),'WORKING'));
			$displayobject->update_html($displayobject->make_table_header('Step 5: Import UBB.Classic Style Settings'));
			$displayobject->update_html($displayobject->make_hidden_code('importstyles','working'));
			$displayobject->update_html($displayobject->make_yesno_code("Make the imported styles user-selectable?","allowstyleselect",1));
			$displayobject->update_html($displayobject->make_input_code("You may specify a suffix for the style titles, so that you can easily identify the imported styles. (Optional)","suffix","(UBB6.x)"));

			$displayobject->update_html($displayobject->make_yesno_code("Would you like to use the posticon images from your UBB.Classic board?","useposticons",1));;
			$displayobject->update_html($displayobject->make_yesno_code("Would you like to use the smilie images from your UBB.Classic board?","usesmilies",1));;
			$displayobject->update_html($displayobject->make_yesno_code("Would you set the global style of your vBulletin board to use one of your UBB.Classic styles?","setstyle",1));


			$displayobject->update_html($displayobject->do_form_footer("Import Styles"));
		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index',''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue',''));
			$sessionobject->set_session_var(substr(get_class($this) , -3),'FALSE');
			$sessionobject->set_session_var('module','000');
		}

	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		// Stage 1 get the main styles
		if ($sessionobject->get_session_var('importstyles') == 'working')
		{
			if(!$sessionobject->get_session_var(substr(get_class($this) , -3) . '_start'))
			{
				$sessionobject->timing(substr(get_class($this) , -3),'start' ,$sessionobject->get_session_var('autosubmit'));
			}

			$displayobject->display_now("<p>Importing Styles ....</p>");
			if(is_file($sessionobject->get_session_var('ubbcgipath') . "/vars_style_sets.cgi"))
			{
				$titlefile = file($sessionobject->get_session_var('ubbcgipath') . "/vars_style_sets.cgi");

				while (list($tline,$tcontents)=each($titlefile))
				{
					$_styles_array = $this->return_style_array('all');

					$stylebits = explode("|^|", $tcontents);

					$i = trim($stylebits[1]);
					$ubbstyletitle = trim($stylebits[0]);

					$displayobject->display_now("<p>Style $i .... <i>$ubbstyletitle</i> ....");

					// read style file and parse for replacement vars
					$stylefile = file($sessionobject->get_session_var('ubbpath') . "/styles/vars_style_$i.cgi");

					while (list($line,$contents)=each($stylefile))
					{
						if (preg_match("/(.+) => q[\~\^](.+)[\~\^]\,/", $contents,$regs))
						{
							switch ($regs[1]) {
								case "BBTitle":
									// $replacement['{titleimage}'] = $sessionobject->get_session_var('ubbrelativepath') ."/".$regs[2];
									break;
								case "BBTopic":
									// $replacement['{newthreadimage}'] = $sessionobject->get_session_var('ubbrelativepath') ."/".$regs[2];
									break;
								case "BBReply":
									// $replacement['{replyimage}'] = $sessionobject->get_session_var('ubbrelativepath') ."/".$regs[2];
									break;
								case "AltColumnColor2": // second altcolor in ubb==1staltcolor in vB
									$_styles_array['alt2']['background'] = $regs[2];

									// $replacement['{firstaltcolor}'] = $regs[2];
									// $replacement['{calbgcolor}'] = $regs[2];
									break;
								case "AltColumnColor1":
									$_styles_array['alt1']['background'] = $regs[2];

									// $replacement['{secondaltcolor}'] = $regs[2];
									// $replacement['{caltodaycolor}'] = $regs[2];
									break;
								case "TableColorStrip":
									$_styles_array['.thead']['background'] = $regs[2];

									// $replacement['{tableheadbgcolor}'] = $regs[2];
									break;
								case "TableBorderColor":
									$_styles_array['.tborder']['background'] = $regs[2];

									// $replacement['{tablebordercolor}'] = $regs[2];
									break;
								case "CategoryStripTextColor":
									$_styles_array['.tcat']['color'] = $regs[2];

									// $replacement['{categoryfontcolor}'] = $regs[2];
									break;
								case "TimeColor":
									$replacement['{timecolor}'] = $regs[2];
									break;
								case "TableStripTextColor":
									$replacement['{tableheadtextcolor}'] = $regs[2];
									break;
								case "CategoryStripColor":
									$replacement['{categorybackcolor}'] = $regs[2];
									break;
								case "TableWidth":
									$replacement['{tablewidth}'] = $regs[2];
									break;
								case "BGColor":
									$_styles_array['body']['background'] = $regs[2];

									//$replacement['{pagebgcolor}'] = $regs[2];
									//$body .= " bgcolor=\"$regs[2]\"";
									break;
								case "TextColor":
									$_styles_array['body']['color'] = $regs[2];

									// $replacement['{pagetextcolor}'] = $regs[2];
									// $replacement['{calprivatecolor}'] = $regs[2];
									// $replacement['{calpubliccolor}'] = $regs[2];
									// $body .= " text=\"$regs[2]\"";
									break;
								case "LinkColor":
									$_styles_array['body']['color'] = $regs[2];

									// $replacement['{linkcolor}'] = $regs[2];
									// $replacement['{caldaycolor}'] = $regs[2];
									// $body .= " link=\"$regs[2]\"";
									break;
								case "ActiveLinkColor":
									$_styles_array['LINK_N']['color'] = $regs[2];

									// $body .= " alink=\"$regs[2]\"";
									break;
								case "VisitedLinkColor":
									$_styles_array['LINK_V']['color'] = $regs[2];

									// $body .= " vlink=\"$regs[2]\"";
									break;
								case "body_extra":
									$_styles_array['body']['EXTRA'] = $regs[2];

									//$body .= "$regs[2]";
									break;
								case "FontFace":
									$_styles_array['font']['family'] = $regs[2];

									// $fonts .= " face=\"$regs[2]\"";
									break;
								case "hr_color":
									// $replacement['{ubbhrcolor}'] = $regs[2];
									break;
								case "BBTitleFontColor":
									// $replacement['{ubbtitlecolor}'] = $regs[2];
									break;
								case "table_border_display":
									switch ($regs[2]) {
										case 1: // outer borders only
											$replacement['{tableouterborderwidth}'] = 1;
											$replacement['{tableinnerborderwidth}'] = 0;
											break;
										case 2: // inner borders
											$replacement['{tableouterborderwidth}'] = 0;
											$replacement['{tableinnerborderwidth}'] = 1;
											break;
										case 3: // inner + thick outer
											$replacement['{tableouterborderwidth}'] = 1;
											$replacement['{tableinnerborderwidth}'] = 1;
											break;
									} // end border width switch
									break;
							} // end style item switch
						} // end if rexex finds style
					} // end parse style file

					$replacement['{ubbimagesfolder}'] = $sessionobject->get_session_var('ubbrelativepath');
					$replacement['{tableinvisibleextra}'] = "class=\"ubtb\" id=\"ubtd\"";

					unset($stylefile);
					$i++;

					if(true)	//import style
					{
						$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_done',$sessionobject->get_session_var(substr(get_class($this) , -3) . '_objects_done') + 1 );
					}
					else
					{
						$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_failed',$sessionobject->get_session_var(substr(get_class($this) , -3) . '_objects_failed') + 1 );
					}
				} // end parse styles list



				if ($sessionobject->get_session_var('useposticons')==1)
				{
					$icons = $Db_target->query("SELECT iconid FROM " . $sessionobject->get_session_var('targettableprefix') . "icon WHERE iconid < 15");

					while ($icon = $Db_target->fetch_array($icons))
					{
						$sql =	"
						UPDATE " . $sessionobject->get_session_var('targettableprefix') ."icon
						SET iconpath=\"" . $sessionobject->get_session_var('ubbrelativepath') . "/icons/icon$icon[iconid].gif\"
						WHERE iconid='$icon[iconid]'
						";

						$Db_target->query($sql);
					}

					$icondir = $sessionobject->get_session_var('ubbpath') . "/icons";

					if (!is_dir($icondir))
					{
						$displayobject->display_now("<B>Coulden't get the icons directory" . $icondir);
					}

					if ($handle = opendir($icondir))
					{
						// Loop through all files
						while(false !== ($file = readdir($handle)))
						{
							// Ignore hidden files
							if (!preg_match("/^\./", $file))
							{
								// Put dirs in $dirs[] and files in $files[]
								if (is_dir($file))
								{
									$dirs[] = $file;
								}
								else
								{
									$files[] = $file;
								}
							}
						}
					// Close directory
					closedir($handle);
					}
					$i=0;
					foreach ($files as $file)
					{
						if ($file != "index.html")
						{
							$iconpath_value = $sessionobject->get_session_var('ubbrelativepath') . "/icons/" . $file;
							$icon_result = $Db_target->query("select iconid from " . $sessionobject->get_session_var('targettableprefix') . "icon where iconpath='" . $iconpath_value . "'");

							while ($icon_id = $Db_target->fetch_array($icon_result))
							{
								$is_there = true;
							}

							if (!$is_there)
							{
								// TODO: What is this ?
								//$Db_target->query("INSERT INTO " . $sessionobject->get_session_var('targettableprefix') . "icon VALUES ('','$file','$iconpath_value')");
								echo"<br />Found icon , $iconpath_value <br />";
							}
							unset($icon_result);
							unset($iconpath_value);
							unset($is_there);
						}
					}


					echo "<p>Icons updated sucessfully ensure that they are correctly named buy going to \"Post Icons\" in the Admin Controll Panel</p>\n";
					flush();
				}

				if ($usesmilies==1)
				{
					$smilies = $DB_site->query("SELECT smilieid,smiliepath FROM smilie WHERE smilieid < 12");

					while ($smilie = $DB_site->fetch_array($smilies))
					{
						$DB_site->query("UPDATE smilie SET smiliepath='".str_replace("images/smilies",$ubbrelativepath,$smilie[smiliepath])."' WHERE smilieid='$smilie[smilieid]'");
					}
					echo "<p>Smilies updated sucessfully</p>\n";
					flush();
				}

				if ($setstyle==1)
				{
					$getstyle = $DB_site->query_first("SELECT replacementsetid FROM style WHERE styleid='$globalstyleid'");
					$DB_site->query("UPDATE style SET replacementsetid='$getstyle[replacementsetid]' WHERE styleid=1");
					echo "<p>Global style updated.</p>";
				}

			}
			else
			{
				$displayobject->display_now('There is no style file.');
			}


			$displayobject->update_basic('displaymodules','FALSE');

			$sessionobject->timing(substr(get_class($this) , -3),'stop', $sessionobject->get_session_var('autosubmit'));
			$sessionobject->remove_session_var(substr(get_class($this) , -3) . '_start');

			$displayobject->update_html($displayobject->module_finished($this->_modulestring,
																		$sessionobject->return_stats(substr(get_class($this) , -3),'_time_taken'),
																		$sessionobject->return_stats(substr(get_class($this) , -3),'_objects_done'),
																		$sessionobject->return_stats(substr(get_class($this) , -3),'_objects_failed')
																		)
										);

			$sessionobject->set_session_var('importstyles','done');
			$sessionobject->set_session_var(substr(get_class($this) , -3),'FINISHED');
			$sessionobject->set_session_var('module','000');

			$displayobject->update_html($displayobject->print_redirect('index.php','2'));

		}
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: 13:19, Thu Oct 21st 2004
|| # CVS: $RCSfile: 005.php,v $ - $Revision: 1.9 $
|| ####################################################################
\*======================================================================*/
?>
