<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3 - Licence Number L422505a
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2004 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
* wBB_003 Import Users groups
*
* @package 		ImpEx.wBB
* @version		$Revision: 1.4 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name:  $
* @date 		$Date: 2004/04/27 12:50:19 $
* @copyright 	http://www.vbulletin.com/license.html
*
*/
class wBB_003 extends wBB_000
{
	var $_version 		= '0.0.1';
	var $_dependent 	= '001';
	var $_modulestring 	= 'Import User Groups';

	function wBB_003()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$proceed = $this->check_order($sessionobject,$this->_dependent);
		if ($proceed)
		{
			if ($this->_restart)
			{
				if ($this->restart($sessionobject, $displayobject, $Db_target, $Db_source,'clear_imported_user_groups'))
				{
					$this->_restart = true;
					$displayobject->display_now("<h4>Imported user groups have been cleared</h4>");
				}
				else
				{
					$sessionobject->add_error('fatal',
											 $this->_modulestring,
											 get_class($this) . "::restart failed , clear_non_admin_users",
											 'Check database permissions and user table');
				}
			}

			$displayobject->update_basic('title','Import user groups');
			$displayobject->update_html($displayobject->do_form_header('index',substr(get_class($this) , -3)));
			$displayobject->update_html($displayobject->make_hidden_code(substr(get_class($this) , -3),'WORKING'));
			$displayobject->update_html($displayobject->make_hidden_code('import_user_groups','working'));
			$displayobject->update_html($displayobject->make_table_header('Import Users Groups'));
			$displayobject->update_html($displayobject->make_description('The importer will now import all the user groups.'));


			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_done', '0');
			$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_failed', '0');


			$displayobject->update_html($displayobject->do_form_footer('Continue',''));

		}
		else
		{
			$displayobject->update_html($displayobject->do_form_header('index',''));
			$displayobject->update_html($displayobject->make_description('<p>This module is dependent on <i><b>' . $sessionobject->get_module_title($this->_dependent) . '</b></i> cannot run until that is complete.'));
			$displayobject->update_html($displayobject->do_form_footer('Continue',''));
			$sessionobject->set_session_var(substr(get_class($this) , -3),'FALSE');
			$sessionobject->set_session_var('module','000');
		}
	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		// Set up working variables.
		$displayobject->update_basic('displaymodules','FALSE');
		$target_database_type 	= $sessionobject->get_session_var('targetdatabasetype');
		$target_table_prefix  	= $sessionobject->get_session_var('targettableprefix');

		$source_database_type 	= $sessionobject->get_session_var('sourcedatabasetype');
		$source_table_prefix  	= $sessionobject->get_session_var('sourcetableprefix');

		$class_num		= substr(get_class($this) , -3);

		// Start the timing
		if(!$sessionobject->get_session_var($class_num . '_start'))
		{
			$sessionobject->timing($class_num ,'start' ,$sessionobject->get_session_var('autosubmit'));
		}

		// Get a page worths of users groups
		$user_groups_array  =  $this->get_wBB_user_group_details($Db_source, $source_database_type, $source_table_prefix);

		// Got some numbers, lets try putting it in the dB
		$user_group_object = new ImpExData($Db_target, $sessionobject,'usergroup');

		$displayobject->display_now("<h4>Importing " . count($user_groups_array) . " users groups</h4>");

		foreach ($user_groups_array as $user_group_id => $user_group)
		{
			$user_groups_permissions  =  $this->get_wBB_user_group_permissions($Db_source, $source_database_type, $source_table_prefix, $user_group_id);


			$try = $user_group_object;
			/*
			can_enter_board
			can_read_thread
			can_upload_attachments
			can_download_attachments
			can_post_without_moderation
			can_close_own_topic
			can_rate_thread
			can_edit_own_topic
			can_move_own_topic
			can_use_post_html
			can_use_post_bbcode
			can_use_post_smilies
			can_use_post_icons
			can_use_post_images
			can_use_prefix
			*/

			$forumpermissions = 0;

			// And they were in order as well.
			if($user_groups_permissions[$user_group_id]['can_view_board'])		{ $forumpermissions += 1;}
			#if($user_group['g_other_topics'])		{ $forumpermissions + 2; }
			if($user_groups_permissions[$user_group_id]['can_use_search'])		{ $forumpermissions += 4; }
			#if($user_group['g_email_friend'])		{ $forumpermissions + 8; }
			if($user_groups_permissions[$user_group_id]['can_start_topic'])		{ $forumpermissions += 16; }
			#if($user_group['g_reply_own_topics'])	{ $forumpermissions + 32; }
			if($user_groups_permissions[$user_group_id]['can_reply_topic'])		{ $forumpermissions += 64; }
			if($user_groups_permissions[$user_group_id]['can_edit_own_post'])	{ $forumpermissions += 128; }
			if($user_groups_permissions[$user_group_id]['can_del_own_post'])	{ $forumpermissions += 256; }
			if($user_groups_permissions[$user_group_id]['can_del_own_topic'])	{ $forumpermissions += 512; }
			#if($user_group['g_open_close_posts'])	{ $forumpermissions + 1024; }
			if($user_groups_permissions[$user_group_id]['can_post_poll'])		{ $forumpermissions += 16384; }
			if($user_groups_permissions[$user_group_id]['can_vote_poll'])		{ $forumpermissions += 32768; }


			#$calendarpermissions = 0;
			// If they can post they can see it .....
			#if($user_group['g_calendar_post'])		{ $calendarpermissions + 3; }

			#$adminpermissions = 0;

			#if($user_group['g_access_cp'])			{ $adminpermissions + 2; }

			#$genericpermissions = 0;

			#if($user_group['g_mem_info'])			{ $genericpermissions + 1; }
			#if($user_group['g_edit_profile'])		{ $genericpermissions + 2; }
			#if($user_group['g_avatar_upload'])		{ $genericpermissions + 512; }


			// Mandatory
			$try->set_value('mandatory', 'importusergroupid',			$user_group_id);

			// Non mandatory
			$try->set_value('nonmandatory', 'title',					$user_group['title']);

			$try->set_value('nonmandatory', 'usertitle',				$user_group['title']);

			#$try->set_value('nonmandatory', 'pmsendmax',				$user_group['g_max_mass_pm']);
			#$try->set_value('nonmandatory', 'pmforwardmax',				$user_group['g_max_mass_pm']);
			#$try->set_value('nonmandatory', 'opentag',					$user_group['prefix']);
			#$try->set_value('nonmandatory', 'closetag',					$user_group['suffix']);

			$try->set_value('nonmandatory', 'forumpermissions',			$forumpermissions);

			$try->set_value('nonmandatory', 'adminpermissions',			$adminpermissions);
			$try->set_value('nonmandatory', 'genericpermissions',		$genericpermissions);
			$try->set_value('nonmandatory', 'genericoptions',			$genericpermissions);


			// TODO

			//$try->set_value('nonmandatory', 'avatarmaxwidth',			$user_group['']);
			//$try->set_value('nonmandatory', 'avatarmaxheight',		$user_group['']);
			//$try->set_value('nonmandatory', 'avatarmaxsize',			$user_group['']);
			//$try->set_value('nonmandatory', 'description',			$user_group['']);
			//$try->set_value('nonmandatory', 'passwordexpires',		$user_group['']);
			//$try->set_value('nonmandatory', 'passwordhistory',		$user_group['']);
			//$try->set_value('nonmandatory', 'pmquota',				$user_group['']);
			//$try->set_value('nonmandatory', 'canoverride',			$user_group['']);
			//$try->set_value('nonmandatory', 'ispublicgroup',			$user_group['']);
			//$try->set_value('nonmandatory', 'pmpermissions',			$user_group['']);
			//$try->set_value('nonmandatory', 'calendarpermissions',	$user_group['']);
			//$try->set_value('nonmandatory', 'wolpermissions',			$user_group['']);
			//$try->set_value('nonmandatory', 'attachlimit',			$user_group['']);
			//$try->set_value('nonmandatory', 'profilepicmaxwidth',		$user_group['']);
			//$try->set_value('nonmandatory', 'profilepicmaxheight',	$user_group['']);
			//$try->set_value('nonmandatory', 'profilepicmaxsize',		$user_group['']);



			if($try->is_valid())
			{
				if($try->import_user_group($Db_target,$target_database_type,$target_table_prefix))
				{
					$displayobject->display_now("<br /><span class=\"isucc\"><b>" . $try->how_complete() . "%</b></span> :: " . $try->get_value('nonmandatory','title'));
					$sessionobject->add_session_var($class_num . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
				}
				else
				{
					$sessionobject->add_error('warning', $this->_modulestring,
								 get_class($this) . "::import_user_group failed for " . $user_group['g_title'],
								 'Check database permissions and user table');
					$displayobject->display_now("<br />Got user " . $try->get_value('mandatory','username') . " and <b>DID NOT</b> imported to the " . $target_database_type . " database");
				}
			}
			else
			{
				$displayobject->display_now("<br />Invalid object, skipping.");
			}
		}

		if (count($user_array) == 0 OR count($user_array) < $user_per_page)
		{
			$sessionobject->timing($class_num ,'stop', $sessionobject->get_session_var('autosubmit'));
			$sessionobject->remove_session_var($class_num . '_start');

			$displayobject->update_html($displayobject->module_finished($this->_modulestring,
																		$sessionobject->return_stats($class_num ,'_time_taken'),
																		$sessionobject->return_stats($class_num ,'_objects_done'),
																		$sessionobject->return_stats($class_num ,'_objects_failed')
																		));

			$sessionobject->set_session_var($class_num ,'FINISHED');
			$sessionobject->set_session_var('import_users','done');
			$sessionobject->set_session_var('module','000');
			$sessionobject->set_session_var('autosubmit','0');
			$displayobject->update_html($displayobject->print_redirect('index.php','1'));
		}
		else
		{
			$sessionobject->add_session_var('totalusersdone',($sessionobject->get_session_var('totalusersdone') + $doneperpass));
			$displayobject->update_html($displayobject->print_redirect('index.php'));
			$sessionobject->set_session_var('usersstartat',(intval($user_start_at)+intval($sessionobject->get_session_var('usersperpage'))));
		}
	}
}
/*======================================================================*\
|| ####################################################################
|| # Downloaded: [#]zeveuilddate[#]
|| # CVS: $RCSfile: 003.php,v $ - $Revision: 1.4 $
|| ####################################################################
\*======================================================================*/
?>
