<?php
# Zoints Forum Ban
# Copyright 2006 Zoints Inc.
#
# This code may not be redistributed without prior written consent.
#

error_reporting(E_ALL & ~E_NOTICE);

function forumban_bbcode_fix()
{
	global $vbulletin;
	
	$templates = array(
		'bbcode_code',
		'bbcode_html',
		'bbcode_php',
		'bbcode_quote'
	);
	
	$templates = $vbulletin->db->query_read("SELECT title, template FROM " . TABLE_PREFIX . "template WHERE title IN('" . implode("','", $templates) . "')");
	while ($template = $vbulletin->db->fetch_array($templates))
	{

		$vbulletin->templatecache["$template[title]"] = $template['template'];
	}
	$vbulletin->db->free_result($templates);
	unset($templates, $template);
	
	foreach ($vbulletin->smiliecache as $id => $smilie)
	{
		if (substr($smilie['smiliepath'], 0, 7) != 'http://')
		{
			$vbulletin->smiliecache[$id]['smiliepath'] = $vbulletin->options['bburl'] . '/' . $smilie['smiliepath'];
		}
	}
}

function print_forumban_chooser($title, $name, $selectedid = -1, $multiple = false)
{
	print_select_row($title, $name, construct_forumban_chooser_options(), $selectedid, 0, $multiple ? 10 : 0, $multiple);
}

function construct_forumban_chooser_options()
{
	global $vbulletin, $vbphrase;

	$selectoptions[0] = $vbphrase['select_forum'];

	foreach ($vbulletin->forumcache AS $forumid => $forum)
	{
		if (!can_forumban($forumid))
		{
			continue;
		}
		$depthmark = construct_depth_mark($forum['depth'], '--');
		$selectoptions["$forumid"] =  "$depthmark " . $forum['title'] . ' ' . iif(!($forum['options'] & $vbulletin->bf_misc_forumoptions['allowposting']), " ($vbphrase[forum_is_closed_for_posting])");
	}

	return $selectoptions;
}

function print_forumban_time_row($title, $name = 'date', $unixtime = '', $valign = 'middle')
{
	global $vbphrase, $vbulletin;

	$monthnames = array(
		'- - - -',
		$vbphrase['january'], $vbphrase['february'], $vbphrase['march'], $vbphrase['april'],
		$vbphrase['may'], $vbphrase['june'], $vbphrase['july'], $vbphrase['august'],
		$vbphrase['september'], $vbphrase['october'], $vbphrase['november'], $vbphrase['december']
	);

	if (is_array($unixtime))
	{
		require_once(DIR . '/includes/functions_misc.php');
		$unixtime = vbmktime(0, 0, 0, $unixtime['month'], $unixtime['day'], $unixtime['year']);
	}

	if ($unixtime)
	{
		$month = vbdate('n', $unixtime, false, false);
		$day = vbdate('j', $unixtime, false, false);
		$year = vbdate('Y', $unixtime, false, false);
		$hour = vbdate('G', $unixtime, false, false);
	}
	
	$days = array('-1' => '-');
	for ($i = 1; $i <= 31; $i++)
	{
		$days[$i] = $i;
	}
	
	$hours = array('-1' => '-');
	for ($i = 0; $i <= 23; $i++)
	{
		$hours[$i] = $i;
	}
	if ($hour === null)
	{
		$hour = -1;
	}
	

	$cell = array();
	$cell[] = $vbphrase['month'] . "<br /><select name=\"" . $name . "[month]\" tabindex=\"1\" class=\"bginput\"" . iif($vbulletin->debug, " title=\"name=&quot;$name" . "[month]&quot;\"") . ">\n" . construct_select_options($monthnames, $month) . "\t\t</select>";
	$cell[] = $vbphrase['day'] . '<br /><select name="' . $name . '[day]" tabindex="1" class="bginput" ' . iif($vbulletin->debug, " title=\"name=&quot;$name" . "[day]&quot;\"") . ">\n" . construct_select_options($days, $day) . "\t\t</select>";
	$cell[] = $vbphrase['year'] . '<br /><input type="text" tabindex="1" class="bginput" name="' . $name . '[year]" value="' . $year . '" size="4" maxlength="4"' . iif($vbulletin->debug, " title=\"name=&quot;$name" . "[year]&quot;\"") . ' />';
	$cell[] = $vbphrase['hour'] . '<br /><select name="' . $name . '[hour]" tabindex="1" class="bginput" ' . iif($vbulletin->debug, " title=\"name=&quot;$name" . "[hour]&quot;\"") . ">\n" . construct_select_options($hours, $hour) . "\t\t</select>";
	$inputs = '';
	foreach($cell AS $html)
	{
		$inputs .= "\t\t<td><span class=\"smallfont\">$html</span></td>\n";
	}

	print_label_row(
		$title,
		"<table cellpadding=\"0\" cellspacing=\"2\" border=\"0\"><tr>\n$inputs\t\n</tr></table>",
		'', 'top', $name
	);
}


function can_forumban($forumid = 0)
{
	global $vbulletin, $fbimodcache;
	
	if ($forumid)
	{
		$forum = $vbulletin->forumcache[$forumid];
		$forumperms = $vbulletin->userinfo['forumpermissions']["$forumid"];
		if ((!($forumperms & $vbulletin->bf_ugp_forumpermissions['canview']) AND !$vbulletin->options['showprivateforums']) OR !$forum['displayorder'] OR !($forum['options'] & $vbulletin->bf_misc_forumoptions['active']))
		{
			return false;
		}
	}
	
	if ($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['ismoderator'])
	{
		return true;
	}
	
	if ($forumid)
	{
		if (!isset($fbimodcache[$forumid]))
		{
			return can_forumban($vbulletin->forumcache[$forumid]['parentid']);
		}
		return $fbimodcache[$forumid];
	}
	else
	{
		foreach ($fbimodcache as $canforumban)
		{
			if ($canforumban > 0)
			{
				return true;
			}
		}
	}
	return false;
}
?>