<?php
# Zoints Forum Ban
# Copyright 2006 Zoints Inc.
#
# This code may not be redistributed without prior written consent.
#

error_reporting(E_ALL & ~E_NOTICE);

if (!is_object($vbulletin->db))
{
	exit;
}

require_once(DIR . '/includes/class_bbcode.php');
$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

$allforumbans = $vbulletin->db->query_read("
	SELECT forumban.*, user.username, admin.username admin, forum.title
	FROM " . TABLE_PREFIX . "forumban forumban
	LEFT JOIN " . TABLE_PREFIX . "user user ON(user.userid = forumban.userid)
	LEFT JOIN " . TABLE_PREFIX . "user admin ON(admin.userid = forumban.adminid)
	LEFT JOIN " . TABLE_PREFIX . "forum forum ON(forum.forumid = forumban.forumid)
	LEFT JOIN " . TABLE_PREFIX . "access access ON(access.forumid = forumban.forumid AND access.userid = forumban.userid)
	WHERE access.accessmask = 0
		AND forumban.release > 0
		AND forumban.release <= " . TIMENOW . "
");

$userids = array();
$accessmasks = array();
$unbanned = array();
while ($forumban = $vbulletin->db->fetch_array($allforumbans))
{
	$userids[$forumban['userid']] = $forumban['userid'];
	$accessmasks[] = "(forumid = $forumban[forumid] AND userid = $forumban[userid])";
	$unbanned[] = "Unbanned $forumban[username] from $forumban[title]";
	
	$messagetitle = $vbulletin->options['zointsforumban_unban_pmtitle'];
	$message = $vbulletin->options['zointsforumban_unban_pm'];
	
	$messrepl = array(
		'userid'	=> $forumban['userid'],
		'user'		=> $forumban['username'],
		'admin'		=> $forumban['admin'],
		'release'	=> vbdate($vbulletin->options['dateformat'], $forumban['release']) . ' ' . vbdate($vbulletin->options['timeformat'], $forumban['release']),
		'date'		=> vbdate($vbulletin->options['dateformat'], $forumban['dateline']) . ' ' . vbdate($vbulletin->options['timeformat'], $forumban['dateline']),
		'reason'	=> $forumban['comment'],
		'forum'		=> $forumban['title'],
		'forumid'	=> $forumban['forumid']
	);
	
	foreach ($messrepl as $find => $replace)
	{
		$message = str_replace('{' . $find . '}', $replace, $message);
		if ($find == 'user' OR $find == 'release' OR $find == 'forum' OR $find == 'date')
		{
			$messagetitle = str_replace('{' . $find . '}', $replace, $messagetitle);
		}
	}

	$pmpermissions = array('adminpermissions' => 2);
	$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_SILENT); 
	$pmdm->set('fromuserid', $forumban['adminid']);
	$pmdm->set('fromusername', $forumban['admin']);
	$pmdm->set('title', $messagetitle);
	$pmdm->set('message', $message);
	# send even if pm box is full
	$pmdm->set_recipients($forumban['username'], $pmpermissions);
	$pmdm->set('dateline', TIMENOW);
	$pmdm->set_info('savecopy', 1);
	$pmdm->save();
	unset($pmdm);
}

# let's fix the options, just in case
if (count($userids))
{
	$allmasks = $vbulletin->db->query_read("SELECT userid, COUNT(*) count FROM " . TABLE_PREFIX . "access WHERE userid IN(" . implode(',', $userids) . ") GROUP BY userid");
	while ($mask = $vbulletin->db->fetch_array($allmasks))
	{
		unset($userids[$mask['userid']]);
	}
	
	if (count($userids))
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET options = options | ~" . $vbulletin->bf_misc_useroptions['hasaccessmask'] . " WHERE userid IN(" . implode(',',$userids) . ")");
	}
}


if (count($accessmasks))
{
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "access WHERE " . implode(' OR ', $accessmasks));
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "forumban WHERE `release` < " . TIMENOW);
	log_cron_action(implode(', ', $unbanned), $nextitem);
}

?>